unit gossdat;
//## ==========================================================================================================================================================================================================================
//##
//## MIT License
//##
//## Copyright 2025 Blaiz Enterprises ( http://www.blaizenterprises.com )
//##
//## Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation
//## files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,
//## modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software
//## is furnished to do so, subject to the following conditions:
//##
//## The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
//##
//## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
//## OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//## LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//## CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//##
//## ==========================================================================================================================================================================================================================
//## Library.................. static data (gossdat.pas)
//## Version.................. -
//## Items.................... -
//## Last Updated ............ 09nov2025
//## Lines of Code............ -
//##
//## main.pas ................ app code
//## gossroot.pas ............ console/gui app startup and control
//## gossio.pas .............. file io
//## gossimg.pas ............. image/graphics
//## gossnet.pas ............. network
//## gosswin.pas ............. static Win32 api calls
//## gosswin2.pas ............ dynamic Win32 api calls
//## gosssnd.pas ............. sound/audio/midi/chimes
//## gossgui.pas ............. gui management/controls
//## gossdat.pas ............. app icons (24px and 20px) and help documents (gui only) in txt, bwd or bwp format
//## gosszip.pas ............. zip support
//## gossjpg.pas ............. jpeg support
//## gossgame.pas ............ game support (optional)
//## gamefiles.pas ........... internal files for game (optional)
//##
//## ==========================================================================================================================================================================================================================
//## Important Format(s) Note:
//##
//## Many of the images and documents used below require a specific file format and storage in a binary pascal array in order to work.  A free gui tool
//## is available at http://www.blaizenterprises.com/blaiztools.html  The tool provides one button actions for pasting and converting images into
//## TEA/JPEG/PNG image formats, and packing them into a pascal array, as well as support for loading, compressing and packing text documents into
//## pascal arrays.
//## ==========================================================================================================================================================================================================================
//## Performance Note:
//##
//## The runtime compiler options "Range Checking" and "Overflow Checking", when enabled under Delphi 3
//## (Project > Options > Complier > Runtime Errors) slow down graphics calculations by about 50%,
//## causing ~2x more CPU to be consumed.  For optimal performance, these options should be disabled
//## when compiling.
//## ==========================================================================================================================================================================================================================

interface

uses
   gossroot;

const
//program icons ----------------------------------------------------------------
//app icon (required) - 24w x 24h size in TEA format only, accessed via tepIcon24
//Note: This icon is used by Gossamer internally for display on the app's Window Header (Title bar) and must be in the TEA (text picture) format.
//      A separate MS icon (.ico) is required for display on Windows Desktop/Explorer/Taskbar etc, currently stored within the resource file
//      "<app name>-256.res"
program_icon24h
:array[0..2781] of byte=(
84,69,65,51,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,24,0,0,0,10,0,0,1,1,14,0,0,1,28,18,0,0,1,112,23,0,0,1,206,28,0,0,1,251,33,0,0,1,255,39,0,0,1,255,45,0,0,1,255,50,0,0,1,255,57,0,0,1,255,62,0,0,1,255,67,0,0,2,255,62,0,0,1,255,57,0,0,1,255,50,0,0,1,255,45,0,0,1,255,39,0,0,1,255,33,0,0,1,255,28,0,0,1,251,23,0,0,1,206,18,0,0,1,112,14,0,0,1,28,10,0,0,1,1,9,0,0,1,28,13,0,0,1,169,17,0,0,1,249,23,0,0,1,255,28,0,0,1,255,33,0,0,1,255,39,0,0,1,255,45,0,0,1,255,50,0,0,1,255,57,0,0,1,255,62,0,0,1,255,67,0,0,2,255,62,0,0,1,255,57,0,0,1,255,50,0,0,1,255,45,0,0,1,255,39,0,0,1,255,33,0,0,1,255,28,0,0,1,255,23,0,0,1,255,17,0,0,1,249,13,0,0,1,169,9,0,0,1,28,8,0,0,1,112,12,0,0,1,249,17,0,0,1,255,23,0,0,1,255,28,0,0,1,255,33,0,0,1,255,39,0,0,1,255,45,0,0,1,255,50,0,0,1,255,57,0,0,1,255,62,0,0,1,255,67,0,0,2,255,62,0,0,1,255,57,0,0,1,255,50,0,0,1,255,45,0,0,1,255,39,0,0,1,255,33,0,0,1,255,28,0,0,1,255,23,0,0,1,255,17,0,0,1,255,12,0,0,1,249,8,0,0,1,112,7,0,0,1,206,12,0,0,1,255,17,0,0,1,255,23,0,0,
1,255,28,0,0,1,255,33,0,0,1,255,39,0,0,1,255,45,0,0,1,255,50,0,0,1,255,57,0,0,1,255,62,0,0,1,255,67,0,0,2,255,62,0,0,1,255,57,0,0,1,255,50,0,0,1,255,45,0,0,1,255,39,0,0,1,255,33,0,0,1,255,28,0,0,1,255,23,0,0,1,255,17,0,0,1,255,12,0,0,1,255,7,0,0,1,206,6,0,0,1,251,12,0,0,1,255,17,0,0,1,255,23,0,0,1,255,28,0,0,1,255,33,0,0,1,255,39,0,0,1,255,45,0,0,1,255,50,0,0,1,255,57,0,0,1,255,62,0,0,1,255,67,0,0,2,255,62,0,0,1,255,57,0,0,1,255,50,0,0,1,255,45,0,0,1,255,39,0,0,1,255,33,0,0,1,255,28,0,0,1,255,23,0,0,1,255,17,0,0,1,255,12,0,0,1,255,6,0,0,1,251,6,0,0,1,255,12,0,0,1,255,17,0,0,1,255,23,0,0,1,255,28,0,0,1,255,33,0,0,1,255,39,0,0,1,255,45,0,0,1,255,50,0,0,1,255,57,0,0,1,255,62,0,0,1,255,67,0,0,2,255,62,0,0,1,255,57,0,0,1,255,50,0,0,1,255,45,0,0,1,255,39,0,0,1,255,33,0,0,1,255,28,0,0,1,255,23,0,0,1,255,17,0,0,1,255,12,0,0,1,255,6,0,0,2,255,12,0,0,1,255,16,0,0,1,255,21,0,0,1,255,28,0,0,1,255,33,0,0,1,255,39,0,0,1,255,44,0,0,1,255,50,0,0,1,255,57,0,0,1,255,62,0,0,1,255,66,0,0,2,255,62,
0,0,1,255,56,0,0,1,255,50,0,0,1,255,44,0,0,1,255,39,0,0,1,255,33,0,0,1,255,28,0,0,1,255,22,0,0,1,255,16,0,0,1,255,12,0,0,1,255,6,0,0,2,255,5,0,0,1,255,76,71,30,1,255,98,94,44,1,255,42,26,7,1,255,33,0,0,1,255,44,17,4,1,255,95,84,38,1,255,105,91,42,1,255,61,15,4,1,255,98,78,34,1,255,124,110,52,1,255,122,107,50,1,255,90,67,29,1,255,97,79,35,1,255,104,92,43,1,255,52,23,6,1,255,39,0,0,1,255,33,0,0,1,255,28,0,0,1,255,83,79,35,1,255,94,91,42,1,255,27,20,5,1,255,5,0,0,1,255,6,0,0,1,255,0,0,0,1,255,133,130,61,1,255,168,167,82,1,255,64,55,21,1,255,36,7,1,1,255,106,99,45,1,255,172,169,82,1,255,123,113,53,1,255,60,15,3,1,255,117,100,46,1,255,152,142,69,1,255,180,175,86,1,255,132,121,58,1,255,128,116,54,1,255,175,172,84,1,255,87,74,32,1,255,38,0,0,1,255,33,0,0,1,255,50,36,12,1,255,159,157,76,1,255,149,147,70,1,255,25,17,3,1,255,5,0,0,1,255,6,0,0,1,255,0,0,0,1,255,148,145,69,1,255,187,186,92,1,255,72,63,25,1,255,108,102,46,1,255,185,181,89,1,255,151,144,69,1,255,66,39,13,1,255,57,0,0,1,255,
64,9,2,1,255,77,38,12,1,255,185,179,86,1,255,146,138,67,1,255,85,60,24,1,255,192,189,92,1,255,137,130,62,1,255,40,4,1,1,255,32,0,0,1,255,95,90,40,1,255,192,191,94,1,255,118,114,52,1,255,0,0,0,1,255,6,0,0,2,255,0,0,0,1,255,159,157,75,1,255,203,202,99,1,255,128,123,57,1,255,197,196,95,1,255,165,160,77,1,255,67,47,17,1,255,50,0,0,1,255,57,0,0,1,255,62,0,0,1,255,76,33,10,1,255,199,193,93,1,255,158,150,73,1,255,61,18,4,1,255,173,167,80,1,255,188,185,90,1,255,68,54,21,1,255,37,9,2,1,255,153,149,71,1,255,195,193,94,1,255,54,48,18,1,255,9,0,0,1,255,6,0,0,2,255,0,0,0,1,255,171,169,81,1,255,233,232,115,1,255,224,223,109,1,255,204,201,98,1,255,75,61,24,1,255,43,0,0,1,255,50,0,0,1,255,57,0,0,1,255,62,0,0,1,255,77,36,12,1,255,213,207,100,1,255,169,162,79,1,255,58,4,1,1,255,141,133,62,1,255,221,218,107,1,255,115,108,49,1,255,76,67,27,1,255,204,202,98,1,255,167,164,79,1,255,28,17,4,1,255,12,0,0,1,255,6,0,0,2,255,0,0,0,1,255,171,169,81,1,255,239,238,118,1,255,213,212,104,1,255,228,226,111,1,
255,151,144,69,1,255,55,27,7,1,255,50,0,0,1,255,57,0,0,1,255,62,0,0,1,255,77,36,12,1,255,213,207,100,1,255,169,162,79,1,255,57,0,0,1,255,101,88,39,1,255,216,214,105,1,255,156,151,72,1,255,119,113,52,1,255,218,216,106,1,255,124,121,56,1,255,21,5,1,1,255,12,0,0,1,255,6,0,0,2,255,0,0,0,1,255,159,157,75,1,255,205,204,101,1,255,96,89,38,1,255,165,161,77,1,255,209,206,101,1,255,132,124,57,1,255,55,17,4,1,255,55,0,0,1,255,59,0,0,1,255,74,30,8,1,255,200,194,94,1,255,158,149,73,1,255,56,0,0,1,255,61,32,10,1,255,173,168,81,1,255,187,183,89,1,255,155,150,71,1,255,192,190,93,1,255,72,67,28,1,255,17,0,0,1,255,12,0,0,1,255,6,0,0,2,255,0,0,0,1,255,147,145,69,1,255,187,186,92,1,255,70,61,24,1,255,61,47,17,1,255,157,153,73,1,255,189,186,91,1,255,110,98,45,1,255,97,77,31,1,255,108,87,38,1,255,131,116,53,1,255,196,192,95,1,255,131,118,55,1,255,56,0,0,1,255,50,0,0,1,255,117,108,50,1,255,195,193,95,1,255,189,187,91,1,255,145,140,67,1,255,30,15,3,1,255,17,0,0,1,255,12,0,0,1,255,6,0,0,2,255,0,0,0,1,
255,124,121,57,1,255,158,156,77,1,255,61,50,19,1,255,33,0,0,1,255,70,56,22,1,255,155,151,72,1,255,153,146,70,1,255,136,125,58,1,255,179,176,86,1,255,179,175,86,1,255,155,147,71,1,255,80,50,20,1,255,56,0,0,1,255,50,0,0,1,255,71,53,21,1,255,160,157,77,1,255,169,166,81,1,255,88,81,36,1,255,21,0,0,1,255,17,0,0,1,255,12,0,0,1,255,6,0,0,2,255,10,0,0,1,255,46,40,14,1,255,61,55,23,1,255,34,12,3,1,255,33,0,0,1,255,38,0,0,1,255,61,39,14,1,255,81,62,27,1,255,76,47,17,1,255,93,70,30,1,255,93,67,28,1,255,75,30,9,1,255,61,0,0,1,255,57,0,0,1,255,50,0,0,1,255,46,5,1,1,255,67,51,21,1,255,68,57,23,1,255,36,16,4,1,255,23,0,0,1,255,17,0,0,1,255,12,0,0,1,255,6,0,0,2,255,12,0,0,1,255,17,0,0,1,255,22,0,0,1,255,28,0,0,1,255,33,0,0,1,255,39,0,0,1,255,44,0,0,1,255,50,0,0,1,255,56,0,0,1,255,62,0,0,1,255,67,0,0,2,255,62,0,0,1,255,57,0,0,1,255,50,0,0,1,255,45,0,0,1,255,38,0,0,1,255,33,0,0,1,255,28,0,0,1,255,23,0,0,1,255,17,0,0,1,255,12,0,0,1,255,6,0,0,2,255,12,0,0,1,255,17,0,0,1,255,23,0,0,1,255,28,0,0,1,
255,33,0,0,1,255,39,0,0,1,255,45,0,0,1,255,50,0,0,1,255,57,0,0,1,255,62,0,0,1,255,67,0,0,2,255,62,0,0,1,255,57,0,0,1,255,50,0,0,1,255,45,0,0,1,255,39,0,0,1,255,33,0,0,1,255,28,0,0,1,255,23,0,0,1,255,17,0,0,1,255,12,0,0,1,255,6,0,0,1,255,6,0,0,1,251,12,0,0,1,255,17,0,0,1,255,23,0,0,1,255,28,0,0,1,255,33,0,0,1,255,39,0,0,1,255,45,0,0,1,255,50,0,0,1,255,57,0,0,1,255,62,0,0,1,255,67,0,0,2,255,62,0,0,1,255,57,0,0,1,255,50,0,0,1,255,45,0,0,1,255,39,0,0,1,255,33,0,0,1,255,28,0,0,1,255,23,0,0,1,255,17,0,0,1,255,12,0,0,1,255,6,0,0,1,251,7,0,0,1,206,12,0,0,1,255,17,0,0,1,255,23,0,0,1,255,28,0,0,1,255,33,0,0,1,255,39,0,0,1,255,45,0,0,1,255,50,0,0,1,255,57,0,0,1,255,62,0,0,1,255,67,0,0,2,255,62,0,0,1,255,57,0,0,1,255,50,0,0,1,255,45,0,0,1,255,39,0,0,1,255,33,0,0,1,255,28,0,0,1,255,23,0,0,1,255,17,0,0,1,255,12,0,0,1,255,7,0,0,1,206,8,0,0,1,112,12,0,0,1,249,17,0,0,1,255,23,0,0,1,255,28,0,0,1,255,33,0,0,1,255,39,0,0,1,255,45,0,0,1,255,50,0,0,1,255,57,0,0,1,255,62,0,0,1,255,67,0,0,2,255,62,0,
0,1,255,57,0,0,1,255,50,0,0,1,255,45,0,0,1,255,39,0,0,1,255,33,0,0,1,255,28,0,0,1,255,23,0,0,1,255,17,0,0,1,255,12,0,0,1,249,8,0,0,1,112,9,0,0,1,28,13,0,0,1,169,17,0,0,1,249,23,0,0,1,255,28,0,0,1,255,33,0,0,1,255,39,0,0,1,255,45,0,0,1,255,50,0,0,1,255,57,0,0,1,255,62,0,0,1,255,67,0,0,2,255,62,0,0,1,255,57,0,0,1,255,50,0,0,1,255,45,0,0,1,255,39,0,0,1,255,33,0,0,1,255,28,0,0,1,255,23,0,0,1,255,17,0,0,1,249,13,0,0,1,169,9,0,0,1,28,10,0,0,1,1,14,0,0,1,28,18,0,0,1,112,23,0,0,1,206,28,0,0,1,251,33,0,0,1,255,39,0,0,1,255,45,0,0,1,255,50,0,0,1,255,57,0,0,1,255,62,0,0,1,255,67,0,0,2,255,62,0,0,1,255,57,0,0,1,255,50,0,0,1,255,45,0,0,1,255,39,0,0,1,255,33,0,0,1,255,28,0,0,1,251,23,0,0,1,206,18,0,0,1,112,14,0,0,1,28,10,0,0,1,1);


//app small icon (optional) - 20w x 20h size in TEA format only, accessed via tepIcon20
program_icon20h
:array[0..1961] of byte=(
84,69,65,51,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,20,0,0,0,12,0,0,1,11,16,0,0,1,73,21,0,0,1,173,27,0,0,1,241,33,0,0,1,255,40,0,0,1,255,47,0,0,1,255,54,0,0,1,255,61,0,0,1,255,66,0,0,2,255,61,0,0,1,255,54,0,0,1,255,47,0,0,1,255,40,0,0,1,255,33,0,0,1,255,27,0,0,1,241,21,0,0,1,173,16,0,0,1,73,12,0,0,1,11,10,0,0,1,73,14,0,0,1,213,20,0,0,1,255,27,0,0,1,255,33,0,0,1,255,40,0,0,1,255,47,0,0,1,255,54,0,0,1,255,61,0,0,1,255,66,0,0,2,255,61,0,0,1,255,54,0,0,1,255,47,0,0,1,255,40,0,0,1,255,33,0,0,1,255,27,0,0,1,255,20,0,0,1,255,14,0,0,1,213,10,0,0,1,73,8,0,0,1,173,14,0,0,1,255,20,0,0,1,255,27,0,0,1,255,33,0,0,1,255,40,0,0,1,255,47,0,0,1,255,54,0,0,1,255,61,0,0,1,255,66,0,0,2,255,61,0,0,1,255,54,0,0,1,255,47,0,0,1,255,40,0,0,1,255,33,0,0,1,255,27,0,0,1,255,20,0,0,1,255,14,0,0,1,255,8,0,0,1,173,7,0,0,1,241,14,0,0,1,255,20,0,0,1,255,27,0,0,1,255,33,0,0,1,255,40,0,0,1,255,47,0,0,1,255,54,0,0,1,255,61,0,0,1,255,66,0,0,2,255,61,0,0,1,255,54,0,0,1,255,47,0,0,1,255,40,0,0,1,255,33,0,0,1,255,27,
0,0,1,255,20,0,0,1,255,14,0,0,1,255,7,0,0,1,241,7,0,0,1,255,14,0,0,1,255,20,0,0,1,255,27,0,0,1,255,33,0,0,1,255,40,0,0,1,255,46,0,0,1,255,54,0,0,1,255,61,0,0,1,255,66,0,0,2,255,61,0,0,1,255,54,0,0,1,255,46,0,0,1,255,40,0,0,1,255,33,0,0,1,255,27,0,0,1,255,20,0,0,1,255,14,0,0,1,255,7,0,0,2,255,19,8,2,1,255,38,29,9,1,255,34,17,4,1,255,33,1,0,1,255,42,7,2,1,255,57,30,10,1,255,59,21,6,1,255,65,21,5,1,255,76,39,14,1,255,76,37,13,1,255,66,23,6,1,255,63,30,10,1,255,51,16,4,1,255,40,0,0,1,255,33,0,0,1,255,31,10,2,1,255,38,30,9,1,255,25,16,4,1,255,7,0,0,1,255,5,0,0,1,255,54,51,20,1,255,114,111,52,1,255,83,77,34,1,255,36,10,2,1,255,78,68,29,1,255,122,114,54,1,255,89,71,31,1,255,93,72,31,1,255,131,119,56,1,255,138,127,61,1,255,105,88,40,1,255,121,111,52,1,255,92,80,36,1,255,43,10,2,1,255,33,1,0,1,255,70,63,27,1,255,116,113,53,1,255,69,66,28,1,255,8,2,0,1,255,3,0,0,1,255,80,78,34,1,255,164,162,79,1,255,117,113,53,1,255,81,72,31,1,255,153,148,71,1,255,149,143,68,1,255,79,58,24,1,255,85,60,
25,1,255,123,107,50,1,255,176,170,82,1,255,130,119,57,1,255,155,148,71,1,255,142,136,65,1,255,56,38,13,1,255,41,20,5,1,255,120,116,54,1,255,161,159,77,1,255,78,76,32,1,255,5,0,0,1,255,3,0,0,1,255,88,87,38,1,255,181,180,88,1,255,146,143,68,1,255,169,166,80,1,255,165,160,77,1,255,89,75,33,1,255,54,0,0,1,255,60,0,0,1,255,83,49,18,1,255,187,180,87,1,255,134,123,59,1,255,137,128,60,1,255,178,173,84,1,255,89,79,35,1,255,64,53,21,1,255,160,157,75,1,255,153,151,72,1,255,38,33,10,1,255,5,0,0,1,255,2,0,0,1,255,96,95,42,1,255,204,203,99,1,255,219,218,107,1,255,203,200,97,1,255,101,91,41,1,255,47,6,1,1,255,54,0,0,1,255,60,0,0,1,255,86,55,22,1,255,202,196,95,1,255,144,135,65,1,255,107,93,41,1,255,199,196,95,1,255,133,127,59,1,255,106,100,45,1,255,192,190,92,1,255,125,122,57,1,255,6,0,0,1,255,7,0,0,1,255,2,0,0,1,255,96,94,42,1,255,207,206,101,1,255,213,212,104,1,255,215,213,104,1,255,154,147,71,1,255,65,42,15,1,255,53,0,0,1,255,60,0,0,1,255,86,55,22,1,255,202,196,95,1,255,144,135,65,1,255,
72,46,17,1,255,186,183,89,1,255,167,163,78,1,255,143,138,65,1,255,193,191,93,1,255,84,80,35,1,255,8,0,0,1,255,7,0,0,1,255,3,0,0,1,255,88,87,38,1,255,182,181,89,1,255,135,132,62,1,255,139,134,63,1,255,189,185,90,1,255,135,128,60,1,255,70,43,15,1,255,74,42,14,1,255,100,77,33,1,255,190,184,90,1,255,130,118,56,1,255,47,0,0,1,255,137,130,61,1,255,185,182,88,1,255,170,166,80,1,255,156,153,74,1,255,37,28,8,1,255,12,0,0,1,255,7,0,0,1,255,3,0,0,1,255,77,75,33,1,255,159,158,77,1,255,114,110,52,1,255,52,36,12,1,255,129,124,58,1,255,165,161,77,1,255,126,115,53,1,255,142,133,63,1,255,159,152,73,1,255,169,163,80,1,255,95,75,33,1,255,50,0,0,1,255,83,68,29,1,255,171,168,82,1,255,174,172,83,1,255,101,95,44,1,255,12,0,0,1,255,14,0,0,1,255,7,0,0,1,255,6,0,0,1,255,44,40,14,1,255,94,90,41,1,255,69,62,26,1,255,35,5,1,1,255,58,41,14,1,255,104,94,43,1,255,105,90,41,1,255,121,108,50,1,255,128,115,54,1,255,103,83,37,1,255,63,15,3,1,255,53,0,0,1,255,52,19,4,1,255,101,93,43,1,255,105,100,46,1,255,48,36,
12,1,255,18,0,0,1,255,14,0,0,1,255,7,0,0,2,255,16,3,1,1,255,27,13,3,1,255,29,6,1,1,255,33,0,0,1,255,40,1,0,1,255,49,12,3,1,255,57,16,4,1,255,65,19,5,1,255,70,20,5,1,255,67,4,1,1,255,60,0,0,1,255,54,0,0,1,255,47,0,0,1,255,43,12,3,1,255,38,14,3,1,255,27,1,0,1,255,20,0,0,1,255,14,0,0,1,255,7,0,0,2,255,14,0,0,1,255,20,0,0,1,255,27,0,0,1,255,33,0,0,1,255,40,0,0,1,255,46,0,0,1,255,54,0,0,1,255,61,0,0,1,255,66,0,0,2,255,61,0,0,1,255,54,0,0,1,255,47,0,0,1,255,40,0,0,1,255,33,0,0,1,255,27,0,0,1,255,20,0,0,1,255,14,0,0,1,255,7,0,0,1,255,7,0,0,1,241,14,0,0,1,255,20,0,0,1,255,27,0,0,1,255,33,0,0,1,255,40,0,0,1,255,47,0,0,1,255,54,0,0,1,255,61,0,0,1,255,66,0,0,2,255,61,0,0,1,255,54,0,0,1,255,47,0,0,1,255,40,0,0,1,255,33,0,0,1,255,27,0,0,1,255,20,0,0,1,255,14,0,0,1,255,7,0,0,1,241,8,0,0,1,173,14,0,0,1,255,20,0,0,1,255,27,0,0,1,255,33,0,0,1,255,40,0,0,1,255,47,0,0,1,255,54,0,0,1,255,61,0,0,1,255,66,0,0,2,255,61,0,0,1,255,54,0,0,1,255,47,0,0,1,255,40,0,0,1,255,33,0,0,1,255,27,0,0,1,255,20,0,
0,1,255,14,0,0,1,255,8,0,0,1,173,10,0,0,1,73,14,0,0,1,213,20,0,0,1,255,27,0,0,1,255,33,0,0,1,255,40,0,0,1,255,47,0,0,1,255,54,0,0,1,255,61,0,0,1,255,66,0,0,2,255,61,0,0,1,255,54,0,0,1,255,47,0,0,1,255,40,0,0,1,255,33,0,0,1,255,27,0,0,1,255,20,0,0,1,255,14,0,0,1,213,10,0,0,1,73,12,0,0,1,11,16,0,0,1,73,21,0,0,1,173,27,0,0,1,241,33,0,0,1,255,40,0,0,1,255,47,0,0,1,255,54,0,0,1,255,61,0,0,1,255,66,0,0,2,255,61,0,0,1,255,54,0,0,1,255,47,0,0,1,255,40,0,0,1,255,33,0,0,1,255,27,0,0,1,241,21,0,0,1,173,16,0,0,1,73,12,0,0,1,11);


//additional icons (B..D) are optional - 25may2025 -----------------------------
//Note: Supported image format: tea
//Note: Each icon, if specified, must be 24w x 24h.  The icons form an animation of upto 10 cells in total.
//      When triggered, the app icon - (top-left) of window - will animate and cycle through each of the cells
//      in a continuos loop for a short time period of about 2 seconds.
//How To Use:
//      Use rootwin.xhead.aniAdd(xtep,xms) to add upto 10 cells, and rootwin.xhead.aniPlay to
//      trigger animation playback for ~2 seconds.  To extend playback, call rootwin.xhead.aniPlay
//      regularly.
//
//Example:
//to setup the animation ready for playback:
//      rootwin.xhead.aniAdd(tepIcon24 ,200);
//      rootwin.xhead.aniAdd(tepIcon24B,200);
//      rootwin.xhead.aniAdd(tepIcon24C,200);
//      rootwin.xhead.aniAdd(tepIcon24D,200);
//
//to play the animation call:
//      rootwin.xhead.aniPlay;
//
//to clear the animation (e.g. to create a new animation) call:
//      rootwin.xhead.aniClear;
//
//Note: the examples above must be executed within "tprogram" for access to rootwin, see
//      the unit marked "main" for tprogram.

//accessed via "tepIcon24B"
program_icon24hB
:array[0..0] of byte=(0);


//accessed via "tepIcon24C"
program_icon24hC
:array[0..0] of byte=(0);


//accessed via "tepIcon24D"
program_icon24hD
:array[0..0] of byte=(0);


//help viewer banner images - optional -----------------------------------------
//.banner 1
programbanner
:array[0..0] of byte=(0);//disabled

//.banner 2
programbanner2
:array[0..0] of byte=(0);//disabled


//app help document(s) - optional ----------------------------------------------
//note: these help documents, if specified, are processed and merged into one large
//      document at runtime by the built-in help viewer, which supports documents in
//      the following 3 formats:
//
//      1. txt - plain text
//      2. bwd - enhanced text (Blaiz Enterprises format)
//      3. bwp - advanced text (Blaiz Enterprises format)
//
//      These documents can be compressed (using zip) or left uncompressed.


//app help - app specific help document, which appears above system help
apphelp//03jul2025
:array[0..0] of byte=(0);


//system help - information relating to the app's system settings and general behaviour
syshelp//07nov2025
:array[0..17112] of byte=(
120,1,236,157,235,110,28,201,153,166,109,96,127,17,152,123,200,37,48,48,53,75,138,18,213,39,11,59,99,80,20,213,226,88,18,5,146,106,185,215,235,31,201,170,36,89,86,157,92,7,81,236,203,88,204,21,205,149,237,243,190,95,68,102,86,145,114,171,103,52,30,187,157,141,238,150,88,149,25,241,157,207,17,124,242,246,233,195,95,240,207,96,124,49,249,127,252,57,44,199,253,121,175,156,86,143,139,7,255,176,49,191,153,47,170,209,188,119,85,141,226,131,235,89,57,157,47,110,134,252,180,247,15,27,23,147,241,98,92,234,171,131,201,114,54,168,102,197,171,234,58,62,158,15,126,224,227,135,233,161,222,100,56,153,121,69,189,226,159,246,88,225,203,47,211,195,177,34,27,158,95,166,71,31,126,245,245,215,95,126,177,151,222,23,132,139,234,195,226,223,255,237,23,191,248,253,226,15,7,87,229,248,178,42,22,87,85,225,199,7,227,203,98,114,225,159,203,233,244,87,243,226,219,55,71,27,207,102,147,81,177,152,76,249,111,50,60,47,103,69,111,56,232,189,43,54,127,191,168,166,143,39,211,197,96,50,158,239,61,248,67,113,28,127,
221,44,38,179,130,183,139,81,53,94,22,155,247,239,223,47,254,165,249,110,75,11,205,6,151,87,11,109,116,61,24,247,39,215,247,238,23,197,254,184,216,172,23,136,143,249,118,56,44,250,131,249,116,88,222,240,200,105,53,172,122,139,180,111,160,206,174,7,162,200,102,177,40,207,129,175,152,95,77,174,139,225,96,238,213,253,76,17,68,159,223,223,216,56,3,205,77,63,95,156,154,19,243,205,120,118,48,47,216,100,176,40,6,99,214,88,92,205,170,170,152,179,151,48,123,188,241,240,126,241,100,57,24,46,118,142,198,65,165,188,100,177,83,204,170,178,95,76,198,195,155,221,229,188,42,202,121,49,152,111,236,221,47,14,150,243,5,68,91,1,128,167,121,6,234,249,187,193,188,60,31,242,198,184,95,12,203,243,106,56,172,250,249,173,135,59,15,31,108,60,186,95,156,150,239,249,240,211,214,152,251,89,246,191,24,12,171,173,249,61,96,18,229,222,25,233,25,251,240,223,195,175,30,252,175,226,220,152,12,214,49,1,237,222,213,100,2,14,23,112,91,196,30,140,166,195,27,168,96,154,151,43,96,136,208,48,152,175,89,7,10,12,23,131,
81,197,59,207,96,252,96,60,95,148,227,94,181,93,236,255,105,89,22,47,203,217,96,172,239,222,150,139,222,149,8,36,89,171,101,139,77,37,128,243,180,124,188,188,96,225,157,98,60,41,198,21,248,95,72,154,198,69,217,239,15,196,143,114,88,12,39,101,127,59,0,216,150,172,205,171,5,204,221,47,158,12,203,193,15,197,225,120,81,205,166,179,193,188,154,255,106,21,234,173,127,186,127,222,131,52,37,124,94,104,75,104,2,231,203,90,94,22,215,213,120,113,19,47,205,183,193,108,62,69,0,6,226,147,160,48,39,164,33,163,9,242,85,206,167,72,200,252,150,186,136,118,147,17,242,195,215,131,18,81,204,60,100,39,54,236,87,179,129,216,90,46,17,144,114,49,232,149,67,208,21,209,69,153,185,72,117,118,13,51,36,213,112,147,109,69,176,139,25,198,97,187,24,67,75,127,6,115,38,51,232,12,24,208,31,88,207,6,11,160,140,183,160,13,82,229,103,71,194,49,96,31,141,16,137,31,38,227,138,167,79,121,181,95,206,146,112,73,53,14,75,184,115,167,108,20,87,146,234,5,182,96,114,61,46,150,227,193,159,150,82,142,70,193,230,128,188,159,164,
58,32,72,250,81,128,218,228,58,144,72,248,32,56,231,128,153,52,160,234,11,91,144,5,135,5,82,113,215,34,219,44,54,155,200,14,104,123,209,194,218,205,66,250,123,82,210,98,33,244,251,40,183,87,222,100,217,231,85,113,51,89,254,138,23,47,176,49,197,162,66,226,111,43,101,49,31,78,224,225,78,81,9,255,139,165,120,145,161,179,126,182,4,28,115,180,184,154,44,33,249,248,38,68,51,176,145,221,70,30,67,3,37,172,104,198,32,80,43,167,146,207,48,151,80,191,244,118,54,83,139,114,182,96,91,177,166,250,80,162,106,224,2,40,197,67,62,76,88,20,15,55,97,204,113,32,29,22,147,5,16,31,212,5,211,89,161,15,6,209,164,45,166,229,176,90,44,248,202,70,19,24,170,114,6,25,14,108,170,203,252,181,246,78,6,213,244,139,119,251,200,233,228,50,25,99,113,179,255,71,72,149,120,9,247,251,213,124,48,147,204,66,200,64,230,248,183,197,245,21,36,237,35,79,122,97,136,206,141,145,230,247,213,240,102,59,61,163,167,251,179,242,82,124,152,161,51,50,144,189,229,108,62,153,237,194,146,203,106,182,24,76,107,193,79,155,37,44,108,96,
122,127,90,178,107,250,194,10,226,133,122,147,209,116,201,118,146,139,10,16,90,28,18,36,248,29,124,22,111,141,23,131,241,146,77,225,232,114,218,71,190,48,61,19,116,250,194,6,45,219,157,108,8,141,196,176,54,71,210,212,85,13,53,123,225,199,6,94,243,91,240,12,172,198,213,117,2,48,188,12,44,150,56,108,188,149,106,26,220,249,213,192,226,178,246,28,160,92,97,178,109,136,36,216,122,235,55,69,113,88,206,229,233,194,227,34,223,193,159,228,193,66,242,119,178,251,77,222,18,231,122,144,92,96,195,219,196,209,157,85,229,9,157,201,74,146,149,7,209,13,35,31,228,189,173,36,97,79,218,78,95,158,93,30,255,165,60,252,191,20,14,4,68,32,125,118,42,180,246,231,184,125,169,225,217,205,84,138,45,244,90,226,35,213,221,212,131,155,216,156,197,98,50,230,201,239,37,37,109,124,101,155,77,245,36,180,239,188,128,180,31,81,92,142,49,164,22,97,175,211,223,204,216,100,123,220,94,105,158,41,55,38,242,169,31,148,65,145,223,128,61,237,135,139,30,222,6,35,181,178,117,144,0,176,199,214,59,107,247,51,116,183,241,118,
16,207,111,38,90,162,23,25,146,59,173,42,70,120,190,12,135,216,242,147,177,141,118,70,48,50,218,219,66,51,91,47,220,137,156,104,210,200,36,143,207,137,121,16,40,41,152,121,104,139,180,130,212,70,216,129,28,97,173,200,140,67,38,113,164,77,133,32,25,108,57,109,91,223,16,160,97,137,113,200,150,55,246,74,76,16,195,175,196,182,136,157,138,41,46,20,151,218,246,177,248,132,164,24,96,185,30,221,160,141,34,92,143,119,102,118,244,61,108,138,165,35,197,126,24,64,7,110,9,221,132,255,1,28,59,50,99,138,17,33,203,173,133,107,203,141,202,201,127,219,14,236,36,50,239,42,156,16,185,171,69,239,55,27,223,87,118,103,200,196,29,203,36,201,200,14,2,240,179,75,184,88,206,245,222,199,168,44,83,184,226,198,86,189,215,10,13,179,249,92,231,136,168,198,126,243,43,129,47,227,31,194,82,134,173,174,159,86,236,215,18,16,217,230,85,179,22,120,173,26,183,243,146,120,158,101,181,138,2,200,28,61,110,215,8,182,125,94,245,1,7,215,195,227,6,145,18,19,222,94,41,174,18,171,181,218,229,108,130,138,38,110,17,155,221,250,
44,30,37,86,36,4,114,194,48,30,16,14,65,82,254,80,70,2,20,56,28,132,111,30,33,99,107,1,178,1,116,191,73,83,44,117,168,69,78,88,16,100,194,163,177,5,111,14,99,203,243,9,10,181,144,96,250,213,221,81,53,99,11,199,250,34,99,86,196,148,222,160,154,250,91,0,194,15,97,161,244,169,172,7,82,18,251,201,67,240,223,87,15,154,176,169,5,99,50,217,188,93,42,0,196,249,207,171,247,149,132,218,248,201,77,47,174,112,197,23,23,213,12,64,67,83,22,108,50,28,188,171,138,171,201,108,64,168,182,224,113,137,14,47,58,80,204,50,68,104,89,245,121,246,162,236,11,13,63,163,192,100,38,47,23,98,113,61,57,87,216,58,100,211,161,36,243,76,177,37,1,206,56,146,154,8,205,28,126,160,82,193,132,68,248,73,113,41,247,54,130,102,152,121,91,33,137,5,212,101,153,183,87,146,142,185,226,219,219,200,154,30,41,236,149,108,16,35,42,190,41,205,89,212,152,96,157,149,136,106,69,183,241,68,65,59,96,181,23,10,16,146,154,65,23,108,188,36,98,236,200,44,236,83,68,252,87,96,190,131,107,189,144,196,44,38,215,138,101,47,103,213,13,9,247,
144,56,153,93,231,119,61,146,16,33,150,37,16,49,221,175,200,68,135,206,70,109,253,64,241,24,3,52,31,14,216,122,59,28,43,38,23,157,132,27,132,161,146,69,196,104,49,27,236,100,90,130,197,93,226,61,95,78,21,162,75,31,70,229,135,193,104,57,74,146,29,86,182,95,77,225,63,50,252,104,175,56,87,54,2,146,39,223,62,217,23,197,208,3,162,192,111,244,57,241,10,161,37,152,85,80,239,124,184,4,18,9,68,57,156,94,17,45,147,59,141,97,111,138,35,179,47,98,71,172,231,120,62,133,204,240,239,245,171,111,99,103,0,125,53,89,84,143,241,120,137,39,208,238,22,23,237,196,38,83,68,85,17,57,28,84,230,17,146,37,112,151,170,2,20,123,15,138,139,233,188,216,242,151,243,130,167,101,242,39,227,254,61,44,198,213,0,191,54,170,128,192,246,4,24,20,198,41,40,107,84,86,218,63,171,166,37,58,216,48,120,91,235,42,149,108,175,152,52,162,44,222,195,146,73,160,47,41,170,32,20,158,2,203,207,190,243,37,48,18,46,58,137,16,217,216,233,224,245,155,98,58,185,22,27,201,227,156,139,33,148,96,36,150,43,183,155,12,151,78,240,225,249,145,
45,215,12,20,70,200,124,31,144,224,218,4,17,128,234,94,131,204,0,54,246,136,229,144,215,74,158,54,18,83,175,213,34,209,110,107,93,177,116,50,115,152,50,225,101,80,229,191,98,62,154,160,5,69,80,24,165,200,68,129,62,50,164,167,150,60,164,6,46,131,230,128,192,25,74,226,180,168,67,108,156,46,224,232,37,111,111,61,184,127,159,154,207,189,199,27,79,43,66,225,17,96,205,49,26,215,197,72,49,69,34,115,139,181,161,87,208,124,142,32,237,142,100,54,222,15,156,216,130,252,62,9,245,117,241,190,68,186,32,139,116,238,150,197,157,47,207,101,237,207,171,49,137,26,14,8,173,5,94,241,26,70,224,109,202,32,170,215,216,46,30,62,120,176,3,116,74,160,99,53,24,114,62,25,246,135,10,109,247,211,78,97,148,121,84,162,64,74,162,84,6,113,188,33,180,185,40,151,195,5,143,158,225,231,198,250,60,187,196,86,248,114,74,178,35,170,108,154,82,132,67,169,54,244,52,170,69,4,56,167,229,69,85,60,169,93,145,130,209,188,55,166,109,38,40,225,202,77,161,31,204,227,140,22,159,190,83,148,0,212,87,178,43,200,251,152,184,225,82,
10,129,97,73,186,193,114,71,42,148,1,253,185,228,70,233,5,100,233,97,238,145,25,196,32,126,222,124,182,183,89,188,171,72,138,18,71,35,157,59,84,145,66,159,107,117,4,248,98,48,27,73,38,23,19,244,174,37,21,225,211,18,73,100,81,141,244,253,141,162,216,56,80,208,175,112,112,139,114,17,242,192,255,144,7,232,18,112,232,219,196,0,33,51,170,200,93,149,110,215,52,184,48,5,50,139,4,251,109,129,89,53,188,232,160,133,4,249,130,107,227,182,193,181,81,106,190,22,68,122,66,171,6,10,31,179,183,8,181,156,89,72,180,16,120,45,69,81,241,132,15,89,225,150,133,1,5,139,76,114,90,59,222,163,5,121,138,15,85,146,3,125,91,24,156,173,2,232,89,229,132,210,53,7,177,141,127,5,223,16,1,102,67,84,107,62,151,154,71,65,115,141,82,59,88,38,168,47,73,151,185,113,229,37,173,94,244,110,122,138,152,160,167,158,250,136,93,68,183,159,55,78,61,130,234,221,239,178,95,79,65,246,10,39,95,34,152,200,86,45,192,201,125,12,171,139,197,46,86,120,11,165,95,206,131,228,84,251,224,181,188,216,174,171,36,91,211,97,243,21,42,245,187,
98,58,248,16,113,64,139,253,63,84,51,34,190,229,12,59,93,59,251,201,197,197,42,164,111,29,71,52,144,198,207,102,215,35,11,220,190,171,29,34,76,10,57,46,202,30,82,44,185,54,247,29,123,253,56,234,25,2,194,87,0,120,38,11,117,52,222,61,38,168,145,173,251,82,146,113,32,58,139,103,132,150,88,240,176,57,59,139,201,14,230,75,127,216,22,203,161,80,178,163,138,119,193,199,114,157,101,127,25,37,182,178,47,69,184,83,208,93,93,120,63,168,120,129,239,73,255,20,15,151,151,136,226,182,132,208,76,79,229,132,96,55,226,241,70,153,88,203,116,58,212,81,17,135,76,95,144,38,79,221,178,140,41,220,186,144,188,249,17,86,73,184,182,200,186,247,41,100,109,19,72,136,38,33,180,81,149,27,81,105,223,73,81,157,171,0,107,75,150,66,75,118,91,159,216,69,40,253,113,158,129,95,5,184,51,153,119,71,107,15,31,228,234,89,235,149,164,106,46,161,241,244,173,228,231,73,45,187,97,165,127,60,3,58,168,203,119,207,16,161,28,208,100,243,143,179,108,149,198,100,202,240,75,112,62,154,18,237,102,65,182,61,81,53,35,226,90,142,224,
98,88,70,250,15,0,155,43,44,51,248,148,83,247,41,140,73,241,116,82,54,203,5,120,77,207,39,242,4,117,233,229,181,158,220,116,156,137,59,80,56,213,126,193,25,84,253,236,51,34,102,21,242,132,209,57,22,94,158,23,137,148,181,199,205,17,174,59,101,15,15,77,42,190,28,226,5,37,89,243,193,104,48,164,217,162,254,79,173,77,78,113,228,177,148,70,19,223,149,33,101,188,128,203,161,230,23,81,9,201,147,68,253,122,50,123,7,204,139,72,204,182,115,193,137,232,55,85,19,137,49,206,39,148,95,70,228,147,42,194,19,242,12,46,40,93,18,224,167,183,176,120,142,87,231,187,97,65,48,130,229,8,45,84,85,77,29,172,208,148,200,245,208,120,5,178,19,226,222,185,182,215,154,197,150,183,178,150,98,184,194,9,78,166,250,57,118,86,235,231,251,84,58,81,253,130,216,85,25,134,43,194,242,131,120,15,147,185,44,46,39,147,62,49,30,21,117,148,27,181,158,18,103,98,118,166,14,72,203,158,114,62,106,67,10,78,6,16,21,98,107,57,213,148,54,159,12,137,67,136,241,144,194,120,90,180,106,145,29,230,188,77,165,221,120,57,209,79,166,34,248,
162,56,33,213,50,200,38,103,203,41,121,160,41,134,213,95,142,175,41,246,65,180,26,113,136,15,49,249,170,73,227,118,97,89,164,112,65,206,154,109,33,12,80,243,143,229,140,78,9,81,135,106,129,88,229,10,168,82,29,86,112,68,70,2,190,138,155,195,143,73,40,90,120,215,105,150,137,156,132,172,34,191,164,73,1,145,219,101,128,100,155,3,55,185,238,122,117,212,61,234,3,128,129,116,69,99,39,236,137,138,76,253,9,117,150,40,157,202,80,166,228,192,109,76,210,104,9,170,87,35,243,120,167,52,49,133,171,187,1,197,111,156,237,69,176,172,184,23,214,192,15,226,86,149,187,100,73,193,30,222,225,60,228,185,29,108,95,134,124,37,120,135,138,192,30,254,250,215,15,224,175,35,79,193,128,161,31,204,208,170,178,63,153,141,197,5,150,125,134,122,30,160,176,144,11,228,94,43,9,136,31,183,230,176,118,184,27,164,226,97,7,141,179,201,152,18,196,104,57,87,47,198,185,150,130,44,34,57,22,144,51,58,138,56,6,191,239,2,0,124,69,221,45,151,222,158,86,211,136,38,23,44,164,54,47,76,228,11,81,220,75,44,11,161,197,205,206,229,
140,58,183,116,213,246,31,181,31,252,160,245,69,63,86,81,95,37,233,179,8,152,189,198,98,146,34,249,62,193,101,138,9,33,195,57,201,131,4,35,81,62,101,202,14,232,175,201,143,36,246,99,4,9,86,181,4,5,238,159,177,89,36,52,214,1,181,116,208,180,155,169,81,14,150,240,126,100,164,95,23,211,15,225,245,232,187,34,7,153,189,72,219,92,105,187,228,142,128,157,28,147,102,44,27,78,122,189,229,244,134,54,70,15,187,160,210,1,118,94,133,121,201,15,169,23,197,5,201,242,179,229,12,140,103,106,72,129,99,130,95,122,21,17,104,212,67,32,108,132,95,229,144,236,1,230,77,70,238,159,41,151,149,68,133,32,69,85,138,69,120,2,19,3,67,30,20,91,180,11,211,83,247,4,32,145,216,214,85,85,190,135,43,241,174,56,121,203,67,61,83,114,75,239,56,10,106,45,150,228,112,53,72,83,199,221,242,57,110,63,177,231,151,173,194,143,31,115,68,89,190,47,177,218,42,189,176,104,171,163,106,116,46,197,119,251,148,125,146,98,245,209,120,232,140,8,37,119,54,191,4,200,179,168,102,72,60,146,113,102,51,253,148,154,226,42,158,44,232,16,102,
157,101,137,86,13,208,144,32,83,167,137,98,72,60,4,38,103,164,42,136,46,156,74,71,183,130,213,176,54,140,186,219,239,171,18,37,81,196,151,168,43,249,64,226,32,242,122,233,123,169,2,64,184,39,121,11,250,0,224,215,123,60,182,102,102,162,237,34,81,90,51,37,251,185,247,73,63,146,29,108,51,208,61,81,135,165,108,164,85,106,211,231,182,81,168,200,120,61,109,207,109,172,249,29,92,69,83,205,212,220,233,170,119,209,204,68,52,102,47,80,249,22,91,159,212,121,167,35,64,195,64,126,192,19,98,81,93,44,53,188,171,37,14,178,68,71,30,174,60,137,56,242,129,54,20,45,240,7,193,65,58,176,3,197,198,238,166,38,224,100,178,136,30,208,71,71,202,123,191,13,122,229,234,4,2,241,246,10,33,86,93,235,214,178,68,52,196,1,180,141,114,237,53,213,57,180,22,145,243,23,191,53,9,191,249,45,170,239,141,231,60,186,79,73,199,6,243,146,1,149,30,14,110,225,44,88,122,77,20,49,57,127,63,160,103,102,121,155,15,46,199,132,3,216,152,69,93,168,228,133,243,138,54,57,234,173,36,200,61,100,64,198,168,165,106,74,216,47,137,171,75,
17,138,201,73,116,27,72,154,39,213,117,126,2,148,107,229,152,26,214,166,46,219,188,157,104,150,124,198,5,209,145,27,220,41,54,217,178,111,133,160,125,122,186,247,92,149,26,140,85,15,1,216,48,73,132,66,8,253,172,10,36,47,41,103,132,105,181,183,206,68,146,4,64,89,69,17,194,35,189,42,141,48,165,160,146,63,86,89,140,210,112,64,160,29,29,40,79,137,121,129,128,52,36,242,159,185,27,95,200,63,186,113,64,230,136,239,166,32,166,38,105,56,17,219,61,49,75,28,150,2,148,231,4,111,11,245,120,101,28,209,5,250,184,20,141,20,239,33,57,148,115,201,78,134,42,94,90,110,128,132,40,39,67,110,67,95,170,85,79,73,162,116,56,133,197,166,69,153,31,176,60,156,125,55,47,148,218,104,177,153,252,29,6,90,165,130,204,66,240,142,228,154,61,145,60,91,2,224,64,27,174,136,80,222,73,62,245,225,238,5,150,206,86,142,200,139,156,75,102,94,142,38,50,235,107,132,54,215,208,172,77,248,87,75,88,182,141,181,190,64,40,10,158,176,73,84,101,159,217,4,143,42,79,223,64,132,164,60,87,38,34,45,33,30,29,97,219,6,115,133,16,23,250,
9,228,178,49,104,189,67,189,12,193,252,103,226,133,189,7,215,197,7,138,29,223,60,184,226,231,98,111,251,193,215,143,182,191,162,64,17,98,179,129,120,253,115,241,232,155,47,252,216,30,67,50,126,236,155,237,189,95,127,177,253,69,243,24,106,244,207,197,215,95,125,227,199,190,120,180,231,199,30,61,218,126,248,245,215,237,213,240,205,44,184,69,104,63,75,85,49,170,55,3,212,143,104,246,94,102,132,98,83,205,69,16,171,68,189,115,235,139,15,250,18,28,147,44,91,82,109,39,192,98,75,131,9,161,40,237,197,122,180,88,96,29,212,80,181,140,108,200,117,124,115,205,61,71,211,61,119,168,178,124,93,59,195,72,172,132,246,95,62,248,71,209,209,91,137,173,219,112,35,151,191,212,158,24,244,64,69,108,6,100,237,34,15,109,173,65,86,99,168,45,4,149,217,131,17,97,49,15,38,176,224,39,252,162,250,144,119,198,210,96,30,9,179,120,211,88,2,240,140,118,10,69,213,75,210,20,132,241,38,140,134,91,32,178,217,250,130,87,152,94,184,154,176,48,243,83,204,214,205,22,75,2,100,230,12,98,3,210,125,226,60,190,149,86,100,25,66,
103,108,220,64,44,73,149,28,171,148,217,234,72,22,128,204,160,128,141,105,36,89,82,230,53,95,170,33,19,106,150,53,35,104,69,83,42,23,52,173,166,132,62,42,49,149,74,73,102,82,160,173,189,47,255,145,66,76,34,37,181,30,188,61,1,80,208,20,213,205,100,112,227,167,109,91,173,206,172,105,16,37,226,128,23,1,90,221,57,182,3,83,252,86,251,30,152,50,96,104,36,44,117,248,115,249,27,42,198,105,178,238,46,55,4,51,136,188,162,62,3,160,123,219,197,35,103,74,95,108,83,117,69,135,251,50,245,80,70,52,107,180,79,56,233,147,100,124,179,146,247,39,236,94,94,99,164,84,249,208,3,30,215,74,15,223,18,18,56,148,216,189,27,170,47,0,67,216,65,252,24,118,20,72,122,50,84,90,46,244,61,79,129,233,117,251,64,98,80,11,22,132,210,158,16,11,115,231,170,143,202,246,13,212,128,233,69,81,198,214,162,38,238,28,22,208,69,182,212,148,17,130,180,136,242,0,133,216,218,251,64,39,99,57,205,60,91,247,231,34,181,118,87,85,63,197,101,64,209,167,117,65,237,73,162,69,58,58,83,185,41,12,125,191,192,142,176,170,148,92,223,182,5,
207,228,36,178,101,69,128,151,174,73,4,120,72,169,170,252,16,127,65,156,45,22,217,52,214,102,89,153,67,237,155,229,138,34,190,104,168,32,39,155,211,107,61,60,83,208,102,250,173,198,52,117,103,48,252,183,226,30,151,37,52,154,98,225,203,149,95,38,81,65,69,157,26,253,159,18,32,255,135,253,194,143,82,217,69,61,152,144,44,133,107,217,70,67,222,12,215,137,21,113,145,85,252,142,218,84,150,171,22,239,12,196,46,203,142,146,152,215,152,229,136,174,26,191,31,144,183,169,65,9,134,209,214,58,141,234,184,25,211,130,25,201,17,152,130,50,66,44,113,160,45,107,173,36,36,73,148,234,31,206,224,148,241,240,62,22,209,129,210,146,138,171,252,23,60,203,181,127,37,63,51,60,38,212,114,51,74,85,130,144,204,92,249,87,221,137,238,185,236,188,214,226,123,66,192,136,33,66,120,111,87,247,163,126,23,163,185,150,3,143,173,96,156,109,195,44,140,50,43,248,5,199,179,252,245,158,55,135,190,226,92,142,208,190,98,223,126,177,247,5,224,222,206,124,28,35,235,251,148,164,168,224,196,146,77,245,91,99,49,1,66,61,62,21,250,
22,97,232,106,84,127,68,76,160,166,112,46,217,165,216,73,192,139,188,153,109,228,44,152,39,196,215,212,37,117,76,161,13,82,108,172,20,90,68,171,206,9,51,171,208,212,114,152,98,153,141,103,164,104,180,234,60,126,32,147,144,242,20,241,206,40,64,2,100,162,137,232,45,16,130,196,78,55,227,169,246,71,45,58,8,144,34,105,191,143,166,193,158,212,190,101,113,25,77,190,18,169,85,71,193,168,188,57,199,239,46,109,246,50,190,72,108,146,152,154,37,254,126,159,80,134,241,11,244,57,226,49,99,128,20,0,142,226,186,107,26,124,196,113,80,33,19,70,5,248,219,210,181,112,73,164,191,236,201,245,8,209,102,23,210,120,77,195,74,186,219,67,120,8,66,12,238,18,216,43,2,247,11,33,47,154,54,81,54,236,34,113,35,100,122,66,133,5,137,84,191,233,42,94,203,6,49,179,231,158,42,2,161,172,223,61,252,192,0,101,50,225,29,95,135,241,144,73,244,75,154,69,255,68,217,243,174,2,44,100,250,94,164,158,90,57,167,219,33,152,72,68,228,207,166,43,132,124,90,253,177,252,110,201,104,248,108,32,194,121,152,235,110,169,93,21,216,227,
161,26,179,218,86,147,78,168,247,230,169,39,244,55,225,137,216,175,233,103,145,89,205,120,213,64,233,249,204,150,96,158,132,45,2,242,156,156,82,216,29,44,70,204,243,195,7,26,196,106,135,215,148,10,154,244,7,12,228,34,100,225,195,136,105,28,237,92,51,246,77,179,144,248,1,149,200,33,59,72,121,50,9,202,142,42,66,66,82,5,189,41,25,172,23,77,130,26,160,202,156,40,227,152,135,109,15,225,128,22,103,147,126,201,203,169,236,19,168,162,2,40,36,116,229,127,174,253,188,71,145,136,85,36,86,84,117,102,229,181,6,39,166,242,236,152,134,40,100,18,162,233,203,154,6,13,24,206,203,219,236,215,124,44,173,25,125,196,49,136,25,101,56,17,141,98,166,151,147,3,162,38,35,71,151,42,152,138,28,60,125,19,208,165,114,150,75,185,213,7,191,19,53,28,155,108,125,28,131,159,230,20,24,42,125,172,201,22,3,46,102,40,145,232,112,66,48,89,35,106,43,110,236,0,141,158,122,77,200,176,83,24,168,28,94,192,26,113,5,245,56,212,236,140,166,11,156,96,52,2,154,4,49,178,61,172,57,46,72,82,1,38,174,238,11,74,104,235,44,14,203,1,
21,83,41,54,84,62,70,227,23,41,196,86,150,40,186,194,185,220,247,93,11,174,97,4,84,38,50,229,143,183,62,44,81,252,154,206,122,110,130,241,126,240,119,7,94,167,7,230,197,195,135,33,117,161,250,233,232,73,16,154,101,94,150,61,195,245,130,6,226,7,16,197,118,71,38,140,44,202,141,169,156,141,57,51,198,41,19,118,177,71,81,71,12,181,128,175,16,187,36,242,229,89,117,106,129,35,215,241,160,158,130,28,207,200,103,150,201,112,62,193,224,133,249,82,114,205,3,96,195,33,1,41,50,145,3,120,70,133,31,119,52,208,233,1,0,37,97,224,115,213,153,86,182,198,32,175,71,151,36,180,19,173,205,75,42,10,156,187,125,151,9,54,55,197,136,77,164,70,23,81,134,20,218,84,154,2,73,219,29,118,10,147,9,54,74,235,249,217,10,91,99,204,182,146,235,92,25,204,168,97,144,96,125,158,225,222,204,246,136,233,151,77,18,150,91,75,4,15,5,18,223,18,2,13,117,228,2,209,152,77,152,17,34,173,33,171,30,114,198,134,246,163,233,15,20,168,172,181,123,129,230,0,246,51,89,250,186,134,181,155,98,40,61,156,219,100,130,178,158,241,13,105,133,
33,84,110,96,82,132,190,162,172,198,177,236,254,61,32,206,7,110,119,218,10,164,17,138,146,243,28,46,253,104,56,28,6,30,196,249,16,45,111,216,76,54,91,99,125,148,237,180,190,10,235,209,243,202,134,230,248,183,121,208,55,90,241,30,27,55,11,244,181,124,115,158,161,88,142,169,71,244,99,232,3,76,243,0,134,62,44,74,166,189,164,187,28,83,49,179,93,218,104,64,217,17,90,50,33,24,48,53,229,156,104,169,235,41,237,20,121,196,238,25,9,210,24,87,61,70,120,169,29,199,23,65,210,155,17,67,42,50,105,72,155,87,13,191,0,199,46,21,202,155,159,119,132,119,22,253,159,30,211,121,135,11,141,211,224,186,198,151,244,36,22,58,45,82,10,53,51,57,79,141,249,193,21,171,130,250,251,132,136,92,148,19,225,57,115,14,216,15,76,187,167,60,82,121,236,92,85,186,48,133,43,26,234,24,36,136,211,218,19,209,250,72,144,40,249,54,16,4,86,105,252,68,71,162,206,36,7,174,36,198,174,219,33,46,207,106,148,146,86,103,87,26,159,59,65,184,84,163,198,129,158,202,139,170,50,65,68,138,96,242,55,113,18,195,48,214,86,90,230,2,9,200,199,
140,206,84,88,80,134,44,225,137,150,128,114,84,140,152,99,194,9,98,162,137,41,127,237,31,36,70,116,6,243,14,74,81,21,81,215,235,219,143,189,56,120,138,123,86,231,2,167,16,67,108,161,242,248,139,232,200,201,75,72,161,93,105,24,43,211,166,204,106,155,22,121,172,141,150,96,194,94,35,168,7,39,103,197,214,1,12,38,111,47,78,48,207,103,75,60,196,61,162,87,233,177,201,151,104,34,45,31,211,57,153,205,77,12,196,87,7,72,68,20,58,0,28,203,113,112,97,30,48,115,23,139,59,244,64,182,99,16,13,149,139,250,126,184,115,149,150,164,133,91,212,254,0,164,241,131,196,162,254,70,21,127,204,190,131,106,101,240,82,255,230,172,142,106,26,58,224,39,243,16,161,118,208,171,145,86,126,238,93,249,36,144,92,145,236,249,92,189,46,53,193,162,23,17,208,207,153,200,139,102,141,42,156,245,8,177,4,74,63,72,168,177,17,8,174,99,96,134,42,123,239,84,2,130,207,59,244,215,167,74,102,240,199,56,200,139,193,229,50,87,106,129,74,169,33,22,83,253,38,198,181,105,135,201,123,156,79,200,206,144,57,234,241,244,189,205,210,32,213,
109,103,193,113,159,251,88,180,21,91,156,56,46,203,139,180,137,139,242,168,12,145,194,114,87,54,118,147,243,131,130,170,224,155,217,146,153,148,116,227,168,20,56,74,62,146,199,146,225,22,157,69,91,18,202,26,170,224,141,201,134,29,252,149,166,204,212,54,132,32,213,232,188,234,171,140,145,40,173,32,202,17,40,53,5,135,248,218,218,161,39,92,13,149,36,103,147,30,40,199,164,248,230,217,73,153,192,104,82,195,14,50,47,232,167,217,21,180,53,137,91,66,196,66,8,227,66,125,83,12,160,99,50,188,175,208,135,246,37,61,238,157,144,177,92,164,202,197,32,24,170,102,30,53,221,84,176,76,117,159,53,197,2,255,253,40,92,70,1,97,39,126,0,13,184,76,129,84,7,40,99,70,16,159,198,128,45,134,80,147,130,25,212,112,81,234,13,55,3,138,100,65,70,25,200,81,16,213,152,157,174,49,160,216,148,168,16,137,219,233,107,219,136,164,138,147,123,15,121,166,32,123,244,204,209,96,40,122,145,81,116,231,141,136,103,62,26,80,237,140,24,40,101,182,252,36,139,154,197,220,141,8,160,158,35,144,101,177,249,98,114,189,153,134,227,
4,117,180,93,97,142,170,141,12,210,99,183,132,74,10,160,76,193,100,203,86,178,43,104,169,128,151,242,125,182,79,170,125,234,77,5,201,210,61,97,144,235,15,88,45,79,204,186,234,86,142,226,20,94,140,213,13,125,206,211,249,122,0,218,18,51,152,239,210,86,154,175,141,218,136,163,117,16,73,221,156,228,7,36,10,155,47,57,137,176,28,249,200,239,230,115,44,226,166,213,35,207,174,0,12,124,150,138,114,38,86,22,47,166,132,147,200,37,143,113,170,140,31,58,144,188,53,46,80,181,86,140,160,213,88,202,104,105,167,100,88,13,49,222,19,105,191,176,115,86,148,197,58,4,181,133,11,4,179,171,128,230,75,141,220,200,58,81,122,243,92,117,61,44,222,106,34,107,104,213,239,32,72,20,190,156,79,169,11,68,232,88,131,32,183,163,94,232,170,42,89,57,245,204,186,173,145,97,68,158,81,165,85,131,35,179,137,119,102,165,182,223,71,134,144,54,69,47,62,187,103,224,147,118,74,169,197,177,80,113,10,61,87,178,217,240,138,6,185,232,251,76,70,169,62,122,75,126,17,21,38,147,45,199,216,54,211,109,71,83,135,243,62,228,128,56,250,
220,44,174,19,74,89,72,144,154,85,68,101,101,30,210,234,37,126,156,49,57,41,249,102,126,210,135,106,28,55,145,60,206,168,91,174,121,87,24,6,196,33,223,178,245,160,98,71,43,11,4,5,154,19,44,43,196,80,185,88,157,107,218,81,185,150,145,202,83,81,3,216,124,202,80,192,102,161,14,55,118,195,93,255,205,23,170,47,233,51,13,44,187,202,241,164,213,217,205,169,219,67,83,110,47,213,3,93,238,137,70,175,52,117,215,203,102,21,75,130,22,177,134,19,188,11,8,47,59,156,58,224,239,201,106,42,38,146,80,134,48,236,73,129,208,191,243,74,231,141,120,212,101,90,60,212,76,39,141,20,247,144,22,143,244,134,76,157,158,87,143,110,93,116,196,85,149,104,246,137,142,233,236,208,246,208,159,148,84,28,58,32,36,237,146,31,20,246,51,110,64,143,177,53,51,183,113,241,237,243,199,72,25,85,12,164,159,90,0,141,40,79,84,168,203,67,194,225,225,10,75,142,79,88,164,86,167,50,74,233,65,102,77,78,44,62,58,126,141,65,0,141,204,156,56,154,183,121,234,35,174,167,130,88,227,111,175,12,4,3,202,250,56,200,41,28,80,39,17,82,183,0,
100,146,203,68,202,253,198,28,56,214,24,104,54,54,94,102,208,111,45,113,53,192,103,106,82,152,81,2,205,112,198,154,228,112,156,43,148,172,185,144,189,40,231,239,184,186,64,11,101,196,111,45,180,2,75,67,31,104,203,68,31,122,201,127,2,172,25,241,240,128,29,226,83,214,219,48,136,254,78,3,134,154,119,25,14,131,158,183,246,193,17,169,161,215,162,182,206,118,76,122,110,187,201,133,168,226,121,67,112,70,12,203,212,46,86,37,33,209,172,254,202,7,57,92,132,142,252,41,135,195,155,47,29,62,189,140,78,0,118,217,119,50,52,169,45,33,225,218,17,72,130,91,206,47,23,155,79,35,237,219,164,241,97,219,36,186,207,49,240,153,92,49,195,185,217,224,69,169,76,100,201,110,75,148,129,161,150,117,145,9,103,116,78,60,143,192,71,239,93,1,124,26,7,146,232,139,154,57,116,130,92,46,70,242,8,73,12,238,94,109,102,200,110,106,107,205,132,127,136,84,226,172,244,230,105,144,59,194,4,61,221,76,150,248,89,84,38,8,176,162,51,192,195,62,82,1,250,70,234,224,104,169,25,181,54,194,48,109,29,190,18,177,1,174,51,55,162,236,
249,125,43,68,128,198,161,86,202,5,185,52,224,27,34,218,176,201,219,37,208,116,143,195,45,160,238,72,181,78,235,243,12,224,29,22,145,221,87,210,172,122,107,159,223,167,32,27,132,64,59,141,79,36,221,117,91,199,238,46,99,40,37,243,235,212,28,20,139,190,27,171,177,99,121,103,228,116,182,232,33,116,59,107,100,126,169,179,189,202,206,36,28,191,199,14,50,115,57,146,172,252,65,37,113,223,181,112,232,246,179,175,90,184,15,187,125,196,66,202,139,6,123,55,254,12,216,162,138,46,111,149,72,206,154,169,158,130,204,68,217,201,3,2,75,38,36,92,183,22,51,147,236,66,144,196,28,125,232,133,173,235,214,235,32,187,96,133,92,41,200,72,164,143,71,195,172,194,46,194,5,226,139,58,221,212,90,238,7,53,114,32,125,75,116,202,18,151,151,74,58,242,201,100,200,65,127,158,122,200,120,129,247,29,232,80,243,27,149,58,175,136,223,109,80,75,123,131,87,104,251,62,84,213,140,36,108,171,136,53,73,1,26,127,134,13,207,238,12,162,231,66,86,210,100,161,74,63,146,96,140,83,145,30,130,23,17,145,9,2,231,22,67,164,5,171,226,
51,171,118,50,255,84,62,83,161,15,63,222,102,156,75,164,17,31,221,252,202,203,141,35,208,162,102,71,109,130,64,94,86,25,155,86,23,167,225,55,24,181,189,50,153,116,11,27,69,76,25,126,156,208,177,237,151,132,185,233,177,5,76,77,131,18,218,105,160,90,72,237,214,226,220,50,31,49,114,144,179,189,84,249,224,10,7,100,121,215,119,175,68,217,147,225,97,32,67,95,207,36,102,212,174,19,125,41,82,214,243,106,201,170,180,116,46,164,172,181,91,202,30,231,201,101,99,215,235,19,61,150,216,156,102,16,87,58,187,147,212,101,216,88,102,88,114,70,179,30,134,137,114,217,202,123,158,1,157,239,122,125,2,91,13,179,239,199,73,133,21,197,91,229,100,195,102,203,68,138,238,179,84,218,208,222,210,182,65,211,90,197,209,40,63,197,108,75,150,146,244,120,94,45,130,39,169,44,204,150,4,1,107,193,220,40,41,116,86,219,221,144,133,218,154,55,18,222,34,133,99,83,229,23,168,64,251,28,158,150,139,42,83,13,172,60,135,192,200,210,31,93,221,173,135,59,143,178,235,10,115,177,182,175,132,73,114,198,17,106,108,127,166,184,226,
234,75,133,47,96,181,80,10,25,45,57,97,66,179,161,133,174,107,178,240,54,210,38,234,46,113,132,55,103,124,154,64,80,107,76,221,127,35,40,8,229,15,35,103,33,1,80,51,33,52,37,62,119,30,33,133,70,145,149,181,161,254,10,186,60,52,19,129,35,243,44,215,40,251,228,220,131,197,145,97,82,102,153,145,23,145,220,81,45,98,51,190,190,168,145,113,71,211,49,35,113,251,53,179,147,245,37,49,0,146,178,54,140,7,199,183,49,195,85,223,78,113,84,254,145,254,79,4,176,9,102,13,84,212,175,166,25,159,250,109,17,12,35,192,236,18,36,130,30,106,120,213,50,94,31,122,8,181,157,235,24,94,118,108,232,214,126,29,35,202,51,164,190,7,114,179,57,25,239,198,73,191,254,110,214,125,162,11,101,72,112,37,188,251,38,157,209,93,178,109,149,134,251,187,89,24,42,46,126,240,115,203,49,79,178,197,137,225,58,208,44,248,140,17,176,19,87,23,28,108,164,54,140,170,33,58,200,171,186,148,162,78,254,34,102,199,133,25,193,211,34,206,51,108,81,234,231,138,2,90,235,177,26,171,159,82,78,164,151,78,205,158,83,180,217,40,216,211,166,66,
62,78,21,25,32,142,88,185,82,37,64,84,181,159,10,215,238,130,99,19,228,44,52,29,97,94,203,50,6,60,110,124,227,140,157,48,158,82,25,218,198,6,170,24,243,204,53,236,76,216,4,111,150,24,167,135,62,51,71,200,147,231,186,21,158,234,112,80,76,97,189,27,76,167,178,53,98,178,77,57,10,186,82,131,109,234,245,220,238,130,67,57,80,175,106,152,162,12,220,58,173,42,119,43,180,64,108,207,238,171,121,103,44,145,243,132,149,25,92,189,149,53,54,222,198,136,166,238,179,165,181,150,48,177,163,161,212,29,20,170,33,73,41,176,219,165,177,150,26,77,251,138,112,96,51,10,151,75,43,144,71,168,148,153,45,77,213,6,103,70,22,164,124,121,55,65,131,62,69,107,42,95,11,80,198,149,38,9,101,132,64,7,75,247,137,185,36,94,138,31,241,164,232,87,98,31,250,159,2,94,213,228,100,170,84,148,11,33,147,13,37,51,205,146,39,34,39,62,242,145,226,253,108,35,133,5,207,150,205,80,157,47,210,73,250,41,169,217,153,92,236,196,248,59,146,116,137,13,81,248,215,184,111,78,45,115,8,78,198,200,142,63,236,146,26,78,156,113,138,25,125,247,
80,217,15,40,83,129,48,238,202,97,48,170,71,108,160,173,18,70,245,82,98,76,30,49,210,164,5,80,158,230,83,238,46,84,171,119,129,9,245,115,78,67,242,211,206,37,164,63,58,163,124,138,249,153,95,113,116,57,18,14,3,94,87,109,222,87,187,228,135,112,68,243,217,126,48,147,19,92,68,230,228,87,217,251,77,29,43,250,60,130,7,115,48,0,169,79,192,5,80,195,41,169,151,175,47,177,181,145,218,239,248,106,17,214,190,226,219,246,245,18,186,149,46,185,183,220,225,11,244,25,141,243,237,72,46,241,48,111,180,100,231,231,78,114,218,55,26,69,218,179,203,44,6,87,26,65,5,5,103,192,107,210,178,173,11,6,20,180,92,234,214,214,208,226,57,46,3,11,213,94,203,203,126,124,17,228,62,9,110,128,159,23,172,137,199,150,200,16,76,158,76,49,3,231,75,93,1,161,18,11,71,73,56,62,57,25,81,182,208,149,81,20,154,199,49,222,148,141,97,176,12,228,34,245,137,195,39,12,177,105,150,105,43,225,3,106,243,123,27,27,79,39,75,157,110,56,144,41,3,252,83,77,253,100,189,118,62,236,34,73,4,89,148,209,252,112,152,133,132,24,66,207,182,248,
116,141,32,248,110,23,251,188,88,35,39,85,33,128,84,136,235,163,17,43,75,165,10,133,140,79,234,188,50,36,17,103,180,101,226,164,231,243,119,140,51,200,18,71,244,199,71,183,97,145,5,4,82,194,173,60,50,117,225,150,129,74,47,199,99,10,32,18,32,85,134,80,6,201,94,68,26,82,234,232,172,243,153,164,87,158,217,174,132,161,1,80,155,140,110,30,167,114,135,223,74,133,29,152,35,43,173,9,12,130,13,218,4,136,155,143,39,199,217,205,88,232,238,75,11,8,27,60,159,27,169,182,48,108,206,191,177,123,58,228,181,170,199,108,39,176,195,22,33,179,9,50,151,83,248,102,198,185,63,141,143,58,172,113,224,200,104,27,13,209,126,106,104,209,148,156,48,87,11,140,212,11,228,68,113,246,125,206,209,185,228,103,223,100,183,203,22,68,253,120,115,42,153,169,85,36,66,113,176,61,78,76,14,198,68,81,86,29,40,228,169,45,0,16,9,52,53,7,247,242,177,95,153,194,150,156,1,175,120,27,165,253,92,30,110,139,57,1,44,42,6,255,132,35,186,139,70,111,182,49,84,197,233,209,158,110,130,248,54,157,20,20,75,22,128,137,97,169,100,42,164,
159,11,77,200,16,237,212,87,60,228,128,52,197,1,44,78,25,47,110,232,0,152,56,67,97,134,71,105,221,71,196,220,114,202,99,106,226,48,225,174,122,121,112,57,166,132,200,238,80,60,146,20,157,182,160,64,143,150,107,110,81,0,88,218,224,91,12,182,112,180,111,57,118,231,114,239,139,84,164,142,83,142,84,147,124,11,71,93,139,65,44,101,73,133,60,228,6,131,56,135,67,15,107,72,218,82,151,174,32,227,25,143,196,151,48,169,28,170,32,72,233,216,5,179,244,52,22,99,173,26,37,67,189,122,121,130,239,12,9,13,37,209,194,4,203,60,195,160,250,32,157,196,104,229,202,159,86,113,50,215,245,66,122,195,220,251,142,159,181,235,36,128,150,60,195,178,24,221,77,32,230,112,47,249,14,85,210,93,133,76,202,126,133,179,47,120,131,210,42,131,167,27,26,92,248,219,149,118,177,76,147,93,198,114,201,182,12,41,120,166,210,99,27,222,84,102,150,52,193,50,33,110,2,82,161,245,237,57,210,1,93,176,208,118,56,10,210,211,162,188,165,244,29,73,19,100,162,100,211,81,184,107,151,45,223,141,225,6,108,100,83,66,38,79,63,100,108,164,
33,144,183,61,12,81,55,118,138,255,204,96,233,74,117,144,203,22,26,200,165,182,178,135,83,232,122,27,19,34,17,14,100,98,4,106,45,176,250,215,146,38,104,239,16,164,53,86,132,21,213,22,97,223,179,167,205,97,130,90,8,8,223,1,218,129,254,248,74,75,96,204,145,140,160,82,206,158,253,180,32,78,33,147,188,186,92,110,80,52,84,34,69,47,26,56,171,102,242,130,113,76,124,159,73,75,207,13,35,211,250,171,145,149,31,180,74,70,93,82,19,121,244,229,52,199,37,137,139,55,37,140,126,88,55,48,16,187,122,203,104,252,196,231,62,233,12,244,190,121,227,64,105,6,53,4,249,93,221,196,209,155,120,32,92,245,205,143,231,86,114,37,33,86,30,105,87,20,171,119,115,148,14,182,202,73,33,159,46,253,193,166,32,105,83,6,11,83,102,19,5,46,77,84,200,175,82,232,198,21,245,48,244,242,179,189,226,72,42,135,195,126,131,104,41,207,222,17,206,130,16,84,180,203,14,83,55,212,90,148,111,192,142,214,139,66,31,152,245,182,109,38,92,8,2,35,184,138,98,242,253,73,251,170,7,228,144,216,91,120,166,213,249,76,56,183,112,154,13,250,146,
124,95,72,74,126,100,195,117,199,21,5,242,45,48,25,133,160,104,100,10,203,5,193,187,166,105,116,94,127,156,5,0,214,232,202,33,192,76,227,162,186,164,171,50,47,129,158,67,107,164,94,92,173,164,94,145,26,38,240,245,225,163,246,19,177,34,207,160,244,173,70,178,178,4,48,241,145,106,40,66,213,92,231,148,124,171,205,153,214,77,13,139,22,60,0,47,211,177,177,241,134,82,15,163,90,40,208,49,39,196,72,183,115,106,26,138,32,81,134,25,227,249,144,230,54,174,97,73,161,206,29,56,193,236,55,115,70,104,181,43,113,99,170,255,233,181,154,62,130,181,62,124,26,169,1,223,129,87,57,116,159,126,192,200,188,175,252,81,5,40,174,208,0,113,90,158,54,90,55,146,34,221,116,203,50,79,19,34,209,178,103,145,220,23,229,175,234,7,106,158,51,141,112,214,85,112,145,190,62,239,181,222,202,178,203,228,101,1,29,247,54,129,64,14,245,160,9,73,216,219,136,160,152,139,219,253,245,55,190,100,13,39,164,132,246,177,171,20,168,64,60,23,99,26,210,68,145,43,82,28,25,6,145,194,117,23,13,121,5,165,229,166,60,244,198,245,147,147,
241,206,234,199,40,207,123,34,129,29,15,221,128,179,247,74,150,27,72,117,5,179,252,150,162,155,135,162,177,246,208,221,30,18,28,169,41,23,98,232,35,221,229,33,57,81,3,246,167,242,87,69,187,187,249,171,149,17,22,153,212,168,42,165,120,132,10,199,157,76,230,40,242,231,98,50,69,230,84,21,183,35,254,75,178,251,192,33,33,6,51,170,2,34,66,86,169,20,45,194,118,149,155,146,153,175,79,71,197,183,228,216,190,196,151,111,67,72,98,214,218,66,17,129,24,175,167,115,249,245,249,156,108,211,179,39,202,7,8,114,145,123,93,146,69,255,198,191,167,64,200,246,19,186,201,228,100,13,124,92,156,232,230,182,99,43,226,118,241,154,218,244,118,241,61,179,177,234,115,190,166,209,174,11,98,116,243,231,118,241,196,215,186,125,27,119,188,241,7,149,110,186,43,61,158,127,75,147,159,199,152,191,196,12,56,165,202,170,41,17,60,240,101,41,136,222,17,57,95,186,29,27,221,102,52,176,127,131,159,76,173,14,3,135,238,36,34,25,74,78,197,14,151,132,244,143,139,205,253,100,245,177,47,206,68,83,151,175,245,177,221,176,175,114,
245,132,181,157,17,65,96,189,94,186,166,23,118,17,43,135,195,170,11,160,153,172,241,113,220,23,35,18,54,195,57,210,100,24,221,126,64,234,134,153,72,53,229,236,225,237,9,19,231,99,111,48,63,211,171,233,194,218,72,40,82,84,150,122,115,228,55,88,202,28,176,102,144,55,239,243,183,64,180,14,96,227,59,110,171,231,19,102,88,116,7,137,131,118,159,249,56,243,233,199,122,14,65,0,175,13,216,130,84,192,226,172,198,125,209,124,250,157,44,47,29,56,38,241,14,96,213,118,215,27,56,248,70,214,3,2,188,113,61,54,155,112,137,193,92,113,60,245,198,116,114,202,251,152,206,134,53,146,92,1,166,98,97,42,89,200,42,57,111,72,151,1,224,53,235,203,154,144,75,46,87,240,164,134,204,121,98,3,86,52,39,19,192,119,154,198,46,210,232,146,119,227,90,5,10,177,245,21,11,138,205,125,97,83,236,67,81,104,197,53,183,214,139,179,57,183,174,30,8,163,237,251,27,198,156,98,2,14,110,18,208,83,12,111,4,77,179,13,136,44,198,10,42,123,92,15,81,125,13,154,81,229,209,175,38,56,53,8,57,105,175,15,70,106,98,176,57,27,41,58,5,104,164,
199,220,45,206,139,46,28,38,68,145,178,47,139,45,236,223,56,218,73,43,96,81,190,29,14,239,73,70,235,254,47,0,224,190,168,137,180,71,255,31,199,103,60,199,92,82,210,69,242,126,221,11,130,180,167,147,12,154,216,209,9,137,40,212,81,177,116,77,63,2,151,48,98,108,166,2,46,65,57,0,99,15,117,112,20,109,86,240,247,114,160,219,81,85,145,206,206,19,234,85,31,42,154,185,4,153,36,58,173,213,105,228,147,91,50,14,192,58,41,120,88,55,109,136,119,186,144,88,183,246,59,189,123,225,19,2,26,221,143,211,75,198,210,231,62,229,191,43,38,53,229,97,119,25,108,25,232,174,31,149,55,25,21,39,216,188,164,86,100,55,233,161,160,136,108,120,52,227,161,6,67,131,57,134,91,12,241,216,200,240,70,30,177,166,143,242,33,238,246,36,35,211,233,113,2,89,119,198,40,89,58,148,34,108,184,77,3,102,238,201,17,80,181,35,124,39,37,95,212,102,255,229,211,175,190,128,73,251,74,255,157,251,235,174,146,24,140,176,224,219,224,120,200,205,137,185,196,11,128,84,100,154,141,125,176,2,122,164,17,46,81,70,163,40,117,82,75,39,130,77,
210,110,65,18,120,19,51,48,90,133,105,245,250,198,185,204,204,59,192,22,119,129,5,38,101,215,67,41,10,214,139,28,113,105,64,143,223,2,178,31,79,153,15,60,29,40,214,155,242,9,15,96,185,50,217,208,160,163,49,221,210,62,129,29,94,197,30,157,141,104,33,129,161,103,178,184,210,79,199,174,163,130,164,106,153,232,197,164,173,162,75,62,76,195,137,8,41,220,187,100,137,214,77,154,18,65,29,96,119,148,79,215,76,193,52,139,171,118,198,117,240,113,16,72,128,202,160,164,107,103,153,111,167,209,36,149,144,85,150,146,123,63,21,69,8,234,157,123,104,103,23,148,220,103,91,125,209,197,106,157,143,64,247,52,181,160,64,128,29,212,196,73,182,194,132,89,81,195,156,166,75,164,226,146,2,98,41,239,65,89,187,249,213,14,77,82,18,13,100,159,61,71,48,179,74,188,215,21,98,34,236,184,79,247,243,50,149,243,67,55,197,101,16,23,69,115,155,117,21,99,40,114,198,51,217,144,37,179,14,25,234,30,173,201,160,67,119,250,133,18,90,47,26,130,20,140,2,69,154,238,158,244,86,205,138,111,171,15,20,200,43,213,147,248,58,170,156,
155,255,231,241,255,149,147,126,6,87,92,54,107,87,203,120,205,148,105,87,205,112,214,215,213,57,17,52,88,45,22,211,249,227,221,221,235,235,235,251,215,112,236,234,79,247,39,179,203,130,213,84,78,143,163,13,41,240,32,243,58,140,57,111,117,44,235,202,40,60,94,235,19,54,164,179,107,215,41,25,242,26,89,239,237,56,80,28,181,149,116,182,12,164,128,39,17,72,204,116,121,217,184,110,174,67,160,139,229,83,83,202,51,207,208,3,113,226,18,179,157,72,232,32,137,104,116,108,253,86,224,44,1,81,125,226,163,21,20,183,104,148,101,234,189,196,201,92,104,215,71,183,64,216,196,66,53,21,108,22,70,184,20,154,147,244,171,174,29,147,9,138,221,201,67,197,50,117,194,69,45,41,23,11,82,8,174,125,252,29,107,199,88,15,203,157,37,112,210,152,149,233,77,112,215,206,206,172,109,225,27,26,143,168,89,48,30,246,89,13,161,149,131,67,1,194,246,20,0,146,111,65,211,100,200,1,46,206,16,238,6,156,108,125,132,121,166,112,98,203,76,207,170,185,150,206,105,55,14,232,253,128,131,167,9,190,52,150,203,174,249,96,31,18,175,54,
244,177,107,232,132,150,117,13,71,212,141,42,122,157,193,134,163,8,54,229,203,124,242,202,234,183,100,94,251,151,12,32,213,127,192,53,231,95,33,20,135,30,40,111,240,219,136,98,179,60,241,6,14,88,161,219,191,148,34,247,38,219,157,105,243,37,197,86,121,12,142,239,215,22,12,148,158,122,98,31,130,68,245,245,227,45,170,214,136,139,9,181,250,36,202,159,36,12,90,166,102,201,136,86,10,243,104,190,74,108,234,219,91,144,157,166,221,117,166,162,163,234,203,84,61,211,13,6,84,139,46,46,228,47,226,244,27,236,253,40,122,68,14,142,230,228,79,68,221,22,158,167,77,83,174,166,94,32,251,54,27,99,110,213,135,115,191,193,213,251,225,204,158,232,150,108,228,240,32,251,23,89,120,79,30,80,78,72,179,93,246,14,33,107,28,106,61,199,187,236,122,8,45,217,98,170,167,188,227,49,2,232,1,218,158,120,113,53,212,157,28,121,212,249,57,133,86,17,4,110,75,57,168,214,70,131,74,161,78,64,210,14,158,37,105,159,38,62,153,243,22,176,88,200,191,199,66,100,217,103,149,103,174,210,123,184,141,131,17,12,79,112,224,0,227,25,
118,197,186,153,141,133,25,153,136,131,73,100,252,177,196,185,242,107,135,136,202,66,84,165,104,113,238,204,71,132,116,104,14,132,157,224,105,66,42,233,77,187,147,177,113,146,122,2,41,4,36,248,113,145,57,42,34,46,7,185,55,36,226,70,141,203,177,81,18,20,42,106,208,150,41,146,133,174,93,8,183,165,153,126,108,33,209,20,145,63,129,18,173,229,100,251,206,213,112,142,223,47,147,88,48,164,38,168,206,40,189,22,5,78,50,114,41,43,48,179,147,43,67,240,106,87,134,123,214,65,201,232,47,69,123,41,150,189,129,229,113,207,50,198,147,11,187,35,254,146,73,84,211,107,55,183,180,144,130,82,23,247,249,172,31,245,120,59,122,181,158,84,102,167,39,37,151,71,241,133,22,61,97,174,163,118,240,243,149,227,83,142,128,214,30,9,254,168,18,95,233,180,136,131,225,149,86,27,30,193,102,121,207,215,245,170,81,159,107,254,178,27,128,68,21,41,14,138,198,18,54,227,60,70,53,45,109,44,91,250,80,111,195,50,133,97,252,246,27,206,137,196,153,36,233,88,96,97,32,26,195,140,230,6,68,98,249,156,203,204,85,80,74,135,98,21,31,
208,35,106,164,95,84,209,207,13,83,154,179,171,251,120,82,183,218,213,20,97,212,63,249,188,186,237,22,173,54,73,86,77,16,87,170,57,99,59,156,156,3,105,106,194,201,13,69,9,91,191,169,40,28,103,106,195,25,116,69,233,204,228,75,72,200,89,199,151,18,93,201,55,249,39,221,28,82,0,88,73,187,211,9,118,138,29,57,178,53,107,60,169,58,32,34,149,69,54,101,28,244,124,85,142,255,212,187,189,179,122,62,173,111,246,78,234,177,102,172,220,137,142,115,105,12,121,18,150,210,147,113,37,220,93,204,108,155,28,137,125,75,232,71,146,192,136,11,33,62,250,77,180,238,39,241,84,138,104,191,32,56,109,238,6,195,215,247,43,133,95,124,155,5,13,174,41,78,195,102,201,204,200,223,198,97,203,49,119,254,84,4,176,201,166,211,31,12,170,168,147,224,120,77,154,226,218,120,211,91,202,199,143,196,107,157,121,137,11,192,212,7,161,22,39,112,180,191,204,99,10,203,211,111,224,210,227,169,232,167,48,195,154,156,74,33,46,140,217,117,107,123,254,115,44,125,55,105,2,35,95,112,162,189,64,71,185,153,162,101,64,86,155,212,54,205,
11,212,141,224,84,20,52,93,35,73,34,202,94,189,19,74,106,113,230,80,163,205,7,133,199,200,18,66,211,67,97,44,73,24,43,9,222,155,179,103,59,223,88,220,245,183,135,95,33,28,160,45,69,146,84,178,115,50,93,62,235,149,26,194,182,52,170,126,40,225,75,150,192,60,65,102,147,156,138,59,113,238,174,54,205,195,234,178,236,213,245,230,157,135,123,95,238,53,7,65,155,109,149,221,56,75,241,89,150,150,98,139,238,237,77,193,210,66,0,131,208,140,84,222,230,134,42,209,14,110,59,99,112,45,105,245,224,113,224,196,38,254,237,51,90,212,83,76,90,57,21,123,83,161,77,145,179,15,45,91,79,25,82,255,227,160,129,215,189,17,182,37,120,110,195,180,175,177,35,205,249,175,0,107,81,80,172,199,57,75,121,29,160,67,165,113,65,87,197,254,233,193,145,47,118,205,183,123,36,135,240,54,178,171,160,82,205,18,217,4,221,252,103,211,87,71,151,68,252,237,89,16,109,141,173,4,195,90,237,227,74,59,57,170,56,56,225,81,68,79,142,134,113,2,94,141,86,104,72,112,77,154,210,188,5,9,224,248,118,238,172,96,32,210,77,190,173,116,216,69,
55,24,150,252,31,11,37,241,209,205,59,2,135,132,86,89,163,212,245,82,117,100,220,133,24,196,243,99,122,31,41,48,226,220,83,156,124,189,168,42,28,102,58,195,35,213,96,133,150,126,102,115,41,17,75,191,166,198,39,87,125,109,200,176,124,143,54,89,65,110,85,40,182,11,151,85,66,160,93,104,89,199,214,19,5,200,147,40,149,90,246,117,178,10,196,244,247,40,131,248,140,8,253,135,1,215,158,225,27,229,251,76,69,56,103,62,204,164,248,250,109,4,162,122,92,95,100,170,35,202,236,23,229,0,95,214,113,13,113,98,46,64,99,30,0,238,185,10,142,58,203,30,104,152,71,150,8,127,131,17,2,32,2,186,108,147,108,19,1,211,119,234,214,163,11,186,61,67,35,234,105,106,34,140,215,152,251,162,246,116,182,142,251,197,185,53,106,79,81,201,255,36,148,144,192,140,28,27,242,139,41,146,65,133,117,45,227,29,39,211,128,81,15,16,202,176,50,190,121,72,6,236,224,18,115,251,65,121,189,107,7,226,80,58,123,203,109,192,83,201,120,148,195,148,132,97,207,174,116,212,57,236,89,140,173,185,140,134,211,37,30,162,146,133,112,112,76,50,
216,44,179,180,11,24,12,3,216,236,249,86,47,100,41,6,54,116,125,201,84,193,58,164,81,158,227,235,55,69,101,1,151,35,95,91,133,164,196,191,129,130,43,159,67,54,133,102,196,9,149,38,198,38,51,255,6,27,254,204,22,56,57,160,161,226,17,185,87,43,156,227,176,102,38,10,83,138,2,103,143,35,65,172,187,114,245,132,81,42,82,230,236,86,56,74,114,135,131,115,4,132,243,149,140,183,149,11,40,42,187,131,220,185,205,139,38,247,184,179,88,119,147,43,63,23,69,176,49,188,67,13,238,82,183,190,229,223,215,230,201,105,125,197,252,141,130,73,128,53,75,219,168,202,135,57,8,145,31,210,237,203,114,47,234,62,4,187,185,74,73,177,29,32,33,18,108,200,106,76,100,98,71,65,142,228,38,255,110,46,171,170,144,146,107,143,24,221,148,233,19,71,234,101,93,14,158,126,47,162,238,42,146,251,121,203,14,233,124,172,100,103,141,49,168,9,76,164,248,161,89,177,252,75,152,92,202,98,221,99,36,95,237,80,153,34,181,53,219,248,200,19,215,101,216,133,100,87,89,7,191,163,69,173,102,246,17,38,64,157,28,150,12,154,9,188,86,115,98,145,
220,132,97,255,116,155,149,68,115,192,58,81,19,134,158,24,28,43,135,177,23,157,47,56,215,173,201,155,136,212,196,241,200,189,195,152,212,96,213,253,23,10,219,213,14,135,70,33,26,125,110,198,200,90,9,122,178,153,90,54,250,195,245,200,119,38,8,145,115,158,139,35,217,111,228,206,146,45,169,184,77,153,56,137,190,74,48,71,146,178,101,142,38,33,72,206,239,114,153,23,138,159,41,150,226,95,148,141,204,68,204,111,42,114,168,188,128,76,111,71,160,150,28,178,94,137,27,30,136,0,230,212,39,5,149,82,31,36,76,169,140,176,94,59,60,65,40,139,204,200,218,55,58,178,224,28,118,248,30,205,109,105,179,228,248,162,17,84,243,35,25,135,75,20,65,215,50,105,51,143,108,218,195,40,173,242,111,127,112,114,161,239,184,186,155,41,97,44,137,86,212,131,146,6,140,175,148,208,211,96,240,113,5,58,91,218,21,97,171,105,135,61,86,108,147,203,206,239,170,138,64,109,229,229,144,194,0,49,165,140,233,119,13,9,22,255,210,9,40,137,9,37,165,226,170,75,136,174,161,132,230,54,77,11,129,218,9,46,184,67,88,177,172,22,41,155,205,
26,52,180,7,223,30,117,237,42,14,254,40,50,211,173,70,10,43,160,172,251,28,168,5,23,58,156,79,62,88,43,148,167,219,131,91,107,106,211,5,43,164,202,192,200,20,84,92,90,187,42,63,9,148,196,127,148,98,93,126,236,47,169,156,219,212,212,7,141,20,8,32,247,92,127,192,111,160,76,26,179,30,88,4,15,211,6,24,23,93,221,107,246,201,9,166,43,56,162,233,14,120,139,43,194,138,148,87,107,110,17,249,215,53,203,210,123,58,105,174,83,128,187,254,180,35,206,210,45,130,228,191,195,224,179,186,113,181,166,61,102,53,225,153,28,45,24,150,197,155,211,39,77,197,67,231,225,217,212,97,165,7,79,178,179,39,69,86,60,92,155,197,120,183,230,84,93,67,201,74,22,110,10,49,208,221,244,130,205,103,197,141,130,98,162,12,169,191,65,108,117,92,52,168,228,72,93,250,145,197,222,92,243,28,140,6,177,25,32,225,151,3,25,62,217,65,154,139,241,154,130,17,153,53,244,77,211,201,184,50,159,40,148,237,18,45,221,32,234,163,38,114,75,144,231,9,206,2,148,148,234,235,26,106,95,51,34,155,127,181,156,201,79,228,243,116,210,38,64,117,96,
205,243,52,209,0,160,70,90,139,131,153,142,169,0,74,146,46,155,38,88,45,101,188,90,142,20,159,167,34,41,15,56,46,89,99,72,222,107,45,148,143,155,114,115,121,21,78,249,3,10,10,44,115,68,147,106,237,158,99,80,179,251,28,53,98,130,196,240,219,196,195,210,64,37,79,220,155,170,105,86,95,32,142,82,101,44,27,236,32,230,53,39,117,108,78,70,81,89,73,242,38,12,49,45,210,209,228,108,99,64,60,73,125,50,102,191,66,132,194,116,41,142,136,250,235,186,66,160,240,132,83,58,41,217,120,161,84,99,94,229,93,83,212,128,139,220,97,194,138,215,46,141,38,67,37,98,228,26,50,194,166,192,217,129,67,109,89,37,69,98,69,13,19,184,96,21,149,185,173,82,216,226,198,147,76,195,52,30,74,49,11,220,139,41,56,107,40,164,215,67,49,94,148,38,181,156,105,243,98,191,226,186,135,48,2,181,64,73,208,105,184,168,137,194,206,21,195,34,152,9,153,216,98,51,107,190,192,91,39,16,191,103,118,176,88,218,9,33,173,207,217,208,62,136,128,33,215,68,234,96,205,209,220,138,80,242,43,220,254,169,56,137,203,239,48,175,89,29,194,165,65,65,
48,90,78,87,31,201,181,123,84,224,233,139,23,77,220,38,160,213,44,20,117,146,75,9,186,33,67,136,125,106,184,177,214,75,5,255,186,103,66,18,23,59,241,170,80,187,210,237,45,235,248,133,89,129,176,185,129,96,97,85,108,88,135,140,226,245,202,46,124,201,71,90,50,187,205,204,84,238,208,29,235,150,8,185,29,121,61,199,199,12,87,234,121,142,253,95,77,34,244,211,171,232,44,37,211,149,117,67,230,249,146,152,200,118,34,170,157,186,75,155,118,164,199,198,244,38,134,105,6,162,79,88,35,37,221,34,204,166,52,33,41,0,30,104,115,149,172,226,190,127,73,14,234,167,147,66,238,187,227,71,194,62,173,50,68,171,228,48,186,14,5,20,191,129,133,238,121,146,248,68,215,157,120,217,141,101,231,21,6,54,250,135,74,75,235,251,106,181,33,129,240,66,229,75,217,196,38,69,241,17,56,89,202,214,211,68,131,117,87,30,160,93,33,204,253,116,197,167,58,26,200,28,27,220,129,205,144,191,10,74,228,80,244,7,14,125,201,99,38,125,215,217,71,197,88,46,87,98,49,35,250,134,146,84,5,91,10,47,16,117,176,73,176,68,176,13,139,163,52,
33,121,83,164,206,54,199,206,91,237,172,204,227,122,138,94,62,199,65,4,148,225,98,101,221,103,175,57,129,36,106,0,109,247,118,251,54,12,49,69,215,10,105,241,23,146,154,168,136,10,138,253,215,71,196,20,220,244,29,106,186,178,110,67,192,214,186,49,0,9,231,214,5,92,52,167,216,146,227,156,54,45,91,100,23,8,45,69,205,46,182,126,173,81,6,156,76,52,107,21,223,54,18,129,8,54,172,187,255,234,240,76,60,248,215,253,239,246,107,149,104,44,40,239,239,52,214,21,36,36,213,52,130,116,46,117,29,124,45,211,32,220,130,24,128,95,17,176,37,127,33,193,34,107,128,207,172,1,55,199,148,89,114,43,82,144,37,181,212,70,173,111,49,126,217,223,72,170,41,218,194,116,74,73,31,83,207,70,52,105,37,91,20,173,137,45,194,41,152,114,41,28,93,238,115,219,85,152,138,100,30,66,205,214,168,6,30,175,211,229,62,113,70,11,110,245,153,173,116,111,204,56,40,45,68,208,221,130,36,137,94,226,75,33,31,63,234,178,51,155,34,58,98,46,59,34,249,89,216,201,41,153,23,109,88,2,173,184,52,175,207,110,216,13,194,151,11,207,67,35,243,188,
227,88,87,177,58,84,67,12,213,195,73,249,177,83,57,249,157,20,219,148,186,130,79,21,16,140,110,188,7,32,118,95,65,124,197,159,249,10,212,180,119,100,72,209,185,178,236,248,34,35,140,184,155,243,88,176,232,158,232,26,213,116,96,166,54,11,35,156,23,227,105,243,145,164,243,84,123,234,126,228,116,133,76,242,157,53,190,138,129,178,13,183,200,203,76,70,46,10,140,57,149,214,47,80,11,13,207,198,150,142,65,243,161,66,168,116,175,27,97,41,101,230,11,202,211,216,108,18,137,243,74,83,137,210,205,228,78,216,176,197,59,205,2,207,213,56,144,181,243,180,2,113,157,71,79,156,249,72,7,85,185,161,4,145,60,112,182,228,185,152,166,159,85,204,193,71,213,197,175,31,81,234,59,245,66,180,250,206,191,182,82,189,8,149,89,228,101,90,119,180,6,226,32,154,189,71,156,224,5,116,215,205,28,246,42,223,134,48,81,253,169,205,91,219,144,8,117,186,10,178,90,58,245,199,250,61,226,102,87,2,118,108,140,47,248,205,77,252,98,11,238,88,118,201,232,185,26,200,154,11,240,173,35,73,195,204,39,223,157,76,102,151,187,238,4,84,
62,0,207,197,53,152,120,238,104,2,82,157,13,133,191,68,85,118,132,22,203,28,223,34,72,189,8,158,39,74,16,21,158,8,115,228,83,103,2,35,62,210,231,113,42,95,41,167,189,50,153,96,176,150,117,235,17,175,100,149,16,105,169,136,236,246,106,202,9,220,128,227,204,5,2,42,202,200,135,162,177,48,249,229,212,36,76,189,78,132,47,69,9,132,136,103,97,89,234,160,57,200,161,107,66,226,26,9,30,81,66,224,176,12,60,156,145,230,223,73,1,228,207,116,253,36,78,151,118,34,96,136,136,177,87,72,39,23,1,241,105,115,82,60,35,239,218,1,51,81,206,59,99,208,228,71,219,230,183,174,120,193,192,140,223,181,238,121,137,159,31,221,113,217,75,124,163,235,102,1,16,247,171,23,161,56,160,9,157,140,49,223,73,224,100,184,124,122,180,31,191,28,202,56,121,182,87,209,51,113,136,114,158,20,174,248,131,28,113,73,22,35,17,209,237,151,150,64,138,164,204,194,121,90,95,223,130,246,98,194,48,142,59,150,2,6,130,74,136,244,71,159,108,94,74,42,43,134,241,44,139,71,92,75,174,83,48,148,52,242,65,97,86,181,136,229,65,159,122,38,4,13,
209,37,137,171,242,28,139,43,11,240,189,187,46,236,181,231,94,180,115,187,61,191,89,143,119,112,123,215,218,124,71,238,0,126,246,6,125,24,12,139,253,143,54,233,17,183,85,5,180,210,173,43,91,221,10,108,84,14,135,29,213,130,86,64,10,246,26,153,90,29,6,72,186,185,34,158,111,53,45,132,206,233,110,21,101,146,84,157,154,67,248,162,161,56,27,69,194,152,41,66,69,45,6,135,191,59,44,54,255,183,158,80,119,236,95,52,129,16,19,207,137,152,18,172,167,190,163,37,233,76,176,138,20,216,195,76,201,86,227,231,176,223,31,153,105,74,6,164,32,80,98,164,48,46,69,211,178,171,104,65,183,179,164,229,214,224,235,90,228,93,115,88,177,39,219,235,53,15,104,39,107,235,162,10,11,169,214,174,99,221,69,204,163,216,78,41,249,116,207,38,168,16,55,207,135,108,30,241,192,111,164,120,202,196,172,57,42,199,101,35,38,218,200,208,105,1,254,206,80,100,16,210,17,132,12,164,170,22,239,76,124,230,34,213,213,70,204,121,153,181,52,117,227,245,154,140,52,107,69,212,5,52,179,148,217,38,45,183,125,138,86,171,15,48,144,44,203,
114,198,205,238,58,227,72,107,70,21,69,109,171,170,72,154,200,146,197,16,108,200,74,158,250,170,93,58,118,84,163,254,174,226,160,185,30,68,56,213,165,169,15,31,51,245,77,65,10,39,225,77,20,150,166,117,28,169,70,5,164,62,68,136,19,162,100,69,255,67,113,199,143,207,186,93,187,35,8,47,188,215,30,83,206,45,9,53,154,109,105,149,139,75,242,44,193,213,156,214,71,54,249,51,67,111,42,125,73,166,20,107,40,42,211,111,205,94,37,55,40,57,165,165,13,234,243,155,121,144,80,86,7,161,75,149,118,249,125,102,119,200,100,62,54,138,8,90,72,139,152,208,190,152,181,62,205,92,167,185,53,241,44,209,136,79,62,245,65,207,104,229,119,38,197,132,82,195,215,22,9,142,99,62,113,211,254,32,106,67,34,141,76,95,58,112,40,164,218,172,201,190,45,88,112,203,162,222,154,36,108,15,74,110,197,136,100,50,21,56,146,88,132,11,115,100,64,116,217,81,132,106,86,117,60,0,118,141,233,88,5,119,119,203,196,159,97,23,52,200,226,155,249,144,84,247,229,209,25,189,79,14,184,113,152,239,96,50,189,9,141,85,103,176,240,117,98,197,161,
50,22,130,36,53,45,183,60,150,154,166,82,207,185,176,230,7,226,207,252,173,110,27,43,184,140,224,181,206,175,2,168,172,30,231,154,81,41,13,195,17,38,82,30,128,207,169,232,67,212,236,223,198,9,61,221,235,35,195,148,30,159,231,20,87,1,27,191,192,18,170,88,92,234,36,79,164,225,186,140,9,213,85,149,27,86,179,144,72,135,57,37,128,206,156,166,108,210,119,231,193,52,221,116,151,180,46,127,229,164,66,30,64,180,81,3,30,152,85,111,80,43,76,116,206,181,187,102,92,194,164,55,137,44,222,120,89,25,227,41,86,130,153,139,193,133,254,172,140,214,148,59,22,104,226,235,162,10,45,13,107,120,146,24,30,117,19,169,205,98,157,127,192,242,15,181,66,234,147,9,242,12,93,10,254,235,163,204,4,230,144,200,251,82,164,225,152,72,235,89,81,154,73,36,226,5,157,7,150,140,114,106,152,89,38,118,252,35,89,166,62,209,227,100,21,105,124,29,15,18,183,56,48,60,28,190,192,55,71,9,151,144,0,44,164,74,24,34,183,25,192,238,153,171,233,43,174,21,5,118,66,204,186,105,6,121,245,81,70,7,236,150,231,170,188,233,6,89,215,220,160,
175,3,164,54,232,200,225,217,243,195,226,244,248,217,217,219,253,147,195,226,232,180,120,125,114,252,221,209,211,195,167,156,132,58,229,103,126,167,243,219,163,179,231,199,111,206,10,158,56,217,127,117,246,125,113,252,172,216,127,245,125,241,219,163,87,79,183,139,195,223,189,62,57,60,61,45,142,79,138,163,151,175,95,28,29,242,217,209,171,131,23,111,158,30,189,250,182,120,194,123,175,142,145,242,35,100,157,69,207,142,11,109,152,150,58,58,228,189,103,197,203,195,147,131,231,172,188,255,228,232,197,209,217,247,220,236,115,116,246,74,107,62,99,209,253,226,245,254,201,217,209,193,155,23,251,39,197,235,55,39,175,143,79,15,217,254,41,203,190,58,122,245,236,132,93,14,95,30,190,58,187,207,174,124,86,28,126,199,15,197,233,243,125,138,131,218,106,255,13,208,159,24,190,131,227,215,223,159,28,125,251,252,172,120,126,252,226,233,33,31,62,57,4,178,253,39,47,14,99,43,144,58,120,177,127,244,114,187,120,186,255,114,255,91,65,119,82,28,179,202,137,31,75,208,189,125,126,232,143,216,111,159,127,15,
206,142,142,95,9,141,131,227,87,103,39,252,184,13,150,39,103,245,171,111,143,78,15,57,217,118,114,116,42,130,60,59,57,102,121,145,147,55,68,179,87,122,239,213,97,172,34,82,27,234,154,35,60,34,44,222,128,116,13,203,211,195,253,23,172,5,123,94,173,60,12,55,117,31,234,191,255,219,47,126,241,203,79,252,231,23,221,63,29,5,58,10,116,20,232,40,208,81,224,239,158,2,159,228,52,255,238,169,212,17,224,47,69,129,79,146,199,95,254,165,160,249,203,239,243,105,248,127,234,83,127,121,248,127,22,59,254,8,121,127,22,56,118,72,116,20,248,27,167,192,255,224,159,191,113,20,126,230,224,139,67,119,255,243,51,71,188,67,175,163,64,71,129,142,2,29,5,62,3,5,126,36,28,255,248,215,159,97,239,110,137,142,2,29,5,126,102,20,248,184,197,248,41,223,252,204,136,210,161,211,81,160,163,192,79,165,192,79,49,24,159,244,236,79,5,224,111,236,249,159,113,233,254,111,140,19,29,184,29,5,58,10,116,20,232,40,208,81,160,163,192,95,17,5,212,48,249,43,2,231,51,128,242,177,192,247,51,44,221,45,209,166,192,207,79,116,218,216,
253,249,191,223,33,100,127,254,133,238,219,142,2,29,5,58,10,116,20,232,40,208,81,224,167,82,224,14,119,251,177,143,126,234,210,221,243,29,5,58,10,116,20,232,40,208,81,160,163,64,71,129,142,2,63,19,10,220,21,32,254,76,80,235,208,248,79,80,224,231,87,182,188,75,210,63,223,103,255,9,82,119,175,118,20,248,111,166,192,207,79,219,255,155,9,218,109,255,169,20,232,68,239,83,41,245,87,243,220,167,123,205,191,26,144,63,27,32,221,176,228,103,35,101,183,80,71,129,142,2,29,5,58,10,116,20,232,40,208,81,160,163,64,71,129,142,2,29,5,58,10,116,20,232,40,208,81,160,163,64,71,129,142,2,29,5,58,10,116,20,232,40,208,81,160,163,64,71,129,142,2,29,5,50,5,62,189,13,221,126,50,191,253,87,249,103,27,208,31,253,251,95,37,6,63,1,168,31,69,176,126,224,39,44,218,61,250,163,20,168,201,154,254,242,163,47,116,15,116,20,248,123,167,192,186,210,124,252,231,191,119,74,117,248,119,20,232,40,208,81,160,163,192,103,162,192,199,93,77,251,155,207,180,89,183,76,71,129,142,2,29,5,58,10,116,20,232,40,208,81,160,163,64,
71,129,142,2,29,5,58,10,116,20,232,40,208,81,160,163,192,223,2,5,218,133,161,79,255,251,127,17,102,221,145,233,255,34,194,118,203,118,20,232,40,240,89,41,240,233,198,178,121,242,179,2,208,45,214,81,160,163,192,127,132,2,141,66,234,111,255,145,21,186,119,58,10,116,20,232,40,80,83,224,151,191,252,255,2,0,0,0,255,255,3,0,33,85,184,202);


implementation

end.
