unit gossdat;
//## ==========================================================================================================================================================================================================================
//##
//## MIT License
//##
//## Copyright 2025 Blaiz Enterprises ( http://www.blaizenterprises.com )
//##
//## Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation
//## files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,
//## modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software
//## is furnished to do so, subject to the following conditions:
//##
//## The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
//##
//## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
//## OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//## LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//## CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//##
//## ==========================================================================================================================================================================================================================
//## Library.................. static data (gossdat.pas)
//## Version.................. 1.00.100
//## Items.................... -
//## Last Updated ............ 11jun2025
//## Lines of Code............ -
//##
//## main.pas ................ app code
//## gossroot.pas ............ console/gui app startup and control
//## gossio.pas .............. file io
//## gossimg.pas ............. image/graphics
//## gossnet.pas ............. network
//## gosswin.pas ............. 32bit windows api's/xbox controller
//## gosssnd.pas ............. sound/audio/midi/chimes
//## gossgui.pas ............. gui management/controls
//## gossdat.pas ............. app icons (24px and 20px) and help documents (gui only) in txt, bwd or bwp format
//## gosszip.pas ............. zip support
//## gossjpg.pas ............. jpeg support
//##
//## ==========================================================================================================================================================================================================================
//## Important Format(s) Note:
//##
//## Many of the images and documents used below require a specific file format and storage in a binary pascal array in order to work.  A free gui tool
//## is available at http://www.blaizenterprises.com/blaiztools.html  The tool provides one button actions for pasting and converting images into
//## TEA/JPEG/PNG image formats, and packing them into a pascal array, as well as support for loading, compressing and packing text documents into
//## pascal arrays.
//## ==========================================================================================================================================================================================================================
//## Performance Note:
//##
//## The runtime compiler options "Range Checking" and "Overflow Checking", when enabled under Delphi 3
//## (Project > Options > Complier > Runtime Errors) slow down graphics calculations by about 50%,
//## causing ~2x more CPU to be consumed.  For optimal performance, these options should be disabled
//## when compiling.
//## ==========================================================================================================================================================================================================================

interface

uses
   gossroot;

const
//program icons ----------------------------------------------------------------
//app icon (required) - 24w x 24h size in TEA format only, accessed via tepIcon24
//Note: This icon is used by Gossamer internally for display on the app's Window Header (Title bar) and must be in the TEA (text picture) format.
//      A separate MS icon (.ico) is required for display on Windows Desktop/Explorer/Taskbar etc, currently stored within the resource file
//      "<app name>-16-256.res"
program_icon24h
:array[0..2476] of byte=(
84,69,65,51,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,24,0,0,0,225,202,40,1,1,224,220,16,1,1,250,247,6,1,4,251,248,0,1,38,251,248,0,1,95,250,247,2,1,155,231,186,56,1,204,244,51,94,1,235,251,48,97,1,250,251,48,97,4,254,251,47,97,1,254,246,44,97,1,254,237,22,109,1,250,248,5,126,1,235,234,14,121,1,204,221,13,115,1,155,217,15,113,1,95,209,14,108,1,38,244,2,122,1,4,251,0,125,2,1,223,205,30,1,1,251,248,0,1,6,251,248,0,1,84,251,248,0,1,201,251,248,0,1,247,251,248,0,1,255,239,223,32,1,255,234,99,85,1,255,251,46,97,1,254,251,47,97,4,254,250,47,96,1,254,235,34,101,1,254,247,3,121,1,254,251,0,124,1,255,251,1,124,1,255,249,2,124,1,255,243,6,122,1,247,219,6,111,1,201,248,0,124,1,84,252,0,126,1,6,252,0,125,1,1,250,242,7,1,4,251,248,0,1,84,251,248,0,1,223,251,248,0,3,254,247,243,7,1,254,226,165,64,1,254,246,49,95,1,254,251,47,97,4,254,242,42,97,1,254,242,14,116,1,254,251,0,124,4,254,251,0,125,1,254,218,4,110,1,254,239,0,119,1,223,248,0,124,1,84,244,2,123,1,4,251,248,0,1,38,251,248,0,1,201,251,
248,0,5,254,232,212,34,1,254,229,106,79,1,254,238,81,87,1,254,239,73,90,1,254,241,66,91,1,254,240,56,92,1,254,235,28,105,1,254,249,1,122,1,254,251,0,124,4,254,250,0,124,1,254,228,3,115,1,254,215,9,111,1,254,223,8,115,1,201,231,9,119,1,38,251,248,0,1,95,251,248,0,1,247,251,248,0,3,254,244,240,17,1,254,233,229,34,1,254,211,186,45,1,254,223,156,53,1,254,236,160,50,1,254,238,160,50,1,254,234,153,54,1,254,224,137,63,1,254,228,62,105,1,254,251,0,123,3,254,245,0,123,1,254,236,0,121,1,254,224,0,117,1,254,221,0,118,1,254,234,2,124,1,254,245,2,125,1,247,250,1,126,1,95,237,235,1,1,155,250,248,0,1,255,251,248,1,1,254,244,240,22,1,254,200,192,73,1,254,148,135,100,1,254,119,103,108,1,254,104,69,110,1,254,124,76,109,1,254,162,106,99,1,254,226,156,63,1,254,250,175,37,1,254,247,173,38,1,254,222,118,79,1,254,244,11,119,1,254,247,0,123,1,254,209,0,123,1,254,151,0,122,1,254,122,0,120,1,254,107,0,119,1,254,110,0,120,1,254,126,0,121,1,254,216,0,124,1,255,251,0,125,1,155,221,213,10,1,204,242,239,0,
1,255,235,230,46,1,254,168,154,108,1,254,79,36,135,1,254,68,2,137,1,254,67,0,137,1,254,68,0,137,1,254,68,1,137,1,254,70,5,137,1,254,120,68,127,1,254,219,150,79,1,254,250,175,36,1,254,234,156,52,1,254,220,62,108,1,254,187,0,131,1,254,92,0,137,1,254,69,0,137,1,254,68,0,137,1,254,67,0,137,1,254,73,0,137,1,254,165,0,130,1,254,235,0,125,1,255,251,0,125,1,204,238,221,13,1,235,214,210,28,1,255,159,144,123,1,254,81,11,157,1,254,103,68,150,1,254,128,105,139,1,254,105,71,147,1,254,78,0,158,3,254,76,0,158,1,254,130,72,144,1,254,234,160,69,1,254,240,166,51,1,254,161,79,130,1,254,86,2,157,1,254,77,0,158,1,254,78,0,158,2,254,77,0,158,1,254,111,0,154,1,254,240,0,127,1,254,251,0,125,1,255,251,0,125,1,235,241,221,13,1,250,220,214,68,1,254,129,98,164,1,254,140,113,157,1,254,219,211,86,1,254,235,230,59,1,254,200,187,92,1,254,115,55,162,1,254,88,0,180,1,254,89,0,179,2,254,91,8,179,1,254,178,112,138,1,254,197,127,123,1,254,108,38,174,1,254,105,0,174,1,254,90,0,179,1,254,89,0,179,2,254,85,0,180,1,
254,161,0,160,1,254,249,0,125,1,254,251,0,124,1,254,251,0,124,1,250,240,221,13,1,254,227,220,83,1,254,131,91,186,1,254,179,159,153,1,254,239,233,67,1,254,196,179,137,1,254,146,100,163,1,254,148,92,151,1,254,103,12,198,1,254,99,0,201,2,254,100,1,201,1,254,117,39,192,1,254,118,39,192,1,254,156,0,179,1,254,170,0,175,1,254,97,0,201,1,254,99,0,201,2,254,101,0,200,1,254,176,3,156,1,254,237,2,118,1,254,251,0,123,2,254,237,221,14,1,254,241,237,60,1,254,162,129,186,1,254,130,72,212,1,254,153,113,199,1,254,121,52,217,1,254,164,133,180,1,254,190,167,123,1,254,119,45,211,1,254,110,0,222,3,254,109,0,222,1,254,126,17,207,1,254,217,8,149,1,254,151,0,205,1,254,108,0,223,1,254,110,0,222,2,254,121,0,218,1,254,216,2,158,1,254,227,7,116,1,254,242,1,119,1,254,250,0,122,1,254,222,209,21,1,254,248,246,4,1,254,231,222,101,1,254,189,162,173,1,254,149,96,216,1,254,125,33,240,1,254,221,206,118,1,254,219,210,98,1,254,134,70,225,1,254,121,0,243,3,254,127,31,238,1,254,182,111,167,1,254,212,67,139,1,254,129,
1,238,1,254,120,0,243,1,254,121,0,243,1,254,120,0,243,1,254,144,0,231,1,254,233,0,153,1,254,242,3,121,1,254,213,7,108,1,254,223,9,114,1,254,237,219,18,1,254,229,227,3,1,254,248,246,4,1,254,246,242,45,1,254,184,154,188,1,254,143,75,225,1,254,241,234,55,1,254,216,193,85,1,254,146,72,220,1,254,122,1,243,1,254,122,0,243,1,254,122,2,243,1,254,159,84,218,1,254,234,169,90,1,254,188,109,163,1,254,123,5,242,1,254,122,0,243,2,254,121,0,243,1,254,164,0,220,1,254,234,0,136,1,254,229,2,114,1,254,234,7,120,1,254,250,3,127,1,254,250,232,15,1,254,231,227,6,1,254,228,225,4,1,254,235,229,69,1,254,153,115,194,1,254,166,132,177,1,254,233,227,25,1,254,224,177,69,1,254,155,87,197,1,254,112,2,222,1,254,112,0,222,1,254,115,14,220,1,254,202,137,151,1,254,249,184,34,1,254,179,116,173,1,254,113,7,222,1,254,112,0,222,3,254,169,1,185,1,254,224,3,119,1,254,243,1,123,1,254,251,0,127,2,254,251,233,14,1,254,248,242,1,1,254,222,218,7,1,254,212,205,89,1,254,123,73,187,1,254,190,174,134,1,254,228,221,20,1,254,221,
173,60,1,254,151,89,177,1,254,102,2,201,1,254,100,0,201,1,254,148,82,177,1,254,242,177,65,1,254,244,180,56,1,254,156,95,173,1,254,102,3,201,1,254,101,0,201,2,254,111,0,198,1,254,200,1,158,1,254,247,1,126,1,254,251,0,127,3,254,251,235,13,1,250,244,239,0,1,254,238,234,25,1,254,201,189,111,1,254,112,64,170,1,254,216,206,96,1,254,232,227,58,1,254,183,152,102,1,254,126,67,162,1,254,91,1,179,1,254,99,24,177,1,254,207,146,115,1,254,250,186,34,1,254,230,168,78,1,254,130,71,165,1,254,91,1,179,1,254,91,0,179,2,254,113,0,175,1,254,201,0,145,1,254,219,0,138,1,254,249,0,126,1,254,251,0,125,1,254,251,0,125,1,250,248,236,6,1,235,226,220,45,1,255,175,162,111,1,254,111,79,147,1,254,94,47,153,1,254,161,145,122,1,254,141,120,133,1,254,101,57,149,1,254,92,39,153,1,254,78,0,158,1,254,134,80,143,1,254,235,173,67,1,254,232,170,66,1,254,159,106,126,1,254,89,28,155,1,254,79,0,158,3,254,87,0,156,1,254,106,0,151,1,254,133,0,152,1,254,244,0,127,1,254,251,0,125,1,255,251,0,125,1,235,243,236,0,1,204,226,220,
53,1,255,133,112,119,1,254,106,75,127,3,254,134,113,119,1,254,200,190,87,1,254,154,138,112,1,254,97,49,130,1,254,194,137,95,1,254,248,184,37,1,254,220,161,74,1,254,118,65,125,1,254,103,18,134,1,254,106,0,137,3,254,107,0,137,1,254,138,1,136,1,254,197,3,124,1,254,249,0,123,1,254,251,0,123,1,255,251,0,123,1,204,243,241,0,1,155,250,248,3,1,255,247,244,16,1,254,246,243,18,3,254,248,245,14,1,254,251,249,3,1,254,239,234,23,1,254,204,150,58,1,254,232,158,54,1,254,239,172,42,1,254,242,179,35,1,254,232,159,58,1,254,237,62,114,1,254,246,0,124,4,254,248,1,124,1,254,229,7,117,1,254,226,3,112,1,254,238,3,119,1,255,239,3,119,1,155,247,245,0,1,95,251,249,0,1,247,251,249,0,5,254,244,239,11,1,254,227,172,63,1,254,241,82,94,1,254,241,76,95,1,254,235,93,90,1,254,228,113,80,1,254,215,102,84,1,254,236,23,115,1,254,251,0,124,5,254,235,1,117,1,254,225,6,115,1,254,240,6,122,1,247,238,5,121,1,95,248,246,1,1,38,251,249,0,1,201,251,249,0,4,254,244,238,14,1,254,227,166,66,1,254,244,80,95,1,254,251,63,99,
3,254,250,64,100,1,254,242,63,99,1,254,220,51,98,1,254,229,8,112,1,254,250,0,124,1,254,251,0,124,2,254,241,0,119,1,254,235,0,118,1,254,250,0,126,1,254,251,0,126,1,201,251,0,126,1,38,249,239,12,1,4,251,249,0,1,84,250,248,0,1,223,245,243,1,1,254,243,240,3,1,254,237,233,10,1,254,224,166,63,1,254,245,70,96,1,254,251,63,99,6,254,249,64,99,1,254,218,51,97,1,254,226,7,113,1,254,239,3,119,1,254,240,1,119,1,254,234,0,117,1,254,248,0,124,1,254,251,0,126,1,223,251,0,126,1,84,251,0,126,1,4,237,212,25,1,1,252,249,0,1,6,235,232,3,1,84,224,215,14,1,201,231,216,15,1,247,233,214,23,1,255,220,122,72,1,255,249,57,95,1,255,251,60,96,6,254,245,57,94,1,254,234,31,108,1,254,243,5,122,1,255,234,8,119,1,255,219,11,112,1,255,237,2,117,1,247,251,0,124,1,201,251,0,125,1,84,251,0,126,1,6,251,0,123,1,1,241,217,22,1,1,240,217,6,1,1,191,178,21,1,4,240,219,20,1,38,251,228,10,1,95,251,227,8,1,155,230,187,45,1,204,235,77,87,1,235,251,59,95,1,250,251,59,95,4,254,248,58,94,1,254,233,38,101,1,254,247,2,122,1,250,
251,0,124,1,235,251,0,124,1,204,240,7,121,1,155,223,5,111,1,95,249,0,121,1,38,251,0,121,1,4,251,0,122,2,1);


//app small icon (optional) - 20w x 20h size in TEA format only, accessed via tepIcon20
program_icon20h
:array[0..1786] of byte=(
84,69,65,51,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,20,0,0,0,224,204,37,1,1,235,231,16,1,1,251,248,1,1,23,251,248,0,1,97,251,248,0,1,164,232,178,60,1,215,248,51,96,1,243,251,48,97,1,253,251,48,97,3,254,250,47,97,1,254,239,34,101,1,253,248,4,123,1,243,239,12,123,1,215,226,12,117,1,164,220,16,115,1,97,213,8,108,1,23,251,0,125,2,1,231,216,23,1,1,251,248,0,1,37,251,248,0,1,199,251,248,0,1,249,251,248,0,1,254,238,223,30,1,254,241,78,91,1,254,251,47,97,4,254,245,45,96,1,254,242,13,116,1,254,251,0,124,2,254,250,1,124,1,254,243,3,122,1,249,227,2,114,1,199,250,0,125,1,37,251,0,125,1,1,251,247,1,1,23,251,248,0,1,199,251,248,0,1,255,251,248,0,2,254,249,246,0,1,254,220,149,66,1,254,244,41,95,1,254,247,41,96,1,254,249,41,97,1,254,249,44,96,1,254,235,26,106,1,254,250,0,124,1,254,251,0,124,3,254,250,1,124,1,254,215,6,109,1,255,227,6,115,1,199,220,11,115,1,23,251,248,0,1,97,251,248,0,1,249,251,248,0,2,254,249,246,6,1,254,245,242,16,1,254,214,180,37,1,254,231,149,57,1,254,231,145,61,1,254,224,
131,66,1,254,213,102,77,1,254,244,20,118,1,254,251,0,123,2,254,249,0,123,1,254,247,0,123,1,254,234,0,118,1,254,237,2,122,1,254,245,4,125,1,249,248,3,125,1,97,242,239,0,1,164,251,248,0,2,254,224,218,50,1,254,167,157,92,1,254,132,119,102,1,254,127,82,105,1,254,156,102,100,1,254,215,148,70,1,254,251,176,36,1,254,244,171,40,1,254,221,69,100,1,254,252,0,123,1,254,233,0,123,1,254,171,0,122,1,254,139,0,120,1,254,119,0,116,1,254,130,0,120,1,254,189,0,123,1,254,252,0,125,1,164,224,216,9,1,215,242,239,7,1,254,200,190,89,1,254,87,50,135,1,254,65,0,140,1,254,67,0,139,1,254,68,0,139,2,254,84,30,136,1,254,203,137,93,1,254,251,176,33,1,254,223,141,63,1,254,203,1,125,1,254,104,0,138,1,254,67,0,139,1,254,68,0,139,1,254,69,0,139,1,254,128,0,135,1,254,224,0,126,1,254,251,0,125,1,215,236,219,11,1,243,206,200,68,1,254,100,57,158,1,254,116,86,151,1,254,162,145,127,1,254,126,97,143,1,254,82,3,164,1,254,81,0,165,2,254,98,34,161,1,254,226,154,81,1,254,217,146,90,1,254,98,14,160,1,254,81,0,165,3,254,83,
0,164,1,254,199,0,142,1,254,251,0,125,1,254,251,0,125,1,243,241,223,6,1,253,208,196,111,1,254,120,77,177,1,254,235,230,60,1,254,235,228,71,1,254,182,155,121,1,254,111,42,178,1,254,94,0,190,3,254,153,86,164,1,254,127,59,178,1,254,140,0,175,1,254,100,0,188,1,254,94,0,190,2,254,100,0,188,1,254,216,1,135,1,254,251,0,123,1,254,251,0,123,1,253,241,225,7,1,254,221,211,108,1,254,123,61,205,1,254,184,159,162,1,254,139,95,200,1,254,152,116,179,1,254,153,102,160,1,254,105,0,217,1,254,107,0,216,2,254,107,3,215,1,254,134,13,200,1,254,201,0,167,1,254,109,0,215,1,254,107,0,216,2,254,131,0,207,1,254,221,6,127,1,254,242,1,119,1,254,251,0,123,1,254,227,215,18,1,254,247,244,37,1,254,202,182,157,1,254,158,113,204,1,254,120,0,241,1,254,224,211,112,1,254,187,169,140,1,254,119,0,241,1,254,120,0,241,2,254,127,34,235,1,254,194,115,136,1,254,182,4,196,1,254,120,0,241,2,254,119,0,242,1,254,163,0,218,1,254,247,1,126,1,254,220,6,110,1,254,224,8,114,1,254,237,220,17,1,254,233,231,3,1,254,252,250,0,1,254,215,
197,133,1,254,138,63,226,1,254,242,237,23,1,254,202,156,123,1,254,125,16,239,1,254,121,0,241,1,254,121,0,242,1,254,174,103,203,1,254,237,173,69,1,254,146,56,214,1,254,121,0,241,2,254,119,0,242,1,254,193,0,194,1,254,235,1,114,1,254,229,4,117,1,254,250,3,128,1,254,251,234,13,1,254,231,226,7,1,254,229,227,0,1,254,171,145,168,1,254,162,132,173,1,254,228,217,0,1,254,225,166,98,1,254,116,27,212,1,254,109,0,216,1,254,113,14,213,1,254,223,158,113,1,254,241,177,72,1,254,129,54,204,1,254,109,0,216,2,254,110,0,215,1,254,199,2,141,1,254,244,2,123,1,254,251,0,127,2,254,251,235,12,1,253,245,239,0,1,254,230,225,36,1,254,132,96,171,1,254,196,183,127,1,254,233,227,23,1,254,206,154,93,1,254,106,29,187,1,254,97,2,190,1,254,170,109,154,1,254,251,187,28,1,254,225,163,93,1,254,101,18,187,1,254,96,0,190,2,254,123,0,184,1,254,234,0,135,1,254,248,0,128,1,254,251,0,126,1,254,251,0,126,1,253,249,236,7,1,243,227,221,39,1,254,179,165,113,1,254,97,47,160,1,254,190,177,105,1,254,169,153,121,1,254,110,62,149,
1,254,87,12,163,1,254,96,34,161,1,254,220,159,91,1,254,241,178,51,1,254,165,110,127,1,254,81,0,165,1,254,83,0,165,2,254,104,0,158,1,254,131,0,154,1,254,200,0,142,1,254,251,0,125,1,254,251,0,125,1,243,244,237,0,1,215,203,194,79,1,254,91,49,132,1,254,95,56,132,1,254,93,53,132,1,254,129,107,124,1,254,197,186,91,1,254,101,69,131,1,254,147,95,119,1,254,246,182,41,1,254,209,150,85,1,254,98,41,133,1,254,94,1,138,1,254,95,0,139,2,254,97,0,139,1,254,144,2,136,1,254,226,1,124,1,254,251,0,124,1,254,251,0,124,1,215,245,243,0,1,164,251,249,0,1,254,249,246,1,3,254,250,248,0,2,254,220,193,45,1,254,229,146,62,1,254,236,165,49,1,254,239,176,33,1,254,228,135,75,1,254,247,0,123,1,254,249,0,124,3,254,249,1,124,1,254,222,6,112,1,254,236,5,118,1,254,237,4,118,1,164,248,246,0,1,97,251,249,0,1,249,251,249,0,3,254,250,248,0,1,254,231,209,41,1,254,240,92,92,1,254,249,67,98,1,254,246,73,97,1,254,239,87,95,1,254,209,60,94,1,254,242,4,120,1,254,251,0,124,3,254,247,0,122,1,254,230,1,115,1,254,248,2,125,1,
249,247,2,124,1,97,250,247,2,1,23,251,249,0,1,199,251,249,0,1,255,252,250,0,1,254,248,246,0,1,254,232,203,48,1,254,241,87,93,1,254,251,62,99,1,254,251,63,99,3,254,248,64,99,1,254,222,52,98,1,254,231,10,114,1,254,247,0,122,1,254,249,0,123,1,254,232,0,115,1,254,249,0,125,1,255,251,0,126,1,199,251,0,126,1,23,230,203,26,1,1,249,247,0,1,37,231,228,3,1,199,219,212,13,1,249,223,210,23,1,254,224,94,81,1,254,251,61,97,6,254,240,53,97,1,254,235,13,118,1,254,226,12,116,1,254,216,6,109,1,254,247,0,122,1,249,251,0,125,1,199,251,0,126,1,37,251,0,124,1,1,238,216,20,1,1,217,185,16,1,1,224,204,26,1,23,250,227,14,1,97,251,228,7,1,164,227,172,53,1,215,246,64,92,1,243,251,59,95,1,253,251,59,95,3,254,246,57,94,1,254,237,23,111,1,253,251,0,124,1,243,251,0,124,1,215,234,9,119,1,164,239,2,117,1,97,252,0,122,1,23,251,0,120,1,1,251,0,122,1,1);
//:array[0..0] of byte=(0);


//additional icons (B..D) are optional - 25may2025 -----------------------------
//Note: Supported image format: tea
//Note: Each icon, if specified, must be 24w x 24h.  The icons form an animation of upto 10 cells in total.
//      When triggered, the app icon - (top-left) of window - will animate and cycle through each of the cells
//      in a continuos loop for a short time period of about 2 seconds.
//How To Use:
//      Use rootwin.xhead.aniAdd(xtep,xms) to add upto 10 cells, and rootwin.xhead.aniPlay to
//      trigger animation playback for ~2 seconds.  To extend playback, call rootwin.xhead.aniPlay
//      regularly.
//
//Example:
//to setup the animation ready for playback:
//      rootwin.xhead.aniAdd(tepIcon24 ,200);
//      rootwin.xhead.aniAdd(tepIcon24B,200);
//      rootwin.xhead.aniAdd(tepIcon24C,200);
//      rootwin.xhead.aniAdd(tepIcon24D,200);
//
//to play the animation call:
//      rootwin.xhead.aniPlay;
//
//to clear the animation (e.g. to create a new animation) call:
//      rootwin.xhead.aniClear;
//
//Note: the examples above must be executed within "tprogram" for access to rootwin, see
//      the unit marked "main" for tprogram.


//accessed via "tepIcon24B"
program_icon24hB
:array[0..0] of byte=(0);


//accessed via "tepIcon24C"
program_icon24hC
:array[0..0] of byte=(0);


//accessed via "tepIcon24D"
program_icon24hD
:array[0..0] of byte=(0);


//help viewer banner images - optional -----------------------------------------
//.banner 1
programbanner
:array[0..0] of byte=(0);//disabled

//.banner 2
programbanner2
:array[0..0] of byte=(0);//disabled


//app help document(s) - optional ----------------------------------------------
//note: these help documents, if specified, are processed and merged into one large
//      document at runtime by the built-in help viewer, which supports documents in
//      the following 3 formats:
//
//      1. txt - plain text
//      2. bwd - enhanced text (Blaiz Enterprises format)
//      3. bwp - advanced text (Blaiz Enterprises format)
//
//      These documents can be compressed (using zip) or left uncompressed.


//app help - app specific help document, which appears above system help
apphelp
:array[0..0] of byte=(0);


//system help - information relating to the app's system settings and general behaviour

//05jun2025: updated
syshelp
:array[0..12309] of byte=(
120,1,236,157,237,114,27,71,150,166,187,55,246,23,35,230,30,106,24,49,97,106,134,250,162,44,219,173,136,158,14,136,162,44,174,37,82,65,82,214,120,123,251,7,8,20,73,180,0,20,26,5,136,162,47,99,175,120,159,247,61,153,85,5,136,182,229,89,239,118,219,3,135,187,37,0,89,153,39,207,231,123,78,158,44,63,125,251,236,225,239,248,103,52,189,168,254,55,127,142,251,211,97,61,232,207,202,39,197,131,127,218,170,111,234,69,57,169,7,87,229,36,190,184,158,247,103,245,226,102,204,167,135,255,180,117,81,77,23,211,190,126,218,175,150,243,81,57,47,142,202,235,248,186,30,125,175,49,123,241,105,80,141,171,185,103,212,35,254,180,247,164,216,123,252,56,13,142,25,89,240,252,50,13,125,248,197,151,95,62,254,124,47,61,47,10,23,229,135,69,125,245,187,223,253,121,241,151,253,171,254,244,178,44,22,87,101,225,225,163,233,101,81,93,248,115,127,54,251,172,46,190,126,115,184,245,124,94,77,252,213,162,154,21,139,170,26,159,247,231,197,96,60,26,188,43,170,105,177,253,231,69,57,123,82,205,22,163,106,90,239,61,248,75,
113,28,127,221,46,170,60,74,211,51,93,49,41,167,203,52,30,46,253,101,187,216,209,140,243,209,229,213,66,171,94,143,166,195,234,250,78,241,239,197,118,158,227,94,81,244,88,34,127,76,67,248,99,60,46,134,163,122,54,238,223,48,228,180,28,151,131,133,73,12,106,130,47,208,178,47,118,109,23,139,254,57,132,23,245,85,117,93,244,139,241,168,246,122,30,85,132,76,234,123,91,91,103,144,185,237,39,138,83,11,170,222,142,177,163,186,96,169,209,162,24,77,153,101,113,53,47,203,98,214,159,47,234,39,91,15,239,21,79,151,163,241,226,238,225,52,56,152,231,43,174,175,70,131,171,162,63,47,139,101,93,14,139,126,93,140,234,173,189,123,197,254,178,94,192,207,149,197,153,179,191,40,6,253,105,113,14,167,134,127,101,136,30,153,242,63,158,159,46,39,231,229,156,47,30,106,237,106,121,121,85,60,124,176,245,232,30,172,25,22,167,253,247,252,178,50,219,110,94,123,92,87,235,147,122,151,204,169,121,191,122,240,111,197,185,137,31,173,17,223,242,180,154,162,29,85,241,126,84,94,23,163,5,223,159,205,111,138,237,167,227,
254,224,221,118,113,129,132,71,211,122,209,159,14,74,126,122,219,95,104,199,181,5,209,168,143,36,63,30,149,241,109,208,57,176,214,193,144,105,49,47,251,227,197,104,82,194,254,94,193,180,163,239,139,131,233,162,156,207,230,163,186,172,63,91,217,88,177,243,175,247,206,7,245,29,24,201,247,19,15,25,90,93,175,203,233,226,38,198,106,29,120,169,253,205,203,122,134,78,142,206,199,165,73,245,226,210,240,242,125,201,46,250,245,76,90,179,174,238,218,227,117,229,7,164,183,23,115,204,114,183,152,142,96,132,247,59,153,85,115,118,236,37,250,121,205,65,127,60,70,12,103,163,5,107,121,157,122,215,242,243,115,147,10,106,244,48,84,79,48,153,239,225,42,191,167,135,78,153,109,216,159,39,33,74,17,15,250,240,241,86,201,20,87,210,163,5,134,89,93,79,139,229,116,244,183,101,89,212,101,171,206,53,228,247,138,193,199,58,86,64,97,117,221,145,2,127,173,164,110,33,140,161,182,141,182,32,143,5,218,113,219,12,187,168,246,188,146,225,105,237,69,117,45,154,197,162,18,53,76,92,180,105,217,70,68,214,64,62,161,88,
136,41,67,44,203,68,109,179,208,11,180,185,184,169,150,159,49,217,5,70,143,58,223,182,96,81,143,171,133,54,100,126,72,19,147,133,196,246,80,16,81,157,140,191,239,209,250,220,191,241,95,11,76,19,86,212,37,238,20,118,93,132,88,176,219,113,185,88,240,77,215,135,200,143,105,39,118,69,60,182,159,156,155,117,127,112,85,85,181,120,50,197,6,44,91,70,28,207,145,159,71,201,74,175,170,49,172,168,138,225,188,127,169,141,33,233,229,188,174,230,247,217,221,37,206,188,143,213,50,76,75,192,195,178,156,134,109,15,254,182,28,193,137,206,204,235,38,1,131,178,177,72,163,107,27,123,127,137,3,233,47,70,210,159,27,212,101,11,71,254,245,232,189,89,58,111,169,76,158,72,211,163,194,91,72,247,178,25,20,118,24,174,47,13,64,173,138,9,34,146,78,196,58,218,208,168,126,199,110,155,8,176,47,127,154,189,99,56,199,157,228,156,113,219,254,245,14,122,210,250,227,149,133,176,119,244,181,182,86,136,109,193,192,112,217,138,13,138,30,175,20,35,254,189,112,80,17,25,250,78,62,174,232,213,247,238,221,147,246,156,221,204,
204,51,54,101,54,198,44,226,237,182,6,110,99,57,139,69,53,101,228,119,150,132,73,78,91,181,208,217,160,244,20,157,68,40,72,167,121,116,184,221,40,109,210,231,143,247,155,248,253,130,72,2,127,112,237,33,111,177,120,213,13,183,97,243,227,73,138,143,152,182,106,91,236,197,150,180,156,46,70,99,45,32,63,137,79,176,2,37,179,138,21,189,229,97,215,168,230,73,122,43,156,95,221,55,172,73,86,131,204,217,133,60,116,86,164,125,130,208,97,81,14,165,13,24,146,21,110,109,170,197,85,181,92,224,137,222,203,151,242,248,188,188,171,113,40,208,159,182,190,43,101,176,105,246,176,132,46,255,47,50,148,72,116,255,52,191,111,97,149,84,199,4,138,29,166,13,251,238,24,176,66,208,188,180,109,201,65,244,166,248,122,30,193,90,86,140,105,197,140,86,85,190,59,195,110,81,142,71,147,209,20,131,211,118,89,114,90,34,106,246,93,126,32,176,13,240,110,193,167,85,205,144,83,238,23,231,196,201,203,48,254,209,164,127,137,21,94,201,247,201,150,63,127,220,137,190,235,227,106,83,92,94,92,32,108,34,197,28,148,166,213,205,62,
226,45,182,111,185,77,153,20,61,102,147,103,160,155,91,87,204,198,152,49,20,182,245,180,33,74,122,211,216,118,134,69,29,90,18,54,202,115,224,130,181,20,44,16,154,91,206,134,44,190,30,197,79,43,204,242,150,41,80,23,64,211,188,154,149,243,133,28,114,192,163,97,137,135,44,241,159,88,211,85,137,156,102,179,18,112,153,164,217,250,202,251,120,157,107,197,117,156,170,131,93,223,91,87,120,73,76,138,231,91,76,88,60,239,128,19,92,146,200,114,8,204,145,125,132,161,44,230,229,244,114,113,133,43,151,146,194,97,6,206,36,93,235,75,179,68,21,136,86,44,239,224,51,169,86,71,165,230,229,133,81,232,10,168,41,236,156,229,44,134,21,102,21,190,220,74,100,92,1,5,100,0,44,10,198,247,154,53,176,242,29,16,34,83,118,63,118,247,39,99,211,120,132,45,203,173,193,169,90,54,200,115,197,184,66,55,174,112,105,21,176,198,158,66,202,34,33,136,100,169,236,88,81,253,225,31,254,240,0,101,186,182,10,154,221,23,163,57,14,191,63,172,230,83,54,173,105,159,247,235,197,62,129,61,20,240,117,117,93,206,227,227,14,110,155,221,
182,140,225,1,194,133,130,16,97,153,7,238,160,255,168,198,13,66,70,43,231,35,89,69,57,23,125,204,5,1,115,242,140,178,95,223,220,93,84,119,47,231,163,153,140,160,111,97,128,211,70,223,103,227,146,102,49,140,199,197,95,155,45,40,182,63,68,38,108,102,137,19,196,53,15,203,65,53,199,10,240,242,194,141,193,152,4,14,38,253,97,73,112,151,99,71,3,166,253,249,92,155,16,21,242,163,53,208,253,194,64,150,188,34,228,202,6,176,175,97,53,17,160,64,254,33,129,96,188,17,71,95,56,186,35,248,221,98,210,127,39,122,241,145,231,68,254,88,169,94,158,131,115,128,5,172,10,192,20,180,157,84,118,145,12,3,159,18,233,97,137,80,32,80,229,170,63,199,16,208,187,113,217,159,138,58,235,189,113,244,214,214,17,158,245,82,2,67,120,29,179,125,46,36,218,120,250,54,141,105,128,98,71,165,96,57,46,102,6,103,89,57,57,136,6,175,157,87,196,199,137,71,44,64,186,245,88,204,170,131,52,231,30,89,22,158,16,172,185,198,19,233,128,52,246,99,222,91,146,48,17,194,251,120,93,171,181,125,214,131,217,135,98,103,10,170,214,30,238,232,
247,47,247,244,213,108,244,161,28,91,117,4,98,122,25,216,128,144,69,160,214,65,191,68,206,114,102,136,73,230,234,175,237,76,235,45,130,213,103,248,4,100,42,37,87,94,91,92,151,227,241,159,138,226,168,146,179,1,249,79,16,72,152,139,101,25,20,182,195,161,196,81,42,197,11,80,136,17,231,241,60,72,64,116,172,188,26,41,48,192,207,191,49,21,95,125,83,0,231,71,152,93,152,203,217,183,66,239,63,36,62,242,245,237,173,173,23,100,187,168,70,93,141,151,198,65,121,2,156,128,148,27,53,109,39,79,222,44,217,249,5,142,209,153,68,48,173,216,177,211,130,219,67,80,242,157,2,125,2,61,202,62,166,25,100,146,9,77,165,4,239,71,213,178,46,46,75,52,205,70,99,56,156,23,198,204,246,201,146,136,151,236,125,124,163,180,197,238,253,122,20,113,62,75,160,127,62,34,5,150,235,150,161,37,71,77,53,160,168,39,138,172,172,138,12,128,67,157,121,207,240,216,168,207,121,57,232,11,40,177,55,65,232,60,192,44,132,101,197,101,31,159,169,156,172,184,116,250,49,239,240,7,127,21,241,142,53,66,161,112,4,114,125,245,21,254,250,157,
240,178,85,81,97,137,180,144,127,175,175,8,35,44,130,78,199,70,50,168,237,43,15,68,222,218,16,73,185,74,25,24,178,82,86,41,79,43,18,68,120,44,141,89,85,198,139,229,52,210,153,97,5,11,22,44,6,101,173,114,106,10,185,46,246,216,64,15,185,38,229,169,56,195,90,94,91,41,136,243,191,196,129,206,154,84,18,246,190,41,254,136,139,222,123,112,93,124,32,33,250,234,193,21,159,139,189,221,7,95,62,218,253,226,193,131,34,164,190,133,118,252,177,120,244,213,231,30,182,247,240,139,24,246,213,238,222,31,62,223,253,188,29,134,106,254,177,248,242,139,175,60,236,243,71,123,30,246,232,209,238,195,47,191,236,206,6,133,76,184,179,28,47,230,125,34,8,170,233,136,140,156,171,233,157,44,41,161,92,185,7,152,162,84,189,46,118,62,255,160,31,229,97,108,191,176,3,149,112,90,202,46,118,46,150,232,195,71,147,13,72,129,148,216,83,55,145,103,239,138,213,30,236,86,165,187,174,150,100,86,73,214,200,235,241,131,127,17,31,189,148,228,222,117,197,195,209,197,197,104,192,86,36,88,72,118,252,192,199,91,233,113,33,81,130,
67,228,170,20,152,22,139,177,56,71,175,146,32,195,220,137,106,12,247,214,236,5,248,180,171,164,34,134,47,72,119,35,119,30,139,33,33,119,185,194,208,54,4,13,47,90,207,80,164,45,44,193,114,243,0,112,142,14,89,213,99,111,64,195,221,156,87,163,189,127,91,194,37,134,239,236,61,254,151,59,205,134,65,40,160,64,194,85,87,227,165,116,214,232,90,42,157,141,246,28,218,132,103,164,203,16,84,32,150,172,116,80,140,224,48,20,220,113,70,178,97,18,29,29,54,131,211,103,44,88,224,151,72,158,214,245,140,168,77,103,70,11,175,102,117,234,102,102,78,63,252,231,69,127,128,119,212,14,246,30,32,186,157,189,15,164,135,203,89,230,183,61,182,220,124,248,115,123,4,173,58,145,71,136,114,32,171,15,81,58,202,56,226,236,128,184,63,100,95,225,167,134,5,26,207,172,82,199,117,190,35,253,51,102,82,109,2,211,150,86,176,229,112,92,82,87,194,136,67,174,42,73,204,77,54,72,69,167,146,15,146,26,193,33,62,230,253,181,174,65,185,205,119,160,8,121,64,13,158,19,57,67,5,214,156,5,85,148,37,92,118,4,51,44,119,64,171,46,40,228,
66,241,174,185,177,91,60,18,245,176,71,187,80,224,168,22,229,147,173,83,202,19,210,63,241,193,79,189,239,143,41,242,160,211,221,225,222,111,87,172,82,107,168,22,24,73,114,3,243,38,216,133,83,178,175,123,167,28,141,164,119,89,203,23,178,151,67,149,122,225,203,149,152,49,197,163,9,34,105,115,66,14,242,114,228,212,207,247,182,139,119,130,230,138,188,55,114,0,154,140,223,17,108,218,188,43,197,56,142,62,108,86,4,84,44,223,111,43,203,150,178,116,7,215,64,16,180,26,221,209,62,81,204,230,139,48,141,47,52,247,222,231,144,246,99,81,52,241,213,112,27,48,37,40,18,210,150,76,20,140,188,24,74,231,149,83,20,37,80,162,84,153,55,169,170,34,30,16,65,148,28,168,26,56,194,184,114,65,51,182,47,243,18,107,211,36,2,75,84,171,9,69,6,180,134,152,142,127,98,187,224,7,75,12,200,112,164,191,121,66,225,92,88,219,56,16,248,109,123,27,198,150,69,17,213,34,107,156,233,38,143,147,2,192,199,83,241,140,218,24,79,36,238,134,150,56,149,213,216,128,121,245,114,166,154,36,27,196,149,105,251,98,170,84,21,67,125,115,
142,167,91,26,219,229,141,17,225,147,94,116,152,143,22,246,230,218,190,164,31,225,218,251,65,28,97,40,0,171,17,245,62,198,53,44,168,46,46,196,191,164,67,213,64,53,175,221,98,225,28,100,184,28,100,37,110,87,1,193,247,135,6,200,20,125,9,207,246,42,206,19,66,148,211,10,102,224,36,165,36,42,111,124,172,74,205,79,66,253,121,24,204,97,54,82,116,248,177,146,36,34,228,57,14,72,224,54,109,2,47,33,126,183,137,165,4,22,207,40,19,99,59,63,166,119,208,115,108,184,175,165,107,74,52,24,212,246,169,79,118,56,99,176,241,5,248,85,9,205,168,40,249,53,184,118,62,90,76,56,241,97,247,169,144,236,130,78,67,97,84,139,61,199,16,207,236,24,22,94,25,175,46,101,146,42,8,109,9,223,66,230,25,56,70,201,223,132,36,99,14,104,211,35,89,243,225,130,92,188,13,84,74,95,103,47,37,178,121,182,120,171,16,128,83,72,32,41,118,163,181,101,125,66,106,192,34,14,170,16,15,113,177,120,79,13,66,8,151,223,168,111,234,0,165,173,169,146,200,204,194,225,147,216,112,168,209,50,124,133,211,34,216,224,48,150,106,54,230,205,160,231,
81,47,76,222,64,146,111,77,131,159,148,76,37,228,164,231,173,26,82,239,80,88,185,245,226,178,170,168,190,93,85,163,1,113,148,157,225,230,248,94,89,160,212,171,107,31,147,74,135,63,107,160,0,177,120,21,158,20,202,118,230,204,223,223,250,64,170,46,254,240,24,201,163,231,93,2,101,197,38,187,68,163,51,116,223,126,86,254,181,255,237,146,130,229,148,179,35,7,54,1,96,9,103,133,8,233,224,58,13,197,78,187,156,182,128,29,150,31,250,147,217,88,249,210,149,74,198,100,139,46,68,207,200,108,62,160,89,100,136,80,129,188,44,228,69,217,31,66,230,235,114,142,76,34,217,77,229,1,59,34,160,81,199,98,208,40,236,197,133,35,77,221,41,161,166,42,125,202,141,209,214,129,253,125,196,118,241,181,154,134,174,198,51,124,209,55,126,71,59,210,241,218,115,201,40,120,163,152,29,97,28,113,237,71,29,221,233,86,35,199,86,208,46,63,177,179,247,8,45,10,48,29,170,142,191,105,202,186,168,11,245,71,80,161,83,105,178,76,169,114,210,54,121,107,178,13,185,243,229,148,239,135,198,252,88,31,122,105,229,214,119,69,255,66,216,
202,101,125,249,168,40,191,183,20,221,213,46,229,6,35,42,26,83,49,232,156,39,53,72,238,147,165,203,209,229,20,55,58,189,92,130,221,210,15,44,132,113,220,76,40,10,168,34,137,234,121,214,240,19,72,247,82,208,5,197,184,27,2,173,71,72,87,245,146,143,98,45,204,252,201,0,219,197,9,94,230,2,208,33,247,41,131,25,91,249,252,117,35,125,206,172,112,240,35,106,43,211,203,173,231,208,58,233,163,69,75,29,69,146,163,44,70,206,239,112,37,170,9,232,43,206,73,108,61,37,144,93,186,214,125,62,129,233,136,63,37,99,171,155,240,124,9,130,192,162,68,77,231,232,163,28,194,169,28,149,91,87,129,249,84,72,132,147,50,131,30,234,114,254,40,153,213,100,179,203,5,5,0,158,155,22,47,247,159,37,207,253,83,105,54,118,192,233,207,115,41,226,243,160,67,123,118,134,24,53,31,131,193,124,230,20,233,135,195,93,162,218,164,148,131,171,56,95,19,92,196,138,57,109,3,94,212,78,68,81,52,206,52,173,82,84,83,56,172,179,119,183,184,73,143,92,19,186,99,17,100,231,41,81,240,11,249,111,57,191,131,49,28,42,16,201,69,129,45,100,67,
113,56,103,149,6,253,235,104,93,222,99,72,209,72,7,219,66,22,29,210,66,194,40,137,226,12,48,10,107,70,177,125,142,106,109,85,121,94,46,198,240,62,230,180,64,113,231,66,9,18,61,72,109,116,23,212,75,242,80,46,8,49,24,222,0,53,20,101,162,6,232,120,93,205,223,185,174,174,179,173,117,103,165,64,171,227,237,43,140,130,60,34,57,55,217,5,187,113,132,71,94,177,103,131,237,97,165,66,77,242,71,105,39,183,13,163,62,108,31,115,129,179,197,137,40,134,162,209,134,58,114,193,144,150,14,147,229,29,21,23,114,162,147,202,192,20,181,154,147,182,172,110,113,114,34,22,54,58,215,229,152,2,137,179,85,45,148,176,119,42,149,8,95,169,20,75,121,149,31,163,34,104,71,230,166,9,69,229,84,64,6,215,188,99,112,170,25,142,38,156,5,141,96,181,15,85,98,114,165,116,148,79,148,122,78,102,75,249,159,156,93,8,93,218,87,164,186,1,75,110,191,172,174,117,20,101,28,232,211,252,177,202,180,212,121,85,201,196,51,228,226,209,144,210,14,254,217,14,134,74,74,62,248,151,243,2,176,18,181,225,161,156,97,78,153,83,186,30,185,66,
62,124,84,166,222,217,59,99,183,95,65,255,114,226,14,142,109,21,172,226,168,255,28,204,175,213,19,202,167,151,193,22,118,42,224,172,240,210,235,58,24,27,219,164,164,134,164,4,204,13,0,201,73,75,45,4,38,146,175,183,166,118,148,91,253,51,115,97,15,31,225,25,93,134,127,69,125,156,180,182,99,241,85,138,94,83,65,170,124,194,149,44,19,49,157,33,147,152,92,11,6,88,176,130,166,142,133,93,105,65,170,13,122,166,174,137,117,168,192,77,96,186,178,41,169,164,33,249,158,173,243,188,68,32,28,206,24,248,201,101,184,172,219,106,153,173,39,160,38,202,123,166,42,182,58,59,26,154,240,41,237,94,90,93,138,208,137,184,35,241,59,47,23,215,58,49,222,126,70,97,154,150,25,87,87,178,226,185,148,186,253,82,57,9,63,81,76,102,250,230,55,22,117,85,85,21,130,5,5,5,204,220,231,13,62,76,80,168,148,158,36,23,130,60,60,6,102,194,124,106,109,84,86,70,28,128,168,38,174,34,11,145,194,229,113,12,92,4,164,93,25,135,54,187,50,36,74,58,59,189,189,134,125,26,58,93,111,67,91,115,240,116,42,226,138,83,1,112,148,62,170,108,
153,9,185,72,95,220,85,126,44,210,200,144,61,94,14,78,155,16,84,106,65,134,213,14,66,244,107,202,153,12,115,89,239,85,222,207,250,12,87,163,225,16,6,187,80,237,70,23,20,213,40,101,209,175,223,209,235,164,103,51,3,214,159,109,56,179,203,177,194,216,165,106,19,246,190,63,26,27,124,200,141,198,81,135,34,31,84,53,10,241,188,225,227,250,164,232,101,203,228,76,190,147,106,220,188,139,3,170,254,83,253,68,106,153,13,153,230,96,78,28,129,239,22,207,202,250,157,122,172,20,76,218,234,186,199,44,103,43,122,16,157,31,18,53,77,78,74,95,245,136,143,48,228,95,166,132,2,217,14,108,193,178,126,32,71,234,10,247,204,77,82,38,82,89,70,0,133,6,3,187,111,170,75,169,26,163,18,173,110,108,106,202,41,153,84,197,243,51,184,215,125,200,116,249,60,11,79,220,96,241,166,110,235,64,29,219,98,121,118,147,183,38,133,217,254,51,238,231,146,211,8,101,27,127,81,226,236,230,163,131,182,247,232,30,158,90,253,95,176,121,7,100,59,95,224,6,92,102,178,106,4,29,106,86,144,167,17,92,227,176,39,220,141,31,89,82,81,111,154,
210,2,115,160,70,236,82,155,200,82,241,200,4,72,34,194,138,81,252,123,206,92,28,14,53,210,238,16,47,63,147,164,159,69,158,167,75,29,1,159,184,51,142,1,35,25,110,17,81,102,226,207,217,18,49,25,238,8,143,227,73,72,116,4,138,92,94,35,63,214,177,36,219,41,57,73,32,192,124,188,142,193,10,170,150,116,56,156,176,152,162,212,141,58,6,51,102,153,49,237,206,170,100,233,58,8,225,146,253,92,4,212,57,47,169,46,26,22,240,13,147,222,124,70,26,60,233,79,9,189,224,108,114,65,16,173,142,57,23,206,136,147,61,226,67,144,204,35,186,233,214,149,46,117,67,213,247,51,17,82,28,203,44,209,92,39,175,58,174,0,86,202,117,152,210,218,145,131,124,14,200,64,1,50,130,156,223,53,190,54,237,187,61,106,16,157,63,135,249,71,174,24,42,51,37,15,74,251,9,254,89,133,124,196,151,133,106,19,128,58,127,73,227,228,52,0,247,138,234,202,159,218,13,174,237,66,143,37,41,55,138,13,173,22,92,136,21,247,160,179,228,20,145,59,214,192,148,0,61,41,192,53,1,164,225,129,66,207,165,43,128,160,34,53,205,69,121,73,102,10,60,242,196,177,
17,231,226,240,219,56,102,208,215,73,68,46,114,39,246,17,70,71,211,247,213,248,61,173,181,212,55,82,208,35,180,82,170,80,232,115,125,38,163,41,180,145,174,13,252,91,57,180,251,155,244,255,74,89,29,92,214,106,3,243,173,63,147,2,37,71,32,208,7,49,2,28,89,232,159,230,15,123,77,32,35,56,185,228,76,165,22,101,220,174,166,247,203,169,34,197,240,126,150,212,54,224,26,219,84,195,233,18,230,137,39,219,212,218,238,3,233,98,96,150,65,73,195,146,135,46,167,12,102,231,39,38,112,95,199,249,115,142,148,252,145,69,40,154,235,11,123,240,72,199,209,100,102,133,14,192,237,184,38,165,38,229,162,235,141,242,194,147,173,198,14,194,129,70,205,129,168,140,123,3,213,142,171,203,20,109,107,242,216,242,222,229,61,183,103,237,210,246,91,82,25,48,34,44,23,3,126,51,101,42,90,184,81,152,250,104,156,222,187,76,184,110,132,65,21,116,244,47,232,244,194,239,61,217,58,152,214,148,208,155,42,44,82,137,65,114,181,200,175,166,39,53,90,59,177,187,92,207,83,234,130,86,234,144,42,248,230,83,232,229,121,67,49,33,44,246,
0,3,240,13,121,10,105,84,235,135,28,174,17,107,79,141,67,244,10,78,102,198,171,110,238,203,80,195,120,16,157,81,103,14,110,159,147,25,82,4,113,181,53,230,98,86,213,62,72,19,255,149,199,5,162,237,209,130,88,215,62,78,9,205,180,187,148,74,168,171,20,63,197,17,202,192,30,80,221,208,237,36,142,96,113,218,108,20,10,129,167,81,216,178,92,149,213,99,70,30,229,228,46,231,23,204,124,49,186,92,166,147,95,148,132,242,201,117,113,138,17,212,87,79,182,158,69,19,181,41,111,48,239,251,242,62,136,140,4,2,80,175,30,107,210,240,196,97,120,109,155,10,199,7,9,111,154,56,231,102,65,233,167,244,48,103,163,47,202,241,12,116,19,125,163,87,124,192,122,26,120,111,98,225,59,232,26,119,37,124,157,53,178,211,152,23,141,148,202,89,83,47,101,168,145,138,234,28,7,205,171,116,76,33,144,147,76,56,23,211,147,186,240,36,126,97,169,147,119,86,122,178,245,66,135,4,113,212,211,174,39,151,44,182,152,68,210,21,231,201,93,82,209,142,62,178,152,129,161,207,151,231,236,82,128,158,3,251,39,91,251,213,132,29,209,97,142,232,
202,105,244,185,100,195,10,113,176,122,216,94,34,125,160,76,27,32,143,196,160,100,65,181,238,206,214,214,179,106,201,172,209,121,10,149,167,78,219,82,223,145,49,164,179,47,41,42,132,12,99,176,77,235,62,19,88,3,44,232,54,115,50,18,78,49,55,1,175,48,38,142,122,233,238,67,25,169,237,118,39,10,160,73,67,24,28,75,149,71,234,202,129,227,3,117,224,128,222,81,3,150,238,198,25,233,42,37,130,163,169,78,152,147,150,11,151,66,84,174,57,158,2,147,164,11,56,253,38,238,9,231,216,100,163,240,47,213,74,254,137,38,104,246,83,77,110,158,36,216,111,189,75,101,8,180,80,30,89,149,106,37,197,110,8,155,9,183,22,131,27,58,106,164,204,195,98,255,245,27,4,70,194,12,36,72,71,49,72,8,96,224,179,205,54,105,3,4,206,168,101,196,67,145,193,219,67,131,179,151,180,77,240,12,203,137,226,4,220,105,71,14,202,204,47,126,153,211,78,163,69,29,169,240,35,42,201,170,38,56,228,34,7,0,136,82,243,168,226,196,24,237,164,6,161,92,145,16,50,28,211,140,81,171,236,44,7,154,161,24,30,137,167,169,167,164,186,143,248,193,209,219,
121,165,234,229,104,74,96,116,205,132,194,109,212,133,38,208,231,195,35,186,226,160,38,2,96,215,84,80,45,108,84,2,245,105,125,87,161,105,87,147,242,69,2,177,221,221,18,71,25,213,108,52,64,102,143,246,168,107,21,95,39,6,73,18,20,223,43,188,66,41,59,55,95,170,97,255,6,215,108,70,147,179,96,192,81,222,136,40,45,190,81,207,139,121,146,67,98,211,76,138,177,1,212,168,194,34,71,128,153,42,107,200,50,14,77,224,152,125,132,74,207,148,72,41,9,59,178,107,61,171,83,103,145,249,50,96,204,222,231,162,52,139,82,185,165,14,17,186,89,155,172,59,235,93,52,74,153,235,77,254,6,159,206,16,114,252,132,20,250,99,74,115,156,140,70,110,72,181,75,37,24,188,192,90,98,150,66,214,211,166,165,178,216,57,77,69,161,59,132,210,28,245,49,53,169,71,183,21,148,172,34,26,57,145,78,116,51,150,195,59,157,148,28,130,0,118,86,188,92,101,178,131,131,54,159,42,73,85,40,17,33,172,42,154,45,52,148,235,58,121,138,110,201,219,155,99,124,114,7,234,103,197,233,234,129,14,85,185,110,32,165,64,20,138,196,230,14,21,226,40,56,178,
60,167,215,204,213,58,125,105,123,154,148,167,16,28,19,123,94,177,41,5,71,30,187,109,149,157,7,119,185,182,228,90,104,108,83,180,71,241,94,7,210,81,175,151,126,195,159,182,152,191,123,91,185,252,103,28,77,191,114,108,124,21,113,20,111,52,67,255,92,12,165,220,141,145,164,102,174,85,213,16,5,183,73,126,31,184,137,218,250,210,7,113,32,62,249,244,138,209,41,250,92,113,224,80,206,21,44,226,218,84,143,243,227,169,112,234,147,173,151,229,5,246,60,240,99,182,235,184,8,69,153,144,147,5,164,234,107,86,6,193,91,4,25,245,221,239,11,175,81,226,81,208,137,191,201,62,20,124,112,125,232,130,74,3,225,199,236,44,140,99,0,119,236,182,26,224,166,124,160,87,28,170,15,153,8,147,34,191,117,231,46,30,205,51,67,143,86,186,203,201,9,177,71,73,40,60,233,60,28,231,153,209,197,230,147,240,162,39,31,14,212,44,93,52,80,45,49,190,151,11,14,175,222,146,40,9,251,238,75,100,184,235,10,232,201,183,182,158,154,15,114,143,24,80,84,204,206,155,175,34,61,249,226,65,177,195,149,153,119,212,210,165,173,15,31,241,57,198,
68,117,253,89,244,34,200,68,208,88,176,40,62,149,226,47,241,22,175,246,6,4,194,13,18,220,240,241,172,79,251,54,33,70,65,73,206,182,138,47,194,33,227,233,136,171,49,146,69,30,89,95,209,254,87,156,32,18,21,224,215,84,141,145,200,175,216,121,244,32,202,253,82,123,2,198,172,79,55,221,125,249,194,116,136,146,129,38,13,61,86,249,227,211,166,102,158,219,197,28,195,29,62,90,131,82,224,135,98,42,172,80,203,157,1,147,203,21,44,86,14,100,233,95,238,56,147,33,198,49,136,66,70,84,230,161,56,197,226,188,169,54,38,199,158,36,161,101,230,5,251,138,85,2,208,138,113,119,31,202,214,79,85,116,198,245,237,60,76,59,68,255,248,124,63,186,9,244,253,3,117,254,62,255,36,150,118,216,249,56,179,243,180,156,140,238,174,48,243,241,255,83,102,238,251,102,14,38,20,199,145,78,119,113,119,205,53,161,166,157,54,162,235,172,2,87,8,218,27,166,199,201,181,159,137,88,5,155,13,249,224,84,175,245,119,201,179,219,150,20,249,159,20,39,42,163,30,155,185,187,197,107,74,28,187,197,119,20,5,84,63,126,189,156,163,38,187,69,
143,35,130,221,226,41,205,62,187,196,92,74,190,254,131,66,172,111,219,237,114,106,63,90,240,19,25,24,168,194,64,48,171,185,225,142,111,87,33,9,93,94,27,222,224,134,226,126,80,24,52,154,17,64,26,247,0,202,240,1,15,205,162,227,37,104,228,73,177,221,75,230,142,165,24,30,199,217,117,247,107,59,57,223,190,241,57,62,202,230,102,153,102,210,116,149,137,144,66,188,247,190,133,125,204,40,133,153,140,201,253,11,72,74,215,96,69,171,127,226,160,98,146,163,72,131,84,51,11,45,173,98,251,30,51,4,85,57,86,166,13,241,19,223,112,64,49,194,129,27,54,184,245,229,52,170,111,249,210,153,188,4,38,31,73,97,100,164,237,177,117,12,37,16,8,159,209,149,2,138,241,170,82,107,227,8,162,132,186,242,91,240,42,149,144,9,54,101,3,4,75,3,185,15,234,212,247,133,255,215,174,3,76,72,58,43,209,96,85,87,112,93,36,247,246,99,123,252,157,40,140,124,125,199,177,41,151,182,132,112,250,240,36,151,109,129,93,177,128,207,36,82,137,162,185,60,106,214,51,159,14,71,60,249,151,123,28,16,168,11,95,230,26,25,153,238,241,158,122,
202,140,202,233,152,32,193,32,212,32,199,116,43,87,25,53,208,151,139,127,12,23,156,76,89,39,154,212,42,252,99,174,242,146,201,221,39,137,154,83,37,133,219,90,78,253,23,164,39,227,177,150,124,171,83,92,146,165,246,168,25,247,222,30,123,198,57,21,8,194,149,52,204,45,78,55,211,217,18,115,224,113,175,75,142,116,226,224,191,205,4,64,133,47,129,234,31,12,250,95,245,7,80,120,204,74,110,201,104,71,225,208,40,17,45,1,133,132,129,33,81,21,216,125,59,48,102,62,147,218,5,200,232,244,117,121,142,192,121,124,177,152,213,79,238,223,191,190,190,190,135,84,203,171,191,221,171,230,151,5,179,61,163,186,24,135,23,32,30,79,193,162,231,84,172,8,132,161,15,209,143,15,170,101,64,164,81,219,255,243,201,255,210,89,200,73,106,167,75,22,173,210,202,83,223,98,195,79,185,126,34,117,138,139,114,208,69,89,228,74,247,226,214,159,210,5,185,116,251,77,103,85,122,38,245,250,179,160,62,29,231,132,210,141,45,226,49,83,221,222,199,215,226,137,157,181,106,152,32,91,175,219,191,245,227,109,131,104,63,232,130,234,224,
132,125,2,136,21,103,23,55,36,24,150,169,206,244,26,228,130,217,112,209,35,34,27,180,65,177,76,54,226,153,220,150,34,114,251,104,34,61,53,177,208,230,211,148,161,27,35,120,63,162,229,140,125,107,77,16,111,57,190,128,6,29,164,188,230,2,115,84,235,245,83,20,75,3,173,32,83,202,46,58,196,23,8,155,221,233,240,95,67,85,74,200,44,246,29,69,114,170,191,116,238,177,71,144,36,69,122,199,213,13,167,188,114,154,107,236,138,66,95,247,110,7,246,103,240,22,46,46,253,46,202,243,36,201,63,38,242,95,40,153,209,9,170,138,221,33,232,213,58,141,173,159,116,157,226,205,141,28,49,155,17,245,56,213,249,98,235,169,106,225,110,214,52,115,86,159,68,103,211,115,232,109,42,55,76,40,70,112,40,228,59,61,51,183,242,51,159,231,90,206,216,221,119,169,105,148,150,87,233,57,51,232,88,83,126,16,199,38,68,114,73,12,245,77,193,206,109,150,213,29,115,66,100,47,236,113,218,118,167,72,197,49,180,213,54,237,221,191,244,216,204,115,39,131,20,78,212,90,240,110,10,75,128,237,44,106,10,180,91,8,113,145,54,12,208,37,109,231,
21,46,99,224,227,40,88,178,11,68,197,125,145,214,202,62,93,202,89,140,214,131,168,116,248,182,170,82,205,150,64,203,95,177,133,38,153,57,233,66,40,24,127,224,87,19,167,131,207,73,81,113,235,231,116,121,211,69,201,117,247,242,3,206,91,1,68,86,26,141,70,110,64,140,251,171,137,35,221,228,125,173,122,75,137,121,137,162,159,171,140,57,191,185,239,52,93,230,88,47,41,106,234,196,66,115,83,41,185,159,82,103,24,214,87,173,34,29,128,230,108,62,0,113,119,29,49,151,187,115,144,20,189,90,141,149,193,115,242,26,105,167,138,28,6,181,20,206,92,3,145,219,203,119,253,221,130,69,83,21,151,179,169,200,104,100,59,230,225,3,142,158,255,173,49,220,216,3,53,134,110,133,39,221,65,39,6,229,28,53,126,118,167,18,235,236,93,184,244,209,99,123,209,238,245,200,147,182,77,246,15,99,192,161,192,157,66,126,106,128,145,2,6,15,44,32,3,165,174,203,17,59,119,25,65,93,73,67,85,100,26,82,143,214,50,252,239,22,254,82,8,1,231,33,169,30,85,91,151,104,155,138,142,66,61,45,10,81,204,17,31,195,146,165,128,104,39,77,141,227,
234,28,202,82,149,103,181,140,158,224,55,81,17,29,10,65,68,66,95,34,93,202,102,234,14,21,129,130,81,248,63,104,155,211,231,51,167,108,158,37,133,132,156,164,55,49,18,26,207,112,186,50,226,21,73,115,66,129,29,11,252,248,64,243,7,109,184,235,181,210,4,217,116,165,14,31,119,16,102,163,87,61,136,1,94,153,191,178,88,54,117,21,65,9,170,244,97,169,17,213,101,139,4,15,28,208,208,65,152,101,60,244,53,133,96,74,62,202,145,105,201,127,174,115,144,56,146,187,75,165,158,14,123,80,77,123,255,9,11,24,150,138,204,62,165,80,31,147,5,39,222,196,148,110,53,57,87,215,5,172,37,200,251,168,198,206,144,171,142,193,78,193,152,50,53,71,166,171,51,77,149,36,247,250,4,219,105,185,139,214,58,41,1,182,5,57,90,95,22,132,182,234,100,52,189,199,193,90,52,118,131,42,238,54,238,11,146,170,9,29,59,41,241,225,154,150,231,127,134,75,183,179,38,226,37,87,20,241,191,172,5,135,116,64,38,83,134,100,213,237,188,17,79,208,20,36,147,195,86,174,130,190,249,234,84,210,11,233,80,188,187,70,250,97,240,223,149,131,142,98,80,
66,148,142,182,247,64,57,174,217,92,20,111,206,158,223,253,202,154,167,191,61,252,2,86,178,109,233,164,100,199,202,1,198,93,152,116,58,65,11,145,33,129,144,188,170,40,194,154,61,153,4,140,66,141,117,204,146,66,121,180,166,121,27,250,106,92,94,246,7,55,249,104,241,238,195,189,199,123,109,19,78,187,44,201,129,224,16,215,189,88,188,107,239,226,123,119,209,51,173,40,254,133,176,100,143,75,31,209,73,75,13,31,237,215,86,59,64,61,233,199,51,5,246,0,156,11,187,200,177,200,180,221,185,173,21,83,149,180,89,156,29,226,4,220,38,151,51,44,166,212,229,103,136,247,122,77,11,91,28,112,233,39,58,15,254,10,193,128,39,21,245,196,57,24,71,175,140,11,129,216,19,39,37,228,158,190,48,207,151,110,112,49,177,153,127,42,33,19,23,163,81,222,96,133,35,52,177,104,101,55,214,58,65,174,249,136,142,122,119,62,98,27,196,161,171,162,119,186,127,120,152,78,4,36,15,176,175,32,84,8,162,145,58,34,244,107,78,80,163,195,22,231,169,249,83,13,106,9,152,106,73,156,63,116,54,110,73,162,184,49,244,139,86,26,159,224,2,180,
149,80,51,14,126,161,53,174,13,71,242,208,42,108,170,63,193,211,105,241,106,164,179,34,157,114,38,234,216,232,25,128,145,27,111,74,252,88,81,110,182,232,243,255,0,42,105,168,46,186,136,28,142,4,200,105,236,17,46,117,238,75,238,39,45,96,252,148,3,72,86,179,10,86,85,116,108,94,148,229,152,187,30,37,50,228,210,165,42,187,209,254,150,92,128,103,78,90,156,78,175,154,234,227,197,184,255,158,71,108,131,31,145,187,187,154,228,184,134,142,208,165,85,169,82,205,105,99,156,135,66,30,237,8,56,53,21,216,105,65,166,19,73,88,204,133,140,116,126,16,76,159,203,145,196,145,186,189,5,186,98,22,19,10,97,165,90,192,116,3,20,14,93,195,137,40,135,235,248,2,42,125,112,192,141,118,237,80,231,82,242,108,132,55,156,26,4,17,31,245,125,227,99,109,190,66,59,185,88,175,128,40,129,197,177,0,122,187,247,96,239,49,242,224,221,17,220,137,210,153,195,63,147,101,74,45,38,78,66,227,126,47,211,168,53,166,19,5,226,78,13,196,105,0,196,251,103,46,225,127,144,151,83,119,31,152,75,105,186,202,152,146,67,186,14,192,117,
247,153,52,24,108,69,75,143,64,16,142,241,138,106,63,169,134,142,215,82,218,109,232,66,100,167,65,155,227,64,85,22,242,213,166,183,50,82,145,3,79,125,240,23,70,174,38,9,26,198,254,4,43,86,190,247,200,243,17,184,162,140,147,58,95,196,150,55,74,174,57,69,38,93,235,128,139,249,109,64,98,114,123,82,135,143,237,132,34,185,164,84,55,52,75,208,2,84,54,19,14,71,165,147,34,89,95,143,71,231,72,154,139,187,128,159,254,130,206,108,57,30,216,227,58,48,246,55,224,50,190,94,50,161,83,123,177,201,250,204,225,47,176,93,30,48,189,72,197,221,26,250,137,204,77,216,30,98,45,162,238,86,229,47,141,97,20,160,252,186,128,84,99,98,78,184,192,85,36,1,61,72,66,196,44,200,108,55,36,84,190,23,79,208,183,119,68,140,54,48,157,235,41,230,7,172,54,103,134,96,86,61,172,187,30,233,149,62,122,27,132,164,242,86,48,65,164,3,51,208,133,53,193,192,15,122,93,5,131,0,75,249,114,159,171,212,204,123,140,170,170,58,139,26,48,247,250,147,186,120,85,83,143,151,195,147,46,82,31,215,141,125,154,253,244,14,48,237,4,170,83,36,
147,27,50,131,35,13,105,236,145,157,231,82,91,194,122,8,83,154,54,98,30,252,233,210,252,196,77,88,217,189,123,139,175,15,56,30,104,13,125,146,196,35,131,13,93,110,200,106,74,108,84,103,202,187,52,220,194,52,93,25,162,53,33,191,2,69,113,219,118,172,137,12,47,218,146,124,102,136,146,132,212,104,74,49,52,235,96,71,1,77,129,212,163,195,34,220,33,122,36,216,36,47,188,170,245,134,207,114,79,70,170,97,240,78,193,114,78,1,239,29,104,121,158,96,67,83,135,46,27,52,132,177,203,128,170,233,241,0,115,9,164,107,205,184,35,0,74,168,177,91,209,165,2,24,5,77,37,58,98,192,202,90,74,66,165,62,114,215,205,137,113,189,224,78,110,4,15,157,62,138,57,41,54,68,49,177,17,77,114,226,151,216,196,92,175,201,233,253,192,78,113,136,210,243,92,177,120,87,150,113,15,71,190,48,53,125,91,123,98,190,116,114,89,79,42,97,18,237,224,130,210,186,182,141,13,68,45,3,22,233,176,130,206,93,174,202,137,61,22,158,162,24,46,196,0,82,12,110,84,193,222,171,177,71,180,158,72,154,171,35,238,132,211,133,77,189,185,66,118,2,27,
252,74,14,212,249,221,13,184,232,131,181,89,8,194,241,210,218,222,184,28,248,38,19,132,198,230,46,255,42,15,16,72,71,214,88,203,122,6,233,128,69,0,176,139,104,46,164,41,236,162,175,245,128,128,147,53,125,29,119,134,116,211,2,56,5,85,0,157,253,201,65,166,59,24,233,133,30,242,93,4,241,84,10,213,129,184,110,68,241,190,168,132,44,111,83,81,32,141,226,22,244,246,139,55,167,79,219,162,128,26,187,153,194,39,221,238,231,207,177,19,251,72,213,239,112,78,241,108,195,247,166,196,144,21,60,144,36,66,165,59,155,34,38,74,34,104,110,187,21,158,104,116,67,191,160,131,68,173,228,80,12,164,125,48,14,227,217,204,220,50,192,70,168,198,144,108,221,184,65,220,244,201,27,81,127,14,86,9,80,201,185,160,234,64,66,181,21,249,221,116,242,32,226,140,239,26,12,1,133,10,14,176,135,58,35,91,215,249,135,0,80,155,82,92,45,231,242,214,249,237,9,90,31,82,115,70,143,219,130,128,102,211,154,28,250,105,216,20,41,73,87,236,22,16,156,118,117,197,59,12,153,45,149,250,24,224,96,191,38,144,188,150,247,196,116,9,107,199,
109,255,124,188,137,164,252,5,47,161,99,154,195,246,165,101,249,41,225,93,173,57,9,30,171,218,227,230,108,57,6,125,141,15,87,135,149,77,46,117,102,197,112,159,250,102,175,25,188,188,166,55,208,121,7,41,88,122,157,142,230,211,6,113,105,50,184,20,241,162,115,40,57,235,228,70,62,67,131,194,105,8,168,70,121,113,93,187,177,94,48,10,237,231,238,219,143,80,160,136,214,91,23,93,91,132,64,136,20,188,152,241,218,149,175,228,117,196,11,100,109,172,143,174,181,87,46,178,79,147,135,145,36,26,154,96,48,240,70,121,213,42,131,53,48,136,109,188,113,196,53,132,167,156,236,76,54,198,18,113,231,37,114,95,88,219,100,191,173,10,73,181,41,138,167,44,185,228,240,12,51,151,139,4,43,46,150,118,233,108,245,133,138,118,124,103,208,152,47,66,231,8,100,152,180,162,103,79,182,182,254,181,56,137,216,134,211,201,26,30,1,2,174,64,37,173,237,43,67,114,81,25,87,243,236,229,203,22,16,73,101,241,73,214,4,16,175,1,147,121,129,90,160,201,233,141,31,204,245,74,22,203,90,190,182,28,43,241,168,245,250,182,235,164,225,
41,112,165,73,221,9,9,9,116,53,88,76,242,91,89,133,49,124,165,41,179,192,178,160,120,97,194,20,196,102,158,139,68,3,79,221,152,96,60,237,136,188,123,176,241,157,152,33,229,195,149,121,67,143,153,23,176,97,211,183,150,115,21,130,203,128,66,193,68,70,45,138,175,153,179,209,167,4,8,217,105,98,204,182,180,59,41,53,33,98,123,149,173,18,47,239,132,209,219,49,200,255,241,15,66,81,194,221,118,57,171,2,209,44,25,159,54,129,85,192,136,93,248,157,5,122,157,154,240,56,136,162,252,48,40,105,185,148,232,77,108,220,174,85,150,246,126,196,225,152,106,209,90,16,132,185,96,60,236,80,117,53,99,121,55,211,202,249,117,70,3,179,210,187,117,212,241,55,113,185,206,39,206,0,123,1,63,246,222,222,163,130,253,101,112,34,99,188,239,71,188,29,193,137,187,205,194,125,204,56,105,215,13,113,130,1,107,225,36,229,186,22,207,69,15,25,213,17,209,18,129,34,171,129,245,77,16,152,101,142,157,180,58,254,88,198,77,35,149,194,136,163,60,162,224,45,26,122,247,142,42,121,201,127,64,180,35,214,249,92,37,5,197,35,28,178,209,
190,132,162,251,101,154,252,53,41,161,20,135,88,175,63,162,80,41,122,26,8,209,159,141,116,137,53,94,84,44,169,119,150,106,121,218,89,42,218,3,16,230,186,35,147,24,160,36,99,147,46,123,59,146,16,85,29,219,205,129,180,121,172,181,15,66,73,28,151,185,235,170,81,18,204,181,149,230,189,163,131,51,89,193,255,232,125,219,107,172,164,117,148,60,127,183,141,127,108,66,138,206,49,134,250,206,215,201,215,52,237,134,59,20,67,240,17,32,43,133,5,233,26,8,29,209,51,7,58,56,77,39,126,97,47,45,13,44,212,249,21,231,150,195,138,121,188,28,227,14,40,178,48,234,86,139,109,181,149,83,71,107,167,141,179,195,56,1,32,151,169,49,239,33,151,43,195,123,36,143,17,74,221,53,45,184,38,117,136,203,213,17,170,36,173,33,77,27,62,217,177,21,40,5,67,247,201,134,232,172,141,138,35,236,115,193,40,189,214,12,95,225,218,31,198,144,245,159,252,141,102,148,86,36,240,138,251,194,67,86,195,149,0,82,46,220,90,132,25,240,140,241,169,178,36,184,134,62,234,136,35,185,69,167,77,10,47,9,193,248,218,187,170,126,248,225,120,14,
66,236,153,131,249,194,140,57,113,74,107,71,14,18,173,181,214,157,116,145,28,37,160,209,17,167,38,63,199,229,80,189,226,40,186,39,27,79,49,161,194,76,15,65,61,145,118,158,106,205,221,120,163,171,120,148,66,100,179,95,33,157,236,214,173,242,242,156,17,31,161,49,167,173,188,12,238,110,24,125,246,191,100,72,237,151,2,74,160,65,189,35,15,240,73,173,247,130,26,49,110,23,240,175,75,133,241,178,71,116,42,105,72,71,118,122,179,149,219,143,228,0,73,72,228,11,33,137,151,38,234,229,113,38,72,85,15,210,253,20,117,179,115,239,54,75,171,16,66,170,209,100,168,63,97,212,183,218,133,120,245,173,223,76,35,96,164,146,134,60,94,231,116,63,54,206,70,115,64,161,192,72,41,134,45,187,216,148,170,196,22,91,116,117,54,30,175,235,72,180,245,198,139,121,254,1,232,216,89,247,93,251,231,11,210,39,222,56,56,93,196,193,110,58,25,93,189,128,98,182,248,45,31,170,209,164,115,98,112,147,175,172,168,38,191,134,67,253,138,175,78,62,131,234,73,149,229,114,87,211,74,152,11,80,200,119,149,4,16,154,59,68,212,244,35,14,
226,106,108,94,113,100,167,136,151,2,188,161,148,61,64,3,178,131,108,43,157,239,44,49,68,240,220,144,9,39,34,146,154,183,92,9,57,69,19,173,208,133,222,227,72,86,160,66,31,68,169,107,50,85,84,211,178,190,171,234,26,110,123,121,4,93,35,198,202,207,114,247,155,250,176,147,188,51,186,135,164,120,202,99,127,250,18,39,183,242,78,117,166,140,187,208,59,119,113,15,211,119,157,187,124,241,249,209,109,119,171,60,82,47,213,8,114,245,17,57,64,141,54,153,249,208,222,41,146,214,200,251,184,101,126,24,239,67,146,106,87,238,23,80,157,202,61,23,170,59,91,218,9,198,169,1,239,3,246,74,67,143,186,117,216,233,162,162,7,41,198,204,84,243,166,153,89,120,219,132,192,98,153,183,254,24,146,59,203,188,228,127,112,123,253,226,17,13,169,122,119,25,39,107,157,107,27,185,53,130,52,32,110,192,161,214,192,236,206,165,170,152,83,232,156,75,106,21,186,11,213,221,23,110,104,65,124,112,211,84,16,77,30,234,42,232,190,30,63,29,2,167,19,184,159,119,224,156,178,212,31,59,112,14,11,183,161,254,240,161,51,92,50,14,182,
146,169,46,106,175,141,127,29,68,230,232,55,41,186,78,238,147,51,185,5,120,65,41,134,208,234,92,220,213,193,132,38,217,54,72,117,237,84,251,54,125,124,43,118,97,117,42,96,40,179,163,218,19,175,65,145,244,197,60,121,139,40,157,69,95,23,90,104,225,31,252,199,129,127,235,28,75,62,131,127,198,80,50,200,16,9,150,79,99,44,104,147,169,112,162,40,61,142,85,205,42,97,233,10,55,184,103,97,7,236,194,143,243,220,9,57,27,254,92,0,85,84,172,238,2,54,157,37,210,108,178,215,173,54,235,229,199,43,14,100,119,181,228,32,78,201,11,98,228,228,152,201,161,233,210,12,231,185,218,170,252,146,114,191,177,78,27,98,207,241,238,162,80,191,67,6,252,73,154,44,194,124,172,2,195,244,106,20,175,217,157,32,54,27,83,56,239,96,132,108,158,187,174,137,213,58,140,69,122,60,204,92,32,131,152,47,171,123,228,226,50,122,143,231,18,135,172,214,138,17,167,143,174,12,234,59,191,178,136,235,79,136,77,107,168,0,241,9,45,71,56,73,189,133,196,5,19,140,144,163,252,116,93,28,181,35,37,64,21,52,34,113,89,48,49,138,12,205,187,202,
36,172,104,126,241,168,237,147,212,229,148,219,171,184,54,231,51,42,100,217,213,47,111,32,49,192,186,38,169,39,239,40,181,83,87,143,86,189,101,190,228,255,108,249,134,45,153,60,180,60,55,219,100,216,192,170,103,74,130,109,145,16,175,38,254,216,75,103,112,115,132,148,234,80,246,235,43,206,246,254,179,31,187,220,109,215,155,240,148,218,132,240,209,90,164,219,128,137,47,2,214,248,50,25,33,132,14,112,31,30,234,28,32,233,222,171,195,51,142,157,232,80,175,75,58,206,103,55,161,114,58,173,41,62,250,79,53,20,59,110,141,75,157,113,231,250,47,57,96,57,249,63,228,160,203,212,5,183,156,94,235,134,0,231,84,50,82,186,252,145,36,206,149,222,19,70,114,156,151,19,46,29,71,234,133,136,112,211,231,47,100,51,82,196,115,181,152,43,125,81,22,55,75,189,151,76,211,100,15,114,5,220,173,171,104,77,85,106,187,10,111,13,53,213,166,168,238,162,148,166,108,115,95,88,186,194,117,181,172,81,249,39,163,85,165,191,82,87,157,121,66,179,114,91,245,204,138,134,92,251,105,15,195,205,95,179,8,109,76,237,166,162,83,
61,244,68,109,253,89,122,91,51,110,122,113,110,202,113,140,42,202,35,84,135,189,2,14,209,47,177,218,192,73,7,187,120,174,177,118,154,14,59,68,121,166,46,161,202,230,202,5,136,15,22,121,93,10,2,241,95,107,201,99,197,233,11,204,153,37,35,54,17,223,235,202,43,254,149,244,69,180,106,106,194,4,109,45,218,26,30,48,154,240,104,192,15,95,230,123,90,218,75,104,0,134,13,169,246,174,134,38,172,158,165,154,126,226,77,24,208,14,248,107,78,62,4,142,59,219,97,119,203,115,157,51,232,157,68,174,239,192,95,71,241,238,54,229,75,95,28,20,167,199,207,207,222,246,78,14,138,195,211,226,245,201,241,183,135,207,14,158,209,180,124,202,231,109,250,162,15,207,94,28,191,57,43,24,113,210,59,58,251,174,56,126,94,244,142,190,43,190,57,60,122,182,91,28,252,199,235,147,131,211,211,226,248,164,56,124,245,250,229,225,1,223,29,30,237,191,124,243,236,240,232,235,226,41,207,29,29,163,229,135,232,58,147,158,29,23,90,48,77,117,120,192,115,207,139,87,7,39,251,47,152,185,247,244,240,229,225,217,119,92,114,61,60,59,210,
156,207,153,180,87,188,238,157,156,29,238,191,121,217,59,41,94,191,57,121,125,124,122,192,242,207,152,246,232,240,232,249,9,171,28,188,58,56,58,187,199,170,124,87,28,124,203,135,226,244,69,143,66,148,150,234,189,129,250,19,211,183,127,252,250,187,147,195,175,95,156,21,47,142,95,62,59,224,203,167,7,80,214,123,250,242,32,150,98,83,251,47,123,135,175,120,175,67,239,85,239,107,81,119,82,28,51,203,137,135,37,234,222,190,56,240,87,172,215,227,223,253,179,195,227,35,109,99,255,248,232,236,132,143,187,236,242,228,172,121,244,237,225,233,1,205,231,39,135,167,98,200,243,147,99,166,23,59,121,66,60,59,210,115,71,7,49,139,88,109,170,27,137,48,68,187,120,195,166,27,90,158,29,244,94,50,23,226,57,90,25,140,52,245,254,17,253,167,135,126,255,137,255,232,63,87,180,249,103,195,129,13,7,54,28,216,112,224,31,144,3,159,228,199,255,1,233,254,181,146,244,73,252,254,253,175,112,119,159,182,177,31,27,245,43,220,244,47,73,242,143,177,198,191,253,146,139,109,230,250,53,112,224,39,85,226,147,6,252,26,118,
186,161,113,195,129,255,60,7,62,201,12,214,6,253,231,87,219,60,185,225,192,134,3,27,14,108,56,176,225,192,134,3,191,52,7,214,194,244,173,31,127,233,53,55,243,253,38,57,112,171,238,240,229,111,114,179,155,77,109,56,176,225,192,134,3,63,201,129,31,242,138,159,252,253,79,174,240,27,24,240,223,215,254,249,13,108,105,179,133,13,7,254,129,56,176,102,96,157,143,255,64,68,254,151,38,229,182,128,240,95,154,33,191,222,205,223,38,202,255,171,239,126,189,172,216,80,190,225,192,134,3,191,251,221,127,227,159,13,31,62,226,192,39,122,197,143,158,251,181,127,177,41,138,253,218,37,184,161,127,195,129,13,7,54,28,216,112,96,195,129,13,7,54,28,216,112,96,195,129,13,7,54,28,216,112,96,195,129,13,7,54,28,216,112,224,23,224,192,39,150,7,211,176,95,96,193,95,118,138,159,71,254,45,163,127,89,114,254,191,206,246,219,218,205,47,193,186,117,142,252,18,115,110,230,216,112,224,239,206,129,117,197,254,225,207,127,119,82,55,4,108,56,176,225,192,134,3,27,14,252,246,57,240,195,97,168,249,229,183,207,132,205,14,
55,28,216,112,96,195,129,13,7,54,28,216,112,96,195,129,13,7,54,28,216,112,96,195,129,13,7,54,28,216,112,96,195,129,191,19,7,154,10,204,207,250,203,223,137,216,205,178,27,14,108,56,176,225,192,143,113,224,103,249,177,52,248,199,230,219,252,182,225,192,167,114,96,85,247,62,245,169,205,184,13,7,54,28,216,112,224,86,14,252,254,247,255,71,0,0,0,0,255,255,3,0,163,80,6,14);


//additional program support files ---------------------------------------------
template_squircle_16
:array[0..133] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,16,0,0,0,16,8,6,0,0,0,31,243,255,97,0,0,0,77,73,68,65,84,56,203,237,147,161,1,192,32,16,196,2,59,224,58,43,139,48,30,76,1,34,53,212,183,188,109,212,153,196,29,106,81,171,218,125,79,223,78,97,143,233,119,166,90,147,218,129,139,51,70,82,37,64,38,200,31,248,3,79,96,4,252,145,129,6,172,3,121,1,141,232,157,111,68,109,198,1,114,167,167,98,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle_24
:array[0..182] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,24,0,0,0,24,8,6,0,0,0,224,119,61,248,0,0,0,126,73,68,65,84,72,199,237,150,177,13,195,48,16,196,40,193,222,194,75,100,20,35,131,120,38,151,89,36,165,83,120,27,191,0,166,209,4,129,31,72,33,86,95,145,229,61,106,81,23,117,83,15,53,252,157,232,142,173,59,11,253,120,169,151,247,113,117,231,50,1,79,96,5,102,238,99,238,206,119,81,15,224,65,14,159,162,6,48,37,5,90,81,37,145,74,50,35,48,2,35,48,2,255,18,104,137,254,86,129,51,49,112,86,96,7,34,65,30,192,158,62,250,100,191,45,95,59,171,133,129,148,132,104,170,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle_32
:array[0..207] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,32,0,0,0,32,8,6,0,0,0,115,122,122,244,0,0,0,151,73,68,65,84,88,195,237,215,161,21,131,64,16,6,225,225,4,46,146,6,232,3,79,17,208,29,69,36,239,225,16,244,3,10,204,196,32,40,32,97,205,78,1,247,127,39,23,174,212,70,29,213,143,186,249,251,182,235,237,81,109,184,167,182,234,172,30,254,191,227,218,106,239,63,159,125,190,89,109,10,208,3,29,207,215,1,125,1,6,160,14,0,212,192,80,169,27,240,34,166,189,82,37,176,66,112,9,72,64,2,18,144,128,4,36,32,1,9,40,192,30,184,191,23,96,13,4,172,5,152,128,51,96,252,4,166,2,188,129,37,0,176,92,219,193,199,105,244,121,254,5,221,46,83,244,50,20,196,4,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle_48
:array[0..332] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,48,0,0,0,48,8,6,0,0,0,87,2,249,135,0,0,1,20,73,68,65,84,104,222,237,218,49,78,2,81,20,133,225,255,190,206,144,176,10,177,34,161,183,161,32,113,7,184,18,150,193,46,236,164,160,55,97,17,38,211,40,172,194,48,78,199,177,152,71,1,145,202,2,110,60,167,158,226,124,243,38,111,138,123,131,179,72,26,2,99,96,14,204,128,123,224,142,235,164,3,118,192,6,88,1,77,68,124,93,124,90,210,68,210,139,164,189,110,47,251,218,109,114,169,252,84,210,135,164,131,110,55,135,218,113,122,236,29,199,55,15,188,2,15,228,200,39,240,28,17,239,165,126,243,11,96,68,158,140,128,133,164,97,72,122,4,222,128,1,185,210,2,79,165,222,54,217,202,83,59,207,75,189,42,179,102,22,146,190,175,120,207,255,249,63,17,146,148,248,4,40,36,143,1,6,24,96,128,1,6,24,96,128,1,6,24,96,128,1,6,24,96,128,1,6,24,96,192,127,5,116,137,251,119,133,126,14,155,53,187,66,63,68,206,154,77,161,159,128,183,9,203,183,192,170,0,13,176,6,50,77,106,84,59,55,165,238,30,44,129,109,34,192,22,88,158,236,
77,100,93,53,56,61,151,132,203,30,241,11,34,213,186,205,15,219,91,230,25,208,50,97,228,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle_64
:array[0..425] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,64,0,0,0,64,8,6,0,0,0,170,105,113,222,0,0,1,113,73,68,65,84,120,218,237,219,49,78,2,97,16,197,241,255,124,141,177,176,35,22,38,118,30,128,112,6,105,109,104,172,185,6,135,144,11,96,109,99,99,11,103,48,28,128,206,132,130,80,97,161,84,99,177,179,70,3,146,88,152,200,55,239,149,4,72,222,111,191,221,157,102,140,3,113,247,115,96,0,244,129,46,112,1,156,240,191,179,5,150,192,28,152,2,143,102,182,250,213,63,184,123,199,221,239,220,125,227,199,159,77,116,233,236,235,106,123,202,95,3,247,192,37,117,229,5,24,154,217,236,71,0,119,191,141,242,167,212,153,183,64,120,216,1,136,43,255,84,113,249,175,8,55,237,73,176,246,158,7,158,43,60,246,135,110,135,158,153,173,75,124,48,74,84,158,232,58,2,176,120,213,45,128,51,114,229,21,184,42,241,158,207,86,158,232,60,40,49,228,100,77,191,196,132,151,53,93,115,247,247,35,24,111,255,108,108,54,119,247,196,39,128,66,242,8,64,0,2,16,128,0,4,32,0,1,8,64,0,2,16,128,0,4,32,0,1,8,64,0,2,16,128,0,4,32,0,1,8,64,0,
2,16,128,0,4,32,0,1,8,64,0,2,16,128,0,106,7,216,38,238,191,45,52,11,70,89,179,44,52,219,85,89,51,47,52,171,101,89,51,213,194,68,44,21,78,18,94,253,137,153,173,180,52,5,96,102,107,96,72,179,82,86,123,218,221,193,245,183,65,40,246,232,106,71,104,203,127,110,143,166,95,157,221,25,133,227,11,61,96,28,79,202,26,158,246,227,184,231,103,59,125,15,253,50,195,250,252,7,109,227,56,91,238,226,98,225,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle_256
:array[0..2173] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,1,0,0,0,1,0,8,6,0,0,0,92,114,168,102,0,0,8,69,73,68,65,84,120,218,237,221,49,136,148,103,30,199,241,223,51,136,18,210,136,178,1,77,136,224,109,145,45,98,145,202,192,22,49,230,26,201,97,119,194,25,46,133,133,177,8,22,130,130,137,136,68,133,8,22,146,34,177,72,225,145,8,185,78,78,210,156,198,20,130,86,41,76,161,133,39,108,136,10,89,12,54,18,148,192,115,197,188,73,70,221,93,119,54,171,59,51,239,231,211,37,187,206,14,255,153,231,59,239,59,243,206,251,150,12,176,90,235,88,146,13,73,38,146,140,39,89,151,100,109,146,177,36,43,147,60,159,100,121,96,233,60,72,114,47,201,221,36,211,73,110,37,153,74,114,61,201,213,36,87,74,41,211,131,122,231,203,128,45,248,245,73,54,37,153,76,178,49,201,43,158,95,140,128,107,73,46,39,185,152,228,66,41,229,134,0,252,177,232,95,77,178,53,201,150,36,175,123,174,208,2,151,146,124,157,228,76,41,229,251,214,5,160,214,250,92,146,237,73,182,37,121,203,243,129,22,59,151,228,171,36,95,150,82,126,25,233,0,212,90,95,
78,178,35,201,187,205,254,60,208,53,149,228,84,146,207,75,41,63,140,84,0,106,173,47,37,217,149,100,103,146,213,30,107,152,213,157,36,39,147,124,90,74,249,113,168,3,80,107,93,150,100,119,146,247,189,226,67,223,91,4,159,36,57,81,74,249,117,232,2,80,107,125,59,201,158,36,111,120,44,97,193,190,77,114,188,148,114,118,40,2,80,107,93,149,100,95,146,189,30,59,88,52,199,146,124,92,74,249,121,96,3,80,107,125,51,201,254,36,155,61,94,176,232,206,39,57,90,74,249,102,224,2,80,107,125,47,201,135,73,94,244,56,193,83,115,51,201,225,82,202,103,3,17,128,90,235,138,36,7,146,124,224,177,129,103,230,72,146,143,74,41,247,151,44,0,181,214,53,73,14,166,251,241,30,240,108,157,76,114,168,148,114,251,153,7,160,214,58,222,44,254,119,60,14,176,100,190,104,34,112,253,153,5,160,89,252,135,146,252,195,252,97,201,157,78,114,112,33,17,40,11,88,252,107,210,253,72,194,43,63,12,214,150,192,222,126,119,7,74,159,139,127,69,146,19,246,249,97,96,223,19,216,221,207,27,131,157,62,255,192,1,139,31,6,214,206,102,141,46,254,
22,64,243,57,255,167,102,12,3,111,215,124,143,19,40,243,92,252,111,38,249,87,28,228,3,195,224,102,146,127,206,231,136,193,206,60,22,255,170,116,15,239,181,248,97,56,188,152,100,127,179,118,255,244,123,0,251,226,216,126,24,54,155,155,181,187,240,93,128,230,43,189,255,49,75,24,90,127,155,235,171,196,157,57,22,255,178,116,191,207,15,12,175,61,205,90,238,123,23,96,119,156,204,3,134,221,27,205,90,158,255,46,64,115,14,191,139,113,26,47,24,5,83,73,38,103,58,199,224,108,91,0,187,44,126,24,25,235,154,53,253,228,45,128,230,212,221,223,197,217,123,97,148,220,73,242,218,163,167,28,159,105,11,96,135,197,15,35,103,117,179,182,103,223,2,104,174,216,115,213,230,63,140,236,123,1,19,189,87,32,122,116,11,96,187,197,15,35,253,94,192,246,185,118,1,182,153,17,140,180,109,51,238,2,52,87,233,189,98,62,48,242,54,252,118,85,226,222,45,128,173,230,2,173,176,117,166,93,128,45,230,2,173,176,229,161,93,128,90,235,250,36,255,51,23,104,141,191,148,82,110,252,182,5,176,201,60,160,85,54,245,238,2,76,154,7,180,
202,100,111,0,54,154,7,180,202,198,36,41,181,214,177,36,63,153,7,180,206,11,157,36,27,204,1,90,105,67,39,201,132,57,64,43,77,116,146,140,155,3,180,210,120,39,190,252,3,109,181,174,147,100,173,57,64,43,173,237,36,25,51,7,104,165,177,78,146,149,230,0,173,180,178,212,90,239,39,89,110,22,208,58,15,74,173,181,154,3,180,83,199,8,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,
4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,4,0,16,0,64,0,0,1,0,134,49,0,15,140,1,90,233,65,39,201,61,115,128,86,186,215,73,114,215,28,160,149,238,118,146,76,155,3,180,210,116,39,201,45,115,128,86,186,213,73,50,101,14,208,74,83,157,36,215,205,1,90,233,122,39,201,85,115,128,86,186,90,106,173,99,73,126,50,11,104,157,23,58,165,148,233,36,215,204,2,90,229,90,41,101,250,183,67,129,47,155,7,180,202,229,228,143,239,2,92,52,15,104,149,139,189,1,184,96,30,208,42,23,126,15,64,41,229,70,146,75,102,2,173,112,169,89,243,15,125,29,248,107,115,129,86,248,125,173,247,6,224,140,185,64,43,156,121,44,0,165,148,239,147,156,51,27,24,105,231,154,181,254,216,22,64,146,124,101,62,48,210,30,90,227,165,247,63,106,173,207,165,123,104,240,58,115,130,145,51,149,100,162,148,242,203,140,91,0,205,15,78,153,19,140,164,83,189,139,255,177,45,128,102,43,224,229,36,223,37,89,109,94,48,50,238,36,121,173,148,242,67,239,255,124,236,172,192,205,47,156,52,47,
24,41,39,31,93,252,51,110,1,52,91,1,47,165,123,168,160,247,2,96,52,246,253,39,75,41,63,62,250,131,25,175,11,208,252,226,39,230,6,35,225,147,153,22,255,172,91,0,205,86,192,178,36,255,77,242,134,249,193,208,250,54,201,95,75,41,191,206,244,195,89,175,12,212,252,131,227,230,7,67,237,248,108,139,127,206,0,52,17,56,155,228,152,25,194,80,58,214,172,225,217,215,248,147,110,161,214,186,42,201,191,147,108,54,79,24,26,231,147,252,189,148,242,243,92,191,244,196,139,131,54,55,112,52,201,77,51,133,161,112,51,201,209,39,45,254,121,5,160,137,192,55,73,14,155,43,12,133,195,205,154,205,162,4,160,137,192,103,73,142,152,45,12,180,35,205,90,157,223,186,238,231,150,107,173,43,146,156,72,178,211,156,97,224,156,76,178,187,148,114,127,190,255,160,211,207,173,55,55,124,40,201,23,102,13,3,229,139,36,135,250,89,252,125,7,160,137,192,237,38,2,167,205,28,6,194,233,102,241,223,238,123,61,47,244,47,214,90,199,147,28,76,242,142,249,195,146,191,242,47,232,26,159,229,207,252,229,90,235,154,38,2,222,19,128,165,
217,231,95,208,43,255,162,4,160,137,192,138,36,7,146,124,224,241,128,103,230,72,146,143,250,221,231,95,244,0,244,132,224,189,36,31,38,121,209,99,3,79,205,205,116,63,231,255,108,49,110,172,44,230,61,171,181,190,153,100,127,28,54,12,79,195,249,116,143,240,251,102,177,110,176,44,246,61,108,190,59,176,47,201,94,143,23,44,154,99,73,62,158,207,225,189,75,26,128,158,16,188,157,100,79,156,79,0,254,140,111,211,253,74,239,217,167,113,227,229,105,222,243,230,164,34,187,147,188,31,167,23,131,126,76,165,123,86,174,19,115,125,159,127,160,3,208,19,130,151,146,236,74,247,227,66,103,27,134,217,221,73,247,227,189,79,103,59,141,215,208,5,160,39,4,47,39,217,145,228,93,91,4,240,216,43,254,169,36,159,207,116,246,222,145,8,64,79,8,158,75,178,61,201,182,36,111,121,236,105,177,115,233,94,174,235,203,71,47,218,49,178,1,120,36,6,175,38,217,154,100,75,146,215,61,31,104,129,75,233,94,162,251,76,239,133,58,151,66,25,164,169,212,90,215,39,217,148,100,50,201,198,36,175,120,174,48,2,174,37,185,156,238,181,54,
46,148,82,110,12,202,29,43,131,60,181,90,235,88,146,13,73,38,146,140,55,239,27,172,77,50,150,100,101,146,231,147,44,247,252,98,9,61,72,114,47,201,221,36,211,73,110,53,251,243,215,211,189,208,238,149,82,202,244,160,222,249,255,3,66,97,149,143,46,30,14,29,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle2_16
:array[0..163] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,16,0,0,0,16,8,6,0,0,0,31,243,255,97,0,0,0,107,73,68,65,84,56,203,237,211,161,13,132,80,16,69,209,243,33,89,141,129,110,80,8,220,210,10,173,65,11,244,65,1,224,40,0,214,252,77,144,31,176,220,100,228,220,55,98,94,192,7,53,190,168,164,177,96,196,4,13,102,236,56,18,103,143,59,77,142,30,173,235,20,216,178,120,118,184,33,8,40,51,15,121,5,175,224,47,88,226,127,95,229,192,250,184,76,225,84,231,14,101,98,250,138,1,211,15,130,39,40,73,205,25,15,233,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle2_24
:array[0..243] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,24,0,0,0,24,8,6,0,0,0,224,119,61,248,0,0,0,187,73,68,65,84,72,199,237,214,49,138,194,80,16,135,241,95,94,20,236,189,64,22,193,70,240,0,122,133,189,150,71,139,130,141,96,105,179,86,91,219,8,194,154,104,225,216,200,86,49,1,139,124,48,205,227,241,253,223,155,102,38,243,96,136,41,22,248,66,210,140,26,63,88,227,128,191,167,252,27,27,156,81,197,197,38,85,133,99,19,206,33,204,226,224,250,134,248,181,174,225,156,165,104,203,252,141,182,252,71,10,231,50,69,207,71,218,103,132,34,69,90,166,27,242,164,99,250,128,62,160,15,232,3,62,37,160,198,173,35,127,149,98,134,94,58,144,95,112,76,49,160,247,241,147,182,168,195,89,230,56,225,23,19,140,49,104,225,229,59,172,176,205,94,214,150,37,10,228,77,123,142,35,202,231,218,114,7,175,135,70,2,234,3,0,106,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle2_32
:array[0..280] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,32,0,0,0,32,8,6,0,0,0,115,122,122,244,0,0,0,224,73,68,65,84,88,195,237,215,189,77,3,65,20,69,225,111,199,4,14,89,9,183,224,4,199,200,114,89,52,64,7,20,226,18,40,96,37,72,49,137,11,32,1,105,83,75,120,109,146,55,194,1,225,122,39,153,43,189,100,52,210,61,243,147,156,198,95,26,220,225,30,75,204,141,155,3,246,248,192,55,206,185,20,18,30,240,136,13,90,204,70,6,24,208,163,195,51,222,112,202,16,107,188,226,24,139,215,156,99,116,173,243,5,44,176,157,168,252,18,98,139,69,138,55,223,196,51,76,149,20,157,171,20,31,174,53,125,90,44,83,252,246,89,1,128,132,121,82,56,21,160,2,84,128,10,80,1,42,64,5,168,0,21,32,133,177,12,5,186,79,56,164,208,165,190,0,64,143,125,10,87,235,178,38,77,120,250,14,187,226,106,150,125,224,19,239,184,141,185,137,205,195,136,243,131,47,188,224,41,228,244,220,252,163,231,171,43,235,249,238,82,207,127,1,142,127,141,157,116,95,219,192,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle2_48
:array[0..454] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,48,0,0,0,48,8,6,0,0,0,87,2,249,135,0,0,1,142,73,68,65,84,104,222,237,218,177,106,20,81,20,198,241,223,204,132,21,33,22,129,1,113,27,91,139,192,190,193,54,91,248,0,62,137,143,146,38,79,32,88,218,217,165,201,11,216,196,70,176,82,146,102,101,13,198,128,193,221,177,152,51,184,132,137,237,204,224,249,96,138,97,46,195,247,63,247,220,211,124,183,208,175,25,142,240,12,53,74,195,104,135,53,174,176,193,221,253,5,197,189,247,50,76,47,177,194,113,0,84,3,1,108,3,224,2,103,56,15,152,93,223,226,3,44,112,138,207,184,197,239,248,201,110,160,103,27,30,110,195,211,105,120,60,208,83,249,5,222,226,122,96,211,255,130,185,14,143,139,174,173,187,214,152,227,53,94,225,73,79,107,141,65,5,30,225,121,156,209,15,248,81,198,203,18,47,113,104,252,58,12,175,75,204,202,152,54,171,56,188,197,4,0,138,240,186,194,81,55,117,142,99,39,166,162,89,120,158,151,49,38,235,137,84,127,127,23,106,212,101,156,230,106,130,0,21,170,210,196,149,0,9,144,0,9,144,0,9,144,0,9,144,
0,9,144,0,9,144,0,9,144,0,9,144,0,9,144,0,9,240,191,2,116,249,83,51,33,223,77,120,222,150,218,24,115,61,65,128,53,214,165,54,119,189,208,19,34,143,88,119,225,249,178,212,38,224,103,1,210,76,164,250,87,225,121,83,69,47,109,180,81,235,11,109,148,57,102,221,224,29,222,224,123,151,19,255,196,23,60,245,55,135,45,70,88,249,27,188,199,137,54,185,111,170,189,143,223,240,41,204,215,120,188,55,102,139,1,77,55,248,133,175,81,249,19,124,140,206,153,254,101,143,135,42,219,93,183,153,143,4,224,210,3,215,109,254,0,181,208,157,8,145,64,148,253,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle2_64
:array[0..614] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,64,0,0,0,64,8,6,0,0,0,170,105,113,222,0,0,2,46,73,68,65,84,120,218,237,219,61,79,20,81,20,198,241,223,94,64,92,16,227,6,95,18,12,13,82,90,225,7,176,180,49,177,55,118,198,248,169,12,141,141,137,141,137,95,192,94,40,45,8,161,209,144,24,77,192,2,54,6,88,44,230,140,142,27,94,90,118,230,156,102,110,238,153,108,242,252,207,185,231,110,49,79,207,197,209,195,12,230,112,43,158,147,16,135,216,143,231,17,78,47,18,120,222,254,44,150,176,134,71,88,197,0,229,138,139,31,97,15,219,216,192,38,118,241,251,44,16,103,1,152,194,29,60,198,211,16,127,15,253,200,245,174,56,128,83,156,96,136,239,1,225,35,62,225,71,228,206,5,48,141,21,188,192,179,88,247,39,160,234,23,117,195,16,59,248,128,183,177,62,110,86,187,185,126,128,215,120,30,226,103,39,160,226,151,205,176,107,184,29,218,230,2,192,126,125,28,166,26,47,222,197,203,16,127,127,12,206,164,71,193,2,150,67,248,23,28,52,1,92,199,19,188,138,202,183,73,124,179,27,110,96,17,95,99,72,30,151,72,44,197,192,
107,171,248,230,49,95,9,173,75,232,149,184,231,235,171,174,175,253,209,15,173,107,152,41,49,24,234,171,174,116,0,64,9,173,143,48,87,226,31,222,106,71,170,223,236,130,85,12,234,14,24,180,252,236,159,53,11,6,152,47,141,182,232,117,8,64,175,214,92,116,60,18,64,2,72,0,9,32,1,36,128,4,144,0,18,64,2,72,0,9,32,1,36,128,4,144,0,18,64,2,72,0,9,32,1,36,128,4,144,0,18,64,2,72,0,9,32,1,36,128,4,144,0,18,64,2,72,0,9,32,1,116,1,192,200,5,190,154,22,198,105,173,185,168,140,69,123,198,172,36,45,143,147,208,124,80,84,238,137,109,149,181,164,43,49,12,205,123,117,7,108,168,12,70,163,14,136,31,249,103,166,58,44,42,95,221,102,108,12,59,82,253,218,78,119,52,213,216,44,120,168,50,24,149,22,159,253,45,188,193,103,28,79,53,18,63,113,83,229,174,90,208,190,175,199,71,42,3,229,59,188,199,47,254,247,8,12,241,77,229,31,88,86,25,140,74,139,42,191,27,194,215,67,231,104,28,192,105,80,217,137,245,98,64,152,158,224,110,24,197,144,223,138,202,175,135,190,191,87,126,90,103,207,249,145,78,155,167,199,243,181,125,
126,128,249,9,233,128,131,128,112,169,125,254,15,149,255,127,38,226,74,188,54,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle2_256
:array[0..7102] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,1,0,0,0,1,0,8,6,0,0,0,92,114,168,102,0,0,27,134,73,68,65,84,120,1,236,157,137,150,36,197,145,69,133,208,10,8,1,2,180,163,234,145,52,203,255,127,206,204,28,154,77,140,196,8,105,246,69,26,49,118,179,243,37,94,209,153,69,117,149,85,85,90,247,245,115,172,34,50,22,15,207,27,241,158,155,123,100,195,203,95,59,143,242,82,53,99,141,175,215,231,196,203,181,78,124,99,137,111,46,235,235,118,215,47,115,146,199,253,242,200,115,202,50,207,47,207,53,235,44,41,235,115,254,100,203,3,254,165,161,15,89,2,131,54,4,84,192,209,54,2,177,19,223,94,226,91,251,117,150,134,12,206,225,25,224,25,165,29,233,156,242,252,230,185,206,179,206,50,37,219,242,249,222,151,15,101,0,249,226,44,87,193,211,99,5,228,119,106,157,248,110,197,107,21,175,239,227,123,155,117,62,27,50,56,135,103,224,213,122,22,9,158,89,204,32,207,51,75,180,150,76,96,125,254,107,243,174,176,237,222,203,125,27,192,250,197,129,17,151,4,22,61,60,224,94,169,64,236,223,175,120,179,226,7,21,239,86,252,
104,31,63,222,47,127,184,44,89,55,100,240,80,207,0,207,39,241,78,197,91,21,111,84,208,105,241,44,243,76,211,145,241,140,243,188,99,6,233,244,106,245,48,52,96,157,114,175,70,112,95,6,176,10,63,162,7,4,80,0,132,107,34,122,192,189,93,193,141,68,232,63,221,199,207,106,249,243,10,150,63,169,96,95,34,198,224,242,75,147,148,197,253,179,224,153,141,9,208,105,209,121,17,60,211,60,219,107,102,64,150,139,14,30,60,35,184,107,3,88,133,207,151,69,244,68,122,123,92,50,162,231,161,69,240,136,252,189,125,32,250,152,0,75,68,191,130,198,113,49,140,4,159,13,25,220,245,51,144,231,109,187,68,248,4,89,0,226,103,153,207,49,2,134,42,235,16,97,53,130,218,245,84,6,112,167,25,193,93,26,64,196,159,84,31,215,67,248,73,241,129,131,99,210,163,35,244,95,84,68,248,152,64,4,143,49,32,122,110,106,156,21,152,9,134,10,134,12,206,241,25,200,51,154,76,128,207,180,243,84,70,16,205,220,169,232,235,250,135,114,23,6,144,47,17,225,175,61,62,238,135,136,211,219,35,252,139,138,136,31,225,211,203,179,63,130,207,152,42,224,
200,26,50,217,226,82,22,231,240,12,208,169,17,105,75,214,121,86,51,57,137,232,137,60,199,217,206,177,201,8,208,99,244,115,204,4,142,109,171,83,110,94,186,13,32,141,143,248,51,198,231,203,166,199,79,138,127,81,219,182,194,39,35,88,123,121,206,139,224,3,42,111,7,214,215,130,174,95,126,77,42,143,251,229,145,73,236,149,123,158,83,196,205,179,123,204,20,98,2,60,227,28,199,249,116,152,49,130,90,221,149,47,178,210,189,236,50,128,8,159,37,117,242,37,0,128,35,146,254,208,155,147,210,35,248,139,253,146,116,63,105,62,251,49,8,142,197,37,1,18,104,212,3,24,32,51,140,32,168,63,160,184,158,33,131,135,124,6,242,60,102,153,231,52,198,144,37,207,50,66,143,41,36,99,88,59,57,142,225,120,190,15,29,105,74,76,32,75,180,118,235,178,94,224,166,149,165,33,212,5,0,26,207,23,35,213,97,236,142,232,127,93,241,183,21,127,87,241,55,251,207,143,106,201,16,128,148,63,61,63,231,164,215,199,0,86,225,71,240,92,199,144,193,185,62,3,8,151,103,21,19,136,240,121,150,17,57,207,54,207,56,89,46,207,60,207,62,26,64,11,104,
4,109,160,17,180,194,103,180,131,134,56,7,77,81,31,117,243,221,41,209,222,147,79,55,248,155,138,110,112,234,238,20,26,64,80,15,13,67,176,124,81,122,115,38,247,242,197,248,66,124,185,95,237,183,49,12,200,56,159,99,215,94,31,7,4,30,245,197,213,169,63,215,114,41,139,9,207,0,207,108,158,95,158,101,158,105,158,237,152,1,207,60,207,62,217,47,90,64,19,232,5,141,160,149,152,0,219,208,18,199,162,45,52,70,125,171,38,234,227,205,10,149,220,180,228,38,80,71,190,28,95,138,47,132,171,253,178,226,175,247,193,151,226,139,176,61,194,79,186,143,179,145,18,173,238,118,236,203,229,122,46,53,128,9,207,64,61,210,187,146,182,242,76,19,136,151,103,157,103,158,103,31,205,100,152,140,54,146,17,160,153,232,7,45,177,29,109,113,124,58,201,99,58,169,221,215,47,84,112,147,178,126,41,190,16,13,162,97,164,53,140,237,105,48,41,12,95,226,175,42,216,70,186,147,177,62,199,242,229,243,69,112,202,237,151,201,53,178,172,67,44,18,24,67,32,207,109,150,52,60,235,60,235,60,243,233,56,99,4,201,8,208,10,154,65,59,104,8,45,
161,41,182,161,177,152,0,218,219,234,166,54,93,191,112,242,179,150,245,75,172,226,79,207,159,70,211,224,139,10,38,250,104,52,95,46,99,153,99,194,175,221,7,64,92,195,34,129,231,137,64,116,147,103,155,37,250,219,26,1,26,65,43,104,6,237,92,84,160,165,116,166,219,76,224,86,38,240,172,6,144,47,193,121,199,196,255,168,182,99,0,44,147,238,51,225,193,15,32,152,0,73,170,207,151,166,14,234,163,164,222,39,159,252,43,129,231,155,192,250,188,179,142,22,208,68,134,6,104,5,205,228,55,51,25,22,172,218,90,135,3,55,54,1,46,124,221,146,70,115,206,41,241,63,170,125,204,92,50,105,193,236,37,78,70,186,146,25,253,181,161,181,89,225,3,193,242,194,18,136,166,0,16,35,64,35,76,244,161,25,180,131,134,208,18,154,66,91,104,140,104,201,4,174,107,0,52,142,194,242,42,241,51,70,161,161,184,211,182,215,231,90,107,61,89,175,205,22,9,188,208,4,208,66,244,192,18,173,108,179,1,52,133,182,208,216,163,125,28,51,129,181,158,58,236,234,114,93,3,160,22,142,141,59,145,162,240,15,33,120,117,113,177,15,26,198,228,5,105,75,
198,250,199,94,89,164,129,117,152,69,2,18,88,8,160,141,196,170,55,38,9,209,20,218,202,4,225,69,173,19,104,16,45,162,201,85,111,245,241,171,203,117,12,32,13,202,24,133,119,145,91,241,103,188,207,246,99,226,167,37,212,99,145,128,4,190,154,64,180,114,204,4,208,88,94,23,94,212,58,17,19,64,155,100,14,104,53,186,173,213,211,229,171,12,32,149,80,33,175,44,24,151,240,206,50,46,196,152,4,241,167,231,207,120,127,109,68,237,86,252,64,176,72,224,25,8,196,4,88,166,243,205,188,64,50,1,180,135,6,147,125,163,77,142,65,171,215,50,129,175,50,128,170,103,39,94,42,91,223,245,243,122,130,139,227,60,219,201,190,85,252,49,144,58,204,34,1,9,60,35,129,232,231,152,9,100,114,16,13,162,197,188,110,207,111,4,98,0,87,94,242,42,3,224,162,236,167,34,198,22,140,67,226,60,92,140,9,9,222,85,178,237,88,207,207,249,22,9,72,224,246,4,98,4,104,145,14,118,205,4,208,32,90,68,147,201,196,209,42,154,229,120,52,124,82,139,167,12,32,23,100,63,233,4,239,239,73,47,24,123,68,252,233,249,153,124,160,65,219,158,191,54,89,36,
32,129,38,2,209,228,106,2,104,47,153,64,76,0,141,162,85,52,139,118,99,0,71,77,224,148,1,212,121,135,212,31,39,161,135,143,211,112,33,46,114,170,231,175,93,22,9,72,224,142,8,32,228,213,4,208,38,90,68,147,104,147,64,171,108,79,22,112,84,252,181,127,231,14,44,215,18,167,73,239,79,239,206,59,125,42,37,197,160,231,143,248,147,106,228,7,62,181,235,116,186,193,78,139,4,36,112,99,2,17,50,218,204,43,121,52,24,19,64,155,104,20,173,162,217,76,8,158,204,2,78,101,0,92,40,23,160,114,126,132,128,195,112,129,245,85,95,126,211,159,134,101,89,135,89,36,32,129,59,32,16,141,177,36,197,71,131,152,0,175,223,209,38,26,69,171,249,169,48,89,0,90,206,121,181,250,101,217,26,0,7,17,164,24,84,190,246,254,17,63,206,194,251,198,107,141,49,234,56,139,4,36,208,75,32,58,69,191,153,163,67,147,104,51,38,176,205,2,208,116,206,171,213,39,101,107,0,108,101,27,7,103,236,143,147,32,126,150,76,56,28,155,244,171,205,22,9,72,224,158,9,164,179,206,155,129,76,10,174,154,93,231,2,158,210,251,186,33,238,192,182,244,254,204,
38,82,25,113,108,220,207,57,148,44,159,124,242,175,4,36,112,215,4,162,57,150,25,174,175,243,1,209,237,250,227,32,180,205,241,57,247,169,73,64,118,112,16,142,66,74,65,143,79,69,164,21,73,253,51,238,79,101,181,203,34,1,9,60,16,129,104,54,243,1,235,80,0,237,162,97,182,161,233,167,52,203,6,74,92,129,207,184,73,126,245,199,201,244,252,17,255,250,239,249,227,34,89,214,97,22,9,72,224,30,9,68,123,44,243,106,16,141,198,4,208,46,26,102,24,128,166,209,118,76,96,119,110,12,160,182,239,76,128,207,56,5,169,4,169,3,61,63,21,228,31,248,216,251,23,12,139,4,206,140,0,98,70,187,201,2,242,86,0,237,162,97,180,204,182,109,22,240,82,220,160,246,237,12,32,99,137,76,38,80,193,218,251,115,129,204,38,230,28,150,22,9,72,224,97,8,108,179,0,52,186,102,1,104,152,64,211,235,43,193,75,25,64,28,4,3,224,100,122,124,78,194,57,72,31,120,29,200,201,84,190,154,70,125,180,72,64,2,103,64,32,26,70,163,104,21,205,162,93,52,140,150,209,52,218,206,48,160,86,159,136,153,229,122,114,12,128,158,63,169,63,219,236,253,33,101,
145,192,249,17,216,245,230,213,44,150,100,232,201,2,50,20,136,150,163,227,116,226,187,33,0,95,103,61,145,147,112,14,196,207,100,2,39,49,118,184,228,28,245,217,34,1,9,156,31,1,196,141,86,209,44,218,69,195,104,25,77,163,237,75,29,249,193,9,106,7,206,193,36,95,78,96,204,192,9,153,248,163,82,140,34,110,83,171,22,9,72,224,140,8,68,159,104,21,161,163,93,52,140,150,211,161,179,13,173,239,180,31,3,136,107,48,118,192,0,56,33,189,127,38,14,114,108,237,210,4,128,96,145,192,25,17,72,199,204,114,213,115,178,0,52,77,92,210,51,7,82,56,9,87,96,39,142,65,112,98,14,78,239,95,155,44,18,144,192,153,19,64,207,201,2,208,48,90,70,211,153,204,71,235,28,115,120,13,200,6,78,32,61,224,32,78,96,125,29,251,239,78,168,109,22,9,72,224,124,9,68,167,116,238,232,26,13,163,101,52,141,182,89,63,204,3,36,173,103,201,129,28,16,167,200,129,24,67,142,171,85,139,4,36,112,166,4,16,63,133,37,154,77,22,128,150,147,217,163,113,180,142,57,124,61,194,142,83,172,6,64,234,16,167,200,113,181,201,241,63,16,44,18,56,99,2,49,0,
116,141,134,183,195,128,24,192,97,8,16,183,224,64,220,34,226,199,65,168,36,206,82,171,22,9,72,96,0,1,52,139,118,147,5,196,4,208,119,178,250,93,6,192,119,137,99,224,22,68,132,159,158,95,3,128,146,69,2,115,8,160,217,232,26,61,199,8,146,213,239,52,29,129,243,181,88,199,49,18,217,167,248,161,99,145,192,60,2,49,128,85,219,171,174,47,253,18,144,131,115,66,214,89,90,36,32,129,217,4,86,61,199,0,118,223,136,15,107,89,15,92,215,215,99,92,151,128,4,102,16,136,134,105,237,186,126,104,253,214,0,14,59,92,145,128,4,158,75,2,24,193,161,104,0,7,20,174,72,224,185,38,176,205,0,118,70,160,1,60,215,247,220,47,39,129,29,129,75,189,254,202,228,148,1,156,60,97,61,217,117,9,72,224,44,9,92,91,191,167,12,224,44,191,149,141,146,128,4,122,9,104,0,189,60,173,77,2,163,8,104,0,163,110,151,141,149,64,47,1,13,160,151,167,181,73,96,20,1,13,96,212,237,178,177,18,232,37,160,1,244,242,180,54,9,140,34,160,1,140,186,93,54,86,2,189,4,52,128,94,158,214,38,129,81,4,52,128,81,183,203,198,74,160,151,128,6,208,203,211,218,
36,48,138,128,6,48,234,118,217,88,9,244,18,208,0,122,121,90,155,4,70,17,208,0,70,221,46,27,43,129,94,2,26,64,47,79,107,147,192,40,2,26,192,168,219,101,99,37,208,75,64,3,232,229,105,109,18,24,69,64,3,24,117,187,108,172,4,122,9,104,0,189,60,173,77,2,163,8,104,0,163,110,151,141,149,64,47,1,13,160,151,167,181,73,96,20,1,13,96,212,237,178,177,18,232,37,160,1,244,242,180,54,9,140,34,160,1,140,186,93,54,86,2,189,4,52,128,94,158,214,38,129,81,4,52,128,81,183,203,198,74,160,151,128,6,208,203,211,218,36,48,138,128,6,48,234,118,217,88,9,244,18,208,0,122,121,90,155,4,70,17,208,0,70,221,46,27,43,129,94,2,26,64,47,79,107,147,192,40,2,26,192,168,219,101,99,37,208,75,64,3,232,229,105,109,18,24,69,64,3,24,117,187,108,172,4,122,9,104,0,189,60,173,77,2,163,8,104,0,163,110,151,141,149,64,47,1,13,160,151,167,181,73,96,20,1,13,96,212,237,178,177,18,232,37,160,1,244,242,180,54,9,140,34,160,1,140,186,93,54,86,2,189,4,52,128,94,158,214,38,129,81,4,52,128,81,183,203,198,74,160,151,128,6,208,203,211,218,
36,48,138,128,6,48,234,118,217,88,9,244,18,208,0,122,121,90,155,4,70,17,208,0,70,221,46,27,43,129,94,2,26,64,47,79,107,147,192,40,2,26,192,168,219,101,99,37,208,75,64,3,232,229,105,109,18,24,69,64,3,24,117,187,108,172,4,122,9,104,0,189,60,173,77,2,163,8,104,0,163,110,151,141,149,64,47,1,13,160,151,167,181,73,96,20,1,13,96,212,237,178,177,18,232,37,160,1,244,242,180,54,9,140,34,160,1,140,186,93,54,86,2,189,4,52,128,94,158,214,38,129,81,4,52,128,81,183,203,198,74,160,151,128,6,208,203,211,218,36,48,138,128,6,48,234,118,217,88,9,244,18,208,0,122,121,90,155,4,70,17,208,0,70,221,46,27,43,129,94,2,26,64,47,79,107,147,192,40,2,26,192,168,219,101,99,37,208,75,64,3,232,229,105,109,18,24,69,64,3,24,117,187,108,172,4,122,9,104,0,189,60,173,77,2,163,8,104,0,163,110,151,141,149,64,47,1,13,160,151,167,181,73,96,20,1,13,96,212,237,178,177,18,232,37,160,1,244,242,180,54,9,140,34,160,1,140,186,93,54,86,2,189,4,52,128,94,158,214,38,129,81,4,52,128,81,183,203,198,74,160,151,128,6,208,203,211,218,
36,48,138,128,6,48,234,118,217,88,9,244,18,208,0,122,121,90,155,4,70,17,208,0,70,221,46,27,43,129,94,2,26,64,47,79,107,147,192,40,2,26,192,168,219,101,99,37,208,75,64,3,232,229,105,109,18,24,69,64,3,24,117,187,108,172,4,122,9,104,0,189,60,173,77,2,163,8,104,0,163,110,151,141,149,64,47,1,13,160,151,167,181,73,96,20,1,13,96,212,237,178,177,18,232,37,160,1,244,242,180,54,9,140,34,160,1,140,186,93,54,86,2,189,4,52,128,94,158,214,38,129,81,4,52,128,81,183,203,198,74,160,151,128,6,208,203,211,218,36,48,138,128,6,48,234,118,217,88,9,244,18,208,0,122,121,90,155,4,70,17,208,0,70,221,46,27,43,129,94,2,26,64,47,79,107,147,192,40,2,26,192,168,219,101,99,37,208,75,64,3,232,229,105,109,18,24,69,64,3,24,117,187,108,172,4,122,9,104,0,189,60,173,77,2,163,8,104,0,163,110,151,141,149,64,47,1,13,160,151,167,181,73,96,20,1,13,96,212,237,178,177,18,232,37,160,1,244,242,180,54,9,140,34,160,1,140,186,93,54,86,2,189,4,52,128,94,158,214,38,129,81,4,52,128,81,183,203,198,74,160,151,128,6,208,203,211,218,
36,48,138,128,6,48,234,118,217,88,9,244,18,208,0,122,121,90,155,4,70,17,208,0,70,221,46,27,43,129,94,2,26,64,47,79,107,147,192,40,2,26,192,168,219,101,99,37,208,75,64,3,232,229,105,109,18,24,69,64,3,24,117,187,108,172,4,122,9,104,0,189,60,173,77,2,163,8,104,0,163,110,151,141,149,64,47,1,13,160,151,167,181,73,96,20,1,13,96,212,237,178,177,18,232,37,160,1,244,242,180,54,9,140,34,160,1,140,186,93,54,86,2,189,4,52,128,94,158,214,38,129,81,4,52,128,81,183,203,198,74,160,151,128,6,208,203,211,218,36,48,138,128,6,48,234,118,217,88,9,244,18,208,0,122,121,90,155,4,70,17,208,0,70,221,46,27,43,129,94,2,26,64,47,79,107,147,192,40,2,26,192,168,219,101,99,37,208,75,64,3,232,229,105,109,18,24,69,64,3,24,117,187,108,172,4,122,9,104,0,189,60,173,77,2,163,8,104,0,163,110,151,141,149,64,47,1,13,160,151,167,181,73,96,20,1,13,96,212,237,178,177,18,232,37,160,1,244,242,180,54,9,140,34,160,1,140,186,93,54,86,2,189,4,52,128,94,158,214,38,129,81,4,52,128,81,183,203,198,74,160,151,128,6,208,203,211,218,
36,48,138,128,6,48,234,118,217,88,9,244,18,208,0,122,121,90,155,4,70,17,208,0,70,221,46,27,43,129,94,2,26,64,47,79,107,147,192,40,2,26,192,168,219,101,99,37,208,75,64,3,232,229,105,109,18,24,69,64,3,24,117,187,108,172,4,122,9,104,0,189,60,173,77,2,163,8,104,0,163,110,151,141,149,64,47,1,13,160,151,167,181,73,96,20,1,13,96,212,237,178,177,18,232,37,160,1,244,242,180,54,9,140,34,160,1,140,186,93,54,86,2,189,4,52,128,94,158,214,38,129,81,4,52,128,81,183,203,198,74,160,151,192,41,3,248,162,247,50,214,38,1,9,220,35,129,107,235,247,148,1,220,99,91,189,148,4,36,112,199,4,78,26,130,6,112,199,228,173,94,2,103,66,0,19,88,141,96,183,174,1,156,201,221,177,25,18,184,39,2,171,9,124,109,107,0,113,137,237,242,158,218,230,101,36,32,129,70,2,209,49,85,174,235,135,75,188,92,107,223,168,248,102,197,247,42,222,173,248,97,197,219,21,223,175,120,165,226,219,21,28,243,210,18,181,106,145,128,4,206,152,0,130,255,191,138,255,173,248,143,138,63,86,252,115,197,167,21,191,171,248,247,138,63,97,0,196,183,42,
94,173,120,167,2,19,248,65,5,6,192,54,13,160,32,88,36,48,140,0,6,240,231,138,255,174,192,0,254,80,241,89,197,63,85,92,50,128,100,0,136,253,173,10,76,224,152,1,48,92,72,22,80,171,22,9,72,224,140,9,252,165,218,22,3,248,183,90,255,188,226,183,21,191,169,192,0,48,133,63,39,3,192,4,190,91,241,70,5,226,199,8,214,33,0,67,4,13,160,32,88,36,48,132,0,6,64,250,255,159,21,255,90,65,250,143,248,63,217,175,99,0,187,33,0,194,206,48,224,181,90,127,115,31,25,2,124,167,62,175,6,80,31,119,153,0,75,139,4,36,112,126,4,50,254,255,159,106,26,66,103,252,79,175,255,113,5,6,240,251,10,140,97,151,1,196,0,200,2,94,169,192,0,200,0,200,6,48,4,12,128,57,2,76,130,99,41,12,5,44,18,144,192,121,17,64,248,148,53,253,103,178,143,244,159,201,191,24,0,243,1,204,13,236,12,32,227,122,122,249,117,24,128,1,240,102,128,109,76,4,98,0,57,86,3,40,24,22,9,156,33,1,76,96,53,0,210,127,122,124,38,255,48,0,140,224,95,42,200,14,254,146,94,157,158,157,12,128,222,254,245,10,50,0,50,1,12,128,172,128,12,96,29,6,104,0,5,196,34,129,51,
37,128,1,32,112,210,124,196,206,236,127,198,255,76,4,238,94,1,214,114,103,0,233,213,51,15,192,219,0,122,127,2,51,192,0,200,0,86,3,168,143,14,3,128,96,145,192,153,16,72,250,159,241,63,41,62,66,39,221,79,239,255,81,173,51,25,184,155,0,172,229,206,0,106,185,19,115,230,2,72,249,17,126,12,0,67,32,51,192,0,200,18,98,24,102,1,5,195,34,129,51,34,128,248,9,102,255,255,171,34,179,255,164,253,31,86,124,82,193,124,192,110,252,95,203,47,182,227,122,4,78,186,79,234,207,91,0,130,137,64,76,129,237,236,199,40,98,2,181,106,145,128,4,206,136,0,191,254,75,250,255,199,90,207,236,63,189,63,70,128,41,176,159,227,14,19,123,172,35,106,196,77,79,159,44,128,76,96,157,8,100,95,76,163,86,119,231,176,180,72,64,2,15,71,96,77,255,243,227,31,132,78,111,143,232,17,63,193,92,192,97,252,95,235,135,12,160,214,15,6,128,192,233,237,73,253,17,127,38,2,29,6,20,12,139,4,206,148,0,38,176,78,254,173,189,255,154,254,51,52,192,36,118,166,129,216,41,107,74,79,22,64,170,79,22,16,3,200,60,0,147,129,235,48,160,62,154,5,0,193,
34,129,7,34,112,172,247,207,79,127,211,251,99,0,76,4,38,253,199,40,158,50,0,218,31,35,72,22,192,27,0,76,0,3,192,16,48,128,117,24,144,227,107,179,69,2,18,120,32,2,233,253,215,127,249,199,216,159,73,191,15,42,62,174,200,236,63,189,63,6,64,217,13,1,158,172,126,249,23,81,175,115,1,76,2,18,201,2,182,147,129,156,201,57,22,9,72,224,126,9,92,213,251,211,227,51,238,167,247,39,19,224,247,0,204,254,51,249,199,121,151,50,128,250,124,16,113,122,245,100,1,244,252,136,63,6,96,22,0,45,139,4,206,131,192,169,222,159,94,63,189,255,103,181,126,120,247,191,54,59,115,0,235,182,244,230,44,217,143,224,25,10,36,248,156,44,128,253,235,241,245,209,34,1,9,220,3,129,181,247,255,83,93,47,239,253,127,95,235,191,169,160,231,199,0,88,103,66,48,189,255,97,252,95,219,118,2,103,153,178,138,153,117,130,73,63,222,0,96,0,100,3,172,99,0,153,11,96,184,144,99,107,213,34,1,9,220,19,1,76,32,239,253,243,171,191,223,214,54,122,255,199,21,152,192,218,251,239,222,253,215,182,67,57,150,1,100,103,68,205,49,8,30,241,199,4,50,
12,192,28,204,2,10,130,69,2,247,72,0,225,111,83,127,198,248,76,244,209,227,127,176,15,230,1,210,251,231,213,95,50,135,218,245,116,6,192,54,132,159,178,154,0,162,79,6,144,44,32,6,160,9,132,152,75,9,220,45,129,8,152,101,82,255,237,107,191,199,181,239,163,138,204,252,243,118,32,51,255,181,250,101,65,184,215,41,164,249,164,252,100,2,136,159,192,16,48,128,152,64,204,162,54,93,50,17,62,91,36,32,129,219,19,136,248,17,115,126,241,71,234,79,47,159,212,159,222,31,241,243,153,172,32,63,251,229,220,156,95,171,79,202,41,3,88,179,128,28,203,54,196,142,9,16,235,48,128,237,152,132,243,1,5,193,34,129,59,36,128,136,25,203,175,239,252,25,231,127,92,129,248,31,87,240,254,159,159,1,239,254,171,63,181,60,218,251,215,246,43,123,106,4,143,160,49,9,82,127,254,97,208,79,42,126,89,241,235,253,242,231,181,228,63,35,254,70,5,175,9,49,5,142,231,92,194,34,1,9,244,16,72,15,158,73,191,252,167,190,232,233,63,170,248,199,138,191,223,47,153,7,160,247,231,205,0,199,95,154,249,175,207,135,242,85,34,141,9,144,254,
35,240,183,42,16,61,38,240,171,138,71,21,152,194,59,21,24,4,199,144,29,104,2,5,193,34,129,38,2,171,248,211,243,35,112,122,126,196,254,126,197,63,84,96,2,152,1,189,255,250,222,159,243,143,22,132,122,85,89,13,34,141,224,248,100,6,156,79,250,79,176,78,172,67,129,250,184,43,107,61,217,230,82,2,18,184,154,64,132,203,146,158,28,241,231,191,242,139,200,153,229,255,168,226,131,138,15,43,48,131,63,84,124,101,234,95,199,236,202,117,132,201,49,4,34,39,197,127,189,226,221,10,50,129,71,251,120,175,150,63,174,120,187,130,253,188,46,92,51,129,250,232,144,0,8,22,9,92,147,192,85,226,103,118,255,211,10,68,255,254,62,48,130,223,85,228,31,252,28,125,237,87,251,47,149,235,24,0,39,112,28,61,59,38,192,27,0,68,78,218,191,53,129,31,213,54,254,191,2,91,19,224,92,202,117,175,247,228,104,255,74,224,197,36,16,241,51,118,223,246,252,252,210,143,158,127,43,126,134,3,136,63,255,181,159,147,227,254,58,230,80,174,43,200,28,135,144,153,15,56,102,2,23,181,29,67,32,19,96,174,96,53,1,140,131,58,82,79,150,181,201,
34,1,9,236,9,68,248,44,9,122,241,109,218,79,207,79,111,255,184,226,253,253,250,42,126,126,27,128,248,41,169,239,201,167,35,127,159,69,136,17,240,169,76,224,162,234,39,48,1,222,12,144,9,240,79,137,25,14,48,116,192,56,56,119,189,230,186,94,187,44,18,120,33,9,172,66,101,29,1,35,100,222,225,51,158,231,135,62,244,252,153,241,127,92,235,4,70,176,138,31,195,72,207,191,214,89,155,143,151,103,21,32,199,19,199,76,224,103,181,253,162,226,23,21,172,51,79,144,76,224,213,90,39,107,192,4,94,174,72,61,181,186,43,124,182,72,224,69,35,176,138,148,117,130,148,31,241,147,202,51,147,79,90,255,121,5,227,251,143,43,62,168,120,188,95,191,149,248,171,142,75,189,49,159,175,83,34,222,173,9,48,1,136,240,223,171,32,11,224,245,96,50,1,134,3,152,0,191,39,96,114,144,33,65,178,129,85,252,235,122,29,98,145,192,115,73,224,152,240,233,185,233,193,73,249,121,127,31,241,167,231,103,134,159,30,255,195,10,140,128,137,192,99,99,254,181,238,58,228,234,114,83,193,29,51,1,210,125,76,128,57,128,159,238,3,19,200,196,96,254,
11,195,235,144,128,108,224,152,17,212,230,27,153,19,231,89,36,112,142,4,182,194,228,51,129,240,211,235,39,229,231,231,189,188,231,71,252,76,248,33,254,79,246,241,105,45,17,63,195,130,237,132,223,246,26,117,200,213,229,166,6,64,173,91,19,96,156,255,90,197,155,21,164,255,49,130,100,2,152,3,191,24,196,40,50,36,32,27,200,176,32,70,80,155,158,18,255,109,218,73,125,22,9,60,4,129,173,32,243,121,43,124,122,253,164,252,8,155,223,246,35,114,198,252,17,63,194,103,24,192,123,126,12,2,179,32,99,120,166,49,127,29,127,169,220,86,88,49,1,150,164,245,8,154,30,158,148,159,73,64,122,127,12,0,51,96,56,128,9,100,94,0,179,96,72,144,185,129,173,17,164,109,89,214,161,22,9,140,35,176,138,126,43,252,140,245,73,249,17,117,198,251,17,63,162,199,0,200,2,200,6,216,207,164,32,134,129,248,169,47,81,171,207,94,58,196,149,58,232,193,73,233,17,50,162,166,151,79,54,64,70,128,25,96,2,252,126,0,115,32,27,192,4,50,55,64,6,193,185,24,201,118,142,128,107,228,58,181,122,178,92,231,152,147,39,187,67,2,215,36,16,81,95,
117,120,132,153,101,198,248,8,55,51,252,25,235,35,126,122,125,68,254,89,5,61,63,162,167,199,79,175,207,156,0,89,2,231,50,100,160,62,202,117,218,242,228,200,35,127,187,4,147,122,88,98,2,4,130,166,135,39,27,64,236,8,31,35,136,9,144,13,176,125,157,27,224,248,12,11,86,35,192,92,50,68,200,181,106,147,69,2,103,71,96,21,60,34,221,10,159,222,27,225,211,147,35,124,198,250,136,159,94,63,226,71,244,172,179,157,94,159,227,73,249,17,62,17,209,103,89,155,110,86,186,197,68,125,137,100,3,24,65,134,5,49,2,204,32,153,0,67,2,182,175,111,10,200,32,146,17,80,15,102,16,99,73,253,181,233,90,89,1,199,89,36,112,151,4,34,196,136,63,66,165,183,103,61,61,62,61,120,122,125,132,141,192,63,175,72,207,143,232,87,225,99,18,8,63,189,126,234,207,245,106,215,237,74,183,1,208,154,212,153,94,251,152,17,48,52,64,248,4,153,0,75,182,37,27,120,181,214,201,6,48,129,100,4,25,30,164,222,218,117,184,22,235,22,9,60,20,129,8,114,237,241,17,45,65,143,143,136,35,252,244,250,76,230,33,126,122,126,150,4,219,48,134,173,240,83,111,
237,58,244,254,172,223,186,68,172,183,174,232,72,5,233,169,89,34,90,122,113,68,156,140,128,241,255,235,21,171,25,144,9,96,2,188,41,96,63,38,64,54,176,102,4,235,252,64,237,58,148,187,252,46,135,139,184,34,129,61,129,136,62,64,248,156,116,127,237,241,211,235,35,124,102,248,147,242,111,69,207,254,85,248,219,25,254,237,245,234,240,219,151,187,22,77,234,103,73,36,141,199,8,232,217,17,54,189,61,130,71,248,4,166,16,19,72,38,144,37,230,145,225,64,234,172,77,102,2,64,176,220,59,129,136,146,37,65,186,143,112,215,30,63,61,127,196,79,15,143,9,16,108,203,228,30,153,66,82,253,140,243,215,250,107,119,127,137,64,251,107,190,92,99,174,195,50,41,124,178,2,140,0,97,211,219,19,136,157,222,31,83,96,238,128,96,91,76,0,243,192,72,52,128,130,96,121,80,2,171,64,99,0,136,56,162,71,220,244,234,4,98,167,151,103,27,251,9,140,34,175,244,146,230,179,92,235,173,143,119,87,34,204,187,187,194,229,154,115,189,136,55,102,64,175,158,33,2,2,79,202,143,49,176,30,35,96,157,253,57,175,86,237,253,129,96,121,48,2,17,107,
4,140,1,144,246,71,248,172,35,116,130,117,246,19,100,10,73,243,35,250,212,149,101,29,114,183,37,130,188,219,171,60,93,123,174,27,35,96,25,81,103,152,144,84,63,195,5,50,133,108,203,121,79,215,236,22,9,60,12,1,68,75,100,24,64,207,190,166,245,136,157,125,68,204,34,231,68,240,89,214,33,247,83,34,196,251,185,218,211,87,201,245,215,37,235,49,3,214,99,8,44,217,206,182,28,95,171,187,178,253,156,237,46,37,112,151,4,182,130,141,160,17,120,196,206,146,237,91,209,211,174,156,159,37,219,94,184,18,65,179,140,240,17,123,134,4,153,44,204,252,64,230,8,152,39,48,100,112,78,207,192,58,87,197,112,149,103,151,12,54,153,107,158,239,245,153,175,221,15,87,254,95,0,0,0,0,255,255,3,0,213,66,173,184,8,230,138,203,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle3_16
:array[0..272] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,16,0,0,0,16,8,6,0,0,0,31,243,255,97,0,0,0,216,73,68,65,84,120,1,196,147,45,14,194,64,16,70,11,40,126,28,9,92,0,7,2,67,170,232,1,240,4,143,66,115,10,20,2,12,10,207,9,240,32,8,30,14,209,19,32,225,61,146,38,132,84,116,139,96,146,183,109,167,51,95,103,183,51,149,40,138,42,80,135,62,196,144,192,24,186,240,105,41,15,103,56,193,21,238,240,168,178,152,60,131,61,108,97,10,223,201,184,222,62,223,25,99,172,57,245,26,203,16,86,96,5,69,173,67,96,15,46,86,16,195,0,66,205,156,88,1,247,92,214,18,183,176,129,102,73,133,182,21,228,29,88,81,189,174,2,63,217,255,5,60,196,5,180,74,238,35,85,192,62,8,105,162,236,91,142,192,81,1,255,194,36,243,6,92,21,216,185,140,192,222,14,173,194,97,154,43,208,128,25,44,33,107,233,39,247,121,102,188,118,131,53,28,116,72,233,113,126,1,0,0,255,255,3,0,228,201,29,210,54,144,162,244,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle3_24
:array[0..400] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,24,0,0,0,24,8,6,0,0,0,224,119,61,248,0,0,1,88,73,68,65,84,120,1,236,150,189,74,3,65,20,70,55,254,22,105,68,137,133,133,69,90,65,98,10,17,31,192,74,132,128,173,149,150,130,141,133,248,0,98,107,99,33,22,130,149,32,136,62,135,72,16,108,45,236,83,166,17,81,207,89,93,80,136,187,56,206,116,94,56,153,48,51,247,251,118,239,206,238,76,45,203,178,26,24,67,48,5,77,152,131,22,180,97,30,234,48,40,250,116,222,195,29,116,225,1,30,161,7,175,144,139,218,142,128,130,251,112,1,167,176,13,203,240,147,56,67,249,152,115,156,107,142,185,106,168,165,102,126,245,195,159,29,123,180,235,118,18,111,31,205,175,127,139,106,92,146,121,8,93,59,166,65,215,29,8,21,38,245,91,168,123,4,7,214,221,154,119,32,118,168,217,212,105,19,172,95,172,171,71,42,15,181,183,188,3,31,72,170,104,105,224,82,76,21,109,87,144,15,99,52,145,195,164,119,80,182,206,255,234,91,215,32,105,252,27,84,150,55,121,137,92,166,187,48,86,121,41,97,19,250,26,172,194,108,88,126,105,150,159,138,
91,13,22,96,177,116,106,216,160,6,215,26,204,192,90,152,70,105,150,6,39,26,140,195,10,76,64,172,80,252,9,142,53,120,134,6,44,65,172,208,224,12,110,252,163,137,159,236,100,91,166,38,110,208,158,30,54,192,157,232,235,170,170,218,136,204,47,194,178,92,193,57,120,218,120,113,176,152,224,75,23,253,216,242,14,0,0,255,255,3,0,101,28,52,149,132,135,68,39,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle3_32
:array[0..492] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,32,0,0,0,32,8,6,0,0,0,115,122,122,244,0,0,1,180,73,68,65,84,120,1,236,151,189,74,3,65,24,69,19,141,162,141,22,17,162,96,10,139,96,64,36,111,160,181,218,8,98,35,54,22,22,193,78,4,11,95,65,108,3,218,219,8,118,90,10,62,130,157,32,34,248,83,164,176,73,35,66,64,207,89,50,33,88,24,155,157,181,200,133,195,254,204,238,222,59,179,187,195,55,249,92,46,151,135,94,21,56,40,66,25,42,80,237,80,99,59,7,182,255,166,54,141,79,112,7,247,29,30,216,190,192,59,216,222,213,48,123,189,1,38,56,94,135,61,56,132,29,88,134,5,48,212,16,244,147,215,76,129,247,120,239,6,172,192,60,140,194,51,124,66,34,205,67,128,18,251,117,56,128,113,72,67,31,60,244,24,26,208,212,32,244,200,158,167,109,174,159,29,179,131,122,233,153,4,240,157,174,65,154,61,215,43,40,132,208,179,224,8,248,110,87,193,134,88,210,75,207,162,1,252,218,253,88,98,75,207,178,1,252,213,102,99,187,119,60,43,6,240,63,207,74,213,127,17,192,25,46,43,213,156,9,79,192,145,200,66,147,26,247,155,219,211,
12,150,204,3,105,26,244,125,118,86,67,223,13,54,8,48,24,129,204,71,192,137,232,8,178,10,210,54,192,54,88,195,197,150,165,224,163,1,150,192,2,50,182,12,112,99,128,69,200,162,32,49,192,165,1,102,192,210,57,182,12,112,106,128,49,88,129,164,74,101,27,75,111,24,53,76,49,13,214,234,91,16,83,231,152,29,24,96,4,54,225,12,98,85,198,46,80,118,225,194,0,226,240,239,67,140,181,65,88,29,89,8,181,66,0,246,115,37,168,67,154,33,130,121,3,159,38,36,189,55,68,144,35,225,138,197,69,131,191,230,207,114,253,139,115,127,81,239,51,189,254,21,110,225,26,174,160,5,137,122,71,32,156,179,68,115,181,20,101,121,254,13,0,0,255,255,3,0,91,40,61,192,227,23,157,11,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle3_48
:array[0..796] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,48,0,0,0,48,8,6,0,0,0,87,2,249,135,0,0,2,228,73,68,65,84,120,1,236,154,191,107,212,96,28,135,239,170,210,42,150,130,67,5,45,213,91,234,15,20,68,16,116,16,50,184,41,222,34,34,130,114,14,130,131,162,131,78,34,226,32,29,236,32,56,40,184,136,139,14,58,248,227,15,168,147,131,139,147,162,131,162,232,226,162,34,84,29,172,62,79,184,28,215,52,39,149,128,205,23,238,3,15,201,229,210,228,243,201,251,38,121,251,126,175,94,171,213,234,208,75,126,55,8,195,48,10,235,96,28,198,160,1,19,237,229,8,203,1,248,23,205,178,243,87,120,11,175,219,203,15,44,223,195,59,248,4,223,224,39,252,134,66,105,80,138,180,130,141,27,96,7,36,208,132,229,144,87,207,131,231,119,236,241,185,232,252,223,217,247,1,76,195,51,120,5,51,48,79,75,216,82,116,128,181,108,63,2,167,224,56,108,131,101,80,214,44,135,88,144,60,215,22,216,3,155,97,37,216,58,182,200,28,229,3,248,121,35,156,133,147,237,245,165,44,23,75,158,123,61,236,132,85,240,6,62,67,231,66,230,251,173,125,250,28,156,
0,251,117,85,164,23,61,233,77,143,29,117,7,176,219,216,101,90,208,73,200,122,85,164,167,22,232,81,175,169,178,0,222,176,7,224,16,84,209,124,106,182,237,77,143,122,213,115,250,232,243,38,246,105,179,31,170,212,109,176,83,40,61,234,85,207,117,91,192,231,188,143,202,93,16,69,122,213,243,160,1,124,73,37,48,4,81,164,215,4,134,13,224,27,182,9,209,164,231,81,251,255,94,120,12,85,190,121,177,55,79,122,223,103,11,56,182,137,170,113,3,56,48,139,170,49,3,52,162,186,215,187,1,230,188,154,131,133,153,112,240,54,9,145,30,161,221,215,120,200,22,136,240,246,237,54,221,189,62,98,0,137,170,129,200,230,211,139,222,15,176,216,125,175,223,2,253,22,40,121,5,250,93,168,228,5,44,253,231,253,22,40,125,9,75,30,32,124,11,56,26,189,0,254,123,22,81,179,6,56,13,69,179,206,17,2,125,49,192,65,88,19,193,109,206,163,189,230,133,1,18,216,10,209,100,128,39,6,216,14,187,163,185,199,175,1,30,25,192,57,70,231,134,162,201,0,119,12,176,26,14,71,115,143,95,3,92,55,128,147,187,199,192,178,78,20,105,222,58,218,148,1,84,
3,172,73,69,145,1,238,139,43,190,3,142,194,85,176,53,34,200,210,235,25,184,109,0,135,19,86,33,167,32,129,8,154,198,164,133,200,231,6,16,203,53,150,83,47,66,213,231,137,44,142,95,130,155,48,147,5,96,61,45,156,157,103,105,53,176,170,83,237,250,189,1,151,225,35,164,87,223,141,153,54,177,98,41,179,5,85,11,161,207,91,112,5,94,66,170,238,22,112,131,79,37,39,123,45,101,90,13,172,74,119,178,219,220,133,107,224,239,42,126,65,170,124,128,108,187,117,88,75,153,86,3,45,168,101,147,191,255,171,85,178,94,241,131,115,63,133,135,112,15,210,110,195,178,163,94,1,220,193,27,219,97,134,213,192,4,154,80,52,236,46,27,42,51,203,225,59,90,240,143,61,254,22,192,163,249,189,239,6,43,153,149,252,185,205,31,0,0,0,255,255,3,0,100,255,105,235,89,229,184,87,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle3_64
:array[0..1051] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,64,0,0,0,64,8,6,0,0,0,170,105,113,222,0,0,3,227,73,68,65,84,120,1,236,155,79,72,20,81,28,199,87,43,60,72,117,40,252,23,138,93,148,8,194,67,84,72,33,132,24,117,173,16,131,58,8,117,142,32,8,132,164,67,80,4,33,68,23,15,29,60,20,65,29,11,138,46,146,68,116,242,16,72,157,68,73,211,91,129,7,161,180,207,103,217,89,116,255,181,75,135,109,230,205,15,62,204,56,243,118,247,125,191,239,247,222,188,25,231,53,100,50,153,6,168,37,26,41,220,12,45,208,1,237,185,253,54,182,93,208,13,157,224,249,38,168,245,251,249,200,182,216,228,175,117,88,133,69,152,135,5,248,14,30,91,134,165,220,254,26,219,13,168,58,172,92,53,21,180,204,30,56,4,39,97,0,250,160,21,118,64,61,227,55,63,190,2,179,48,13,51,48,7,63,65,243,42,134,173,249,183,80,248,25,152,128,151,112,15,206,129,173,95,111,241,84,33,91,7,235,98,157,172,155,117,180,174,214,217,186,87,140,74,6,216,234,189,48,6,147,112,5,76,243,106,50,134,98,117,9,235,102,29,173,171,117,182,238,106,40,91,231,114,6,216,
178,166,250,3,184,14,7,32,110,97,157,173,187,26,212,82,50,91,75,25,96,193,65,184,15,166,213,78,136,107,88,119,53,168,69,77,69,38,20,26,96,170,244,195,56,28,135,178,169,195,185,184,132,26,212,162,38,181,109,211,84,104,64,15,5,110,194,49,72,90,168,73,109,106,204,199,86,3,28,49,71,193,209,115,155,75,249,210,241,222,81,147,218,212,152,191,58,68,6,120,210,244,24,129,56,247,121,170,95,49,212,166,198,124,87,136,12,208,145,97,136,227,104,79,181,107,10,53,170,53,155,5,145,1,206,240,134,106,250,154,120,23,86,171,154,51,26,32,94,39,91,33,148,80,171,154,27,21,239,141,141,115,251,36,14,124,200,42,25,106,85,115,179,6,120,215,214,7,161,133,154,91,52,160,3,66,74,255,168,161,213,220,161,1,222,207,23,77,17,163,82,9,222,170,185,61,234,2,9,214,89,81,90,182,11,120,251,24,106,180,153,1,62,198,10,53,186,52,160,59,84,245,106,215,0,31,96,134,26,157,233,32,72,211,55,133,218,252,106,55,3,66,154,2,23,182,117,131,6,4,29,169,1,65,55,63,226,211,12,72,51,32,112,7,210,46,16,120,2,164,131,96,218,5,210,46,16,184,
3,105,23,8,60,1,210,171,128,207,198,111,67,168,207,4,54,53,224,22,36,249,157,0,228,149,141,117,13,184,10,123,203,22,73,246,137,37,13,56,15,161,254,111,224,179,6,156,134,35,16,98,188,215,128,163,112,42,68,245,104,126,165,1,135,225,108,160,6,188,208,128,131,112,33,80,3,166,52,96,31,92,134,208,166,197,190,102,255,88,3,118,193,69,216,13,33,133,11,46,30,57,3,244,125,185,167,224,75,197,33,197,107,196,94,210,0,179,224,6,184,216,32,148,41,241,38,90,157,1,63,84,176,156,0,87,90,132,242,182,136,233,239,4,240,99,100,128,83,225,9,112,165,69,8,49,133,72,23,83,252,136,12,112,235,155,212,147,144,244,247,133,191,161,241,26,188,129,205,200,0,246,179,131,225,24,91,157,73,234,221,225,47,180,153,233,119,193,85,101,217,254,175,9,81,244,178,227,26,27,175,8,91,143,71,231,227,188,117,224,115,228,119,209,196,151,72,72,97,75,127,229,132,6,236,135,227,81,161,132,108,63,161,67,109,106,204,199,214,46,16,29,244,178,56,8,227,224,50,147,184,103,130,45,175,248,59,240,14,156,1,230,163,148,1,158,212,132,126,48,
93,28,28,11,51,133,67,177,8,251,188,131,157,45,255,1,182,137,231,239,162,49,192,99,81,104,78,15,140,194,8,196,237,234,224,104,255,12,158,128,105,111,38,20,69,185,12,216,90,208,169,178,217,48,12,67,224,91,214,126,238,127,12,69,174,192,91,120,14,182,122,118,180,103,91,50,170,49,192,15,90,78,35,92,102,226,74,139,1,232,3,205,176,187,212,51,76,107,69,207,194,52,204,192,28,84,181,120,186,90,3,248,190,124,120,219,220,12,46,180,232,128,246,220,190,211,104,159,45,118,67,39,120,190,9,252,141,127,9,91,117,29,86,97,17,230,97,1,156,206,122,108,25,150,114,251,107,108,55,160,234,248,3,0,0,255,255,3,0,24,6,129,139,215,110,20,70,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle3_256
:array[0..7993] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,1,0,0,0,1,0,8,6,0,0,0,92,114,168,102,0,0,31,1,73,68,65,84,120,1,236,157,215,143,93,215,121,197,85,40,81,36,69,81,197,84,161,10,135,69,133,234,86,181,44,197,166,236,88,137,44,91,54,16,4,78,94,242,148,167,60,228,37,64,128,32,65,254,158,32,65,128,0,65,130,192,177,227,184,38,177,236,216,146,101,89,150,213,168,94,162,94,168,66,137,89,191,235,251,141,206,220,153,225,204,157,194,185,247,236,223,7,44,222,115,251,217,235,236,181,246,183,191,189,239,240,196,19,78,56,225,196,192,248,132,7,248,56,41,216,20,156,18,156,26,156,22,108,13,78,31,98,123,110,207,8,118,12,111,57,46,240,28,224,181,219,2,222,199,251,1,159,7,78,14,248,14,80,252,215,109,30,106,34,142,14,91,201,237,199,67,124,148,219,15,135,120,47,183,224,221,224,157,224,237,224,173,33,222,204,109,23,111,12,239,243,60,175,3,188,143,247,127,16,240,153,71,2,190,167,251,189,185,219,118,208,17,91,232,120,37,106,218,139,160,17,37,226,221,25,92,20,236,11,174,10,110,10,238,8,126,55,248,114,240,
245,224,15,131,63,10,254,120,120,251,141,220,254,65,240,181,224,238,128,215,254,78,112,75,112,93,112,32,216,27,240,185,231,5,103,7,152,3,223,185,57,232,26,0,231,85,200,97,83,81,237,238,94,27,184,129,35,184,130,51,184,131,67,184,132,83,184,189,54,184,57,184,61,184,51,248,82,192,117,248,74,112,111,240,213,225,49,143,241,220,193,224,182,224,198,128,107,204,181,230,243,184,246,103,6,124,23,125,162,21,45,164,169,159,68,31,27,77,135,162,93,116,166,45,65,9,253,226,28,95,22,84,7,66,232,213,129,238,202,241,239,5,136,153,199,120,238,214,160,4,189,39,199,187,2,58,13,159,199,200,190,152,152,243,148,177,142,12,112,125,1,217,83,93,103,174,5,215,132,107,243,169,224,130,96,38,224,122,35,250,235,3,12,0,147,230,186,2,76,228,134,224,154,224,138,128,107,124,97,192,53,198,124,232,59,244,33,190,167,183,209,7,3,160,51,208,14,92,156,78,192,168,65,7,96,196,184,50,224,34,127,38,64,212,159,27,130,17,155,199,232,20,87,7,251,3,12,226,220,128,81,161,4,190,41,199,116,0,190,3,24,211,193,64,93,47,174,29,215,
112,212,32,48,243,221,1,215,29,241,99,18,244,3,110,15,4,24,7,253,167,12,1,99,33,83,232,157,33,76,171,1,112,129,185,176,204,171,113,107,132,203,5,229,98,50,106,227,238,164,125,159,29,222,226,252,140,2,92,220,61,1,6,129,81,48,79,231,51,20,122,72,104,32,22,51,6,76,159,145,31,193,211,143,246,5,151,14,193,49,125,134,105,3,211,145,234,55,12,56,53,56,80,87,0,83,23,211,100,0,92,60,206,183,68,207,197,152,9,16,117,137,190,210,59,70,118,82,125,12,129,11,202,107,187,46,94,237,230,51,141,182,25,160,15,84,223,170,105,35,69,92,132,78,191,65,248,151,4,51,67,144,41,214,116,240,172,28,147,45,118,51,131,169,50,2,28,108,210,131,115,196,109,25,233,33,254,242,128,17,254,206,224,238,224,222,224,107,193,61,193,23,3,76,128,84,14,225,159,19,140,94,160,60,100,200,192,49,25,160,207,33,106,250,14,125,136,190,68,159,162,111,209,199,238,9,232,115,244,61,250,32,125,145,62,73,223,164,143,210,87,43,67,200,225,228,198,36,27,0,231,198,104,143,203,226,192,204,209,72,235,185,0,144,206,69,248,253,224,96,0,249,140,
246,184,53,175,223,18,212,40,159,67,67,6,86,204,64,101,7,244,41,250,22,125,140,190,70,159,59,24,208,7,233,139,244,73,250,38,125,148,190,74,159,229,245,167,5,19,171,179,73,60,49,206,9,178,203,121,169,210,50,151,255,66,112,215,16,7,115,203,188,158,34,31,41,25,233,154,162,15,9,198,186,50,208,53,3,250,28,125,143,62,72,95,60,24,84,255,164,175,210,103,233,187,149,137,210,63,233,219,19,21,147,116,66,156,11,213,90,92,19,98,73,185,168,212,31,12,112,86,210,44,214,126,153,239,239,11,40,252,81,196,35,85,227,194,24,50,112,60,25,160,207,209,247,232,131,244,69,250,36,125,147,62,74,95,165,207,30,12,232,195,244,101,250,52,125,155,62,62,49,186,155,148,19,129,72,10,47,84,97,43,189,98,201,14,34,63,31,48,247,170,180,138,204,160,70,251,28,26,50,176,225,12,156,156,51,168,172,181,166,171,244,89,250,46,125,152,190,92,211,84,250,56,125,157,62,191,225,177,209,6,192,247,179,190,186,51,192,65,89,170,35,117,130,176,59,2,72,171,52,127,226,231,83,57,87,163,109,6,232,207,204,249,43,139,165,239,210,135,233,203,
244,105,250,54,125,156,190,78,159,167,239,111,168,6,55,242,203,113,192,29,1,69,149,34,138,244,169,132,79,218,132,155,42,252,144,96,76,21,3,93,35,160,15,211,151,203,8,232,227,53,176,209,247,209,192,134,101,3,164,46,204,101,214,59,142,118,190,0,114,72,151,40,162,64,206,129,0,87,252,116,64,209,132,221,89,108,212,129,152,137,154,47,229,124,12,25,24,135,1,250,58,226,38,43,160,86,192,242,32,253,154,41,0,26,96,3,26,241,81,7,93,173,172,187,54,215,219,0,186,141,161,161,124,31,68,156,23,144,6,33,120,132,127,109,192,220,31,67,96,142,79,106,196,107,13,25,232,3,3,24,1,251,2,16,61,253,31,3,224,150,126,206,227,8,253,227,224,200,16,163,186,89,55,35,224,196,214,43,70,27,129,219,177,229,178,155,18,81,40,225,23,120,221,116,159,81,127,221,26,156,207,54,100,96,35,24,160,79,215,42,87,105,128,190,143,6,152,18,148,6,208,72,101,6,57,28,196,168,150,234,241,85,223,174,151,1,140,158,48,46,199,175,180,246,4,140,250,52,152,181,83,82,127,82,126,50,2,28,209,81,63,36,24,189,102,160,155,5,211,247,209,0,90,64,
19,104,3,141,160,21,52,211,141,81,77,117,159,91,241,241,122,24,192,232,137,50,255,97,157,148,198,94,23,208,208,26,245,103,114,76,202,207,107,28,245,67,130,209,4,3,244,117,250,60,125,127,38,96,244,71,19,104,3,141,160,21,52,195,107,186,49,170,173,238,115,43,58,94,107,3,24,61,65,230,56,231,7,151,5,56,29,13,188,33,184,60,96,61,148,162,200,166,192,144,129,22,25,160,239,163,1,180,128,38,208,6,26,65,43,104,6,237,160,161,110,140,106,172,251,220,216,199,107,105,0,163,39,182,45,103,67,53,159,134,81,232,187,49,40,119,35,229,231,121,83,254,144,96,52,205,0,26,64,11,104,162,178,100,180,130,102,208,14,26,226,249,110,140,106,173,251,220,88,199,124,249,90,164,222,163,39,196,124,126,87,64,3,16,61,142,118,101,176,59,96,249,207,148,63,36,24,50,48,100,0,13,178,92,184,57,96,165,0,80,3,96,128,102,117,224,131,14,114,56,27,171,214,238,90,100,0,139,137,255,138,156,38,194,199,201,174,10,74,252,52,108,244,61,121,200,144,129,166,25,64,19,104,131,1,18,173,160,25,180,131,134,208,18,3,42,3,107,55,86,173,163,
213,26,192,232,9,144,170,84,218,95,35,255,129,60,198,15,33,206,12,106,199,211,170,157,43,159,101,200,64,159,24,40,77,160,17,180,130,102,208,14,6,128,150,214,101,58,176,26,3,24,21,127,183,224,199,198,30,78,26,231,170,237,142,22,251,66,134,33,3,203,96,0,173,236,8,208,14,26,66,75,104,106,205,11,131,171,49,128,156,207,108,156,150,163,90,234,99,45,147,147,197,177,170,210,111,177,47,100,24,50,48,6,3,104,166,187,66,128,166,208,22,133,194,133,150,8,243,240,248,177,82,3,232,142,254,204,91,216,184,176,55,184,58,224,36,23,19,127,247,125,121,153,33,3,50,48,194,64,87,35,163,38,128,182,208,24,90,27,221,44,212,125,223,200,71,46,126,119,165,6,80,159,72,170,66,209,98,38,160,202,207,201,41,254,144,96,200,192,42,24,232,138,121,212,4,208,24,90,155,9,208,222,170,166,214,171,49,0,78,172,230,41,136,158,19,91,108,206,223,109,80,94,102,200,128,12,44,193,64,87,51,163,53,129,26,104,171,190,134,22,87,20,188,177,170,143,227,124,0,198,113,122,192,9,84,165,146,244,100,79,128,43,85,181,63,135,134,12,200,192,
26,48,128,230,208,21,224,152,159,16,191,23,188,27,28,14,62,12,198,142,149,102,0,20,253,118,6,123,3,210,17,76,128,95,56,157,21,184,206,31,18,12,25,88,99,6,200,8,208,22,26,67,107,104,14,237,161,65,180,136,38,199,142,149,24,64,173,83,114,18,164,252,156,200,76,64,81,162,78,98,37,89,69,222,110,200,128,12,44,194,64,105,10,141,161,181,153,0,237,161,65,180,216,221,103,147,187,203,139,113,13,128,215,147,250,179,43,137,53,73,190,28,7,98,31,243,214,96,220,207,203,91,12,25,144,129,49,24,64,99,104,13,205,161,61,52,136,22,107,167,224,88,26,28,235,197,249,18,220,167,82,127,190,248,210,128,157,127,152,2,159,213,45,92,228,174,33,3,50,176,198,12,160,49,180,134,230,208,30,26,172,129,120,236,169,192,56,6,208,77,253,169,250,243,197,85,133,92,213,82,68,62,199,144,1,25,24,143,129,238,202,0,90,68,147,99,79,5,150,107,0,188,142,180,131,223,39,239,11,72,57,118,7,84,252,55,7,134,12,200,192,241,103,0,237,161,65,180,136,38,209,102,253,13,129,101,105,123,89,47,202,135,50,250,215,95,47,225,139,246,6,53,239,
175,226,68,30,50,100,64,6,142,35,3,104,175,91,15,64,155,51,1,90,69,179,75,198,114,12,128,215,212,124,3,135,217,31,80,112,216,30,176,143,192,144,1,25,216,56,6,208,32,90,68,147,104,19,141,118,235,114,185,187,120,44,199,0,72,51,106,244,231,11,248,153,98,173,247,47,254,201,62,35,3,50,112,188,24,56,53,95,132,38,209,38,26,157,9,208,236,146,211,243,165,12,160,70,127,220,5,103,217,19,152,250,135,4,67,6,38,136,129,238,84,0,141,162,213,101,45,11,46,101,0,56,75,21,25,246,230,184,126,222,187,41,199,134,12,200,192,228,48,128,38,235,231,195,104,181,138,244,104,120,209,56,150,1,240,92,253,133,31,92,133,15,100,7,210,146,105,69,94,99,200,128,12,28,127,6,208,38,26,69,171,104,150,90,0,26,94,84,231,139,62,145,55,225,40,181,239,184,62,140,98,32,69,7,67,6,100,96,242,24,64,155,85,176,71,179,236,11,64,195,139,102,236,139,25,192,137,121,211,150,128,249,62,110,66,113,129,169,192,49,211,137,60,111,200,128,12,108,44,3,53,109,71,179,104,23,13,163,101,52,61,47,22,51,0,30,175,249,4,31,178,100,42,49,239,147,
125,64,6,100,96,35,24,64,187,53,117,71,187,85,183,91,80,235,11,62,152,55,225,34,44,35,224,34,192,101,191,144,96,200,192,148,48,128,126,107,89,16,253,162,229,5,179,247,133,12,128,84,161,182,253,50,135,96,107,33,243,138,133,94,155,135,13,25,144,129,9,99,0,173,162,89,180,91,26,70,211,243,166,1,11,137,154,66,2,127,234,139,212,225,152,238,145,231,13,25,144,129,201,100,160,155,197,163,101,52,61,175,128,191,144,1,240,70,150,18,248,165,31,115,127,183,252,134,4,67,6,166,140,1,196,142,118,209,48,90,70,211,243,166,1,163,6,208,173,254,215,155,92,247,15,115,134,12,76,33,3,181,47,0,45,47,184,26,48,106,0,220,167,250,143,107,176,149,144,180,97,209,53,196,60,103,200,128,12,76,46,3,104,23,13,163,101,52,141,182,231,104,126,206,157,60,201,27,88,239,103,206,224,158,255,144,96,200,192,20,51,80,5,125,180,140,166,209,246,156,1,125,212,0,72,25,248,179,66,56,134,27,127,66,130,33,3,83,206,0,243,126,180,140,166,209,246,156,41,125,215,0,112,11,54,16,224,22,85,252,235,62,159,135,13,25,144,129,41,99,0,13,87,
49,16,109,163,241,217,229,192,174,192,57,174,249,63,78,177,232,246,193,60,103,200,128,12,76,7,3,85,216,71,211,243,234,0,93,3,96,217,128,221,67,188,200,244,63,36,24,50,208,19,6,106,26,128,182,209,248,236,126,128,174,1,212,250,63,105,194,188,106,97,79,136,176,25,50,208,34,3,149,221,163,237,57,251,1,186,6,64,202,207,255,59,14,76,255,67,130,33,3,61,97,160,166,1,93,125,15,154,86,6,208,45,0,46,250,195,129,158,144,97,51,100,160,69,6,200,240,209,246,156,66,96,215,0,72,251,113,136,5,247,12,231,113,67,6,100,96,122,25,96,222,143,182,209,56,90,31,172,4,148,1,112,75,113,128,39,143,249,39,132,242,188,33,3,50,48,125,12,160,113,180,141,198,209,250,64,251,101,0,181,3,144,2,1,255,255,159,33,3,50,208,63,6,208,54,26,159,221,17,88,6,80,243,3,158,88,214,255,40,210,63,110,108,145,12,244,158,1,180,141,198,103,235,124,101,0,56,3,27,5,156,255,135,4,67,6,122,202,64,213,1,208,250,32,211,47,3,224,175,133,144,26,240,87,68,6,197,129,220,26,50,32,3,253,98,0,109,163,113,180,142,230,103,127,26,88,15,186,254,15,
43,134,12,244,147,1,12,0,141,215,96,63,107,0,252,88,192,237,191,253,188,232,182,74,6,186,12,212,182,96,52,63,48,0,92,129,185,63,75,3,115,126,43,156,251,134,12,200,64,191,24,64,227,104,29,205,159,88,53,128,51,115,199,253,255,33,193,144,129,158,51,128,230,209,58,154,159,205,0,112,4,11,128,48,98,200,64,191,25,168,66,32,154,31,100,0,56,2,119,22,252,187,225,253,230,194,214,201,64,115,12,96,0,104,29,205,159,132,248,107,78,224,14,192,144,97,200,64,3,12,160,117,12,96,19,6,192,238,32,238,184,3,48,36,24,50,208,0,3,179,154,199,0,88,22,160,32,224,10,64,3,87,222,38,202,192,80,235,104,254,84,12,128,116,128,37,1,142,13,25,144,129,254,51,128,214,209,252,105,28,80,16,152,253,125,112,142,13,25,144,129,126,51,64,33,16,205,111,197,0,88,254,115,9,48,36,24,50,208,8,3,181,20,120,122,25,0,127,40,192,144,1,25,104,135,1,52,63,48,0,246,4,187,4,216,206,133,183,165,50,0,3,104,126,59,25,0,115,129,57,255,93,80,238,27,50,32,3,253,102,0,205,159,129,1,80,13,116,15,64,191,47,182,173,147,129,81,6,208,252,142,202,
0,220,3,48,74,143,247,101,160,223,12,160,249,65,6,192,20,0,35,48,100,64,6,218,97,96,48,248,87,6,192,178,128,33,3,50,208,14,3,131,189,0,26,64,59,23,220,150,202,64,151,129,89,3,96,25,208,12,160,75,141,199,50,208,127,6,208,252,96,25,112,240,183,193,250,223,94,91,40,3,50,48,194,192,192,0,216,6,108,200,128,12,180,199,192,96,39,160,219,128,219,187,240,182,88,6,96,96,27,69,192,193,127,16,32,31,50,32,3,205,49,48,248,53,160,191,3,104,238,186,219,96,25,24,48,48,248,123,0,26,128,189,65,6,218,100,96,96,0,254,14,160,205,139,111,171,101,224,20,106,0,26,128,29,65,6,218,100,96,96,0,252,151,193,134,12,200,64,123,12,156,76,6,0,12,25,144,129,246,24,24,252,199,32,26,64,123,23,222,22,203,0,12,12,12,192,223,1,216,25,100,160,77,6,102,255,119,224,54,155,111,171,101,160,113,6,72,255,205,0,26,239,4,54,191,89,6,204,0,154,189,244,54,92,6,194,128,5,64,187,129,12,52,204,128,6,208,240,197,183,233,50,160,1,216,7,100,160,97,6,52,128,134,47,190,77,151,1,13,192,62,32,3,13,51,160,1,52,124,241,109,186,12,104,0,246,
1,25,104,152,1,13,160,225,139,111,211,101,64,3,176,15,200,64,195,12,104,0,13,95,124,155,46,3,26,128,125,64,6,26,102,64,3,104,248,226,219,116,25,208,0,236,3,50,208,48,3,26,64,195,23,223,166,203,128,6,96,31,144,129,134,25,208,0,26,190,248,54,93,6,52,0,251,128,12,52,204,128,6,208,240,197,183,233,50,160,1,216,7,100,160,97,6,52,128,134,47,190,77,151,1,13,192,62,32,3,13,51,160,1,52,124,241,109,186,12,104,0,246,1,25,104,152,1,13,160,225,139,111,211,101,64,3,176,15,200,64,195,12,104,0,13,95,124,155,46,3,26,128,125,64,6,26,102,64,3,104,248,226,219,116,25,208,0,236,3,50,208,48,3,26,64,195,23,223,166,203,128,6,96,31,144,129,134,25,208,0,26,190,248,54,93,6,52,0,251,128,12,52,204,128,6,208,240,197,183,233,50,160,1,216,7,100,160,97,6,52,128,134,47,190,77,151,1,13,192,62,32,3,13,51,160,1,52,124,241,109,186,12,104,0,246,1,25,104,152,1,13,160,225,139,111,211,101,64,3,176,15,200,64,195,12,104,0,13,95,124,155,46,3,26,128,125,64,6,26,102,64,3,104,248,226,219,116,25,208,0,236,3,50,208,48,3,26,64,
195,23,223,166,203,128,6,96,31,144,129,134,25,208,0,26,190,248,54,93,6,52,0,251,128,12,52,204,128,6,208,240,197,183,233,50,160,1,216,7,100,160,97,6,52,128,134,47,190,77,151,1,13,192,62,32,3,13,51,160,1,52,124,241,109,186,12,104,0,246,1,25,104,152,1,13,160,225,139,111,211,101,64,3,176,15,200,64,195,12,104,0,13,95,124,155,46,3,39,135,130,191,13,78,148,10,25,144,129,230,24,56,106,6,208,220,53,183,193,50,240,9,3,102,0,159,112,225,145,12,180,198,192,81,12,224,111,2,51,129,214,46,189,237,149,129,19,78,248,8,3,248,235,128,91,67,6,100,160,45,6,142,32,252,191,10,78,105,171,221,182,86,6,100,32,12,124,128,1,252,101,176,89,58,100,64,6,154,99,224,48,6,240,23,193,214,230,154,110,131,101,64,6,222,198,0,254,60,56,67,46,100,64,6,154,99,224,53,12,224,207,130,179,155,107,186,13,150,1,25,120,25,3,248,211,224,60,185,144,1,25,104,142,129,103,49,128,63,9,46,106,174,233,54,88,6,100,224,9,12,224,27,193,94,185,144,1,25,104,142,129,135,49,128,175,7,7,154,107,186,13,150,1,25,184,31,3,248,114,112,109,224,
47,2,237,16,50,208,14,3,71,211,212,251,48,128,47,4,55,7,26,64,72,48,100,160,17,6,48,128,31,96,0,183,15,225,15,130,26,185,242,54,83,6,194,192,199,193,127,96,0,55,5,119,6,28,27,50,32,3,109,48,240,81,154,249,111,136,254,154,224,75,129,63,8,10,9,134,12,52,194,192,7,105,231,63,99,0,151,6,119,7,254,32,40,36,24,50,208,8,3,135,211,206,127,196,0,118,7,95,9,182,5,134,12,200,64,27,12,188,153,102,254,61,6,112,65,112,111,176,35,48,100,64,6,218,96,224,213,52,243,239,48,128,115,130,175,6,159,10,12,25,144,129,54,24,120,62,205,28,24,192,246,28,48,5,32,19,112,47,64,72,48,100,160,231,12,176,7,224,80,48,48,128,45,57,160,8,56,19,104,0,33,193,144,129,158,51,128,1,252,58,248,7,166,0,167,6,44,3,94,22,184,25,40,36,24,50,208,115,6,216,3,240,64,240,79,24,192,166,224,96,112,213,240,56,55,134,12,200,64,143,25,96,15,192,79,130,127,197,0,24,245,111,11,174,15,220,11,16,18,12,25,232,57,3,236,1,248,97,240,45,12,128,121,255,141,67,184,23,32,68,24,50,208,115,6,216,3,240,221,224,251,101,0,164,255,183,4,236,5,176,
16,24,18,12,25,232,41,3,20,0,255,47,248,118,240,147,50,128,125,185,115,107,192,94,0,13,32,36,24,50,208,83,6,48,128,231,130,127,15,30,44,3,224,111,2,98,0,187,2,87,2,66,130,33,3,61,101,128,21,128,39,130,111,6,143,97,0,196,206,128,63,10,178,59,96,85,192,144,1,25,232,39,3,172,0,252,42,248,86,240,116,101,0,103,230,206,13,193,254,192,149,128,144,96,200,64,79,25,120,55,237,250,121,240,157,224,165,50,0,254,107,48,254,46,192,21,1,43,1,214,1,66,130,33,3,61,99,128,249,255,27,193,143,131,31,4,175,151,1,176,27,16,241,179,26,64,54,160,1,132,4,67,6,122,198,0,6,240,82,240,163,0,19,120,167,12,128,219,61,193,213,1,245,0,238,27,50,32,3,253,98,224,72,154,243,84,240,189,224,254,224,253,50,0,70,252,11,3,50,0,110,253,243,96,33,193,144,129,158,49,240,126,218,243,72,240,253,128,31,3,29,41,3,200,241,96,228,231,63,8,97,37,128,95,8,26,50,32,3,253,98,224,173,52,231,23,1,243,255,67,193,199,93,3,224,191,8,231,23,129,251,2,254,70,128,117,128,144,96,200,64,79,24,224,207,128,191,18,252,52,248,175,224,197,224,
104,215,0,24,245,247,6,252,145,208,179,3,158,51,100,64,6,250,193,0,243,255,103,131,255,9,48,129,215,131,129,200,107,164,103,222,207,252,31,3,56,47,96,101,192,144,1,25,232,7,3,239,165,25,143,5,140,254,15,6,239,4,115,12,128,45,192,172,0,48,5,96,107,48,25,65,153,67,14,13,25,144,129,41,101,128,229,63,126,1,248,203,0,3,120,52,96,71,224,28,3,224,62,191,6,220,19,92,50,60,198,20,12,25,144,129,233,102,128,249,63,235,255,236,0,100,253,255,153,128,223,4,204,51,128,173,121,140,209,127,38,224,175,5,51,45,48,100,64,6,166,155,1,150,255,158,10,238,11,126,22,80,12,36,43,152,103,0,8,158,249,255,204,240,246,180,220,58,13,8,9,134,12,76,41,3,8,157,229,63,214,255,41,0,62,52,188,159,155,249,6,64,202,207,10,192,197,1,5,193,237,129,211,128,144,96,200,192,148,50,64,250,207,31,0,121,32,32,3,120,60,32,35,24,68,119,25,176,30,59,61,7,187,2,76,224,172,192,105,64,72,48,100,96,74,25,64,236,79,7,255,27,144,254,63,31,12,230,255,185,157,55,5,224,49,150,255,88,13,160,22,112,110,224,106,64,72,48,100,96,10,25,168,
234,63,233,63,163,63,171,0,175,5,131,249,127,110,23,52,0,82,126,70,126,178,128,11,2,166,1,110,10,10,9,134,12,76,25,3,71,114,190,84,255,217,254,203,230,31,150,255,248,123,0,179,177,208,20,128,162,223,182,128,98,32,38,64,77,192,77,65,33,193,144,129,41,99,224,112,206,247,80,64,250,207,18,224,115,193,135,193,108,32,246,209,42,255,166,60,198,62,128,59,131,123,130,91,2,166,2,102,1,33,193,144,129,41,97,128,121,62,163,63,235,254,255,18,124,39,96,41,144,172,96,54,22,202,0,152,31,48,13,32,245,71,248,100,2,108,16,178,24,24,18,12,25,152,18,6,40,254,61,27,80,253,39,3,160,250,63,39,253,207,253,5,107,0,60,78,176,7,128,205,64,24,0,211,0,139,129,33,193,144,129,41,96,128,165,63,254,244,215,99,1,226,167,6,240,66,48,39,253,207,253,65,250,63,58,5,224,113,50,3,230,255,183,5,119,5,183,7,76,11,48,5,67,6,100,96,178,25,224,135,63,164,251,63,12,190,25,176,255,159,249,255,236,242,95,142,7,177,208,20,160,158,227,150,81,159,209,159,255,48,132,149,1,119,6,134,4,67,6,38,152,1,70,255,55,3,82,126,10,127,76,1,
158,14,48,133,121,177,80,17,176,94,68,229,159,81,255,179,193,23,131,91,131,139,3,179,128,144,96,200,192,132,50,128,208,17,60,219,126,191,29,252,40,32,27,248,32,152,23,199,50,0,10,129,140,250,215,4,7,131,207,7,87,6,60,70,230,96,200,128,12,76,22,3,164,248,108,244,121,40,248,110,240,159,1,243,127,30,35,51,152,23,199,50,0,94,204,104,191,59,248,76,112,103,112,115,64,86,176,53,48,100,64,6,38,139,1,170,252,140,246,236,250,99,217,239,191,131,67,193,130,233,127,30,95,180,8,200,115,4,89,0,43,1,87,5,159,11,238,24,30,83,19,96,191,128,33,3,50,48,25,12,176,190,207,143,126,216,238,203,31,253,252,222,240,248,149,220,46,56,250,231,241,37,13,128,215,80,8,100,238,207,232,143,9,112,187,39,96,159,0,25,132,33,3,50,176,177,12,176,119,231,173,224,137,128,209,31,241,115,75,45,128,221,128,139,6,2,94,74,196,100,1,204,251,175,8,40,8,146,5,80,23,56,63,216,28,24,50,32,3,27,203,0,155,126,94,8,152,239,51,250,83,248,123,56,88,116,238,159,231,6,177,28,3,224,133,8,157,191,15,112,125,192,158,0,86,4,46,13,44,8,134,
4,67,6,54,144,129,42,252,253,38,231,64,229,159,181,127,150,255,216,5,136,49,28,51,150,107,0,100,1,164,252,251,2,166,0,152,0,102,64,65,144,191,31,176,84,22,145,151,24,50,32,3,107,204,0,169,255,219,193,83,1,162,71,252,164,254,143,5,76,9,22,157,251,231,185,65,44,215,0,120,241,41,193,206,128,165,64,86,5,200,2,40,14,158,23,176,90,96,200,128,12,28,95,6,168,238,191,24,252,50,96,244,167,234,207,18,224,203,193,135,193,146,49,142,1,240,97,44,255,93,20,92,23,176,77,248,166,96,127,192,74,129,171,2,33,193,144,129,227,196,0,85,127,42,252,143,6,63,9,216,238,123,127,240,76,48,239,71,63,121,108,193,24,215,0,152,10,236,8,246,6,55,6,100,1,76,5,102,130,51,2,54,8,145,150,24,50,32,3,235,195,0,154,101,222,207,118,223,39,3,82,127,70,255,159,6,143,7,111,4,75,166,254,121,205,32,198,53,0,222,196,84,128,125,0,151,7,212,3,110,9,152,10,92,24,108,11,248,76,67,6,100,96,125,24,96,128,125,39,160,200,71,234,255,227,224,190,224,215,1,251,0,150,149,250,231,117,131,88,137,1,240,198,45,193,5,1,194,199,4,152,10,96,
8,212,3,120,142,147,212,8,66,130,33,3,107,196,64,105,234,112,62,239,197,0,193,147,250,35,126,140,224,249,128,231,198,138,149,26,0,239,163,250,207,42,0,123,2,48,129,27,2,234,1,100,7,252,144,200,144,1,25,88,91,6,248,65,15,163,60,243,126,126,231,143,248,89,251,103,21,224,237,96,236,233,247,74,13,128,47,98,190,127,102,176,39,160,40,136,9,112,203,253,179,3,166,10,21,99,159,88,189,209,91,25,104,152,1,244,89,65,106,255,106,240,68,64,177,15,241,115,203,253,215,3,234,2,221,215,231,238,210,193,27,198,126,83,222,83,130,166,242,207,136,207,200,79,49,144,194,32,25,193,238,0,115,224,249,138,122,79,221,247,86,6,100,96,113,6,186,186,164,226,143,200,15,5,140,248,20,252,126,30,144,9,144,17,240,60,209,125,207,111,31,89,226,95,222,48,246,155,242,158,174,152,73,247,207,13,46,11,62,29,48,21,160,54,112,113,192,138,1,153,66,69,247,125,245,152,183,50,32,3,115,25,232,106,146,145,157,202,254,211,1,115,125,82,255,159,5,143,4,47,5,221,223,249,119,223,151,167,150,142,149,26,0,159,220,21,51,27,129,248,109,
0,133,64,76,0,28,8,46,10,106,121,48,135,131,232,190,175,30,243,86,6,100,224,183,12,116,69,92,203,125,207,228,169,95,5,8,31,80,0,100,239,63,27,129,42,186,239,171,199,150,188,237,166,232,75,190,248,24,47,224,68,112,35,70,123,62,147,91,246,12,212,73,141,154,64,158,50,100,64,6,142,193,64,137,159,229,62,4,255,64,64,250,79,218,143,214,186,226,207,221,149,197,106,50,0,190,113,116,52,223,150,199,118,5,87,4,215,13,65,86,192,30,1,76,0,115,24,125,79,30,50,100,64,6,134,12,160,73,230,244,111,6,37,254,251,115,12,30,14,158,11,222,9,186,81,3,109,247,177,101,29,175,214,0,248,146,81,65,179,60,136,9,32,252,107,135,40,19,216,145,251,101,2,43,62,233,124,134,33,3,125,99,0,29,149,248,223,200,113,137,159,145,31,144,5,32,126,150,251,186,177,42,29,173,133,1,112,50,11,153,192,5,121,156,194,32,171,2,0,19,160,38,192,234,192,169,129,33,3,50,48,151,1,10,122,84,251,159,9,16,60,41,63,120,36,120,62,88,83,241,231,243,6,142,179,42,7,225,67,134,49,106,2,76,7,206,15,246,7,87,15,193,212,128,213,129,179,2,10,135,212,
9,70,223,151,135,12,25,104,134,1,244,199,222,125,230,244,175,5,84,251,73,245,31,28,130,57,63,5,191,53,75,251,243,89,179,177,86,25,64,125,224,168,152,183,230,9,150,8,249,241,208,149,1,70,128,9,176,131,144,253,3,60,143,9,24,50,208,42,3,136,159,95,239,177,158,255,84,80,226,127,40,199,143,7,20,252,120,190,27,107,53,104,175,105,6,80,39,56,106,2,140,244,136,125,38,96,26,192,30,1,150,8,103,2,126,59,64,205,128,186,128,33,3,173,49,64,177,143,180,158,189,253,79,6,44,245,177,214,79,250,255,100,128,41,144,25,116,99,205,196,207,135,242,97,107,250,129,195,51,29,53,1,230,252,103,7,212,0,46,13,200,6,48,1,50,3,106,5,20,7,55,7,235,113,46,249,88,67,6,38,138,1,244,241,126,64,177,239,249,128,145,30,241,51,234,255,38,160,6,240,106,64,77,160,27,107,174,143,245,50,0,78,122,212,4,24,229,17,58,130,71,248,76,5,0,134,128,49,96,16,76,9,216,67,96,200,64,95,25,96,125,159,148,30,129,35,116,4,79,218,15,48,2,12,1,99,32,59,232,198,154,139,159,15,95,79,3,224,243,71,77,0,113,83,28,220,25,92,18,176,74,80,38,176,59,
199,76,9,182,7,100,12,235,210,224,124,174,33,3,27,193,0,90,96,68,127,43,32,229,63,20,148,248,169,242,51,255,127,57,160,216,135,73,116,99,221,180,176,222,6,80,141,232,26,193,73,121,144,186,0,203,129,187,2,178,129,203,3,204,128,99,30,99,149,128,108,192,218,64,72,48,166,158,1,70,115,70,125,170,252,207,5,140,244,136,158,185,62,199,60,198,242,31,243,253,143,131,138,117,19,126,247,11,214,253,75,234,203,70,110,79,201,125,10,128,149,13,236,203,49,38,176,63,96,169,144,108,128,221,131,212,6,156,22,132,4,99,234,24,96,36,103,174,255,102,192,168,255,116,240,104,128,248,31,11,106,212,167,16,248,97,112,220,227,120,101,0,139,53,172,155,13,156,159,23,205,4,24,1,38,176,39,184,48,96,5,1,163,56,53,224,245,134,12,76,58,3,140,226,31,4,8,155,74,62,187,250,158,8,16,63,194,127,50,120,33,88,104,212,207,195,199,47,54,218,0,170,165,100,3,164,252,231,4,20,9,103,2,140,128,41,1,181,1,30,163,72,72,253,64,35,8,9,198,68,50,80,194,103,30,79,145,143,130,222,161,128,52,191,132,207,99,175,4,76,9,54,100,212,207,247,
206,198,164,24,0,39,196,232,94,211,2,140,128,90,0,226,223,51,196,197,185,197,8,168,15,84,70,224,212,32,100,24,27,206,192,71,57,131,26,241,153,231,35,114,210,125,70,125,128,9,48,207,71,248,149,238,119,231,250,121,120,99,98,146,12,160,24,192,8,54,7,136,156,81,31,209,95,18,96,6,0,35,96,186,128,73,176,98,192,107,41,22,210,22,67,6,142,23,3,71,243,69,20,247,222,15,168,236,35,110,210,122,132,143,224,193,83,1,102,64,54,128,240,121,237,68,8,63,231,49,136,73,52,128,58,55,140,128,116,159,180,159,81,159,162,32,53,1,12,0,67,168,140,128,26,1,251,11,152,66,212,244,64,51,8,25,198,154,51,128,232,17,48,163,61,41,60,235,245,204,241,107,196,71,240,24,0,115,126,138,126,100,3,76,7,120,253,68,9,63,231,51,136,73,54,128,58,71,140,128,17,126,75,192,170,0,35,63,25,0,102,112,209,16,76,23,48,8,50,6,178,2,94,171,25,132,4,99,213,12,116,69,127,56,159,198,104,207,136,142,192,73,235,159,25,2,209,147,1,144,9,80,245,231,181,100,8,19,41,252,156,215,32,166,193,0,186,231,90,89,1,163,61,163,62,163,63,194,103,154,128,
33,96,4,28,179,180,136,25,96,24,101,6,212,11,120,191,33,3,75,49,128,104,107,94,143,144,17,52,162,103,163,14,163,61,194,71,240,28,99,4,100,1,100,3,100,5,53,218,99,28,19,31,211,100,0,93,50,57,111,4,205,40,143,192,17,58,130,71,248,101,8,24,1,199,231,6,100,13,24,6,211,9,54,33,81,108,228,253,211,218,254,156,186,177,70,12,32,84,128,224,169,202,179,25,135,180,29,65,51,154,191,20,32,114,196,94,130,199,8,48,132,26,233,17,61,239,159,10,209,231,60,103,163,15,2,160,13,53,77,216,156,99,68,142,33,80,55,32,67,192,0,202,8,56,230,49,204,2,67,160,208,88,25,2,211,12,62,167,15,156,164,25,198,2,12,148,216,25,225,73,207,17,46,35,252,219,1,130,71,212,140,230,136,190,132,207,45,143,49,159,71,240,152,3,197,188,74,239,167,78,244,57,247,217,232,99,103,47,67,232,102,8,93,83,64,252,100,4,100,11,152,65,25,2,134,129,113,96,10,91,131,202,20,52,134,144,49,101,49,42,244,26,217,73,209,17,59,66,70,208,37,120,4,206,168,206,136,207,99,93,177,99,16,53,194,99,28,83,45,248,156,255,156,232,163,1,204,105,224,240,78,181,
179,50,5,166,14,8,28,161,35,120,10,135,100,4,252,62,1,35,232,130,199,120,174,204,1,51,225,189,100,27,76,37,70,13,130,239,50,214,143,129,18,55,183,53,146,35,112,70,229,74,223,75,228,140,234,236,182,67,208,93,240,24,207,81,208,227,181,24,3,239,69,232,221,145,189,87,98,79,219,230,69,9,99,222,19,13,62,80,194,229,182,140,2,129,143,154,69,25,6,134,80,198,192,113,1,51,1,188,14,179,168,108,162,50,138,170,63,240,29,53,229,200,97,115,251,24,74,92,37,228,42,188,33,230,26,177,17,37,226,36,237,70,168,8,22,48,130,119,129,152,185,95,130,30,21,53,159,215,21,118,238,246,107,36,167,65,43,137,255,23,0,0,0,255,255,3,0,249,166,175,250,14,219,250,142,0,0,0,0,73,69,78,68,174,66,96,130);


template_squircle4_256
:array[0..12211] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,1,0,0,0,1,0,8,6,0,0,0,92,114,168,102,0,0,47,123,73,68,65,84,120,1,236,157,9,143,44,189,121,157,37,203,187,164,79,214,106,57,171,229,45,54,140,36,54,130,216,14,18,4,70,128,32,64,16,56,254,255,63,193,251,110,199,155,194,167,231,62,61,103,56,85,221,61,61,93,125,107,102,14,1,206,203,98,177,72,214,33,207,225,75,86,223,239,251,202,151,190,244,165,47,55,222,13,131,31,41,214,23,97,61,96,186,168,92,231,238,43,113,98,66,54,92,135,192,53,147,239,186,150,62,222,83,197,246,78,99,254,149,209,14,96,55,60,69,224,146,9,248,244,137,231,74,220,213,254,57,38,151,224,186,86,6,188,243,222,57,252,179,172,233,249,153,15,127,253,209,5,192,137,113,206,174,145,153,124,163,117,120,93,251,136,205,45,176,0,95,234,89,194,217,188,217,66,240,204,155,175,189,71,254,135,12,31,81,0,28,244,217,206,147,203,251,115,190,147,25,236,230,180,121,88,227,143,78,105,174,27,79,99,32,118,137,231,140,181,227,98,62,227,149,105,175,29,199,217,142,226,71,113,152,211,92,127,136,
0,192,0,243,158,67,14,124,78,26,243,51,143,244,60,233,156,140,18,121,201,38,161,127,108,212,177,20,127,124,37,127,169,108,243,30,4,2,28,18,91,177,103,76,50,237,24,205,99,167,32,228,24,59,238,218,81,213,51,33,152,243,184,126,151,1,192,0,226,189,4,7,85,235,192,115,237,100,200,180,19,135,123,57,161,114,210,45,145,17,50,75,104,211,63,49,242,140,63,25,105,242,184,158,243,44,91,251,136,219,140,133,216,106,25,11,211,140,209,60,54,57,110,166,29,99,197,97,105,30,56,95,210,142,234,159,9,131,247,185,247,46,194,123,16,0,7,5,75,200,107,210,14,56,214,73,192,228,112,98,204,19,201,9,198,100,36,237,164,148,192,146,121,182,63,53,202,18,127,58,226,87,35,125,73,126,150,249,136,233,196,79,60,177,137,181,227,177,102,29,191,53,113,96,220,29,255,156,27,164,157,47,57,135,70,246,33,152,199,133,105,236,155,14,111,89,0,28,4,6,192,116,14,162,132,207,1,103,82,72,120,39,138,19,201,73,230,132,115,2,74,68,200,108,156,243,190,54,238,25,191,254,41,141,157,163,101,106,31,241,58,135,197,140,57,227,34,254,166,29,
43,45,99,201,184,106,73,59,222,10,131,243,0,75,204,249,194,124,202,185,228,252,26,217,135,185,54,91,238,191,201,240,22,5,96,30,140,28,168,28,68,7,214,129,118,2,48,25,152,40,76,14,39,16,19,202,137,150,118,137,204,95,140,178,228,167,37,77,252,198,74,204,251,166,107,31,48,91,194,97,22,78,199,65,177,96,140,230,180,121,138,3,54,5,65,129,87,20,156,15,10,130,139,3,156,32,50,151,50,42,10,35,251,153,8,152,247,230,132,224,45,9,128,196,215,230,224,72,124,201,206,96,58,192,14,188,147,33,201,238,36,194,58,233,156,144,51,153,127,102,148,201,60,202,229,53,105,202,124,243,147,37,109,204,114,115,61,121,175,233,243,162,144,99,229,152,97,25,143,20,10,5,65,65,87,24,156,7,206,11,172,115,101,22,3,230,211,44,8,206,191,217,142,162,139,194,64,254,110,195,91,17,128,25,108,201,239,224,168,222,18,223,85,222,21,222,73,144,19,5,178,73,98,137,138,77,2,155,198,154,206,178,166,169,203,251,90,239,97,147,216,107,2,147,101,62,98,58,113,49,157,118,137,236,224,148,101,72,103,57,197,34,133,222,185,128,85,12,176,10,
66,110,23,210,139,100,174,57,239,180,206,203,113,235,72,254,57,205,245,110,195,222,5,64,128,181,2,79,191,231,213,126,38,189,131,238,164,144,84,18,83,82,207,246,91,163,238,204,163,188,164,198,90,207,146,149,236,180,185,54,57,237,79,78,212,166,31,137,43,105,197,196,113,204,124,211,75,88,146,231,253,172,195,52,196,183,78,197,96,105,187,192,124,82,12,92,96,20,132,89,12,152,159,134,76,147,55,95,91,110,23,118,175,2,32,225,177,146,30,155,196,215,109,83,197,117,237,25,104,38,1,17,18,74,96,73,13,193,141,228,101,218,50,138,132,132,214,38,169,109,199,137,53,95,207,147,204,201,86,187,124,222,34,46,142,163,46,59,249,230,89,70,43,198,18,62,175,47,77,91,151,237,232,53,234,21,40,2,218,20,1,249,195,220,116,206,142,228,33,44,93,123,111,55,214,23,216,77,135,70,71,0,142,112,138,248,12,134,3,197,192,73,66,87,101,73,47,185,177,223,254,20,77,123,15,210,39,225,21,14,69,4,75,253,57,201,114,210,100,218,73,107,223,184,118,34,105,117,53,107,31,221,238,53,44,102,204,188,22,87,241,214,74,98,174,231,113,241,
154,113,204,180,66,225,179,90,218,178,29,250,167,0,96,61,43,128,63,198,20,1,231,240,184,125,20,134,31,126,74,147,183,155,176,39,1,80,49,177,146,95,112,231,189,189,3,204,224,73,122,137,44,177,33,124,166,185,118,197,183,172,207,74,114,133,36,39,133,19,194,201,192,196,48,46,77,92,38,136,81,47,165,246,241,160,237,82,44,28,115,173,207,137,109,218,28,7,242,21,10,173,99,167,37,159,180,81,65,112,172,181,142,179,245,40,4,180,177,38,2,41,4,163,216,113,65,35,109,72,129,48,239,179,216,189,8,128,128,72,126,137,239,62,159,193,119,208,24,28,136,10,121,231,149,30,146,127,103,68,87,251,20,1,72,79,156,73,63,147,221,118,28,252,156,104,164,157,136,105,157,12,105,237,123,90,221,199,218,135,51,156,115,56,48,15,44,3,182,166,177,92,51,6,105,77,103,254,60,126,138,133,164,118,156,181,138,130,98,225,181,247,83,4,108,135,118,157,179,46,94,35,235,9,249,157,227,228,19,230,235,135,220,59,255,221,131,0,0,132,196,7,188,28,116,0,6,112,6,1,162,66,124,86,107,136,159,171,251,76,122,137,191,70,122,21,223,65,118,50,
228,100,161,237,28,96,6,153,152,147,144,180,3,111,191,243,218,180,147,162,246,209,187,187,4,139,196,143,180,243,195,124,172,227,97,158,215,90,199,204,241,195,58,182,216,28,115,197,65,43,233,211,122,15,155,245,216,158,253,160,175,206,237,145,124,66,248,93,144,159,78,209,217,207,213,25,193,209,2,152,32,58,48,16,212,21,31,226,179,122,67,124,87,248,239,142,180,228,215,74,122,68,130,242,60,135,120,204,164,103,0,29,124,39,133,147,196,126,204,19,204,9,136,53,82,198,180,150,119,34,237,187,213,190,14,11,177,20,223,180,98,77,158,99,129,53,146,207,120,114,157,150,180,227,157,68,54,205,220,72,178,155,206,197,194,188,156,63,217,174,253,28,85,29,121,70,127,231,176,148,55,151,217,228,154,206,126,142,198,109,19,235,192,57,32,12,0,192,74,126,137,15,177,37,62,100,55,186,218,35,12,186,248,60,227,193,93,174,242,18,158,54,28,124,218,205,104,127,28,60,44,253,180,175,166,181,121,223,188,218,71,204,238,141,69,142,135,105,172,81,130,106,25,123,210,57,7,156,27,204,19,231,76,10,130,121,204,83,210,138,134,
207,89,119,182,15,14,167,194,185,251,167,158,189,250,30,29,189,119,195,182,135,5,32,193,7,60,192,68,97,115,213,103,37,151,248,172,248,174,250,8,128,219,128,36,190,171,61,196,87,161,29,36,7,200,65,207,129,154,7,203,254,97,27,247,139,193,24,158,147,227,227,184,230,120,154,135,53,58,23,114,62,50,95,152,43,88,73,46,249,181,138,132,247,125,134,231,172,219,246,232,195,169,112,238,254,169,103,175,186,199,203,222,179,81,219,2,16,129,6,40,192,115,213,119,175,63,187,251,223,27,101,116,243,37,191,196,119,181,71,56,36,190,164,167,110,9,175,165,109,7,135,62,229,0,113,109,28,201,99,218,188,217,82,166,225,243,33,48,143,199,124,77,207,230,60,174,29,243,180,206,9,172,243,83,235,226,161,149,240,90,230,91,10,133,207,97,151,218,31,217,135,192,61,195,221,63,21,218,57,59,176,149,77,0,4,89,128,0,208,67,22,200,15,241,33,182,123,253,121,213,199,27,224,62,158,65,238,239,169,35,85,153,193,160,141,140,14,118,78,0,7,32,251,152,233,81,69,195,27,70,32,199,50,211,188,210,210,181,243,51,109,206,33,210,138,128,
150,57,44,249,205,195,206,11,14,237,25,72,67,248,181,144,101,215,202,188,58,159,151,220,58,248,34,88,34,109,2,140,128,65,92,86,109,200,44,241,33,253,207,142,248,253,136,92,147,239,158,63,15,248,220,231,227,69,56,24,180,225,0,56,152,246,97,238,147,215,227,145,134,15,130,192,169,185,224,124,129,236,206,35,231,43,115,204,57,203,130,229,25,85,46,88,107,115,215,115,42,158,113,206,230,124,165,93,251,53,146,135,52,118,179,192,11,110,57,249,173,27,203,203,9,40,96,178,90,3,36,110,59,128,248,105,15,247,222,85,31,171,219,15,120,146,126,118,245,83,109,29,60,237,12,168,215,246,109,84,219,240,193,17,200,57,225,188,152,243,188,118,94,49,151,141,41,18,204,69,231,163,249,185,16,89,143,237,156,131,254,210,114,231,234,89,188,207,203,108,21,236,56,54,65,75,242,171,160,172,252,172,236,174,252,40,40,123,126,162,171,190,159,245,120,70,245,116,223,37,208,12,136,109,217,254,200,122,162,170,92,55,20,129,83,8,48,119,230,249,227,188,114,17,99,206,229,92,102,78,186,133,245,224,154,185,235,60,102,78,167,23,
203,156,103,225,227,25,183,175,212,183,52,135,179,47,163,200,237,2,141,109,85,185,32,10,28,128,225,238,228,97,31,0,72,126,86,122,87,127,211,172,250,185,215,7,40,221,124,73,79,253,190,135,109,142,172,35,233,183,122,63,218,104,120,223,8,56,159,156,67,94,243,214,204,59,174,181,204,65,163,115,51,45,247,228,130,207,88,239,184,245,44,156,58,31,120,86,248,218,12,58,178,69,16,40,1,226,229,85,203,84,74,8,46,233,81,74,87,126,87,253,89,37,37,63,117,1,174,128,218,222,200,58,18,159,116,67,17,184,21,2,75,115,204,249,199,92,100,78,186,192,177,80,45,121,183,243,28,103,238,187,181,213,179,213,171,85,48,108,23,123,243,176,133,0,216,81,44,245,95,66,126,221,35,0,18,20,86,126,62,239,177,223,119,229,151,248,212,57,3,227,245,184,213,80,4,54,67,32,231,153,105,44,115,82,33,240,160,144,185,203,28,102,46,187,216,41,2,110,7,156,239,156,111,157,18,129,113,251,48,231,177,55,11,183,22,0,128,32,204,202,56,31,248,233,246,231,30,41,87,253,4,99,105,213,167,29,218,200,1,160,221,134,34,112,47,4,114,238,57,23,177,
138,128,222,64,122,188,231,230,61,91,98,23,60,61,129,244,116,121,55,57,70,250,213,129,14,223,42,216,49,44,245,170,136,2,193,139,229,158,31,194,43,0,168,160,223,247,147,252,128,192,243,130,144,160,155,30,183,27,138,192,103,67,192,121,152,86,33,96,238,50,135,151,68,128,57,143,55,32,15,156,255,138,128,11,31,115,31,46,81,39,109,16,180,15,87,175,248,123,75,1,176,99,73,126,92,118,94,100,201,21,2,0,87,125,94,126,62,236,3,60,201,47,0,130,112,51,0,70,27,13,69,224,22,8,40,0,204,209,228,128,243,56,207,5,152,235,204,121,34,28,128,11,68,15,189,221,250,194,157,220,246,58,255,71,246,109,2,21,222,34,228,203,67,86,162,228,159,213,143,151,228,197,125,97,15,65,242,165,93,249,37,190,245,107,199,227,13,69,96,119,8,56,63,181,10,129,158,64,46,134,120,186,204,125,34,92,128,19,164,217,38,164,23,172,8,200,43,69,128,54,94,29,110,33,0,190,44,214,23,150,252,170,30,47,196,139,249,178,75,228,71,40,120,89,87,125,234,202,151,189,201,11,143,58,27,138,192,214,8,204,156,96,30,227,202,51,183,153,227,204,117,22,188,
89,4,228,69,138,64,30,128,47,45,136,163,154,235,3,29,123,77,144,148,73,126,94,148,21,156,23,245,83,136,167,160,186,61,42,29,251,29,202,248,146,146,255,230,47,58,218,104,40,2,247,68,96,22,1,230,116,138,128,139,163,231,98,112,34,249,145,91,98,184,4,167,110,126,30,240,90,1,24,125,58,158,196,207,47,232,161,159,228,247,5,177,249,114,185,242,83,7,49,193,27,151,13,69,224,205,34,144,115,217,249,157,158,192,210,34,9,71,146,39,112,41,189,227,228,200,171,128,121,141,0,248,98,212,225,139,233,250,235,226,168,110,107,202,70,57,148,141,231,172,131,250,136,214,143,109,40,2,111,17,129,156,195,206,107,231,57,115,158,185,15,7,150,68,0,206,176,21,128,67,108,23,92,40,103,174,216,198,40,242,242,64,167,174,9,146,18,75,29,188,148,47,132,107,227,234,239,190,95,69,115,111,227,11,1,64,186,253,249,50,182,49,138,52,20,129,55,141,128,115,217,249,13,95,220,14,40,2,158,9,44,113,6,17,128,83,112,43,23,76,23,202,145,125,221,167,193,107,5,128,6,121,214,168,0,224,166,208,209,249,101,120,169,153,252,148,69,52,0,194,
23,73,160,70,118,67,17,120,55,8,228,220,38,205,156,103,238,195,1,184,160,215,236,129,185,66,144,188,113,43,160,23,32,255,176,87,133,107,30,84,197,124,137,36,191,171,63,47,193,62,95,226,231,75,164,43,195,139,248,18,89,239,85,47,211,135,138,192,206,17,200,57,238,188,135,3,167,68,0,238,192,37,56,165,23,224,226,9,247,168,39,235,29,151,151,135,107,4,128,218,109,144,231,117,101,150,86,255,236,188,110,63,229,112,251,83,197,172,111,100,55,20,129,119,143,128,243,29,254,184,128,230,193,160,30,116,46,162,8,0,249,122,1,110,157,83,0,94,12,220,75,5,192,142,99,37,127,170,23,135,25,116,84,15,64,229,178,227,107,123,152,172,247,197,47,209,7,138,192,27,66,32,231,186,60,82,4,216,223,235,69,167,8,200,35,120,5,199,210,139,158,183,208,212,121,113,120,137,0,204,29,167,211,52,62,119,218,147,127,59,157,7,24,174,252,175,234,244,197,111,215,130,69,96,191,8,36,159,114,49,133,35,138,0,220,113,49,197,155,230,122,94,76,225,18,92,204,250,46,22,129,151,8,192,104,227,16,168,156,231,150,84,139,14,74,124,58,110,
103,81,44,132,130,151,227,57,158,207,14,143,203,134,34,240,225,16,72,14,200,41,56,2,87,224,76,30,168,43,4,185,160,82,110,222,74,143,172,203,195,165,2,144,29,37,237,234,79,103,243,4,83,197,194,18,117,87,36,255,172,86,163,72,67,17,248,240,8,200,175,228,149,34,224,111,4,146,91,44,172,110,3,224,224,204,43,235,59,11,236,165,2,96,69,84,172,82,161,60,116,82,119,133,78,73,124,247,42,243,129,69,87,255,1,82,67,17,8,4,36,107,114,11,66,187,184,194,33,207,214,228,151,158,245,218,153,90,84,127,58,121,137,0,208,49,130,29,93,82,41,58,148,2,64,135,37,191,171,191,228,207,186,72,55,20,129,143,142,128,220,2,7,23,88,183,2,126,93,75,79,64,190,229,214,122,246,2,168,75,238,146,94,12,151,8,0,15,218,65,59,151,10,229,94,69,117,146,252,168,19,157,119,143,130,0,88,207,72,54,20,129,34,48,33,32,63,224,10,209,47,108,122,217,41,2,44,176,75,219,0,56,106,61,35,121,58,156,19,0,42,34,88,161,2,160,58,73,126,58,150,49,59,166,0,88,135,246,80,113,255,20,129,34,112,64,64,94,104,21,0,183,2,112,42,57,70,90,17,152,189,108,
235,160,98,210,171,225,156,0,240,160,21,96,233,20,171,255,172,76,184,36,217,33,86,126,58,37,249,105,135,104,93,35,217,80,4,138,192,2,2,112,68,190,40,2,112,201,195,118,207,4,224,28,233,244,180,115,27,48,110,157,231,219,37,2,96,69,118,74,247,159,78,233,1,216,41,59,36,249,41,235,115,212,67,168,8,60,224,208,191,69,96,70,32,185,33,111,92,112,225,84,110,5,224,26,17,14,114,15,79,33,249,150,117,141,91,203,225,148,0,88,1,150,72,89,21,137,198,232,140,29,202,206,184,250,211,25,202,243,156,117,140,100,67,17,40,2,103,16,144,47,114,14,46,65,242,244,2,228,156,60,132,147,233,113,91,7,77,145,94,12,167,4,128,7,124,48,59,162,251,63,119,134,142,144,103,71,84,35,235,200,250,72,55,20,129,34,240,28,129,153,47,112,15,46,193,59,184,5,199,114,225,245,188,141,124,202,228,194,59,46,143,28,38,253,44,156,19,0,30,160,67,196,236,136,238,8,141,27,233,84,186,34,93,253,7,32,13,69,224,74,4,146,119,112,9,98,35,0,167,184,167,0,192,85,159,31,201,245,112,169,0,80,78,247,159,14,204,157,112,245,39,159,78,44,145,159,14,
53,20,129,34,112,30,1,185,34,137,103,254,233,5,204,139,239,18,255,78,182,118,74,0,178,113,59,160,10,217,1,136,159,228,71,161,116,65,124,222,151,57,217,145,222,44,2,69,224,25,2,201,161,217,11,88,226,96,242,15,206,18,173,227,89,229,100,172,9,128,164,245,97,202,65,108,86,119,84,38,27,39,77,36,159,50,10,128,141,143,172,134,34,80,4,174,68,0,14,194,37,5,0,126,201,193,153,135,122,0,148,145,127,201,229,145,253,52,80,232,84,152,27,71,97,136,146,94,15,32,27,166,163,10,135,117,219,9,175,107,139,64,17,56,141,64,114,70,62,41,2,46,196,242,79,62,202,207,139,23,225,83,2,96,163,216,185,225,75,149,39,95,226,244,235,246,110,17,40,2,75,8,36,15,225,43,228,86,0,78,241,48,23,226,85,30,174,9,128,141,114,159,138,20,0,20,134,213,94,23,196,52,249,121,248,199,115,54,170,29,89,13,69,160,8,188,0,1,185,131,133,83,242,17,174,157,226,162,30,0,188,149,139,214,53,178,30,3,55,231,48,23,228,122,22,0,148,71,17,144,252,54,106,131,115,189,189,46,2,69,224,122,4,20,1,185,168,8,36,23,225,36,124,148,139,75,92,126,210,131,
37,1,160,0,15,218,32,101,116,59,108,84,242,207,13,74,254,185,97,234,108,40,2,69,224,122,4,146,147,138,128,94,128,34,224,98,12,79,225,44,124,60,201,73,110,174,5,27,164,177,185,65,136,47,249,109,140,50,54,70,157,21,1,80,104,40,2,175,71,64,46,97,225,152,124,204,5,57,57,169,7,64,57,121,188,216,139,89,0,178,176,105,27,164,49,27,68,105,84,27,27,163,28,209,231,70,178,34,0,8,13,69,224,21,8,192,39,130,188,146,103,179,8,36,39,225,105,46,200,115,29,135,10,249,67,101,75,33,27,179,33,183,1,52,116,106,245,183,177,165,122,155,87,4,138,192,245,8,44,241,210,69,121,230,100,46,204,62,247,172,229,53,1,176,224,172,54,170,76,174,254,54,148,141,84,4,68,176,182,8,220,6,1,57,37,207,150,22,102,249,41,39,229,239,106,15,150,4,192,6,124,216,134,220,2,164,157,27,242,89,26,180,195,171,141,247,70,17,40,2,23,33,32,151,228,215,107,185,121,108,116,73,0,184,105,67,88,202,172,137,64,10,128,207,240,124,67,17,40,2,219,32,32,207,94,202,75,158,123,22,206,9,128,141,164,0,232,254,155,71,25,35,13,44,54,244,172,229,102,
20,129,34,240,82,4,228,150,124,195,186,8,123,22,128,53,15,142,82,70,209,24,201,167,129,155,6,11,217,8,214,134,36,59,21,103,36,255,108,35,54,80,91,4,138,192,171,17,144,167,112,83,254,37,39,77,203,75,5,128,134,125,86,142,31,8,190,212,35,11,158,106,196,198,109,224,88,233,82,133,205,43,2,69,224,102,8,220,140,159,144,119,45,100,35,170,138,7,128,94,243,188,209,122,42,4,34,81,91,4,110,139,64,114,75,222,97,229,227,18,63,229,241,98,79,120,120,14,62,96,3,174,244,52,98,58,173,157,242,57,234,51,111,174,187,215,69,160,8,92,135,128,156,154,121,150,92,52,157,92,149,199,249,220,177,7,179,0,204,141,248,112,86,172,218,144,199,125,43,246,217,99,229,77,20,129,34,176,9,2,201,57,56,8,23,229,229,57,242,63,225,233,44,0,246,214,6,172,60,27,80,12,184,103,124,82,169,149,212,22,129,34,176,25,2,112,78,254,157,227,169,124,126,214,25,30,156,131,100,246,161,172,92,33,80,4,44,147,207,204,245,245,186,8,20,129,219,33,144,92,147,127,242,49,87,127,242,224,174,101,232,129,207,146,62,132,37,1,224,134,15,113,127,22,
0,243,180,86,170,61,84,220,63,69,160,8,108,134,128,92,195,202,67,173,98,160,0,144,79,57,159,121,210,41,110,174,5,31,210,218,128,214,124,237,90,61,205,47,2,69,224,246,8,200,59,173,188,212,154,175,93,236,1,133,9,20,50,248,64,90,202,113,189,86,121,62,111,61,181,69,160,8,108,135,64,242,211,116,242,83,206,122,79,107,143,184,62,16,218,12,236,33,51,50,184,182,34,43,215,206,101,227,177,38,139,64,17,184,35,2,242,84,110,38,103,103,158,62,185,230,208,96,41,80,40,99,86,108,229,121,159,58,230,235,165,122,155,87,4,138,192,245,8,192,49,66,218,228,221,37,60,125,168,225,211,95,30,152,67,86,72,58,43,157,239,113,221,80,4,138,192,231,67,96,137,147,167,56,251,164,167,41,0,51,153,179,18,211,121,178,72,222,252,204,147,202,123,81,4,138,192,230,8,192,65,249,137,157,57,234,189,236,200,145,183,220,156,3,55,141,62,236,167,5,27,224,218,50,218,185,158,94,23,129,34,176,29,2,242,78,187,196,81,249,107,25,236,147,48,11,128,5,124,32,9,239,79,13,83,97,44,247,164,210,94,20,129,34,112,23,4,228,159,68,135,155,201,
83,185,106,57,58,69,250,24,102,1,224,134,133,173,52,69,192,10,201,179,156,246,88,105,19,69,160,8,108,142,128,188,211,202,87,56,106,52,47,249,250,164,99,220,48,88,81,90,238,91,89,90,43,166,172,33,211,230,213,22,129,34,112,123,4,146,107,164,229,99,114,212,52,247,40,51,199,67,175,184,185,20,44,108,197,107,214,114,216,134,34,80,4,238,135,64,114,111,141,159,230,91,246,89,239,40,48,7,11,107,173,36,173,247,176,13,69,160,8,124,62,4,146,139,201,81,211,121,255,25,95,41,180,22,230,7,231,107,159,123,86,169,55,106,139,64,17,216,20,129,228,222,204,207,249,122,177,35,107,2,48,63,124,234,122,177,226,102,22,129,34,112,23,4,78,113,115,190,247,172,67,8,0,133,50,204,215,220,203,138,178,108,211,69,160,8,236,11,129,83,92,157,185,253,229,53,15,96,233,149,124,216,6,150,202,52,175,8,20,129,207,131,64,242,82,174,158,237,201,57,1,184,184,162,179,45,181,64,17,40,2,159,3,129,147,28,62,39,0,115,135,79,86,54,23,238,117,17,40,2,119,71,224,69,28,125,169,0,220,253,109,218,96,17,40,2,219,33,80,1,216,14,219,214,
92,4,118,143,64,5,96,247,67,212,14,22,129,237,16,168,0,108,135,109,107,46,2,187,71,160,2,176,251,33,106,7,139,192,118,8,84,0,182,195,182,53,23,129,221,35,80,1,216,253,16,181,131,69,96,59,4,42,0,219,97,219,154,139,192,238,17,168,0,236,126,136,218,193,34,176,29,2,21,128,237,176,109,205,69,96,247,8,84,0,118,63,68,237,96,17,216,14,129,10,192,118,216,182,230,34,176,123,4,42,0,187,31,162,118,176,8,108,135,64,5,96,59,108,91,115,17,216,61,2,21,128,221,15,81,59,88,4,182,67,160,2,176,29,182,173,185,8,236,30,129,10,192,238,135,168,29,44,2,219,33,80,1,216,14,219,214,92,4,118,143,64,5,96,247,67,212,14,22,129,237,16,168,0,108,135,109,107,46,2,187,71,160,2,176,251,33,106,7,139,192,118,8,84,0,182,195,182,53,23,129,221,35,80,1,216,253,16,181,131,69,96,59,4,42,0,219,97,219,154,139,192,238,17,168,0,236,126,136,218,193,34,176,29,2,21,128,237,176,109,205,69,96,247,8,84,0,118,63,68,237,96,17,216,14,129,10,192,118,216,182,230,34,176,123,4,42,0,187,31,162,118,176,8,108,135,64,5,96,59,108,91,115,17,216,
61,2,21,128,221,15,81,59,88,4,182,67,160,2,176,29,182,173,185,8,236,30,129,10,192,238,135,168,29,44,2,219,33,80,1,216,14,219,214,92,4,118,143,64,5,96,247,67,212,14,22,129,237,16,168,0,108,135,109,107,46,2,187,71,160,2,176,251,33,106,7,139,192,118,8,84,0,182,195,182,53,23,129,221,35,80,1,216,253,16,181,131,69,96,59,4,42,0,219,97,219,154,139,192,238,17,168,0,236,126,136,218,193,34,176,29,2,21,128,237,176,109,205,69,96,247,8,84,0,118,63,68,237,96,17,216,14,129,10,192,118,216,182,230,34,176,123,4,42,0,187,31,162,118,176,8,108,135,64,5,96,59,108,91,115,17,216,61,2,21,128,221,15,81,59,88,4,182,67,160,2,176,29,182,173,185,8,236,30,129,10,192,238,135,168,29,44,2,219,33,80,1,216,14,219,214,92,4,118,143,64,5,96,247,67,212,14,22,129,237,16,168,0,108,135,109,107,46,2,187,71,160,2,176,251,33,106,7,139,192,118,8,84,0,182,195,182,53,23,129,221,35,80,1,216,253,16,181,131,69,96,59,4,42,0,219,97,219,154,139,192,238,17,168,0,236,126,136,218,193,34,176,29,2,21,128,237,176,109,205,69,96,247,8,84,
0,118,63,68,237,96,17,216,14,129,10,192,118,216,182,230,34,176,123,4,42,0,187,31,162,118,176,8,108,135,64,5,96,59,108,91,115,17,216,61,2,21,128,221,15,81,59,88,4,182,67,160,2,176,29,182,173,185,8,236,30,129,10,192,238,135,168,29,44,2,219,33,80,1,216,14,219,214,92,4,118,143,64,5,96,247,67,212,14,22,129,237,16,120,169,0,252,112,187,174,180,230,34,80,4,110,128,192,139,56,122,78,0,94,84,217,13,58,223,42,138,64,17,184,45,2,39,57,124,78,0,178,43,86,132,53,157,247,155,46,2,69,224,243,33,144,188,188,152,159,8,192,92,120,190,230,149,172,124,233,222,231,123,229,182,92,4,138,192,140,192,41,174,206,252,253,225,87,198,211,95,142,136,32,144,247,163,35,254,196,136,63,53,226,215,70,252,250,136,95,124,138,164,127,122,196,159,28,241,199,70,164,44,207,101,61,227,178,161,8,20,129,13,17,128,204,255,60,226,63,142,248,247,35,254,221,136,127,61,226,95,142,248,231,159,226,95,12,251,87,35,254,205,136,255,111,68,202,254,211,136,138,196,129,236,73,92,5,0,98,255,248,136,167,4,128,123,148,65,48,102,33,25,
89,13,69,160,8,108,136,0,36,134,204,196,127,24,241,111,71,60,37,0,136,196,69,2,128,8,176,170,43,0,95,29,233,244,0,240,8,200,75,15,160,2,48,0,105,40,2,119,68,96,246,0,16,0,86,123,86,253,53,15,0,161,192,107,56,235,1,40,0,144,124,73,0,220,2,32,18,110,1,114,27,48,178,27,138,64,17,216,16,1,136,204,234,207,170,142,123,127,74,0,184,231,22,96,85,0,70,153,195,62,62,61,0,4,0,178,123,14,128,39,144,30,0,2,192,118,161,30,192,0,161,161,8,220,9,1,87,112,200,204,170,174,0,176,255,199,3,248,179,79,17,79,0,175,32,5,0,209,224,185,67,152,137,11,249,21,0,136,189,36,0,136,0,94,129,103,0,245,0,6,24,13,69,224,142,8,232,254,187,255,71,0,56,232,131,236,144,94,1,240,16,16,1,240,12,64,15,96,100,61,95,185,57,16,68,20,136,172,238,249,37,32,189,0,207,0,184,143,0,80,190,91,128,1,66,67,17,184,3,2,122,0,10,0,95,0,16,0,60,0,201,143,16,32,0,28,12,114,31,1,160,60,145,231,15,97,246,0,16,0,136,156,2,192,22,32,207,1,220,2,144,95,1,24,32,52,20,129,59,35,176,228,1,248,5,192,45,0,2,128,32,164,0,112,94,176,234,1,240,14,
185,5,96,101,135,224,243,25,64,110,1,184,239,25,64,61,128,1,70,67,17,184,3,2,179,0,44,253,6,96,22,0,206,10,88,253,17,128,197,51,0,250,45,137,241,0,32,54,4,207,223,2,124,99,92,243,131,32,188,0,61,0,182,10,221,2,12,16,26,138,192,157,16,72,1,240,71,64,158,1,204,30,0,249,8,4,2,128,7,192,179,196,67,200,45,0,25,122,0,41,0,243,22,192,47,1,10,0,66,129,183,224,15,138,168,135,116,67,17,40,2,183,69,64,242,106,33,116,10,128,191,2,228,28,0,15,192,95,1,42,0,238,255,87,5,32,207,0,150,60,0,86,255,20,0,190,18,228,111,1,20,129,10,192,0,166,161,8,108,132,128,2,0,161,89,217,231,45,0,2,128,39,128,32,224,1,240,149,32,183,0,207,4,96,220,63,174,224,144,55,61,0,182,0,28,2,230,191,5,64,4,240,0,16,128,165,51,128,10,192,0,166,161,8,108,132,0,4,102,31,159,30,0,135,125,144,158,149,223,168,7,144,2,160,120,28,68,192,45,192,120,230,40,0,108,3,200,247,16,48,207,0,210,3,240,83,160,2,96,93,122,1,212,217,80,4,138,192,237,17,128,188,172,254,41,0,144,61,5,128,116,10,0,101,87,183,0,227,222,19,1,64,4,16,0,220,123,4,
128,213,222,223,1,44,29,2,82,214,243,131,10,192,0,163,161,8,108,136,128,39,249,144,218,95,1,42,0,249,59,128,20,0,182,0,60,167,7,112,232,158,171,54,23,18,23,171,7,128,0,204,191,6,68,8,252,10,128,56,120,6,96,93,214,51,110,53,20,129,34,112,99,4,36,112,122,0,126,1,208,245,207,67,192,249,103,192,62,127,232,150,164,229,66,226,98,245,0,60,8,204,47,1,30,2,230,22,0,15,192,186,172,135,58,27,138,64,17,184,45,2,18,216,3,64,127,6,156,95,0,60,4,196,3,88,250,25,48,117,28,130,164,229,2,226,18,116,229,33,53,2,128,7,224,57,128,219,0,44,2,48,123,0,60,91,1,24,32,52,20,129,141,16,128,188,184,242,41,0,121,0,232,234,207,25,0,249,179,0,240,236,49,204,2,32,121,33,50,247,244,0,32,58,132,103,245,159,61,0,127,13,40,249,177,4,5,229,225,170,127,139,64,17,120,13,2,174,218,238,255,177,236,235,33,56,68,127,137,7,48,138,63,132,75,5,0,47,0,1,112,255,239,25,128,63,6,194,91,240,32,80,17,169,0,60,96,220,191,69,224,86,8,232,254,99,151,190,0,176,250,255,233,136,110,1,252,21,160,255,16,8,209,80,72,70,242,113,223,78,
58,137,75,26,113,128,212,107,7,129,110,1,244,0,40,175,23,96,93,35,171,161,8,20,129,27,34,0,129,33,178,2,128,7,48,127,1,64,0,240,8,240,12,86,127,5,56,238,29,15,238,72,27,32,47,68,38,158,19,0,61,0,182,10,122,0,41,2,35,187,161,8,20,129,27,34,224,22,0,247,223,79,128,144,157,61,63,196,55,146,167,7,224,39,64,61,128,163,23,144,91,128,81,254,137,23,0,145,185,159,7,129,172,250,185,21,224,108,32,127,13,104,125,245,0,6,48,13,69,224,198,8,64,92,34,171,191,2,192,42,143,7,0,241,117,255,243,223,1,32,18,148,127,246,35,160,145,247,204,3,144,184,122,1,172,234,243,65,160,231,0,110,1,16,128,252,45,64,61,0,144,109,40,2,183,71,64,247,223,47,0,249,111,0,150,4,32,191,0,92,44,0,116,91,33,96,69,207,109,64,174,254,164,217,2,204,159,2,21,143,113,171,95,2,0,161,161,8,188,18,1,93,118,221,127,61,0,4,32,247,255,179,7,160,0,184,5,176,158,99,119,116,217,205,144,248,146,152,213,28,15,192,131,64,63,7,234,5,32,0,122,0,148,163,190,244,0,168,167,161,8,20,129,215,35,0,121,245,0,16,0,247,255,10,0,228,55,250,27,0,4,98,
245,11,192,184,183,186,5,224,30,68,38,186,13,128,232,10,128,158,128,30,128,95,2,122,16,56,64,106,40,2,27,33,160,7,224,254,159,67,62,191,255,255,201,72,235,1,228,23,128,20,128,103,221,154,61,0,11,232,9,164,0,224,5,32,0,144,94,1,192,146,135,0,112,127,246,0,70,86,183,1,128,208,80,4,174,68,64,183,221,213,63,247,255,10,128,251,127,4,128,3,64,60,0,238,225,37,32,22,185,255,183,190,145,253,220,3,32,79,242,159,219,6,64,254,89,0,240,0,20,129,172,139,116,67,17,40,2,215,33,32,105,241,0,112,255,89,213,253,5,32,100,135,248,122,0,126,1,224,62,91,128,213,47,0,227,222,179,45,0,121,238,219,21,2,8,61,111,3,240,2,244,4,240,0,60,7,72,1,240,121,235,27,197,26,138,64,17,184,18,1,61,128,20,128,37,247,31,65,32,223,3,64,202,251,253,255,89,211,151,108,1,40,67,244,115,96,158,5,40,4,75,2,144,135,129,207,26,110,70,17,40,2,47,66,0,18,235,254,227,218,235,254,123,240,135,7,192,86,32,15,0,117,255,21,0,61,137,81,236,33,172,9,0,119,115,5,87,0,252,26,32,241,217,2,144,86,0,16,137,249,32,112,100,29,189,10,210,13,69,
160,8,92,134,128,132,197,66,126,226,236,254,67,122,221,127,5,0,113,56,251,5,96,148,89,220,2,144,175,219,142,205,175,1,8,0,7,126,184,253,30,8,42,0,126,9,232,231,192,1,78,67,17,184,17,2,144,159,232,254,223,207,127,233,254,167,0,240,89,208,3,64,247,255,60,187,24,214,60,128,92,253,21,1,86,118,34,68,103,197,135,248,10,65,158,3,212,11,24,192,52,20,129,87,34,224,234,79,53,16,152,136,75,207,202,14,193,231,195,63,182,2,185,255,71,40,78,238,255,199,253,85,15,128,123,122,1,122,0,136,5,2,176,228,5,40,0,136,3,101,40,235,115,214,163,29,183,26,138,64,17,184,16,1,221,127,15,255,16,0,86,121,78,251,117,255,245,0,214,246,255,52,149,130,194,245,33,172,121,0,222,199,234,1,40,0,172,240,158,5,184,13,72,1,208,3,80,4,120,222,72,125,13,69,160,8,92,134,0,164,37,186,250,231,225,31,2,224,231,63,15,0,217,22,232,254,207,7,128,227,214,243,112,74,0,36,173,150,21,93,17,96,165,119,43,0,249,83,0,16,135,165,115,128,145,125,244,42,72,55,20,129,34,176,140,128,171,181,2,224,233,63,171,63,255,250,143,149,222,213,255,
143,71,26,33,64,16,46,254,252,55,202,30,194,37,2,64,65,221,121,172,219,128,244,2,20,128,252,26,176,228,1,32,38,13,69,160,8,156,71,64,242,179,250,235,254,179,186,235,254,187,250,43,0,167,220,255,213,214,206,9,0,15,74,90,172,2,224,97,160,94,0,196,87,4,200,211,3,80,4,120,46,235,25,151,13,69,160,8,44,32,224,234,207,45,200,239,167,191,116,255,89,253,33,62,17,247,159,213,31,1,64,32,240,18,116,255,21,145,145,181,28,78,9,0,79,36,105,21,0,158,65,0,32,121,110,5,16,1,175,185,167,8,232,61,140,172,67,125,214,201,117,67,17,40,2,207,17,144,184,144,127,109,245,87,0,240,4,16,4,60,131,181,95,255,165,168,140,98,143,225,18,1,144,176,10,0,132,230,57,73,174,23,32,249,177,121,14,96,27,245,2,30,113,111,170,8,44,33,144,68,117,245,103,53,103,245,247,191,252,171,235,207,202,175,251,207,222,63,255,251,127,126,254,27,217,167,131,228,92,43,149,228,39,173,8,240,156,34,0,217,61,15,208,11,80,0,242,147,160,207,107,215,218,108,126,17,248,200,8,32,2,144,223,189,63,228,103,101,207,189,63,196,255,163,17,117,255,61,
252,163,44,130,193,179,122,17,35,185,30,206,9,0,79,66,88,130,196,117,37,159,69,32,201,191,36,0,62,247,80,219,99,189,94,215,22,129,143,140,128,132,213,234,250,231,201,191,171,127,186,255,236,255,89,253,17,9,200,239,234,79,61,4,237,195,213,244,247,165,2,192,227,8,129,219,128,244,2,216,18,64,124,183,0,164,241,0,244,2,124,110,100,29,197,132,116,67,17,40,2,15,8,72,126,247,254,30,252,229,234,207,202,79,116,239,191,244,237,223,122,206,226,122,137,0,80,73,122,1,94,167,8,64,114,8,111,68,4,60,35,224,158,101,177,68,131,245,122,93,91,4,62,34,2,73,216,116,253,115,245,247,228,31,242,227,1,232,254,187,250,243,143,132,94,180,250,3,244,75,4,32,201,74,154,40,177,33,185,132,71,4,244,6,204,167,29,34,229,125,118,36,15,33,235,53,175,182,8,124,20,4,36,63,22,242,231,143,126,252,205,63,110,190,110,191,123,127,4,193,213,127,254,244,55,110,93,22,46,21,128,172,77,194,42,0,138,0,117,205,34,224,53,66,144,2,160,23,48,139,65,182,211,116,17,248,40,8,40,2,233,250,175,29,252,185,250,243,221,127,237,211,159,245,
157,197,239,37,2,48,147,213,235,20,0,234,131,236,122,1,10,128,249,150,197,250,60,157,36,221,80,4,62,26,2,18,213,213,31,23,158,125,63,43,58,228,102,133,103,175,239,234,255,135,35,173,235,239,234,239,201,63,226,65,61,47,10,47,17,128,172,88,194,106,33,180,228,118,181,151,252,92,27,105,47,201,239,243,212,157,105,174,27,138,192,123,70,96,137,252,126,243,199,245,135,224,184,249,16,30,183,95,242,35,8,185,250,207,39,255,214,59,138,157,15,175,21,0,90,128,184,68,69,0,43,225,103,171,0,88,214,103,199,35,199,80,33,56,66,209,196,59,68,192,85,90,162,230,190,127,62,245,135,252,172,254,30,252,145,246,31,253,32,18,243,234,111,157,227,214,101,225,26,1,144,160,73,94,210,174,236,88,234,37,206,2,192,181,34,144,207,44,213,57,138,54,20,129,119,137,128,68,77,242,231,127,234,11,146,235,250,67,126,15,254,92,253,231,223,252,83,143,194,242,34,192,174,17,0,27,144,180,94,99,115,101,79,17,80,12,204,83,36,20,1,158,205,250,50,205,189,134,34,240,30,16,144,248,88,72,75,196,133,39,114,232,199,39,61,220,123,201,159,
171,63,222,128,174,63,2,48,127,246,179,238,113,235,242,112,173,0,64,80,21,135,244,82,84,12,36,253,108,189,143,245,121,122,78,154,160,125,184,234,223,34,240,182,17,144,47,18,21,242,47,253,218,207,239,253,146,223,213,63,63,251,225,250,243,44,7,127,10,201,72,190,60,92,43,0,180,180,70,80,201,172,117,181,215,210,102,166,45,55,219,83,109,112,175,161,8,188,21,4,102,242,251,185,143,85,28,50,187,242,231,161,159,174,63,66,32,249,41,199,23,2,158,147,252,89,247,200,126,89,120,141,0,204,45,65,96,131,233,92,221,147,244,122,3,228,101,228,121,159,181,174,181,188,188,223,116,17,216,35,2,73,78,87,126,136,75,156,79,252,221,247,67,124,78,252,177,146,159,123,243,47,254,82,0,108,103,20,123,89,120,173,0,72,86,173,173,231,53,105,162,68,151,252,88,243,178,12,117,44,61,79,126,67,17,120,107,8,72,124,172,228,103,5,103,37,103,47,159,191,243,135,240,146,31,1,224,44,0,242,251,131,159,116,253,173,119,220,190,62,188,86,0,104,57,201,154,61,33,159,78,74,110,173,164,199,46,137,128,229,168,139,180,33,211,230,213,
22,129,189,34,32,65,177,238,211,217,183,179,242,67,126,127,233,199,193,94,126,238,67,0,16,2,242,32,63,191,7,160,44,207,240,108,174,252,227,242,120,22,71,250,197,33,201,246,226,135,227,1,235,145,212,124,238,227,215,128,252,103,194,190,54,226,23,35,126,107,196,239,140,248,221,17,191,247,41,126,123,88,242,191,49,34,229,248,127,13,248,175,9,169,67,177,176,254,138,192,0,165,97,247,8,172,145,223,61,127,174,252,146,255,15,198,91,17,245,0,200,247,212,31,1,224,217,60,248,179,141,145,125,125,144,88,215,215,240,248,164,117,65,90,191,255,35,2,144,26,114,67,242,20,1,132,128,72,30,17,145,72,17,240,151,132,122,9,214,63,138,61,241,12,184,110,40,2,123,64,0,82,18,36,39,43,191,251,253,220,243,227,210,67,110,72,78,132,244,198,63,250,148,167,235,159,159,252,16,0,234,180,254,145,124,93,184,197,22,192,30,156,90,157,5,198,178,88,203,207,214,123,75,249,75,207,103,94,211,69,224,115,33,32,41,181,51,249,113,225,57,200,195,165,135,220,146,31,194,27,201,99,223,143,56,32,18,60,179,180,242,143,236,219,4,72,
38,209,110,81,163,117,233,186,227,9,176,146,227,214,167,39,240,205,113,141,251,207,150,64,139,23,240,51,35,126,49,226,215,71,164,60,255,149,33,255,97,145,91,2,251,108,91,218,81,180,161,8,220,29,1,23,55,137,143,133,252,238,247,243,192,15,242,67,238,252,220,199,126,31,1,192,230,161,31,43,191,63,245,117,229,167,94,130,109,62,92,189,226,175,100,122,69,21,207,30,149,144,179,8,64,102,69,0,146,35,2,144,158,168,16,40,2,108,23,82,4,252,15,140,224,177,184,37,24,201,131,120,217,158,150,252,134,34,176,53,2,146,80,226,211,158,171,190,110,63,4,102,21,135,204,174,252,146,95,226,235,9,228,202,79,121,15,253,54,35,255,104,227,9,129,184,190,85,80,88,176,146,150,149,92,79,224,171,35,141,8,176,226,43,4,120,2,68,68,128,188,20,1,14,19,121,158,136,39,160,8,100,59,35,251,16,42,4,34,81,187,5,2,18,159,186,37,63,86,242,67,88,86,125,34,135,119,73,126,72,14,225,33,63,145,52,121,136,194,95,140,200,22,193,149,159,231,253,108,152,237,140,236,219,5,9,116,187,26,31,107,178,238,217,19,64,4,32,52,34,192,42,15,209,
21,1,200,191,36,2,148,229,25,158,77,17,64,8,104,135,54,8,73,254,76,63,220,237,223,34,112,61,2,51,241,169,9,210,147,47,81,37,63,43,63,228,207,61,127,146,63,87,253,63,31,229,240,14,40,203,51,75,110,191,2,48,110,223,54,72,210,219,214,250,80,155,4,196,42,2,16,214,51,1,182,4,16,251,107,35,34,2,120,3,179,0,164,39,64,89,182,16,138,0,66,160,119,97,253,217,230,184,125,12,230,31,51,154,40,2,23,32,144,164,167,184,215,88,200,239,170,143,0,184,234,67,96,86,241,153,252,179,0,176,234,67,126,14,251,40,139,203,47,249,169,207,250,179,205,145,125,219,0,49,182,36,135,117,99,37,169,34,0,129,231,115,129,220,18,184,21,32,15,129,96,203,160,8,240,28,66,48,127,42,164,13,223,73,59,178,142,193,254,28,51,154,40,2,11,8,72,58,111,113,157,81,114,66,84,62,239,249,137,207,253,62,132,198,165,135,224,16,93,242,207,46,63,228,119,191,143,128,228,15,125,104,195,126,104,71,214,109,195,18,73,110,219,194,163,192,216,22,36,245,119,2,16,24,50,231,15,134,32,58,43,127,70,69,128,45,3,30,3,66,192,115,68,132,132,122,242,108,
96,22,130,113,123,81,232,42,8,32,211,176,68,48,243,176,198,36,62,238,62,132,133,184,16,159,8,241,33,53,46,125,146,31,1,48,34,12,68,202,225,242,243,28,245,80,31,81,226,103,251,35,123,155,32,41,183,169,253,177,86,137,102,123,16,20,79,0,210,42,2,144,25,98,67,114,68,128,85,95,143,0,171,8,112,79,17,64,56,120,78,111,64,97,161,110,69,64,107,219,227,214,33,216,167,181,107,243,107,223,39,2,18,204,183,203,107,9,143,149,144,88,86,124,137,154,171,190,251,125,72,157,43,255,159,141,107,136,143,69,16,184,231,126,95,209,144,252,186,253,182,61,138,30,61,0,210,155,132,153,20,155,52,18,149,74,58,72,169,8,184,37,128,196,144,153,125,190,66,128,8,24,241,8,72,43,14,138,128,191,23,224,249,20,2,234,53,250,158,41,6,227,246,209,43,176,95,228,205,225,212,189,185,108,175,247,135,64,18,123,238,157,247,210,146,150,244,164,33,166,209,85,159,189,58,17,18,187,223,135,252,146,28,11,241,177,70,137,175,203,159,251,125,201,79,187,4,251,243,112,181,225,95,137,177,97,19,207,170,150,80,216,20,1,86,111,207,5,252,74,144,
66,0,241,211,11,208,19,64,8,16,1,189,1,234,200,109,193,188,53,72,17,200,247,207,126,141,42,14,193,60,175,151,236,37,101,150,158,107,222,109,16,184,132,44,89,198,116,90,210,70,72,104,132,152,185,226,123,208,7,241,89,245,33,51,196,119,229,207,213,223,180,196,103,123,160,203,79,61,212,171,176,40,56,35,235,126,228,167,177,36,0,215,247,10,146,6,11,33,21,2,183,4,122,3,10,1,36,119,107,0,241,51,234,9,32,22,179,55,128,16,184,45,80,8,220,30,216,174,24,104,199,35,71,207,224,84,154,123,4,223,229,225,170,127,239,141,128,68,206,118,51,111,41,45,217,181,18,30,43,41,37,62,22,194,46,173,250,238,249,33,251,28,33,62,194,144,196,119,213,151,252,182,107,31,181,227,177,251,132,156,244,247,105,241,177,21,137,99,31,20,1,183,4,121,54,224,182,64,143,0,49,80,16,16,0,35,247,17,13,189,129,220,22,80,95,30,22,166,16,208,7,218,79,59,247,111,220,62,4,243,215,174,207,229,123,191,246,101,8,172,145,99,206,207,107,210,94,155,118,181,77,59,19,159,125,185,49,137,207,10,158,251,253,92,253,33,188,17,210,19,117,247,61,
232,163,78,5,198,246,179,127,227,246,125,3,147,121,158,208,247,237,193,67,251,246,3,235,190,93,33,200,109,1,196,86,12,16,0,8,175,119,64,218,152,91,2,15,9,17,131,165,173,129,237,233,17,104,233,11,105,66,246,47,175,15,55,227,15,229,8,179,125,200,237,223,107,17,152,73,226,117,214,39,193,201,51,109,57,201,134,205,40,25,177,174,248,144,116,94,241,211,229,151,220,216,92,229,73,75,122,133,130,231,168,43,137,79,91,217,63,251,56,178,239,31,156,216,247,111,249,105,139,73,24,9,136,133,156,185,45,200,173,1,36,87,12,36,190,214,123,122,2,90,69,96,22,130,121,123,64,187,246,67,140,184,54,173,29,89,71,178,155,94,186,71,94,195,203,17,144,28,105,37,143,181,45,221,35,79,210,155,230,26,242,105,147,244,144,95,226,75,126,73,175,101,53,39,166,0,152,246,158,123,124,189,6,234,156,221,125,251,53,110,29,189,19,210,159,37,228,100,253,44,29,136,70,37,137,125,146,128,88,247,241,184,240,144,87,215,222,175,6,122,6,218,20,0,242,140,10,136,66,144,219,2,219,56,39,6,41,4,163,234,103,162,96,255,211,90,14,219,112,
25,2,107,196,38,127,142,212,104,158,4,195,74,118,237,76,122,137,47,249,33,46,132,199,186,138,107,37,57,150,188,180,62,195,115,174,248,122,20,246,3,107,31,71,242,243,147,159,78,56,73,73,239,37,208,39,66,18,141,180,174,58,4,85,8,20,3,221,124,136,78,90,194,107,205,179,156,150,231,245,6,20,3,189,142,180,122,4,90,113,75,107,127,211,154,30,205,60,241,20,184,110,56,141,0,100,33,96,37,145,233,180,164,51,74,118,173,164,79,11,225,141,16,54,87,125,69,192,213,92,1,208,234,17,88,78,210,39,241,105,139,152,164,39,77,160,175,187,9,78,224,221,116,232,83,71,20,1,251,167,157,133,0,49,144,192,146,89,114,187,218,115,109,52,15,171,23,160,85,0,176,179,55,48,123,5,18,91,75,255,236,27,54,163,125,199,18,180,15,87,253,59,35,32,65,102,82,67,32,227,18,185,40,159,247,147,240,174,198,185,226,231,170,175,0,36,169,33,122,70,238,121,95,209,176,14,235,95,34,190,239,49,30,223,23,249,233,144,147,147,244,30,131,100,177,159,90,201,198,138,236,74,173,103,32,145,37,118,90,210,121,173,104,40,34,60,75,90,1,224,218,250,
181,73,110,211,244,43,251,100,58,239,231,187,140,226,13,43,8,204,2,144,164,38,61,147,204,251,105,33,100,10,0,68,149,164,174,212,146,87,50,187,146,75,244,188,86,32,120,198,104,125,246,7,75,31,36,188,118,100,237,143,248,116,138,32,161,30,174,246,251,55,251,105,26,43,193,32,167,164,75,242,42,10,18,92,194,75,116,197,194,251,94,103,29,18,159,60,210,182,101,219,88,250,98,254,82,185,236,243,40,122,8,228,53,60,34,32,241,201,145,60,88,137,45,209,32,30,121,92,231,253,165,114,10,65,10,128,4,198,206,98,96,158,249,90,234,201,58,36,187,118,38,254,40,126,124,7,210,187,13,78,204,221,118,48,58,38,97,210,218,127,172,132,148,136,146,85,50,167,133,232,92,107,231,116,150,37,77,93,90,235,207,54,179,237,185,156,2,145,125,29,213,53,172,32,144,228,79,130,167,0,36,241,36,190,101,231,114,174,212,179,77,66,155,214,206,101,173,83,225,201,54,179,191,188,18,215,4,237,195,213,78,255,58,41,119,218,189,197,110,209,103,67,246,223,180,132,147,148,88,197,64,155,36,53,173,181,12,118,41,143,124,218,186,164,29,251,
96,223,176,13,231,17,72,82,73,54,73,168,53,31,75,121,173,247,211,66,232,188,38,109,158,54,243,178,236,90,59,18,220,190,142,42,15,193,124,175,119,111,115,114,190,165,180,228,74,130,67,88,34,43,59,110,61,135,127,124,9,224,247,1,252,96,136,127,76,196,191,39,248,214,136,223,29,241,103,71,252,23,35,254,171,17,255,237,136,63,24,241,151,70,252,149,17,127,109,196,95,31,241,63,140,248,27,35,254,167,17,255,243,136,191,61,226,239,140,248,95,70,252,175,35,254,183,17,255,251,136,191,59,226,255,24,241,127,142,248,191,70,252,223,35,254,159,17,127,111,196,255,59,226,239,55,190,8,3,48,3,59,48,4,75,48,5,91,48,254,221,17,193,28,236,25,3,198,130,49,97,108,24,35,198,138,49,99,236,24,67,198,146,49,101,108,25,99,198,154,49,103,236,153,3,204,5,230,4,115,131,57,194,92,97,206,48,119,152,67,110,17,157,95,46,18,63,50,238,25,223,18,119,178,175,199,115,128,204,124,75,105,7,64,235,224,184,130,43,6,28,254,49,160,68,5,129,95,19,50,224,223,28,241,219,35,126,103,196,239,141,248,253,17,153,28,255,114,196,127,61,
162,226,240,11,35,205,36,250,229,17,153,80,255,110,196,95,29,145,9,198,68,251,247,35,254,199,17,127,115,68,5,227,183,70,90,209,96,146,42,30,76,218,198,167,24,136,15,22,204,192,78,66,131,41,216,130,177,164,6,123,198,128,177,96,76,24,27,198,232,7,35,50,102,140,29,99,200,88,126,127,68,198,150,49,102,172,25,115,198,158,57,144,132,103,126,48,87,146,244,57,167,156,103,218,183,196,149,165,190,190,121,1,200,151,114,80,180,57,112,168,55,98,144,130,160,135,48,139,194,23,163,28,147,131,21,129,149,65,113,96,165,96,18,177,106,48,161,136,63,55,162,94,4,19,238,223,140,248,243,35,254,96,196,95,24,241,23,71,84,52,152,164,141,151,97,0,102,96,7,134,96,249,243,35,130,45,24,187,122,131,189,227,192,152,48,54,140,145,36,207,85,157,49,93,34,59,115,32,9,207,252,96,174,228,220,113,62,105,191,60,238,191,151,248,110,94,100,109,64,28,52,172,131,202,0,27,25,112,34,138,207,68,96,66,164,48,240,171,66,61,6,86,10,38,17,145,9,149,66,129,88,176,170,44,9,134,162,193,36,109,188,12,3,48,91,34,52,24,131,181,238,186,
227,224,184,48,70,174,232,140,29,226,78,116,92,151,200,238,92,112,126,228,156,89,155,87,239,37,255,221,11,192,60,80,57,184,14,56,214,73,128,85,20,20,6,196,65,129,96,2,165,80,204,98,177,38,24,41,26,78,218,218,71,33,77,44,36,51,118,38,244,18,169,25,3,199,69,130,59,102,57,150,57,198,57,246,57,39,230,249,242,222,175,63,156,0,228,128,230,192,103,58,39,199,44,14,57,137,114,114,153,118,226,229,132,108,250,41,65,175,193,67,92,197,57,109,142,73,166,231,113,204,49,206,116,206,137,143,150,254,208,2,176,54,216,57,57,46,77,207,147,45,39,98,211,79,61,172,107,240,152,241,189,116,92,178,220,218,120,127,216,124,95,124,120,80,13,47,68,0,236,26,246,131,192,15,247,211,149,183,211,147,10,192,125,199,170,162,113,25,222,37,243,101,56,189,186,212,255,23,0,0,0,255,255,3,0,72,80,6,221,74,55,233,90,0,0,0,0,73,69,78,68,174,66,96,130);


template_circle_16
:array[0..308] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,16,0,0,0,16,8,6,0,0,0,31,243,255,97,0,0,0,252,73,68,65,84,120,1,148,147,49,110,194,64,16,69,13,68,185,129,27,144,56,128,171,52,73,129,4,116,136,62,109,114,145,68,169,162,228,16,41,233,185,0,37,5,5,21,55,130,247,44,214,130,197,155,53,35,61,123,119,230,207,140,189,30,23,69,187,85,184,151,240,126,198,181,190,27,235,69,158,39,246,175,176,128,151,40,182,103,191,129,53,28,66,236,33,44,184,79,224,23,102,16,23,198,85,23,124,230,62,133,15,216,65,209,247,130,217,217,228,57,180,37,227,174,205,152,26,181,230,52,5,124,108,59,119,53,181,230,212,5,60,156,5,252,215,89,237,165,169,53,167,242,21,198,16,31,24,174,172,153,51,182,64,153,149,166,5,101,56,196,180,36,19,25,16,31,194,91,70,151,10,255,89,224,17,252,190,163,148,42,225,119,176,86,225,228,191,217,124,66,216,39,114,26,247,145,213,15,124,133,73,116,60,157,48,135,164,139,109,17,153,115,213,49,55,202,234,237,108,114,51,202,241,35,223,253,51,89,181,205,156,206,78,191,243,9,0,0,255,255,3,0,64,
168,31,110,200,197,151,40,0,0,0,0,73,69,78,68,174,66,96,130);


template_circle_24
:array[0..500] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,24,0,0,0,24,8,6,0,0,0,224,119,61,248,0,0,1,188,73,68,65,84,120,1,172,150,187,74,3,81,16,134,215,11,216,164,74,196,216,89,217,8,162,96,233,165,85,176,18,108,172,4,45,5,81,68,240,17,4,17,43,11,11,11,11,177,17,4,193,194,86,95,32,130,93,158,64,223,64,16,244,251,54,187,75,178,73,118,115,217,129,207,61,151,153,127,146,57,123,38,6,65,190,85,113,153,131,21,216,136,112,236,154,123,153,54,146,177,59,203,222,26,172,194,2,44,66,179,213,152,124,192,59,188,65,29,218,108,172,109,165,177,176,195,227,16,142,96,9,166,33,109,174,153,116,29,102,64,173,79,104,177,209,150,89,16,76,50,63,129,43,216,130,9,200,51,125,244,53,198,88,53,18,75,39,216,101,231,28,172,109,86,249,18,129,104,160,175,49,198,170,145,88,115,2,203,114,10,227,201,110,255,3,99,213,80,43,180,56,129,7,186,13,83,141,229,161,254,170,161,150,154,65,156,192,183,101,19,250,41,139,241,157,76,13,181,212,12,19,88,59,95,197,94,14,212,152,94,76,45,53,171,126,131,10,248,158,23,109,106,86,76,80,
134,244,37,42,34,153,154,101,19,148,138,80,235,162,81,138,15,185,203,254,240,203,94,111,175,252,222,240,82,29,21,110,76,96,137,150,161,83,191,233,24,213,227,98,13,191,123,19,88,166,121,40,250,160,95,209,124,142,47,214,62,147,107,40,234,46,252,160,117,0,183,113,2,175,181,141,202,174,24,175,49,28,200,254,136,122,130,51,168,55,139,217,160,108,185,185,191,82,248,100,217,23,155,199,240,160,83,115,2,231,246,115,191,201,160,29,245,151,88,63,249,37,132,150,22,186,139,214,109,185,118,197,244,7,136,182,219,30,150,229,27,46,32,214,8,157,186,9,88,46,91,174,93,49,239,224,61,208,23,120,132,176,44,60,19,235,150,64,135,66,126,244,147,76,25,3,15,125,224,127,91,254,1,0,0,255,255,3,0,38,76,52,192,154,231,193,8,0,0,0,0,73,69,78,68,174,66,96,130);


template_circle_32
:array[0..636] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,32,0,0,0,32,8,6,0,0,0,115,122,122,244,0,0,2,68,73,68,65,84,120,1,196,151,49,72,22,97,24,199,207,12,20,52,9,13,157,114,49,194,33,104,16,9,92,66,164,173,69,156,28,76,133,28,11,135,160,193,193,26,27,203,177,65,115,9,220,132,182,134,166,130,136,22,39,17,90,220,130,18,55,105,235,247,187,239,222,227,251,244,62,189,47,239,222,254,240,251,238,190,247,222,123,254,207,189,239,221,189,207,37,73,231,26,230,148,91,112,23,238,101,184,111,155,199,58,82,119,201,222,131,244,155,129,121,88,128,37,120,10,171,240,24,102,225,62,76,193,29,184,6,191,224,4,206,85,215,185,71,147,228,58,199,39,65,179,7,208,3,101,244,135,78,31,225,13,124,131,99,40,212,149,194,214,70,227,109,54,107,240,30,30,66,89,115,186,166,125,61,199,115,141,97,172,66,181,75,192,171,222,134,103,48,84,120,102,185,70,207,53,134,177,140,121,70,69,9,216,241,21,120,131,85,37,99,25,243,76,18,167,19,112,168,54,96,26,170,150,49,141,221,50,29,205,9,120,195,173,64,149,87,78,184,22,25,91,15,189,
82,53,39,224,240,44,103,237,117,110,244,200,167,34,36,224,115,238,163,118,153,27,174,108,210,122,232,165,103,18,18,240,5,226,115,30,75,122,233,153,39,48,193,126,39,207,185,231,94,70,122,233,153,38,224,251,123,220,63,145,165,231,176,83,48,0,163,145,205,181,211,115,192,4,250,96,12,98,75,207,62,19,232,133,145,216,238,153,103,111,120,10,254,131,127,195,178,155,205,13,112,61,239,111,52,69,251,253,137,211,150,9,88,60,88,76,220,132,152,218,195,108,199,4,174,66,168,100,98,38,240,25,179,221,174,204,113,157,237,139,108,63,214,70,191,151,142,128,114,26,230,192,209,136,33,75,182,215,112,16,70,192,133,225,29,88,70,197,208,7,76,22,225,40,36,160,169,11,132,53,156,171,85,157,250,77,112,171,107,139,214,124,49,114,223,234,117,211,157,154,165,135,94,169,154,71,192,6,203,165,109,168,171,42,250,74,236,71,112,0,169,78,39,96,99,40,74,167,27,93,42,251,253,68,164,231,144,95,189,145,139,18,176,221,36,54,160,170,145,240,202,159,64,139,57,255,219,38,224,49,167,99,5,150,225,95,111,76,111,56,231,252,45,228,
195,206,126,174,118,35,16,58,212,254,105,118,81,2,33,17,223,19,190,174,39,192,74,198,98,98,12,194,50,238,194,242,3,14,97,31,190,195,23,56,130,202,85,233,231,249,95,0,0,0,255,255,3,0,168,52,74,0,103,253,36,55,0,0,0,0,73,69,78,68,174,66,96,130);


template_circle_48
:array[0..1016] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,48,0,0,0,48,8,6,0,0,0,87,2,249,135,0,0,3,192,73,68,65,84,120,1,212,154,59,104,20,81,24,70,215,152,32,4,27,9,152,8,62,214,32,196,52,162,6,141,86,66,26,223,65,16,12,104,33,26,49,70,4,81,196,128,141,216,40,166,136,8,226,11,173,4,17,11,17,241,129,141,96,165,130,90,216,72,154,16,181,81,68,20,17,44,4,245,156,117,103,216,93,247,49,201,102,179,51,31,156,157,251,154,123,191,127,103,230,206,221,155,164,82,181,81,11,221,182,193,252,44,166,45,155,114,205,156,130,30,53,182,20,86,195,6,232,131,189,48,8,199,225,0,108,133,30,88,5,182,109,133,102,248,5,63,97,210,170,38,128,118,70,221,14,123,96,55,28,131,141,176,22,58,96,30,104,82,76,91,102,93,16,228,50,210,203,97,46,124,131,175,48,97,77,38,128,5,140,178,11,206,100,143,107,56,90,54,3,162,202,182,158,179,18,188,50,162,151,79,240,29,34,171,33,114,203,84,106,14,109,183,193,21,184,8,93,48,27,170,149,125,216,151,125,218,183,99,56,86,36,69,13,32,77,111,222,207,231,193,219,164,86,178,111,199,112,172,
52,84,84,148,0,188,87,47,192,16,44,172,216,99,245,13,28,195,177,28,211,177,203,170,82,0,221,156,61,12,155,97,34,247,120,217,65,35,84,58,150,99,58,182,30,74,170,92,0,70,127,10,214,151,60,187,246,21,142,173,135,146,87,162,84,0,105,78,58,13,245,52,207,240,25,233,65,47,233,76,174,224,163,88,0,206,0,3,176,169,160,109,61,179,122,209,211,127,179,83,177,0,214,209,112,39,120,31,198,69,122,209,147,222,242,84,24,128,47,151,253,48,29,179,77,158,145,8,25,61,233,77,143,161,10,3,216,66,77,45,231,249,112,224,73,38,244,166,199,80,185,1,180,83,218,31,214,196,55,161,71,189,102,148,27,64,15,37,29,217,242,56,31,244,168,215,140,130,0,92,18,187,40,155,138,181,205,191,158,107,247,169,71,189,234,57,21,4,224,3,210,105,65,66,164,215,204,68,19,4,224,147,109,84,73,81,176,132,15,175,192,98,156,7,193,36,33,8,189,234,57,52,189,40,9,174,11,60,102,60,27,137,15,195,146,130,202,36,100,245,220,98,0,77,224,238,65,210,164,231,38,3,104,132,188,215,115,66,34,209,115,163,1,36,90,238,4,52,131,251,54,110,125,36,73,163,
152,189,97,0,179,160,7,146,176,140,192,102,168,151,164,238,4,107,254,17,50,71,194,170,100,36,206,97,243,104,240,12,188,75,134,231,60,151,25,207,222,66,170,21,250,32,184,34,150,197,89,191,49,119,25,70,131,0,124,144,253,229,159,148,233,244,25,94,111,193,199,224,27,247,109,124,22,250,33,9,186,142,201,33,248,18,4,160,233,125,224,131,17,247,223,4,63,240,232,132,115,13,242,238,249,118,242,183,161,203,138,24,235,21,222,118,192,152,30,115,175,128,249,65,112,151,56,206,58,136,185,75,129,65,215,65,185,186,79,198,183,242,198,220,194,24,165,31,225,69,143,161,10,175,128,21,238,207,159,135,204,79,54,11,98,162,247,248,56,12,119,115,253,20,11,192,237,59,247,231,125,202,139,213,231,158,63,93,233,63,12,228,44,57,12,121,127,138,42,101,48,77,67,247,231,221,226,142,131,30,96,226,16,140,23,154,41,21,128,237,124,177,25,241,122,51,117,212,99,198,246,142,120,83,204,67,185,0,108,223,13,167,160,94,65,104,254,36,188,128,162,170,20,128,39,121,37,220,159,223,4,81,218,211,172,106,121,207,63,132,19,80,244,155,
15,70,136,106,40,205,9,3,224,22,119,173,103,39,103,155,155,112,5,198,161,172,162,6,96,39,206,78,235,192,45,238,90,189,39,156,231,175,194,83,200,155,109,200,23,213,68,2,8,58,112,197,186,5,92,248,117,64,181,107,39,215,54,254,60,116,129,230,75,234,3,68,214,100,2,8,58,119,237,212,3,110,243,117,102,143,13,28,163,200,245,252,115,120,155,61,62,225,56,6,117,145,75,241,21,208,11,190,41,71,224,30,188,134,207,89,76,91,102,157,109,122,193,115,60,55,150,210,88,27,212,252,223,109,254,2,0,0,255,255,3,0,51,122,116,168,253,93,9,194,0,0,0,0,73,69,78,68,174,66,96,130);


template_circle_64
:array[0..1185] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,64,0,0,0,64,8,6,0,0,0,170,105,113,222,0,0,4,105,73,68,65,84,120,1,236,155,207,107,212,64,28,197,87,43,253,3,68,171,23,41,43,88,44,30,180,82,236,213,30,20,60,8,82,122,83,16,42,84,170,183,90,69,17,20,5,241,103,61,42,136,10,133,30,69,16,15,30,61,136,7,69,168,30,188,40,40,197,139,149,226,31,80,4,125,159,176,19,146,221,205,110,178,153,108,103,178,126,225,145,108,50,249,206,123,47,51,249,49,153,173,84,122,60,250,186,164,127,88,245,236,23,14,10,147,194,113,225,148,112,86,152,18,142,9,135,132,49,161,42,108,21,250,133,85,161,208,216,80,80,246,109,202,187,87,24,23,142,8,123,132,77,66,150,248,163,194,159,133,87,194,107,225,147,176,34,88,13,219,6,140,136,221,81,129,179,58,104,149,105,165,178,172,124,79,133,151,194,146,173,220,182,12,24,21,33,68,211,172,105,186,69,198,154,146,63,17,48,227,67,222,138,54,230,76,80,213,241,55,133,183,194,140,80,180,120,85,17,212,65,93,212,73,221,112,232,56,178,246,203,104,69,19,250,1,129,161,232,198,46,174,
99,246,69,1,30,151,132,231,66,230,232,164,5,12,168,150,59,194,51,97,189,196,71,133,194,1,46,112,130,91,166,200,106,192,46,101,127,44,156,23,108,93,63,50,17,78,40,12,23,56,193,13,142,169,35,139,1,220,214,22,5,174,242,174,6,220,224,8,215,84,145,214,0,18,46,8,7,82,101,93,223,66,112,132,107,42,19,210,24,64,147,122,148,54,161,202,185,16,136,135,115,219,238,208,206,0,46,42,243,130,15,103,94,52,99,1,103,184,163,33,49,218,25,48,167,35,93,238,243,137,194,106,59,224,142,134,196,104,101,0,247,215,150,7,39,102,117,107,7,26,208,210,52,146,12,168,170,52,15,57,220,94,124,15,52,36,62,49,38,25,48,173,131,92,120,200,177,101,62,90,208,212,16,205,12,24,85,169,217,134,146,254,111,64,19,218,98,209,204,128,41,149,232,143,149,42,199,15,52,161,45,22,245,6,240,62,207,43,109,89,3,109,104,12,163,222,0,110,27,101,60,251,70,48,218,98,183,245,168,1,12,99,53,52,17,115,100,137,150,104,68,107,16,81,3,120,124,180,61,140,85,171,198,169,5,26,195,247,132,168,1,227,78,209,44,150,76,168,53,106,0,163,183,189,18,161,
86,99,192,176,148,51,116,221,43,129,86,52,87,140,1,59,180,158,103,124,144,92,62,5,90,209,28,51,192,39,1,54,184,198,12,216,105,35,163,103,57,2,205,166,11,108,247,140,188,13,186,129,102,99,192,22,27,25,61,203,17,104,54,6,108,246,140,188,13,186,129,102,99,128,141,132,94,230,48,6,252,246,146,125,62,210,129,102,99,64,225,19,17,242,113,45,228,232,64,179,49,224,103,33,85,184,157,52,208,108,12,248,230,54,215,66,216,5,154,141,1,63,10,169,194,237,164,129,230,190,26,71,70,74,78,11,198,16,183,169,231,103,199,252,163,219,194,106,116,220,255,163,54,132,3,5,249,235,112,58,3,19,174,246,193,48,122,198,153,141,213,43,17,106,141,26,192,84,180,94,137,80,107,180,11,48,80,248,78,40,251,184,224,178,52,142,9,43,66,195,183,191,43,218,118,141,29,37,142,171,210,118,221,232,171,31,5,98,18,226,101,161,172,223,6,152,99,136,198,48,162,93,192,108,124,160,149,25,243,163,100,203,135,210,115,38,170,169,190,5,176,143,25,152,124,66,42,91,43,224,236,163,45,22,205,90,0,5,248,158,206,36,196,50,197,45,137,97,66,101,
44,154,181,0,10,48,193,104,66,24,226,71,9,226,139,52,160,169,33,146,90,0,5,49,128,25,152,173,202,80,206,245,248,43,130,147,66,211,169,180,237,196,49,253,148,25,152,62,199,93,145,191,144,36,32,169,11,152,242,247,180,178,91,136,125,82,54,59,61,88,114,203,67,67,98,180,107,1,28,200,100,195,69,129,121,119,62,197,123,145,61,33,124,109,69,58,141,1,28,207,91,226,66,109,201,111,215,131,183,189,147,2,203,150,145,214,0,146,96,2,87,82,215,91,2,103,126,90,104,43,94,101,50,95,225,233,14,243,130,171,215,4,250,252,57,161,101,179,215,254,48,178,180,0,115,208,128,86,230,106,232,228,120,147,199,230,146,91,29,23,59,240,43,75,226,60,2,120,78,224,137,113,189,31,150,120,200,233,248,47,51,121,12,192,232,170,64,127,155,21,250,133,110,198,154,42,187,47,112,93,250,222,105,197,121,13,48,245,142,106,101,74,232,198,75,20,194,173,253,109,206,150,1,198,136,17,173,112,129,196,140,65,179,209,210,114,89,121,120,155,227,66,183,100,41,103,230,187,64,218,122,25,94,227,182,57,46,28,17,156,253,235,172,184,117,37,134,
85,203,97,129,46,114,67,160,9,191,16,222,212,192,58,219,216,71,25,202,114,204,255,40,218,129,127,0,0,0,255,255,3,0,172,219,137,139,237,125,203,85,0,0,0,0,73,69,78,68,174,66,96,130);


template_circle_256
:array[0..5694] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,1,0,0,0,1,0,8,6,0,0,0,92,114,168,102,0,0,22,6,73,68,65,84,120,1,236,157,91,200,46,85,25,199,183,134,160,37,72,230,249,128,228,57,149,4,67,60,219,135,164,89,90,110,189,201,72,47,218,137,208,225,98,235,85,40,120,33,232,69,144,238,11,245,66,202,2,133,188,41,119,208,65,244,162,93,237,204,144,2,193,202,51,132,121,200,74,240,148,93,69,255,255,254,246,188,223,124,243,206,204,59,231,89,179,230,183,224,249,222,57,172,89,107,61,191,181,158,231,93,167,121,191,45,91,8,16,128,0,4,32,48,11,2,7,75,203,42,50,11,24,40,185,101,203,135,128,48,121,2,54,232,143,74,14,147,28,43,57,97,239,231,25,250,60,71,242,201,189,242,25,125,94,33,185,168,130,156,174,56,78,39,121,246,24,29,39,233,59,175,3,37,7,72,246,147,124,32,33,76,148,192,62,19,45,247,220,138,109,35,223,95,114,136,196,198,119,144,196,215,108,148,71,75,108,176,151,75,134,12,143,42,179,63,75,94,149,188,41,121,75,242,182,228,61,201,191,36,255,149,248,26,33,96,2,56,128,48,43,231,40,21,203,198,110,
227,246,241,17,146,11,37,67,27,185,178,108,20,236,28,118,75,222,144,188,38,177,147,176,83,240,49,33,32,2,12,1,194,168,12,119,177,79,146,156,45,249,188,228,102,201,119,37,95,145,124,81,114,137,228,68,201,84,130,203,234,50,187,236,214,225,235,18,247,82,220,99,177,184,23,227,182,247,142,132,48,34,1,28,192,56,240,253,173,254,113,201,89,146,47,72,110,146,124,71,242,101,201,103,37,83,50,118,21,183,82,176,78,214,205,58,222,40,57,77,98,103,224,57,133,15,75,220,22,223,149,16,6,36,128,3,24,6,246,161,202,198,6,144,24,124,250,27,62,86,131,95,69,54,113,8,217,30,66,226,16,254,167,4,254,179,42,17,238,183,35,192,28,64,59,126,101,79,219,232,143,148,120,28,127,174,228,54,9,161,58,129,219,21,245,73,137,231,15,94,151,252,83,66,232,152,0,14,160,99,160,74,206,99,121,127,187,97,244,221,177,77,156,193,139,74,242,133,238,146,37,37,28,64,55,109,192,99,250,227,37,158,196,187,171,155,36,73,165,128,128,135,79,79,73,94,150,176,170,80,0,169,234,101,28,64,85,82,249,241,252,109,127,134,228,74,201,182,252,40,
92,237,137,192,3,74,247,103,146,103,36,244,10,26,66,198,1,212,7,231,177,189,119,220,157,41,113,35,36,140,79,192,206,247,105,201,43,18,230,10,106,212,7,14,160,58,44,27,254,41,146,75,37,76,232,85,231,54,100,76,207,21,60,46,121,78,130,35,168,64,30,7,176,26,146,55,233,120,124,191,85,226,245,122,66,248,4,238,86,17,119,74,60,79,240,247,240,139,59,94,9,113,0,197,236,189,73,197,221,252,107,37,140,239,139,57,133,124,199,67,180,135,37,30,30,188,25,114,65,199,42,219,190,99,101,28,112,190,54,252,139,37,223,150,60,38,193,248,5,97,162,193,117,231,58,116,93,186,78,93,183,132,20,1,28,192,6,12,143,241,253,194,141,27,203,175,37,116,247,5,33,146,224,186,116,157,186,110,93,199,174,107,130,8,48,4,88,111,6,159,208,199,101,146,29,235,167,252,141,156,192,118,233,231,158,193,95,35,215,115,165,122,115,119,0,94,199,247,143,102,60,184,146,20,17,98,36,112,189,148,250,131,100,182,251,8,230,58,4,240,88,208,203,121,247,75,48,126,65,152,105,112,221,187,13,184,45,204,114,126,96,142,61,0,119,247,175,150,220,33,
33,64,32,33,112,171,14,30,145,204,106,88,48,39,7,96,15,127,158,196,235,195,4,8,20,17,216,170,27,191,151,204,98,217,112,46,67,0,191,135,239,25,96,140,95,16,8,165,4,220,70,220,86,220,102,162,15,177,247,0,248,214,143,190,9,247,170,96,244,189,129,152,123,0,30,235,223,32,225,91,191,87,27,137,58,113,183,29,183,33,183,165,40,67,140,14,224,99,170,41,207,234,186,242,152,232,139,178,217,14,170,148,219,144,219,146,219,148,219,86,84,33,54,7,112,156,106,231,75,18,111,242,56,57,170,154,66,153,49,9,184,45,185,77,185,109,185,141,69,19,98,114,0,238,166,109,151,220,27,77,237,160,72,104,4,220,182,220,198,162,25,18,196,226,0,188,188,119,223,222,202,209,7,1,2,189,17,176,3,112,91,115,155,155,124,152,186,3,240,44,255,85,146,39,36,107,18,2,4,134,32,176,166,76,220,230,220,246,220,6,39,27,166,236,0,78,16,245,47,75,60,65,67,128,192,24,4,220,246,220,6,221,22,39,25,166,234,0,12,252,91,146,29,147,164,78,161,99,34,224,54,232,182,56,73,39,48,69,7,224,9,24,3,223,46,33,64,32,4,2,110,139,110,147,147,155,28,156,
154,3,96,178,47,132,230,78,25,242,8,216,9,76,110,114,112,74,91,129,109,252,158,120,33,64,32,116,2,231,171,128,126,161,40,248,48,21,7,112,129,72,238,14,158,38,5,132,192,6,1,255,244,216,239,54,78,195,60,10,125,8,144,108,235,197,248,195,108,63,148,170,152,128,219,108,240,219,135,67,118,0,54,254,139,36,222,130,73,128,192,20,9,184,237,186,13,7,251,14,65,168,14,32,49,126,255,66,11,1,2,83,38,224,54,28,172,19,8,213,1,248,199,24,48,254,41,55,123,202,158,38,224,182,28,228,15,140,132,232,0,60,225,71,183,63,221,124,56,142,129,128,219,180,219,118,80,33,52,7,224,165,62,38,252,130,106,34,20,166,67,2,110,219,110,227,193,132,144,28,0,235,252,193,52,11,10,210,35,1,239,101,9,198,9,132,226,0,188,133,242,206,30,161,147,52,4,66,34,224,182,30,196,182,225,16,28,128,95,162,184,81,178,38,33,64,96,14,4,214,164,164,219,252,232,47,16,141,237,0,146,183,250,120,177,103,14,205,30,29,211,4,146,23,136,70,117,2,99,58,0,255,144,194,149,18,140,63,221,44,56,158,19,1,183,125,219,192,104,63,42,50,166,3,240,68,200,142,
57,213,54,186,66,32,135,128,109,96,180,73,193,177,28,128,21,222,153,3,131,75,16,152,35,1,219,194,40,78,96,12,7,192,140,255,28,155,56,58,175,34,48,202,202,192,208,14,192,191,169,206,140,255,170,166,192,253,57,18,88,147,210,182,141,65,255,239,192,144,14,192,47,248,92,33,217,46,33,64,0,2,203,4,108,27,182,145,193,222,30,28,210,1,248,101,8,254,105,199,114,165,115,5,2,105,2,182,145,193,94,28,26,202,1,120,220,127,79,90,75,142,33,0,129,66,2,182,149,65,118,10,14,225,0,188,198,121,181,228,228,66,117,185,1,1,8,164,9,216,86,108,51,189,239,15,24,194,1,120,121,195,255,97,149,0,1,8,84,39,96,155,233,125,105,176,111,7,224,177,12,235,253,213,43,157,152,16,72,19,176,237,244,58,31,208,167,3,112,247,229,186,180,54,28,67,0,2,181,9,216,134,122,27,10,244,233,0,220,125,185,169,182,186,60,0,1,8,164,9,216,134,122,27,10,244,229,0,60,131,73,215,63,93,141,28,67,160,57,1,219,82,47,171,2,125,56,128,100,214,191,185,186,60,9,1,8,100,9,244,178,42,208,135,3,56,83,37,103,214,63,91,125,156,67,160,29,1,219,148,109,
171,211,208,181,3,56,73,165,187,165,211,18,146,24,4,32,144,16,176,109,217,198,58,11,93,59,128,115,84,178,181,206,74,71,66,16,128,64,154,192,154,78,108,99,157,133,46,29,128,39,41,30,236,172,100,36,4,1,8,228,17,176,141,117,54,33,216,149,3,56,84,133,186,44,175,180,92,131,0,4,58,39,96,91,179,205,181,14,93,57,128,83,84,146,29,173,75,67,2,16,128,64,21,2,182,53,219,92,235,208,133,3,240,178,223,53,173,75,66,2,16,128,64,29,2,182,185,214,59,4,187,112,0,167,170,32,236,248,171,83,117,196,133,64,123,2,182,57,219,94,171,208,214,1,216,3,109,109,85,2,30,134,0,4,154,18,176,237,181,234,5,180,117,0,222,152,192,183,127,211,234,227,57,8,180,35,96,219,107,181,57,168,141,3,56,70,153,95,219,174,252,60,13,1,8,180,36,96,27,180,45,54,10,109,28,192,241,202,113,91,163,92,121,8,2,16,232,138,128,109,208,182,216,40,236,219,232,169,245,53,72,198,254,13,225,241,24,4,58,38,96,91,108,180,47,160,169,3,240,26,36,99,255,142,107,145,228,32,208,144,128,109,177,209,190,128,38,14,192,158,230,210,134,5,229,49,8,64,160,
31,2,182,201,218,189,128,38,14,224,88,101,116,91,63,58,144,42,4,32,208,144,128,109,210,182,89,43,52,113,0,173,150,29,106,149,142,200,16,128,64,29,2,181,109,179,174,3,240,187,200,15,212,41,17,113,33,0,129,193,8,216,54,107,253,94,64,93,7,112,198,96,170,144,17,4,32,208,132,64,45,27,173,227,0,142,82,105,174,108,82,34,158,129,0,4,6,35,96,27,181,173,86,10,117,28,192,241,74,113,91,165,84,137,4,1,8,140,69,192,54,106,91,173,20,246,173,20,107,61,210,217,53,226,18,21,2,16,24,143,64,101,91,173,234,0,60,177,112,215,120,250,144,51,4,32,80,131,128,109,181,210,100,96,85,7,112,98,141,204,137,10,1,8,140,79,160,146,205,86,113,0,222,93,116,238,248,250,80,2,8,64,160,6,1,219,236,202,157,129,85,28,192,145,74,136,157,127,53,200,19,21,2,1,16,176,205,218,118,75,67,21,7,112,116,105,10,220,132,0,4,66,37,176,210,118,87,57,0,186,255,161,86,45,229,130,192,106,2,43,135,1,171,28,0,221,255,213,144,137,1,129,80,9,172,28,6,172,114,0,43,187,16,161,106,78,185,32,0,129,61,4,74,109,120,149,3,104,253,179,195,84,2,4,
32,48,42,129,82,27,46,115,0,222,79,204,191,251,26,181,238,200,28,2,173,9,216,134,11,223,13,40,115,0,135,232,193,203,91,103,79,2,16,128,192,152,4,108,195,182,229,220,80,230,0,74,199,14,185,169,113,17,2,16,8,145,64,161,45,151,57,128,210,177,67,136,90,82,38,8,64,32,151,64,161,45,23,57,0,255,163,1,198,255,185,44,185,8,129,201,17,176,45,231,254,243,144,34,7,112,184,30,96,252,63,185,122,166,192,16,200,37,96,91,182,77,47,133,34,7,80,56,102,88,74,129,11,16,128,192,20,8,228,218,116,145,3,56,97,10,26,81,70,8,64,160,50,129,92,155,206,115,0,172,255,87,102,74,68,8,76,134,64,238,126,128,60,7,192,250,255,100,234,148,130,66,160,50,1,207,3,44,237,7,200,115,0,185,99,133,202,217,16,17,2,16,8,149,192,146,109,231,57,128,194,109,131,161,106,69,185,32,0,129,74,4,150,108,59,235,0,14,86,50,71,84,74,138,72,16,128,192,212,8,216,182,109,227,139,144,117,0,251,235,206,133,139,187,28,64,0,2,49,17,176,109,219,198,23,33,235,0,152,0,92,160,225,0,2,209,17,88,154,8,204,58,128,3,163,83,25,133,32,0,129,52,129,77,
54,158,117,0,7,165,99,114,12,1,8,68,71,96,147,141,103,29,192,166,9,130,232,84,71,33,8,64,96,147,141,103,29,192,97,240,129,0,4,162,38,176,201,198,211,14,192,158,97,105,163,64,212,40,80,14,2,243,35,96,27,95,244,2,210,14,192,203,3,167,207,143,7,26,67,96,86,4,108,227,139,165,192,180,3,56,64,55,188,76,64,128,0,4,226,37,96,27,183,173,239,9,105,7,240,145,228,34,159,16,128,64,212,4,22,182,158,118,0,155,214,7,163,86,31,229,32,48,111,2,11,91,79,59,128,121,35,65,123,8,204,144,64,218,1,108,218,32,48,67,22,168,12,129,185,16,88,216,122,218,1,44,150,6,230,66,1,61,33,48,83,2,11,91,79,59,128,153,178,64,109,8,204,151,0,14,96,190,117,143,230,16,216,146,118,0,155,182,8,194,6,2,16,136,150,192,194,214,19,7,192,54,224,104,235,26,197,32,176,68,96,177,29,56,113,0,75,49,184,0,1,8,196,79,0,7,16,127,29,163,33,4,10,9,224,0,10,209,112,3,2,241,19,192,1,196,95,199,104,8,129,66,2,56,128,66,52,220,128,64,252,4,112,0,241,215,49,26,66,160,144,0,14,160,16,13,55,32,16,63,1,28,64,252,117,140,134,16,40,36,128,3,40,
68,195,13,8,196,79,96,159,148,138,55,233,248,174,212,57,135,16,128,64,156,4,110,150,90,119,91,181,116,15,224,205,56,117,69,43,8,64,32,67,96,97,235,105,7,144,137,195,41,4,32,16,59,1,28,64,236,53,140,126,16,40,33,144,118,0,111,149,196,227,22,4,32,16,15,129,133,173,167,29,192,219,241,232,135,38,16,128,64,9,129,133,173,167,29,64,73,124,110,65,0,2,49,18,72,59,128,247,98,84,16,157,32,0,129,37,2,11,91,79,59,128,247,151,162,113,1,2,16,136,145,192,194,214,63,148,210,206,255,47,204,255,56,240,196,212,53,14,33,0,129,184,8,60,42,117,126,44,121,215,106,165,29,192,126,58,63,85,114,190,111,16,32,0,129,40,9,252,84,90,253,74,242,129,181,75,111,5,246,57,219,129,77,129,0,129,120,9,44,182,1,91,197,244,28,128,207,23,91,4,125,66,128,0,4,162,35,176,201,198,179,14,96,177,65,32,58,181,81,8,2,16,48,129,77,54,158,117,0,139,13,2,176,130,0,4,162,36,176,201,198,179,14,96,177,62,24,165,234,40,5,1,8,108,178,241,244,42,128,209,248,156,165,64,26,9,4,226,36,224,37,192,135,37,123,150,0,173,98,214,1,120,41,240,112,
201,37,190,73,128,0,4,162,34,240,67,105,243,164,100,207,18,160,53,203,46,3,250,218,215,36,223,243,1,1,2,16,136,138,192,13,210,230,251,105,141,178,115,0,190,247,90,58,2,199,16,128,64,52,4,150,108,59,207,1,188,26,141,186,40,2,1,8,164,9,44,217,118,118,14,192,145,153,8,76,35,227,24,2,113,16,88,154,0,180,90,121,115,0,190,206,150,96,83,32,64,32,30,2,155,182,0,39,106,229,13,1,124,239,165,36,2,159,16,128,64,20,4,114,109,186,200,1,44,141,21,162,64,128,18,16,152,47,129,92,155,206,155,3,48,34,95,63,77,194,111,3,152,6,1,2,211,38,224,241,255,143,36,239,100,213,40,154,3,112,60,230,1,178,180,56,135,192,52,9,228,142,255,173,74,209,16,192,247,158,245,31,2,4,32,48,121,2,133,182,92,230,0,114,199,12,147,71,129,2,16,152,31,129,66,91,46,154,3,48,34,246,3,204,175,161,160,113,124,4,114,215,255,19,53,203,230,0,28,135,121,128,132,20,159,16,152,38,129,194,241,191,213,41,27,2,248,126,225,216,193,55,9,16,128,64,240,4,74,109,120,149,3,40,28,59,4,175,54,5,132,0,4,76,160,212,134,87,57,128,215,149,192,237,112,
132,0,4,38,73,192,182,107,27,46,12,171,230,0,252,224,231,36,191,40,76,129,27,16,128,64,168,4,62,175,130,253,178,172,112,171,122,0,126,182,180,11,81,150,56,247,32,0,129,81,9,172,180,221,42,14,128,97,192,168,117,72,230,16,104,68,96,101,247,223,169,86,25,2,56,30,195,0,83,32,64,96,58,4,86,118,255,173,74,149,30,128,227,189,232,63,4,8,64,96,50,4,42,217,108,213,30,128,181,102,83,208,100,234,158,130,206,156,64,233,230,159,52,155,170,61,0,63,243,84,250,65,142,33,0,129,96,9,84,182,213,58,14,224,101,169,251,64,176,42,83,48,8,64,192,4,108,163,182,213,74,161,206,16,192,9,94,45,249,73,165,148,137,4,1,8,140,65,224,26,101,250,72,213,140,235,244,0,156,230,51,85,19,38,30,4,32,48,10,129,90,54,90,183,7,96,141,190,42,97,40,48,74,221,146,41,4,74,9,108,211,221,31,148,198,200,220,172,219,3,240,227,79,103,210,224,20,2,16,8,131,64,109,219,108,226,0,94,145,174,183,135,161,47,165,128,0,4,246,18,176,77,218,54,107,133,38,67,0,103,112,161,228,183,181,114,34,50,4,32,208,39,129,139,148,248,238,186,25,52,233,
1,56,143,231,36,119,215,205,140,248,16,128,64,47,4,108,139,182,201,218,161,105,15,192,25,93,44,249,117,237,28,121,0,2,16,232,154,192,167,149,224,111,154,36,218,180,7,224,188,188,217,128,213,128,38,212,121,6,2,221,17,176,13,218,22,27,133,54,61,0,103,120,169,228,177,70,57,243,16,4,32,208,5,129,203,148,200,227,77,19,106,211,3,112,158,94,118,96,46,160,41,125,158,131,64,59,2,182,189,218,75,127,233,44,219,246,0,156,214,197,18,230,2,210,84,57,134,192,48,4,26,143,253,147,226,181,237,1,56,29,255,236,48,189,128,132,40,159,16,24,134,128,109,174,244,39,191,171,20,163,139,30,128,243,97,95,64,21,218,196,129,64,119,4,26,173,251,103,179,239,162,7,224,52,189,6,185,61,155,56,231,16,128,64,47,4,108,107,141,214,253,179,165,233,170,7,224,116,63,33,249,75,54,3,206,33,0,129,206,9,156,166,20,255,218,69,170,93,58,0,151,231,58,201,131,93,20,140,52,32,0,129,92,2,215,235,234,67,185,119,26,92,236,218,1,156,164,50,220,47,89,107,80,22,30,129,0,4,202,9,236,210,237,27,37,47,148,71,171,126,183,107,7,224,156,217,
28,84,157,63,49,33,80,135,64,171,77,63,121,25,117,53,9,152,78,219,27,19,110,77,95,224,24,2,16,104,77,192,54,213,106,211,79,94,9,250,232,1,56,31,38,4,243,104,115,13,2,205,9,116,54,241,151,46,66,95,14,192,121,92,37,217,153,206,140,99,8,64,160,17,129,173,122,234,167,141,158,92,241,80,31,67,128,36,203,223,235,128,29,130,9,13,62,33,208,140,128,109,200,182,212,75,232,179,7,224,2,159,37,249,99,47,37,39,81,8,204,131,192,167,164,230,159,250,82,181,111,7,224,114,51,20,232,171,246,72,55,118,2,189,117,253,19,112,125,14,1,146,60,220,125,97,85,32,161,193,39,4,170,17,176,205,244,214,245,79,138,48,68,15,192,121,121,85,192,19,130,39,251,132,0,1,8,148,18,120,94,119,253,237,223,201,118,223,178,156,134,114,0,46,3,27,132,202,106,130,123,16,216,32,208,249,134,159,141,164,55,31,13,49,4,72,114,244,68,198,55,147,19,62,33,0,129,92,2,182,145,222,38,253,178,57,14,217,3,112,222,199,73,182,239,21,159,19,32,0,129,13,2,59,116,104,249,219,198,165,126,143,134,118,0,214,198,243,1,247,73,214,36,4,8,64,96,157,192,
46,125,124,67,210,251,184,127,61,187,245,191,99,56,0,231,124,158,228,137,245,34,240,23,2,16,16,129,243,37,189,207,250,103,73,143,229,0,92,14,246,7,100,107,131,243,185,18,240,140,127,47,91,125,87,1,29,114,18,48,91,22,123,59,207,7,16,32,48,103,2,182,129,193,191,249,19,224,99,246,0,92,134,19,36,223,146,224,8,76,131,48,55,2,59,164,240,61,146,151,198,82,124,108,7,96,189,113,2,99,213,62,249,142,73,96,116,227,183,242,33,56,0,151,131,149,1,83,32,204,133,192,46,41,58,248,140,127,30,220,80,28,128,203,198,202,64,94,13,113,45,70,2,163,204,248,231,129,12,201,1,184,124,56,129,188,90,226,90,76,4,130,49,126,67,13,205,1,184,76,23,72,118,251,128,0,129,200,8,248,63,104,253,46,36,157,66,116,0,230,195,139,67,33,181,18,202,210,5,129,193,94,240,169,83,216,49,247,1,148,149,211,47,67,92,93,22,129,123,16,152,16,1,183,229,193,94,240,169,195,37,212,30,128,117,248,152,196,255,0,241,17,159,16,32,48,81,2,54,254,223,74,254,29,98,249,67,118,0,230,101,39,224,223,21,124,204,39,4,8,76,140,128,187,253,254,230,15,
210,248,205,50,116,7,224,50,58,48,49,184,206,129,191,211,33,16,220,132,95,30,186,80,231,0,178,101,245,204,169,151,79,8,16,152,2,1,183,213,160,102,251,139,160,77,165,7,144,148,223,251,4,238,148,172,37,23,248,132,64,64,4,118,169,44,183,72,70,123,185,167,46,139,169,57,0,235,231,109,195,55,74,120,129,200,52,8,161,16,240,222,254,251,37,131,254,160,71,91,229,167,232,0,172,51,47,16,181,173,121,158,239,146,64,16,47,246,52,81,104,170,14,192,186,218,9,92,41,49,124,2,4,198,34,224,158,232,207,36,163,189,210,219,70,241,41,59,0,235,125,152,196,243,2,59,125,66,128,192,192,4,182,42,63,143,247,223,28,56,223,206,178,155,186,3,72,64,48,57,152,144,224,115,8,2,187,148,201,164,38,251,138,160,196,226,0,172,31,147,131,69,181,204,245,46,9,120,200,57,185,201,190,34,0,49,57,0,235,232,255,59,112,133,228,94,159,16,32,208,49,1,255,211,142,159,75,254,214,113,186,163,37,23,155,3,48,200,100,251,176,127,107,237,228,209,200,146,113,76,4,158,151,50,254,237,202,160,183,245,54,1,30,163,3,72,56,120,72,224,23,49,238,
72,46,240,9,129,6,4,252,95,122,253,66,218,164,214,247,171,234,25,179,3,48,3,86,9,170,182,4,226,229,17,152,252,44,127,158,82,233,107,177,59,128,68,87,191,81,120,157,228,166,228,2,159,16,40,33,112,183,238,61,36,9,242,29,254,146,114,215,190,53,23,7,96,48,244,6,106,55,143,89,62,16,253,183,126,186,86,231,228,0,18,189,153,27,72,72,240,153,38,16,245,88,63,173,104,250,120,142,14,192,250,187,55,112,166,196,155,57,214,36,132,249,18,216,37,213,253,134,233,211,146,201,238,232,83,217,27,133,185,58,128,4,214,73,58,56,71,242,96,114,129,207,89,17,184,94,218,254,65,242,194,172,180,78,41,59,119,7,144,160,240,176,224,50,137,119,121,17,226,39,176,93,42,62,38,137,114,105,175,78,245,225,0,54,104,29,170,195,83,36,215,72,88,45,216,224,18,211,145,103,247,127,34,121,78,242,207,152,20,107,170,11,14,96,153,156,231,7,78,149,120,54,24,71,176,204,103,138,87,108,248,59,37,207,74,102,55,206,47,171,48,28,64,49,157,100,162,240,90,69,217,86,28,141,59,1,19,120,64,101,123,88,50,203,9,190,42,245,130,3,88,77,233,24,
69,57,94,66,143,96,53,171,80,98,36,223,248,47,171,64,127,15,165,80,33,150,3,7,80,189,86,146,57,130,75,245,200,109,213,31,35,230,128,4,110,87,94,143,75,24,227,87,132,142,3,168,8,42,21,205,142,224,88,137,247,17,184,139,73,24,159,128,135,104,238,230,191,34,97,114,175,70,125,224,0,106,192,202,137,234,125,4,103,72,252,219,132,204,19,228,0,234,241,146,157,175,127,139,239,25,201,108,215,241,219,242,197,1,180,37,184,254,252,81,250,240,60,193,217,146,187,214,47,241,183,39,2,55,43,221,167,36,30,223,191,214,83,30,179,73,22,7,208,125,85,187,87,112,162,228,92,9,115,5,221,240,245,216,254,73,201,139,18,190,237,187,97,186,39,21,28,64,135,48,51,73,121,174,224,72,201,209,18,156,65,6,78,133,211,196,232,95,85,220,215,37,140,237,43,64,171,27,5,7,80,151,88,179,248,105,103,224,77,70,222,118,124,121,179,164,162,125,234,81,105,230,237,185,207,74,48,250,129,170,25,7,48,16,232,76,54,158,51,56,68,226,222,193,92,29,66,214,224,255,37,22,140,233,5,97,200,128,3,24,146,118,113,94,222,108,116,184,196,14,193,255,
241,40,198,30,66,98,240,254,15,58,254,134,255,135,132,77,58,130,48,102,192,1,140,73,191,56,239,116,15,193,199,71,72,46,148,76,101,216,96,99,223,45,121,67,226,111,117,27,60,223,240,130,16,90,192,1,132,86,35,249,229,57,88,151,247,151,120,216,112,160,228,32,137,175,249,125,5,247,26,78,151,12,237,28,108,228,127,150,216,184,253,130,205,91,146,183,37,239,73,108,236,255,149,248,26,33,96,2,56,128,128,43,167,98,209,18,231,112,128,226,127,68,98,7,225,144,56,137,245,179,13,103,145,156,151,125,38,70,157,196,73,140,219,231,54,240,247,37,31,72,48,114,65,32,64,96,42,4,236,44,170,200,84,244,161,156,16,128,0,4,32,208,148,192,255,5,0,0,0,255,255,3,0,200,115,27,94,19,105,201,207,0,0,0,0,73,69,78,68,174,66,96,130);


template_circle2_256
:array[0..9519] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,1,0,0,0,1,0,8,6,0,0,0,92,114,168,102,0,0,32,0,73,68,65,84,120,218,237,93,107,151,218,200,146,76,61,232,166,31,246,120,230,206,236,255,255,127,119,60,15,219,253,6,105,63,172,106,157,29,157,153,85,18,2,4,68,158,83,7,26,183,5,13,68,100,100,84,86,85,37,140,37,69,117,164,255,59,37,250,35,253,95,198,66,190,112,140,195,191,255,213,158,174,215,207,12,224,158,132,64,2,96,236,246,126,87,133,143,87,5,255,111,234,231,220,23,60,214,23,130,185,39,33,144,0,248,30,151,255,94,101,220,47,125,44,186,63,149,0,114,247,75,31,27,11,114,146,1,9,224,34,64,95,21,220,122,143,229,126,103,236,235,138,192,220,27,247,115,191,19,221,146,12,72,0,23,243,126,150,2,222,2,117,13,255,102,141,218,33,130,136,20,100,36,216,69,68,58,0,191,53,186,17,100,49,150,16,72,4,36,128,147,121,31,171,17,128,175,28,192,215,106,84,112,107,61,230,93,19,9,193,2,150,5,88,11,216,250,214,123,172,115,8,161,31,65,8,61,137,128,4,112,106,239,95,78,190,123,128,215,128,110,212,109,173,110,163,
251,181,113,157,136,12,60,2,240,128,111,141,109,230,254,118,248,255,219,128,28,60,66,40,37,3,18,1,9,96,17,153,222,147,248,185,172,142,96,110,96,180,206,125,107,140,33,130,18,240,123,160,247,198,198,185,191,5,82,176,174,235,169,5,171,68,160,50,32,1,28,245,125,202,213,243,149,35,215,107,7,228,26,224,171,225,254,106,248,185,133,251,122,52,198,173,126,142,200,67,136,8,64,131,16,51,251,198,184,197,241,6,247,183,234,49,143,60,44,66,232,10,202,5,15,244,36,2,18,192,65,37,190,39,233,19,40,91,7,236,120,123,53,220,174,156,159,145,12,86,134,58,136,252,1,113,8,64,50,117,62,102,246,55,3,244,122,188,58,63,111,140,91,84,17,150,82,40,245,15,72,4,133,209,242,45,152,5,248,94,150,111,3,176,35,184,175,96,92,27,143,93,25,132,129,106,192,34,0,75,1,228,60,128,206,40,3,16,164,86,198,79,64,199,241,98,60,102,145,132,69,10,155,140,58,200,1,190,34,17,80,1,204,5,252,116,191,118,50,189,6,124,11,64,247,64,126,29,140,43,32,137,149,145,245,49,243,55,18,207,8,72,166,126,246,202,129,173,161,4,80,13,188,1,184,19,
248,189,225,145,195,43,144,194,38,40,23,210,107,148,192,55,160,34,32,1,76,174,243,35,224,91,128,111,13,160,167,177,134,251,107,227,113,61,176,4,104,29,83,176,14,192,31,153,148,146,49,217,60,18,232,28,211,111,99,72,126,11,248,207,234,246,217,120,252,197,32,134,141,67,8,83,136,128,36,64,2,40,6,126,21,100,123,148,244,22,216,111,134,251,55,234,254,26,8,32,253,190,86,6,43,7,248,173,248,83,128,57,199,191,196,3,136,212,128,53,51,144,64,184,113,136,224,13,50,61,2,94,143,167,97,164,251,22,41,96,201,176,45,240,11,72,4,36,128,73,192,215,25,223,147,247,215,70,86,191,17,145,91,184,213,35,17,195,21,200,125,148,250,185,250,30,239,139,148,117,255,85,25,32,68,93,129,94,19,80,228,19,96,105,160,51,124,2,250,19,140,71,184,125,14,200,192,82,5,37,83,138,23,77,4,45,129,111,130,164,14,128,175,107,250,107,200,240,26,240,119,195,173,30,107,5,254,181,81,227,151,128,190,36,211,151,182,254,230,162,207,144,65,137,50,240,200,0,61,130,103,69,2,207,3,232,245,120,0,66,208,10,225,197,240,12,210,243,86,240,218,
60,208,95,164,81,216,94,56,248,45,224,87,129,204,79,96,213,210,62,129,254,14,134,38,1,45,253,209,220,107,157,218,190,150,216,205,143,50,125,53,146,0,75,51,97,201,194,31,111,246,160,115,188,130,141,97,22,62,131,10,120,80,183,122,104,117,144,254,159,54,16,145,8,42,240,9,60,34,232,47,21,16,151,44,247,235,12,240,45,121,175,1,127,239,144,128,206,250,215,129,161,167,159,55,234,237,247,128,159,251,76,199,126,214,165,14,122,110,149,96,103,152,136,91,48,17,55,134,87,128,106,0,193,255,3,126,182,202,132,215,66,159,224,98,203,130,234,2,193,239,205,225,55,5,192,183,64,255,201,0,255,45,152,125,215,129,161,231,45,244,41,49,242,230,4,252,28,132,80,106,32,246,70,169,96,25,135,47,96,14,62,26,36,240,221,33,131,28,17,108,197,95,181,120,49,36,208,94,24,185,121,174,126,4,124,157,237,239,213,248,52,12,157,253,111,193,228,187,54,12,189,198,1,254,24,208,151,0,188,58,240,251,220,195,115,150,144,65,239,120,6,104,28,190,128,73,248,8,42,224,187,34,130,31,234,113,173,10,144,8,106,85,26,68,36,112,214,222,64,
117,33,224,71,201,92,2,252,91,3,248,159,212,184,87,4,160,77,190,8,248,37,70,222,49,179,252,49,213,65,151,81,5,232,17,104,115,240,187,82,3,72,6,15,234,119,75,74,3,171,164,57,91,53,80,157,57,248,189,105,189,200,220,75,96,182,64,255,25,100,255,173,202,250,215,32,245,75,100,190,72,249,206,61,167,246,89,245,133,132,224,173,65,136,202,3,173,8,18,184,117,57,240,205,33,3,77,4,175,1,17,228,86,34,146,0,78,56,235,235,102,26,148,250,169,134,215,160,255,197,200,252,119,6,240,117,198,111,70,0,127,138,188,63,198,103,219,239,225,26,30,33,116,153,242,192,42,13,30,193,23,72,227,95,248,89,207,32,104,69,160,155,152,46,70,13,180,103,8,254,92,214,215,243,248,30,240,63,15,3,193,159,126,79,155,123,22,240,155,140,196,159,178,79,95,181,48,130,157,66,24,22,209,245,112,95,79,215,213,80,34,108,141,114,237,213,248,28,239,97,252,171,72,251,251,240,251,72,4,73,13,84,134,26,176,254,174,179,152,46,108,207,8,248,98,100,124,13,254,22,128,191,86,82,95,103,251,207,234,246,179,250,18,221,41,131,15,155,119,162,37,184,
82,96,232,157,163,58,171,10,8,33,42,119,80,130,235,207,178,19,187,41,235,198,241,111,112,154,246,102,32,130,235,65,49,172,228,231,172,65,13,68,128,211,152,72,90,39,173,6,218,51,3,191,229,240,99,203,238,26,190,28,26,240,95,212,253,68,10,88,231,235,6,30,236,201,31,227,226,95,138,33,59,134,16,60,66,239,13,85,208,24,138,224,21,8,254,70,222,55,101,105,2,64,211,246,97,184,86,42,11,116,87,97,110,129,209,201,170,129,246,12,190,76,94,67,143,149,245,211,7,175,165,254,151,97,36,34,248,5,76,62,207,224,67,224,151,214,247,151,4,250,210,207,48,34,3,44,11,80,17,116,138,232,45,83,247,70,125,238,122,154,246,78,252,94,141,86,169,129,90,249,3,81,59,241,73,146,64,123,70,224,199,134,30,157,245,245,92,62,2,255,23,200,252,218,228,179,234,252,18,224,19,244,243,145,129,247,126,53,1,17,224,30,12,122,161,150,38,3,77,16,184,46,163,29,252,129,90,149,5,91,195,168,172,78,153,4,218,19,7,127,36,249,245,66,29,13,252,95,20,248,53,9,124,2,137,184,22,223,217,39,240,247,255,25,247,133,239,161,71,4,214,52,47,18,129,
181,60,251,90,149,120,233,51,127,25,174,255,54,60,103,84,18,156,20,9,180,39,8,124,15,252,141,83,235,223,43,131,47,1,254,87,5,124,45,249,111,140,47,65,187,3,240,9,250,195,169,130,198,48,11,173,229,219,87,242,113,243,21,220,151,1,215,107,224,148,46,18,129,85,14,156,132,57,216,158,56,248,107,0,255,85,144,245,127,85,195,146,252,94,214,199,185,124,2,127,57,170,32,71,4,209,114,110,107,173,7,170,0,239,187,80,169,146,0,125,129,147,50,7,219,19,252,18,120,115,251,137,189,173,172,31,129,95,27,125,216,193,167,73,134,192,63,61,34,240,86,122,230,246,106,180,54,97,141,72,32,82,3,84,0,51,129,94,140,15,179,53,140,62,61,181,247,219,0,250,223,20,17,124,118,36,191,199,244,21,129,127,178,68,80,203,251,6,35,239,208,21,84,4,184,43,179,181,65,75,5,190,64,37,239,59,8,43,195,36,36,1,204,4,126,253,193,225,244,158,206,250,191,169,241,197,145,252,81,51,15,129,127,250,68,128,29,134,150,105,220,58,134,161,246,1,162,178,176,146,255,155,42,20,165,6,78,130,4,218,19,5,255,10,192,175,37,127,2,254,127,212,125,221,
220,115,43,31,231,125,241,67,205,201,125,2,255,116,136,64,47,83,246,202,2,76,42,214,150,238,171,64,5,88,187,48,157,4,9,180,11,7,191,231,244,235,149,123,73,242,127,1,240,39,249,143,245,254,58,99,238,16,248,231,69,4,94,89,16,237,11,209,24,202,192,58,132,197,250,222,160,15,128,205,75,61,9,96,60,248,27,3,252,186,149,87,203,125,11,252,186,177,199,146,252,185,131,51,8,252,243,39,130,28,9,68,4,128,215,74,230,224,214,32,132,69,145,64,123,98,224,191,86,224,215,245,254,127,20,248,255,35,239,157,254,84,239,227,220,190,150,251,181,243,37,33,240,207,151,8,146,105,231,237,193,152,59,165,25,55,110,245,18,200,162,73,160,61,49,240,235,249,253,47,10,252,191,67,230,79,245,190,6,63,214,112,204,250,151,69,4,22,9,164,133,69,214,202,77,207,35,104,140,36,146,59,119,113,177,36,208,46,4,248,22,9,88,224,191,87,224,215,25,31,51,127,50,251,52,248,75,37,63,129,127,185,101,65,206,36,180,182,107,183,18,138,4,36,128,198,160,28,147,8,218,19,3,255,103,0,255,239,1,248,147,211,143,108,61,117,185,46,227,60,137,192,
242,6,164,64,17,212,5,223,41,139,4,172,89,129,163,169,129,118,65,31,136,53,213,103,129,95,3,255,247,0,252,184,160,35,114,249,9,254,203,46,11,42,120,172,154,64,0,181,148,31,186,210,45,165,12,104,143,12,122,153,8,254,223,69,228,15,121,239,246,223,59,224,207,213,104,4,63,73,32,167,4,172,49,22,252,40,245,59,89,192,186,129,246,200,224,143,22,245,104,183,95,131,255,15,149,249,17,252,150,211,79,201,207,152,90,18,212,65,210,200,237,245,152,174,105,157,82,172,73,64,142,89,10,180,11,0,127,85,0,254,223,84,230,215,142,255,231,76,230,39,248,25,115,169,129,182,80,69,230,14,80,245,20,193,81,72,160,93,8,248,245,194,30,11,252,201,232,251,67,129,31,101,255,138,224,103,28,160,36,240,84,0,2,187,147,248,68,36,189,219,241,209,72,160,93,0,248,113,97,79,106,239,253,197,168,251,245,60,127,4,254,41,251,243,49,24,30,9,148,0,210,58,255,48,29,134,106,29,72,218,27,165,192,193,73,224,88,37,128,37,253,245,194,30,109,250,233,241,107,65,230,39,248,25,115,147,128,94,78,28,17,128,72,124,52,122,23,40,3,145,35,204,
12,180,7,4,189,4,224,71,199,255,87,241,231,249,199,130,159,192,103,236,242,189,237,11,73,0,79,54,138,134,85,34,116,98,119,44,246,167,76,0,37,142,191,222,204,67,215,253,191,17,252,140,5,169,129,28,9,68,4,128,199,146,111,11,202,129,131,148,2,135,244,0,176,246,215,59,176,232,205,60,112,73,47,54,249,224,174,173,4,63,99,73,36,96,149,0,250,220,193,141,81,22,232,255,151,59,47,225,100,8,192,219,212,67,155,126,122,15,63,4,191,174,249,189,14,63,130,159,177,36,18,240,84,192,214,32,0,60,150,188,3,21,112,144,205,68,218,61,131,127,76,221,255,197,200,252,159,9,126,198,9,145,128,69,0,26,248,56,144,4,80,9,236,221,15,104,14,92,247,167,35,185,147,227,175,101,255,239,34,242,63,98,119,249,225,146,222,26,222,124,130,159,113,72,18,240,110,115,223,67,61,53,136,35,106,24,146,125,125,191,155,61,191,65,94,167,223,13,200,254,223,97,164,237,187,61,211,175,164,13,147,193,56,20,9,68,201,79,103,111,175,52,64,99,176,147,3,77,5,54,123,122,99,68,242,109,190,56,221,247,199,48,18,248,63,73,89,151,31,193,207,88,18,
9,68,25,91,175,6,220,58,4,208,101,212,192,172,223,245,118,207,224,247,178,255,157,124,116,253,245,238,189,222,78,62,185,157,87,24,140,99,146,129,200,71,99,208,242,2,210,209,227,175,106,188,5,68,128,4,50,155,31,208,236,241,77,168,228,227,225,29,218,241,255,205,144,254,122,239,126,107,77,63,123,251,25,75,5,126,238,59,89,5,62,64,174,79,0,9,96,113,10,32,58,178,219,218,211,79,111,227,157,70,206,241,39,248,25,75,37,129,62,80,2,189,1,250,13,100,255,23,80,2,27,71,9,204,190,139,80,179,7,240,235,109,189,172,102,31,92,219,175,87,247,233,102,31,52,253,106,130,159,113,6,74,32,145,2,118,10,90,211,131,185,153,129,157,49,208,238,233,205,192,131,59,215,138,0,116,246,215,93,126,119,98,31,218,193,93,124,24,167,166,4,244,119,180,1,208,111,149,15,144,178,254,243,160,2,158,13,21,176,215,217,129,102,134,63,26,179,191,181,196,87,187,254,184,177,71,154,239,79,198,95,78,250,19,252,140,165,43,129,210,239,40,146,194,70,129,223,83,2,179,170,128,102,230,63,216,107,245,213,139,124,244,150,94,184,177,135,151,
253,41,253,25,231,82,22,104,181,160,9,64,43,3,79,1,120,107,6,142,66,0,86,246,215,39,168,232,86,95,116,253,83,237,255,69,252,69,62,172,251,25,231,2,252,94,236,205,69,176,101,248,205,81,1,29,200,255,217,122,3,230,32,0,156,243,199,221,125,116,195,207,31,242,190,219,47,77,249,89,210,159,224,103,156,11,9,84,5,101,64,39,31,251,4,172,82,96,86,31,160,153,241,15,212,71,38,89,217,31,183,246,210,173,190,215,18,207,247,19,252,140,83,38,129,232,49,156,34,124,51,198,70,226,61,4,38,99,164,153,9,252,158,241,167,123,253,117,237,175,157,127,107,125,63,235,126,198,185,147,129,150,242,122,111,0,84,1,105,160,33,56,230,121,14,70,0,104,252,233,218,255,15,37,253,209,245,95,25,217,159,224,103,156,163,31,16,109,33,238,53,10,121,126,192,193,27,129,114,217,31,23,251,252,6,181,191,215,240,195,86,95,198,37,43,2,156,17,208,125,2,250,22,75,129,157,85,192,174,4,128,13,63,41,251,235,13,62,112,206,63,45,246,89,83,250,51,46,84,5,120,229,128,54,3,117,163,144,85,10,116,64,30,123,87,0,37,27,125,220,64,237,111,101,
255,123,144,254,250,144,69,79,42,49,24,231,148,241,43,167,4,232,12,21,80,178,78,96,178,10,216,133,0,188,236,175,251,253,117,175,127,90,233,167,23,251,52,204,254,140,11,39,3,171,12,136,150,13,163,31,176,147,10,104,38,130,223,203,254,247,80,251,99,199,31,141,63,6,129,239,27,130,86,99,208,171,124,220,55,96,54,21,80,239,240,199,88,238,127,50,0,239,7,37,144,6,110,240,209,128,236,103,48,46,53,188,115,50,238,0,67,247,242,211,59,67,28,77,222,32,167,41,4,59,2,95,55,254,120,217,63,201,127,52,254,82,211,79,77,233,207,160,10,120,231,5,136,227,3,228,188,0,60,100,180,24,75,245,196,63,2,89,235,202,200,254,247,138,181,34,211,143,193,160,10,248,57,112,235,188,123,192,20,46,155,247,90,231,139,159,120,172,236,215,36,160,59,255,110,12,249,175,95,44,46,244,225,156,63,131,42,192,87,213,58,169,98,25,112,35,239,55,203,197,243,49,170,185,9,160,114,106,150,244,98,211,12,192,29,100,127,220,222,139,217,159,193,200,171,0,221,84,119,11,42,224,78,226,35,242,70,37,211,122,34,91,121,166,133,206,254,183,98,239,
236,203,236,207,160,10,200,171,0,235,224,92,84,1,158,25,88,140,171,122,194,11,247,54,253,184,83,12,133,44,197,218,159,193,152,230,5,104,124,221,25,42,192,218,54,127,22,15,96,204,209,222,104,88,220,26,12,197,236,207,96,148,171,128,198,80,1,104,172,123,83,235,197,248,170,71,188,80,107,211,15,156,251,191,27,81,163,48,24,12,95,5,120,30,155,198,218,90,236,51,51,139,219,233,235,137,181,191,37,255,53,248,215,153,250,132,217,159,193,136,85,128,213,100,103,97,173,244,244,172,106,87,15,192,123,81,55,240,162,110,230,168,77,24,140,11,39,6,43,217,90,88,243,146,237,100,15,160,202,200,127,189,233,39,178,18,107,127,6,99,255,94,128,165,182,189,101,245,33,222,74,61,0,107,241,143,102,164,91,200,254,185,13,62,25,12,70,94,1,88,94,64,14,115,158,17,56,202,3,176,20,64,2,63,54,41,220,58,181,127,43,241,105,190,36,4,6,195,198,130,183,211,54,170,238,91,249,216,108,103,117,6,186,207,85,23,202,127,171,247,95,75,146,244,34,188,93,126,8,122,6,99,90,73,96,109,185,167,147,175,86,0,222,218,128,201,211,128,37,245,
72,122,17,55,70,246,223,105,169,34,131,113,225,68,128,165,55,246,222,32,9,228,246,215,28,69,0,85,166,254,95,171,23,17,57,255,52,255,24,140,241,153,63,55,253,174,177,183,206,248,0,110,25,80,103,228,191,24,12,116,5,44,180,118,106,127,154,127,12,198,238,164,80,59,42,96,173,146,48,150,1,26,131,97,210,29,163,0,176,14,185,113,158,60,183,75,9,9,129,193,200,171,0,171,20,104,156,36,156,18,113,238,100,237,201,30,128,245,228,107,5,126,75,254,215,112,13,6,131,49,222,3,208,42,28,203,128,107,163,4,40,221,42,172,138,8,192,202,254,22,1,92,203,251,221,73,104,254,49,24,251,33,2,171,20,95,3,22,113,179,221,200,135,123,167,0,170,192,11,176,152,103,13,10,32,154,250,163,252,103,48,118,43,3,196,41,197,181,2,88,203,132,22,252,49,10,32,177,142,158,139,212,91,125,121,217,159,160,103,48,118,35,3,75,5,180,1,30,115,155,132,252,255,245,75,76,64,175,246,184,46,168,59,8,126,6,99,126,18,192,114,92,15,111,42,190,72,1,88,243,143,117,80,255,71,141,63,108,253,101,48,230,41,3,42,137,27,131,60,31,160,206,249,0,185,
122,93,27,128,45,48,14,154,127,197,221,71,12,6,99,18,41,88,251,6,94,65,66,214,126,92,214,7,168,11,234,127,171,9,232,218,0,63,215,253,51,24,251,39,1,76,202,17,46,115,170,188,200,4,68,3,240,218,97,155,202,168,255,73,6,12,198,60,153,223,83,1,22,38,117,25,16,182,226,215,153,250,191,145,143,139,128,166,48,13,137,128,193,216,159,15,128,36,176,2,236,214,145,7,144,99,158,4,126,124,34,148,255,172,255,25,140,195,250,0,214,236,220,149,194,107,22,151,245,200,39,185,130,39,224,174,63,12,198,113,124,0,156,158,71,124,98,114,22,171,12,240,54,4,137,154,14,172,39,225,252,63,131,113,152,146,192,235,207,65,124,90,205,121,82,82,2,32,195,96,9,176,146,178,117,255,36,3,6,99,62,208,139,228,247,9,88,25,37,64,184,67,80,29,60,65,29,176,204,168,110,35,6,131,177,23,47,160,20,159,69,38,160,119,20,88,11,12,99,205,253,243,196,31,6,227,176,129,42,221,194,104,155,73,208,85,93,192,46,250,226,45,140,108,163,1,131,193,216,75,246,183,124,186,22,176,58,122,26,48,50,26,90,168,45,188,186,130,36,192,96,28,206,19,192,245,
58,58,81,123,37,122,229,17,128,4,30,64,11,172,18,205,49,146,4,24,140,253,128,223,82,2,13,168,245,182,192,3,168,44,15,32,234,4,44,145,255,4,62,131,113,184,18,32,42,3,188,78,64,137,74,0,145,120,154,193,99,22,6,131,113,28,50,168,157,82,61,154,166,127,87,2,84,5,23,214,42,32,59,181,192,96,48,14,170,4,144,4,154,177,10,192,50,255,44,19,16,167,254,168,0,24,140,101,40,128,218,40,215,17,171,18,149,0,232,48,214,142,10,72,63,91,125,3,12,6,227,112,217,95,255,220,56,88,117,229,191,12,44,17,61,129,71,2,225,69,25,12,198,65,75,0,107,54,192,82,233,69,139,129,42,135,0,106,40,13,188,233,63,158,1,200,96,204,11,244,72,105,91,101,187,133,217,226,62,0,235,194,77,112,65,130,156,193,56,46,57,120,138,221,43,1,138,26,129,42,35,219,83,250,51,24,203,47,5,170,140,82,239,45,2,240,246,30,243,46,70,5,192,96,44,71,1,72,65,210,254,16,99,78,7,174,50,242,159,68,192,96,28,199,23,144,12,86,39,149,0,146,41,5,24,12,198,50,203,128,226,22,253,122,196,69,43,102,127,6,99,145,42,32,135,89,25,91,2,140,186,8,131,193,88,164,
47,144,197,111,93,120,65,107,30,145,165,0,131,177,44,249,63,6,159,239,26,129,8,100,6,227,2,131,123,249,49,24,36,128,159,141,1,12,6,131,10,64,71,175,70,244,24,131,193,56,124,76,197,103,31,17,64,111,12,42,5,6,227,52,8,65,74,241,91,23,50,75,238,98,36,6,6,227,56,64,47,193,172,139,209,58,184,8,94,176,163,244,103,48,22,95,6,88,88,237,167,120,0,214,5,59,170,0,6,99,81,217,31,147,117,23,144,192,7,66,168,11,50,127,159,1,63,129,207,96,28,191,222,151,140,2,24,93,2,244,99,152,132,193,96,44,66,254,71,73,59,69,209,142,64,250,34,219,225,182,203,148,1,12,6,227,56,10,160,7,140,110,51,201,219,36,0,139,65,58,3,252,30,179,244,244,5,24,140,189,214,251,125,144,168,35,204,154,184,204,245,1,32,163,164,193,82,128,193,88,158,244,215,24,69,2,48,201,164,14,12,5,15,252,157,34,129,136,153,24,12,198,126,193,175,127,222,58,88,13,147,117,29,212,18,186,254,223,12,35,98,23,6,131,113,120,34,176,18,181,198,171,254,247,15,81,139,223,81,100,101,127,188,40,75,0,6,227,248,37,64,7,201,122,27,40,1,177,20,64,116,225,116,
209,55,135,89,8,126,6,227,248,10,64,103,254,55,192,233,168,70,32,4,63,202,138,52,58,25,209,114,200,96,48,102,207,252,154,0,16,159,59,43,0,139,89,240,194,30,240,73,4,12,198,252,192,247,136,192,75,212,81,185,110,46,7,182,204,64,148,22,111,78,9,192,198,32,6,227,48,36,208,59,37,192,155,83,170,143,234,3,176,74,0,244,0,162,50,128,193,96,28,166,4,240,228,255,155,124,156,181,11,167,1,69,236,121,253,206,200,254,214,197,59,126,46,12,198,65,163,115,146,52,170,128,46,72,206,189,215,7,96,121,0,111,34,242,58,140,183,140,196,96,48,24,251,87,1,165,248,44,82,0,226,212,21,186,182,120,53,84,128,55,19,64,79,128,193,152,191,230,143,166,233,17,163,91,137,253,186,208,4,196,250,226,21,70,164,2,8,122,6,99,127,100,16,101,255,52,44,159,78,74,21,0,78,47,88,18,195,147,25,12,6,99,191,68,208,5,217,31,147,243,86,130,29,188,74,246,3,192,18,224,101,24,214,147,208,11,96,48,246,95,251,91,201,57,225,18,75,128,226,29,129,114,157,128,250,73,94,128,105,114,211,129,36,5,6,99,154,228,183,240,169,203,115,76,204,47,80,
255,23,79,3,70,76,163,229,5,146,192,198,97,26,170,1,6,99,190,172,111,225,114,227,96,242,53,163,0,138,26,129,114,76,99,213,26,244,1,24,140,253,215,255,150,55,55,69,153,187,203,129,189,39,211,79,244,108,144,0,125,0,6,227,48,245,191,6,255,179,163,202,179,73,185,116,79,192,45,48,205,179,124,52,3,233,3,48,24,135,175,255,95,0,147,90,254,103,87,236,142,217,21,24,159,240,197,121,66,246,3,48,24,243,147,1,226,209,50,255,112,118,46,219,165,91,98,2,226,19,38,201,241,44,113,211,1,73,128,193,152,31,252,86,115,30,226,209,74,200,69,107,1,172,251,150,2,72,79,248,100,212,29,93,198,87,96,48,24,229,242,223,195,98,202,254,79,10,143,158,2,144,57,20,128,231,3,160,25,216,9,23,8,49,24,115,18,130,55,35,247,28,212,255,91,41,216,177,171,30,241,228,22,1,60,5,181,71,7,215,96,48,24,227,129,47,98,183,254,190,128,2,200,249,113,166,210,24,115,58,176,150,30,9,252,79,80,6,148,60,57,201,128,193,40,151,255,81,18,214,24,124,118,74,241,98,19,208,243,1,188,102,160,167,160,254,224,185,1,12,198,60,132,208,137,61,245,247,
12,137,216,107,2,10,19,239,24,5,208,129,249,144,158,252,81,189,128,146,125,2,168,2,24,140,56,251,231,214,253,191,0,246,116,9,48,170,39,167,212,3,208,171,143,240,5,60,2,11,209,12,100,48,230,243,0,172,236,255,100,224,15,23,1,21,117,229,214,25,22,66,25,98,213,32,233,69,60,7,117,8,51,63,131,49,77,9,88,254,219,179,1,126,175,3,80,100,66,35,144,71,2,27,120,33,233,69,60,40,18,64,21,192,214,96,6,163,28,244,86,249,141,181,191,198,220,35,36,222,77,6,252,253,24,2,144,140,15,240,164,94,200,131,248,141,65,52,3,25,140,113,132,208,137,223,248,19,97,110,84,233,93,23,72,16,113,204,8,100,163,135,194,122,132,37,1,131,225,227,173,196,119,123,48,84,119,201,254,156,163,27,129,196,169,71,180,28,121,82,47,232,65,226,25,1,6,131,49,14,107,104,254,33,214,158,33,225,142,194,90,61,146,149,172,23,245,8,47,234,49,120,81,84,1,12,70,89,246,183,146,173,133,181,220,244,123,136,179,122,196,139,140,76,137,7,17,249,97,188,48,203,11,96,48,24,126,120,181,191,6,127,194,90,100,186,23,37,215,122,36,59,117,6,51,61,41,105,
242,99,24,244,2,24,140,249,107,255,31,10,252,79,6,198,60,3,112,242,52,96,105,109,146,216,233,187,163,2,222,228,125,75,35,131,193,240,179,127,39,239,251,109,116,246,255,94,32,255,139,163,158,200,82,150,10,72,10,224,251,48,188,22,97,170,0,6,179,127,156,253,173,150,223,132,43,173,0,34,159,173,8,87,245,132,23,156,171,81,190,67,41,160,155,20,168,2,24,140,124,246,199,102,187,31,42,185,150,122,108,69,9,117,236,52,160,213,25,248,38,239,167,3,181,10,120,144,143,91,135,81,5,48,152,253,227,236,175,183,250,122,112,178,255,179,124,52,255,68,70,174,189,169,39,254,1,214,218,128,103,32,0,52,44,232,5,48,24,229,181,63,26,235,154,0,244,46,92,59,117,219,54,133,191,87,57,63,87,195,168,135,107,53,34,178,18,145,171,97,92,15,227,106,120,188,29,126,167,30,70,229,60,71,197,239,4,227,130,178,63,78,173,167,154,255,31,17,249,42,34,127,14,183,127,137,200,191,3,17,60,73,124,50,87,145,162,158,66,0,8,126,77,2,237,48,52,1,92,1,1,104,18,168,212,45,9,128,113,201,217,127,163,50,255,143,1,232,127,13,192,79,224,255,
27,74,235,73,221,127,83,8,192,83,1,154,12,44,21,160,9,32,13,36,0,188,14,73,128,113,41,217,31,75,233,100,250,125,27,178,63,18,128,149,253,71,207,253,207,65,0,149,65,4,154,4,218,129,4,86,170,12,184,6,21,80,103,72,128,4,192,56,103,34,232,157,186,255,199,64,0,127,15,192,255,239,0,254,127,134,199,31,231,202,254,99,9,160,84,5,232,82,96,5,158,64,228,5,84,44,5,24,23,144,253,197,169,253,181,227,255,55,212,254,127,239,35,251,239,74,0,145,10,168,85,41,16,17,64,83,224,1,144,4,24,231,38,253,173,102,186,100,252,233,218,255,79,85,251,167,236,63,121,229,223,28,4,224,1,178,114,74,1,139,4,86,129,10,160,33,200,184,132,240,166,252,190,25,217,255,175,225,113,203,249,223,41,251,207,65,0,149,51,188,82,32,17,65,107,144,0,13,65,198,37,100,255,206,201,254,223,134,236,255,85,222,27,127,255,64,246,159,117,143,141,102,226,255,43,85,1,218,20,108,13,37,144,254,173,206,120,0,36,0,198,169,19,129,119,200,78,106,161,79,210,255,79,163,246,215,205,63,179,101,255,93,8,0,193,105,169,2,36,128,149,2,254,149,34,5,26,
130,140,115,207,254,34,246,190,154,207,74,250,255,99,100,255,127,7,95,224,73,101,255,100,254,229,158,239,96,4,16,145,2,250,1,88,18,68,4,32,36,1,198,153,72,255,14,178,191,94,232,147,58,254,172,236,255,205,200,254,179,158,183,209,236,248,255,171,2,95,160,150,143,166,96,107,248,0,173,188,55,2,235,192,119,96,48,78,169,238,23,249,184,118,38,173,242,195,142,191,63,37,110,249,237,100,198,45,246,231,34,0,11,152,94,151,96,164,2,26,250,1,140,11,168,251,61,215,63,129,255,31,249,185,167,70,180,234,111,231,104,102,184,70,110,161,16,170,128,218,80,0,86,41,80,103,174,205,96,44,53,251,91,27,124,226,26,255,111,134,244,255,83,126,186,254,150,241,55,251,18,250,185,9,32,215,41,88,169,76,223,24,4,144,155,22,100,41,192,56,5,233,175,73,192,218,225,7,27,126,254,43,239,167,253,210,102,58,222,105,63,179,69,51,211,117,170,130,127,183,252,0,75,9,120,165,0,251,3,24,167,84,247,207,33,253,95,37,62,98,175,95,10,1,68,192,172,28,18,168,13,53,208,0,1,228,252,0,146,0,227,84,192,143,83,126,90,246,163,235,111,173,
245,23,217,195,238,89,251,34,128,232,223,163,70,161,134,36,192,56,19,240,227,148,95,90,232,163,151,249,234,236,255,47,72,127,107,179,207,217,163,153,249,122,99,72,160,118,74,130,70,198,55,7,145,0,24,199,38,2,239,244,44,189,177,231,63,67,166,255,51,144,254,47,135,144,254,251,34,0,43,211,151,170,128,26,192,111,205,8,228,174,201,96,28,58,251,247,1,1,188,200,251,249,254,191,65,246,127,21,219,245,127,19,223,244,155,85,9,236,147,0,34,127,192,155,42,68,240,231,72,128,155,136,48,142,13,126,9,192,175,183,247,210,173,190,255,29,72,64,175,243,199,141,62,189,157,179,101,233,4,80,10,196,72,13,120,94,64,109,16,7,73,128,177,20,240,167,41,59,116,252,245,124,127,154,242,75,224,79,189,254,184,203,207,44,139,125,142,69,0,99,179,179,183,118,192,82,2,81,127,0,73,128,113,104,240,91,7,229,104,199,255,95,0,127,52,229,23,153,126,39,97,2,230,72,32,42,11,68,108,115,16,239,91,27,135,144,4,24,75,2,127,212,233,247,85,129,223,219,227,191,119,158,243,100,9,192,122,172,15,252,129,4,112,171,4,136,26,132,72,2,
140,99,130,31,247,244,215,27,123,126,21,123,149,95,218,226,171,59,84,221,127,72,2,24,3,66,36,130,26,136,32,82,1,36,1,198,49,193,95,50,221,135,224,183,246,247,59,72,221,127,104,2,24,227,7,244,198,255,67,18,168,13,130,200,145,0,137,128,49,21,248,99,193,143,211,125,186,238,143,76,191,131,213,253,199,36,128,177,224,23,0,185,85,10,144,4,24,75,3,255,87,200,254,218,241,127,204,128,255,160,7,228,54,7,124,174,106,228,27,239,149,5,86,246,143,26,133,72,2,140,93,192,95,218,229,151,22,248,252,165,178,126,146,253,104,250,165,245,253,91,57,64,183,223,82,8,32,2,95,101,188,233,248,38,88,125,3,85,102,144,4,24,251,0,255,171,1,126,92,218,139,211,125,8,254,238,216,224,63,6,1,228,192,215,7,230,139,0,1,88,68,32,82,214,138,76,18,96,140,5,191,110,242,121,41,144,253,22,248,189,69,62,71,1,255,177,8,96,42,9,120,229,193,174,217,159,68,64,224,139,3,254,46,147,249,255,53,100,127,233,92,127,119,108,240,31,147,0,68,202,102,4,172,129,111,86,68,4,66,53,192,152,152,108,18,240,45,240,123,243,252,26,252,250,52,31,
111,186,79,142,9,254,165,16,128,7,192,190,96,164,223,43,217,140,100,202,107,96,92,174,228,215,178,63,45,236,209,189,253,56,207,175,101,127,41,248,251,99,191,9,205,145,159,223,3,107,31,144,64,231,60,94,101,202,131,18,37,64,34,184,108,201,143,153,255,173,16,252,95,161,230,183,192,191,21,223,224,238,47,149,0,162,76,93,66,2,83,183,75,42,1,61,137,224,188,129,111,125,183,182,18,59,253,120,114,175,94,214,171,107,254,82,240,95,188,2,200,1,174,119,140,153,232,214,242,7,60,162,169,64,61,80,13,92,78,214,23,249,121,196,22,74,126,203,236,195,37,189,127,58,224,127,14,192,223,47,9,252,75,35,128,169,36,208,25,36,224,245,17,148,100,122,170,129,203,202,250,216,220,163,151,243,90,224,215,187,249,232,246,94,203,237,95,52,248,151,72,0,17,9,120,70,141,53,166,172,170,34,17,156,63,240,69,226,41,62,93,239,163,211,175,51,63,110,232,81,50,207,191,56,240,47,149,0,60,47,192,146,111,248,65,110,13,69,32,25,34,168,72,4,23,3,124,129,68,177,133,172,239,153,125,95,13,240,127,147,143,189,253,57,183,191,95,218,27,
214,44,248,195,172,10,20,1,158,186,26,145,129,165,8,42,231,67,41,93,189,72,34,88,46,240,75,179,126,218,190,43,205,239,91,27,121,224,201,61,122,255,126,171,183,255,36,192,191,116,2,24,67,2,72,4,154,0,244,173,103,22,238,82,158,144,8,150,15,252,92,87,159,222,190,75,103,125,125,139,102,159,117,112,231,73,129,255,20,8,192,35,1,175,137,195,82,1,91,131,20,162,62,236,168,219,144,68,112,58,192,247,228,254,155,216,83,124,214,129,29,81,189,143,78,191,103,64,247,75,126,35,79,137,0,162,47,131,215,200,161,231,117,145,0,44,211,112,236,235,32,17,44,19,248,104,18,107,135,255,69,101,253,239,242,190,159,223,91,208,131,107,249,163,157,124,250,83,122,67,155,19,121,157,213,72,2,232,12,2,208,195,83,4,185,205,25,122,18,193,73,1,95,103,253,23,85,235,63,56,89,95,27,125,86,91,111,169,211,159,123,221,36,128,61,169,1,4,242,182,144,8,52,97,228,214,30,76,33,2,146,193,124,160,47,205,248,27,67,238,235,90,223,146,252,9,248,150,228,199,83,123,58,201,47,84,163,2,56,0,9,228,86,116,161,249,179,81,198,141,190,143,
166,97,201,146,77,18,193,242,128,239,77,237,125,23,187,157,215,58,162,59,101,253,71,241,155,123,60,51,153,37,192,129,73,32,215,56,212,57,126,192,91,64,4,91,199,39,232,70,18,1,201,96,62,208,151,2,255,5,228,254,15,168,245,35,224,163,203,255,34,249,117,252,39,11,254,83,38,128,82,95,64,127,88,86,41,240,6,195,42,17,54,18,155,134,209,23,96,204,114,227,138,160,15,129,223,23,102,124,116,247,191,129,201,167,9,224,171,147,245,159,228,103,143,192,217,212,251,231,70,0,81,246,151,76,41,128,126,128,38,129,87,131,16,182,32,255,116,54,16,137,219,61,251,137,96,175,46,12,240,17,232,251,224,243,211,25,255,9,50,190,110,229,181,128,143,181,62,74,254,141,196,139,205,78,26,252,231,64,0,37,153,214,91,70,236,169,129,87,96,127,143,12,74,214,30,244,51,2,189,58,67,192,231,60,156,156,185,247,2,6,31,46,222,201,153,124,86,173,255,42,241,142,189,253,57,0,255,220,8,32,2,136,183,144,8,73,0,21,64,250,130,189,25,132,16,77,37,246,35,191,56,253,158,192,94,29,9,208,99,174,81,145,250,130,8,0,0,4,235,73,68,65,84,178,
255,190,245,249,224,148,158,110,225,213,25,95,111,215,245,151,124,156,215,215,237,188,175,64,242,157,196,123,82,246,231,0,154,115,34,128,49,222,128,215,30,154,192,253,106,168,129,87,32,136,141,188,119,134,173,89,132,210,125,13,251,35,0,250,24,10,32,151,237,183,14,57,191,26,53,190,110,228,209,6,223,95,142,212,255,91,121,2,8,124,173,240,206,62,235,235,104,207,212,92,170,130,140,19,129,255,205,249,162,165,186,242,187,136,124,26,198,253,112,123,39,34,183,195,88,139,200,245,48,174,68,100,53,188,199,173,148,29,114,90,25,127,67,2,127,191,96,82,232,11,30,239,11,84,89,52,109,251,170,234,253,244,217,104,34,208,159,81,250,249,135,170,237,117,23,223,171,248,179,62,103,159,245,207,217,104,202,253,109,214,153,2,233,208,209,102,0,234,106,0,239,245,0,232,155,1,220,119,3,232,239,21,248,63,169,199,19,17,220,12,35,34,130,166,128,8,42,217,109,59,243,67,151,0,57,121,223,23,0,127,155,1,254,19,72,255,31,138,0,52,232,53,240,159,70,0,63,106,231,237,47,5,36,231,254,55,122,39,12,53,25,34,88,43,34,184,83,
192,255,164,8,224,14,136,96,173,84,193,74,13,79,21,228,78,60,42,49,61,15,77,0,253,72,208,119,146,111,210,210,237,187,73,141,105,224,63,128,50,251,1,143,63,170,255,231,1,127,43,229,237,223,23,149,37,47,73,13,136,216,7,143,230,136,224,198,33,131,59,131,8,214,142,34,176,136,32,61,111,37,211,14,63,157,147,16,250,194,199,45,201,28,237,225,136,126,201,198,49,249,94,84,246,70,224,63,56,160,127,42,0,126,73,63,199,69,128,255,146,8,160,68,13,136,124,60,124,212,34,130,43,149,213,111,84,182,183,192,143,101,1,122,4,87,234,218,86,137,208,136,127,16,170,71,4,149,236,214,125,152,235,202,235,51,192,239,28,159,197,147,248,218,228,211,53,62,202,125,139,4,158,20,240,95,228,253,84,94,36,245,187,140,9,219,95,42,32,168,6,126,18,129,38,3,36,2,173,10,174,21,184,111,65,29,220,194,208,106,96,13,68,128,170,160,133,178,164,196,64,244,118,50,154,250,57,247,193,109,169,145,23,53,94,105,224,63,27,89,255,17,204,190,71,5,250,103,5,124,157,237,45,224,235,215,38,151,158,245,47,157,0,198,148,5,85,64,4,154,12,174,
213,192,50,225,6,84,128,54,9,111,128,72,174,20,185,148,144,65,101,220,151,12,25,120,127,127,95,0,126,111,63,198,190,16,244,175,134,204,127,85,64,126,130,241,8,183,90,222,167,17,53,106,149,244,100,92,36,240,73,0,227,137,32,231,19,120,100,160,21,194,13,152,131,107,40,11,214,138,16,174,2,227,176,53,74,132,49,202,32,71,0,83,50,189,238,205,247,90,172,19,224,159,65,238,63,131,217,247,4,25,222,3,125,73,125,79,224,147,0,102,35,130,156,79,160,235,249,43,53,44,82,184,6,2,88,195,239,165,177,10,140,195,70,62,206,38,52,226,31,155,62,134,0,172,165,213,214,182,107,27,137,219,170,223,0,188,47,0,234,103,131,16,94,64,33,232,22,221,168,45,219,219,9,154,192,39,1,236,244,126,148,16,65,45,31,167,18,209,51,184,50,136,225,202,1,254,181,225,17,232,210,96,5,207,131,230,97,52,165,152,171,251,163,163,216,44,51,111,43,239,187,35,95,141,26,223,27,175,6,208,173,214,107,175,253,122,44,240,9,126,18,192,44,68,32,142,79,160,71,107,148,10,88,50,92,57,4,113,237,144,198,74,62,206,28,228,124,2,111,58,49,2,191,231,
230,123,187,43,33,1,224,120,145,184,181,250,13,174,129,202,194,219,159,97,204,70,156,4,62,9,96,175,68,16,249,5,181,1,210,214,0,244,202,168,255,241,103,4,255,10,202,1,203,40,180,166,16,61,211,207,58,119,17,51,255,86,62,238,161,240,38,254,210,106,107,29,133,5,118,13,248,92,93,79,224,147,0,142,238,15,228,8,193,83,7,141,51,52,160,87,134,183,96,101,253,54,227,7,120,229,64,36,253,113,51,21,171,238,223,56,106,192,218,118,109,235,128,221,147,245,37,46,126,110,145,14,129,79,2,56,216,251,85,5,164,96,129,176,118,72,161,118,72,193,186,111,13,235,186,185,214,98,175,246,247,206,96,220,6,99,227,220,247,86,76,90,25,190,100,69,94,233,54,98,12,18,192,98,74,4,9,192,136,128,109,212,109,109,100,118,139,52,172,222,128,18,240,231,72,192,59,129,201,58,146,205,234,254,235,229,125,239,125,201,114,105,74,124,18,192,217,40,131,220,173,71,8,30,57,120,77,64,57,208,231,58,3,251,2,34,240,26,128,162,99,219,251,66,192,139,140,59,89,135,192,39,1,156,212,251,89,21,18,131,5,216,18,112,215,25,213,81,242,26,163,197,
61,82,0,102,4,188,140,4,124,9,176,9,124,18,192,201,191,175,185,133,73,185,50,34,34,139,92,231,95,85,0,172,190,144,20,74,22,8,149,100,246,177,155,134,50,72,0,103,245,254,86,19,213,66,41,208,119,89,14,92,66,12,99,179,122,63,241,181,48,72,0,23,71,6,165,4,129,255,174,183,18,155,74,0,149,148,237,146,83,2,112,130,158,4,192,152,129,12,114,255,54,165,4,217,69,130,207,101,212,17,244,36,0,126,6,123,240,23,230,138,125,212,233,4,253,17,227,127,1,112,163,65,31,222,26,123,241,0,0,0,0,73,69,78,68,174,66,96,130);


template_circle3_256
:array[0..13329] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,1,0,0,0,1,0,8,6,0,0,0,92,114,168,102,0,0,32,0,73,68,65,84,120,218,237,125,217,178,219,58,207,44,72,41,121,255,231,253,98,137,231,38,235,63,218,12,134,110,144,146,39,185,202,229,121,16,197,110,0,13,16,44,242,221,151,114,255,199,211,47,237,254,143,247,228,186,143,251,62,23,239,0,186,118,3,225,62,230,123,236,191,27,124,237,6,195,125,188,239,252,31,202,155,3,164,221,36,112,19,192,39,29,107,249,210,115,213,222,28,140,237,6,197,125,156,207,252,205,242,66,199,221,94,224,59,218,77,2,55,1,188,250,49,150,39,124,246,217,231,176,61,1,92,237,38,129,155,0,94,229,248,202,137,159,41,47,124,46,219,9,239,109,47,10,208,118,3,228,62,182,171,128,95,158,248,219,87,128,177,189,41,17,180,27,36,247,113,101,190,123,20,208,217,207,151,9,147,55,250,142,81,48,159,65,6,237,38,129,239,38,128,242,228,239,44,201,215,203,228,207,204,24,147,81,215,189,77,254,204,89,161,199,215,146,64,185,193,127,9,248,89,112,151,39,19,193,89,192,111,23,145,196,77,2,95,72,0,229,
9,223,55,10,236,89,239,153,73,2,35,224,71,158,155,245,158,43,116,133,143,39,129,114,131,127,42,240,209,231,103,63,158,161,35,204,112,225,219,201,143,103,120,6,237,38,129,207,34,128,242,2,192,207,128,180,76,122,13,253,109,239,63,103,173,126,68,2,109,210,107,12,57,92,77,4,237,6,207,231,131,63,227,134,163,32,30,185,63,66,0,101,2,104,24,2,24,185,159,33,8,228,152,190,158,4,202,151,131,127,134,98,207,184,235,218,253,209,215,89,2,24,209,0,218,0,216,71,95,207,18,195,85,68,208,110,2,120,159,255,125,182,197,71,65,141,188,150,37,133,89,99,149,177,242,222,115,204,123,178,222,194,179,60,130,118,19,192,107,255,231,25,192,159,9,116,134,0,50,132,112,6,1,140,2,222,250,204,25,196,240,12,34,104,55,1,124,62,248,89,224,123,183,253,231,203,4,66,24,37,131,54,64,2,200,109,4,126,150,60,60,66,186,73,224,67,8,224,12,240,103,45,126,22,244,179,159,203,134,5,217,201,204,2,127,246,115,108,40,49,74,6,31,79,2,229,195,193,63,82,168,147,1,190,103,205,251,251,5,124,31,66,10,103,16,1,27,231,71,32,70,239,71,239,139,
8,130,13,25,16,192,182,79,37,129,114,131,159,182,250,168,133,71,8,0,125,15,67,2,51,244,128,200,229,207,128,191,129,175,103,200,33,19,46,160,222,193,71,147,64,249,64,240,207,0,126,228,94,91,64,68,30,123,239,171,224,243,172,87,112,22,1,68,214,122,55,0,188,7,192,110,32,1,32,250,66,68,10,87,16,65,187,9,224,181,192,207,136,123,25,87,221,2,124,5,222,199,146,135,69,6,214,113,89,99,224,185,197,22,168,50,22,61,186,90,4,129,122,9,217,16,1,9,19,62,142,4,202,23,128,127,52,141,199,186,232,153,171,70,12,17,89,176,36,144,245,0,70,193,127,4,117,244,28,123,149,4,49,8,113,127,182,64,216,110,2,152,255,159,178,10,127,38,166,23,208,186,215,195,115,22,224,81,82,168,68,136,224,133,6,200,152,181,192,3,232,93,108,196,197,223,9,176,239,206,243,199,239,136,188,4,198,35,64,180,130,153,68,208,110,2,184,30,252,108,172,143,186,237,22,200,123,50,40,14,49,212,36,65,160,34,33,235,5,160,49,52,235,218,91,0,223,29,160,55,5,244,22,57,160,225,196,25,218,192,219,146,64,249,50,240,103,149,124,198,149,183,64,92,131,251,
40,17,160,161,65,68,4,200,4,141,8,0,113,245,35,224,239,14,25,52,240,181,76,200,144,245,6,62,138,4,202,7,131,159,201,227,35,46,118,6,248,213,0,120,37,222,139,122,6,25,77,128,241,0,24,235,191,7,207,239,6,160,119,226,189,8,17,160,89,8,68,36,108,159,72,2,229,139,193,207,164,236,34,11,29,221,22,17,89,148,215,106,194,59,64,73,0,177,254,5,136,121,145,84,92,100,169,119,224,245,254,189,155,243,61,187,243,253,8,57,72,224,25,124,13,9,148,15,0,63,155,210,99,227,124,207,157,175,129,21,247,238,123,68,96,125,63,170,15,8,65,2,66,128,31,137,249,53,215,221,3,110,127,223,123,205,242,8,118,32,108,96,244,129,108,234,240,237,72,160,124,16,248,189,251,94,225,142,230,234,75,96,137,171,99,221,53,160,91,207,33,100,129,120,8,253,127,47,39,17,64,83,212,125,212,194,35,160,222,131,231,251,207,109,32,209,52,35,51,225,121,7,158,87,48,146,53,120,41,18,88,63,200,242,91,159,99,93,253,2,0,144,1,245,226,188,175,38,188,3,70,28,212,198,160,41,132,112,156,240,69,176,114,92,68,209,71,173,252,238,144,192,230,124,166,
28,158,47,135,199,165,59,150,227,123,127,200,178,25,243,165,31,11,4,156,69,121,79,33,65,93,158,65,2,235,7,128,31,93,107,159,81,243,17,55,158,189,30,9,97,57,124,231,50,224,17,136,65,2,214,88,48,34,160,85,226,171,17,1,99,241,183,238,190,6,248,253,239,49,237,192,245,56,30,187,2,122,52,132,233,199,162,40,224,212,200,225,45,73,96,253,112,240,179,226,94,5,8,0,5,185,247,248,72,4,11,24,46,68,161,128,4,94,192,204,16,192,203,215,55,208,133,223,15,224,95,15,192,95,186,215,118,231,113,68,6,77,185,111,133,6,30,32,123,192,23,3,248,111,71,2,235,151,128,223,42,204,137,128,111,129,17,5,120,255,218,18,124,38,10,17,44,225,145,169,9,240,206,69,3,73,192,115,251,181,199,200,117,83,238,47,135,251,155,226,13,104,4,81,148,112,192,242,4,246,67,56,208,19,194,241,243,242,169,36,176,190,9,248,179,149,124,76,238,94,179,250,11,104,229,23,224,177,69,10,40,33,176,224,207,132,1,145,251,207,146,0,10,248,254,185,227,237,114,184,191,41,96,183,30,31,175,162,144,66,47,4,246,250,64,83,180,130,102,140,157,70,8,253,120,
190,36,9,172,31,6,126,70,224,99,93,124,207,162,47,10,240,23,146,8,22,82,32,140,50,2,146,12,3,60,37,28,85,254,17,18,216,2,224,239,29,240,235,193,35,216,14,99,209,123,7,27,225,13,148,78,107,136,66,2,11,244,69,33,1,1,30,63,157,4,214,15,4,191,181,178,14,113,247,17,224,91,160,143,30,87,144,28,16,47,32,42,33,70,42,2,197,81,185,51,85,127,123,16,255,71,4,176,25,68,160,1,127,57,220,63,222,238,138,149,223,156,241,233,137,160,25,94,129,4,97,193,219,146,192,250,161,224,247,242,249,136,171,111,185,243,11,8,124,134,20,142,143,139,224,161,64,153,64,0,136,23,144,173,252,243,128,223,12,151,126,115,8,161,191,106,196,176,43,164,80,28,141,64,12,125,224,24,14,236,157,120,88,63,137,4,214,15,6,127,73,198,248,26,48,35,144,163,87,235,59,61,15,96,17,174,116,248,170,44,0,154,251,223,2,15,128,1,189,69,4,181,3,124,239,242,111,198,125,205,11,176,66,3,233,72,230,35,72,96,125,65,240,11,9,254,145,88,127,113,220,125,4,244,235,36,50,200,8,129,222,130,33,52,254,71,66,0,17,172,137,7,83,228,131,88,126,230,250,80,
198,106,235,198,100,59,60,167,121,2,123,32,134,246,34,161,37,16,122,36,48,10,234,233,36,176,190,32,248,203,73,224,215,44,255,226,128,159,1,190,246,184,6,4,129,16,192,98,120,45,154,158,33,100,42,48,235,1,104,100,112,36,133,13,240,2,88,2,120,252,125,253,225,0,223,34,130,106,120,0,155,51,70,71,50,232,195,129,17,97,240,229,82,132,235,7,131,31,201,227,71,49,250,10,2,127,5,200,224,248,26,42,4,46,130,85,6,62,179,14,0,169,252,67,8,224,72,2,143,195,227,199,33,214,95,58,18,168,32,17,20,197,27,56,146,128,24,158,128,22,14,124,20,9,172,95,2,254,5,32,128,35,56,87,16,228,43,65,4,145,39,224,85,7,122,150,159,89,11,192,164,1,61,17,80,36,94,246,187,41,161,192,214,17,130,101,249,23,229,254,67,33,129,234,16,193,195,208,74,118,193,154,191,30,9,161,118,247,63,134,4,214,15,3,127,148,218,139,196,56,20,228,200,107,40,9,120,85,130,214,74,195,25,238,127,212,21,120,36,12,208,86,236,89,185,127,36,246,127,116,68,80,13,2,232,129,175,17,229,118,56,70,205,27,216,12,15,64,140,76,193,91,147,192,250,37,224,247,92,
254,62,94,63,130,246,151,1,112,148,12,150,192,187,168,96,38,128,77,255,101,187,2,161,221,128,70,211,129,94,193,207,67,9,5,122,171,191,28,72,161,39,132,35,9,252,220,254,49,198,108,79,204,237,222,35,120,107,18,88,95,16,252,50,9,252,71,119,58,18,248,44,64,107,192,207,146,0,42,4,142,18,0,154,1,240,178,0,81,38,96,70,61,128,37,0,90,238,255,98,220,214,238,254,145,4,142,227,244,80,198,236,161,204,177,13,152,155,89,18,208,64,251,84,18,88,47,2,63,251,221,104,121,47,10,126,203,205,247,0,28,93,23,128,16,172,80,128,73,1,178,194,95,86,0,28,21,2,209,62,0,71,240,47,65,38,224,209,17,129,6,254,234,168,255,71,34,64,251,43,106,227,244,243,219,12,9,104,139,135,68,206,171,234,75,125,255,122,17,248,61,235,131,116,242,169,36,248,43,97,241,81,192,163,68,128,120,0,40,1,140,130,159,217,38,140,217,14,108,6,9,32,169,192,94,0,212,172,253,98,120,0,8,33,136,3,254,77,1,60,19,14,104,197,66,34,255,54,101,105,147,188,128,212,231,214,39,131,63,114,249,69,236,218,254,12,248,173,248,222,187,254,74,146,0,75,0,179,99,
255,179,60,128,89,90,192,34,120,45,64,237,60,128,234,184,254,85,226,98,41,212,242,35,23,139,4,154,66,2,44,224,79,39,129,245,201,224,47,142,251,127,4,127,212,118,91,19,210,180,252,123,228,186,255,10,0,255,11,32,2,43,12,136,74,128,163,174,64,94,7,160,26,88,253,89,4,32,226,55,6,17,193,218,130,245,153,129,37,32,128,31,160,63,64,171,111,121,139,85,236,78,81,136,104,234,9,131,165,75,17,86,37,109,24,45,19,190,156,4,214,19,193,47,32,248,145,102,30,86,158,223,114,159,61,240,255,234,0,31,129,252,151,240,94,192,2,16,0,226,246,123,205,75,196,32,128,200,3,96,46,209,198,25,123,119,235,181,232,62,146,192,210,121,2,154,30,96,45,254,121,128,238,254,98,140,223,145,60,31,4,57,174,127,223,223,0,111,96,119,194,128,18,136,132,51,43,253,194,239,90,79,4,63,179,67,15,162,250,123,224,47,29,224,61,240,71,150,253,8,248,95,129,245,255,21,8,137,90,218,111,113,38,106,148,243,215,244,144,72,245,103,183,8,111,4,9,84,37,36,240,122,6,88,181,1,199,78,63,253,42,191,199,97,140,52,29,96,17,172,131,82,117,244,17,235,
57,15,47,77,17,6,197,177,250,158,56,24,145,192,8,41,184,159,93,47,2,63,250,126,100,179,11,107,85,159,165,246,71,241,125,15,246,232,54,242,0,162,216,159,105,254,129,88,255,89,177,255,136,22,96,121,1,213,32,128,30,240,187,66,6,125,45,191,150,223,239,211,125,85,114,59,44,49,115,120,233,178,3,181,35,68,75,236,243,72,246,212,84,159,247,217,245,162,84,31,227,250,139,96,205,60,16,177,47,178,244,214,45,227,5,88,110,255,42,126,67,16,111,194,46,78,246,195,19,175,178,86,63,227,13,52,69,240,106,202,253,214,185,250,158,56,216,119,248,209,196,190,190,242,47,178,254,253,28,18,137,11,205,178,99,213,47,21,174,138,48,88,146,94,192,41,225,192,122,2,248,11,104,233,173,73,203,196,252,40,248,127,25,143,53,176,35,94,1,98,249,215,164,226,143,212,248,179,213,126,51,8,32,83,37,120,116,137,143,19,220,202,12,212,142,44,142,225,128,215,34,157,177,254,40,216,103,24,64,79,19,64,72,96,166,23,160,126,126,189,0,252,232,94,126,94,209,15,218,138,59,242,0,80,208,123,94,64,148,1,136,84,127,166,213,151,4,36,48,18,
243,71,117,0,25,77,64,3,127,81,192,208,228,223,30,254,90,107,111,109,93,191,22,22,32,155,187,20,39,222,47,129,171,238,145,159,181,149,216,241,113,127,220,253,235,22,176,103,102,5,212,207,175,23,130,63,187,5,183,151,246,211,172,127,47,248,253,114,192,255,219,0,61,235,1,68,170,127,17,174,206,95,139,249,71,243,253,35,26,0,171,9,244,161,192,209,234,85,193,202,133,143,239,71,69,190,26,184,251,51,242,254,30,97,246,187,10,245,192,247,214,96,32,45,199,167,147,192,122,82,204,207,122,1,136,218,175,109,185,101,149,247,254,10,44,255,175,0,244,168,7,224,229,252,17,215,31,109,238,201,212,249,207,138,255,181,10,54,109,178,34,33,65,81,200,161,4,158,192,209,93,182,230,195,3,204,26,69,59,69,137,96,11,164,44,253,67,20,226,139,194,1,9,92,254,179,59,2,23,17,105,235,36,240,51,165,190,153,21,127,72,143,190,53,208,0,216,171,231,1,104,169,191,170,8,128,81,190,127,214,2,159,81,247,127,102,24,128,104,3,218,254,125,26,9,108,29,65,88,0,127,24,217,147,25,66,159,213,15,161,63,206,197,177,236,218,255,177,86,
10,138,145,73,104,103,16,196,149,77,65,153,189,250,208,174,62,11,104,249,87,199,194,255,118,44,255,111,34,245,199,164,251,216,242,222,25,192,47,228,121,107,160,55,192,132,4,189,245,223,149,251,90,235,110,77,7,216,192,172,72,37,199,36,58,38,49,8,161,25,33,144,136,94,22,236,253,246,105,128,239,191,115,61,193,250,163,41,63,33,72,128,233,211,231,89,238,223,10,248,163,80,128,5,191,213,216,3,85,251,209,206,190,25,197,159,233,9,88,8,183,180,136,191,246,221,42,31,46,134,71,80,20,203,191,59,36,193,132,78,168,39,128,0,223,19,0,197,0,127,113,200,246,202,2,161,83,61,0,84,245,23,225,59,249,86,193,107,252,61,96,255,6,181,0,214,242,47,130,85,167,121,214,95,38,164,250,102,11,186,145,22,80,12,235,95,58,160,20,192,11,168,10,224,127,60,1,73,18,0,58,38,77,226,250,7,45,28,176,74,160,171,33,12,122,99,199,0,251,105,13,65,80,107,227,89,124,100,153,239,34,118,91,175,42,254,194,158,21,80,249,17,13,0,17,253,208,26,255,76,188,159,177,250,229,2,66,247,54,199,44,6,9,148,129,112,64,228,223,158,255,136,181,
23,64,133,247,22,62,105,11,157,164,115,245,23,229,51,75,231,5,136,226,9,104,61,6,17,13,96,202,101,118,71,32,79,116,138,66,5,36,239,31,53,234,140,74,125,89,17,48,99,253,71,54,245,68,197,190,204,248,143,166,186,60,151,21,33,138,2,100,5,246,238,190,0,154,0,10,244,2,30,167,39,100,106,27,138,54,135,52,180,48,225,248,127,61,215,222,202,18,76,213,7,206,106,11,30,197,252,214,118,221,104,43,111,180,220,23,21,2,35,235,239,173,244,67,74,124,145,116,223,8,248,207,170,104,243,98,126,145,120,89,171,167,9,68,36,32,134,46,16,117,241,245,10,204,24,165,191,57,64,247,0,254,83,201,24,137,130,125,157,64,149,127,183,40,59,115,11,242,33,2,200,76,184,76,218,47,218,153,87,3,232,175,193,107,148,247,143,226,126,111,85,223,204,28,255,85,110,63,162,7,120,154,0,123,169,74,104,160,205,155,205,33,67,54,221,215,192,91,203,250,31,227,253,229,224,254,91,25,16,237,156,35,229,192,47,187,51,80,9,220,254,136,181,209,221,121,189,205,55,60,171,31,185,249,76,209,79,182,196,119,180,131,111,159,43,62,187,142,93,64,224,
91,170,119,75,134,2,154,101,45,242,111,239,1,17,125,155,47,54,199,223,132,75,99,90,187,32,107,239,93,130,140,65,175,7,32,181,1,83,67,129,179,122,2,102,214,249,35,11,128,208,122,127,100,185,239,106,16,1,90,235,239,41,254,89,193,79,4,235,149,112,181,224,103,253,78,11,194,18,111,193,139,230,210,90,42,122,115,230,80,118,158,142,244,57,180,54,67,209,238,87,229,88,162,58,143,203,4,193,217,27,131,68,173,189,133,116,249,163,178,95,180,125,151,102,253,127,131,162,159,183,194,111,150,229,143,98,254,108,154,111,22,49,52,224,251,189,52,161,245,157,209,255,171,130,229,218,181,189,254,50,199,35,134,240,23,1,95,3,255,210,17,192,98,16,79,49,188,60,36,37,120,121,29,0,187,212,87,68,111,239,37,64,250,47,234,234,171,101,0,44,177,111,70,215,95,68,244,27,45,237,125,150,216,55,162,3,72,160,7,88,96,247,38,59,235,9,176,227,161,89,126,6,224,253,34,166,85,244,198,39,222,113,52,69,239,240,234,4,78,89,50,60,218,20,20,21,252,250,231,162,234,184,10,144,192,34,120,243,78,52,205,183,128,224,71,211,125,209,158,
125,35,42,255,85,110,255,72,56,128,20,15,181,96,30,237,138,39,112,44,176,97,199,195,115,253,45,15,192,138,251,189,21,141,26,232,107,7,244,214,221,238,14,41,158,178,100,248,108,17,144,141,253,189,130,31,111,51,143,40,254,207,88,253,236,234,62,13,244,209,125,214,226,151,193,115,51,195,253,71,39,34,19,30,180,32,140,220,229,191,155,124,142,40,252,22,25,120,226,222,102,0,126,21,187,195,209,34,118,167,36,173,228,217,91,52,52,61,35,112,70,33,80,212,170,10,109,246,25,137,127,145,250,143,10,129,200,22,95,22,33,205,40,242,137,72,128,1,241,213,105,64,212,43,64,211,133,154,229,235,93,230,99,119,157,204,113,91,214,255,87,32,0,70,22,255,135,8,180,247,30,231,115,3,68,193,230,144,167,200,19,10,129,50,130,83,118,225,15,226,250,143,238,230,195,116,244,241,118,241,25,81,251,103,130,255,234,112,0,221,134,42,178,92,145,215,80,12,97,176,39,129,150,4,189,136,191,211,241,158,184,46,78,216,128,102,4,138,216,43,47,209,140,192,212,125,1,208,73,203,128,62,218,201,55,42,1,158,181,157,215,226,16,193,12,240,
159,165,242,63,91,3,136,172,146,0,19,216,242,26,144,236,128,182,1,135,117,89,140,255,216,19,194,58,129,0,86,37,12,168,93,56,80,197,47,16,42,64,134,101,138,22,48,186,47,0,82,251,63,66,2,236,50,224,81,133,63,42,242,209,192,31,137,126,22,49,190,51,240,51,94,65,212,83,160,0,217,131,210,1,191,239,196,91,193,248,159,221,219,208,218,220,116,149,255,191,169,201,114,176,254,139,225,25,52,35,20,240,12,71,75,0,31,190,44,137,9,199,244,249,243,26,123,120,34,159,182,153,71,84,217,199,174,245,143,122,252,45,18,47,237,101,193,31,133,4,17,217,190,42,248,153,255,89,0,99,33,9,194,28,209,78,178,157,141,162,133,63,218,2,34,107,57,113,212,128,84,192,172,9,53,6,139,240,22,158,17,248,162,142,190,81,123,239,104,33,207,8,232,145,6,159,232,210,222,190,161,71,84,229,133,238,74,83,78,2,62,219,28,99,244,55,16,146,136,26,201,120,0,136,202,163,17,205,34,83,14,108,61,206,146,5,66,84,51,26,154,78,201,2,100,172,129,86,244,179,4,226,95,117,132,191,37,120,204,52,241,140,44,190,183,176,39,187,71,223,85,133,61,217,
44,194,217,123,212,69,105,66,237,86,219,116,243,248,89,47,12,88,156,248,63,170,245,239,93,127,235,177,181,231,161,150,21,208,52,1,75,12,140,198,49,117,174,70,60,0,111,97,143,213,214,11,77,243,105,238,191,231,246,255,150,127,123,252,253,22,187,42,112,9,172,127,239,157,28,87,248,101,91,121,137,204,111,221,149,181,192,87,126,199,168,150,100,25,146,22,140,173,87,125,232,121,0,86,182,64,115,229,119,208,3,136,194,128,168,225,40,35,146,82,97,192,146,140,39,162,165,189,222,102,23,145,192,135,180,243,254,29,144,0,219,224,195,43,247,141,74,125,69,176,237,185,145,206,52,51,192,118,150,86,112,246,127,203,104,1,35,46,113,212,222,155,245,20,188,157,145,209,48,160,255,253,34,246,238,76,94,248,3,143,3,67,0,232,196,142,42,252,50,177,63,98,245,123,235,207,108,234,137,84,252,141,128,255,10,171,127,149,72,56,139,8,144,215,70,72,32,42,96,98,251,254,29,45,185,7,254,29,212,13,60,45,32,170,94,140,196,64,120,204,103,17,0,186,194,111,17,191,195,79,228,250,255,54,158,139,26,124,90,219,122,71,109,189,145,
248,191,60,25,252,207,202,14,204,8,47,102,144,64,38,164,208,60,129,2,2,51,227,9,68,158,129,231,145,156,161,245,132,34,32,186,234,47,82,174,53,112,68,219,58,33,123,236,121,57,252,72,244,67,54,232,244,182,153,138,212,115,102,194,158,105,73,175,36,130,54,248,255,35,97,203,170,124,139,182,218,42,157,40,168,21,225,28,243,242,245,32,218,29,129,218,139,126,253,124,59,214,4,88,115,88,219,245,184,138,189,155,176,39,6,178,25,14,243,92,173,39,89,4,102,143,191,108,39,32,171,37,184,181,108,55,211,190,27,169,240,139,212,254,79,6,255,12,18,64,213,109,111,73,172,69,194,218,246,98,189,69,95,148,251,63,4,176,117,106,254,114,32,131,77,1,255,34,255,22,7,213,238,59,188,109,205,251,149,130,209,26,129,83,74,129,217,98,130,168,247,122,180,95,91,13,66,131,168,29,88,84,33,168,125,7,178,217,100,68,2,150,88,117,54,248,223,181,18,240,44,18,208,148,241,126,83,210,30,252,69,254,93,100,84,59,2,56,86,244,173,135,199,209,156,211,192,191,27,6,174,255,127,218,26,129,104,44,36,240,146,220,75,77,158,100,164,7,32,
186,243,175,149,33,168,18,47,206,89,9,82,208,126,167,128,150,223,138,77,111,240,95,115,124,236,110,83,66,8,211,214,156,96,74,208,23,112,206,162,115,15,53,58,195,218,210,25,27,131,68,27,53,68,219,102,49,154,192,2,2,31,45,235,141,132,62,17,172,143,219,183,130,127,150,46,192,46,118,137,214,15,136,225,9,84,197,19,56,134,4,199,66,158,145,249,135,234,77,125,55,32,79,11,136,182,17,131,198,183,38,38,158,199,192,26,59,69,43,230,16,192,87,208,181,103,54,232,100,251,247,69,177,127,185,193,127,153,39,128,236,3,192,110,64,27,173,76,93,38,205,205,40,179,164,225,133,205,188,192,99,207,180,85,98,82,47,200,86,87,200,50,96,164,55,96,150,125,51,130,95,22,228,223,6,254,171,194,1,196,48,177,157,168,88,47,116,77,204,63,132,8,44,143,51,10,137,40,77,175,78,96,98,100,208,139,96,233,54,38,21,136,14,52,186,81,103,5,173,61,58,240,223,14,254,43,142,31,89,99,17,89,127,36,37,141,18,3,50,119,163,185,207,122,164,67,99,188,14,156,168,72,0,203,172,18,244,150,8,51,154,0,154,235,47,131,3,126,214,78,61,159,0,252,
89,25,2,180,171,16,66,22,125,99,90,173,65,231,168,30,133,204,93,166,200,76,251,239,109,150,254,82,39,77,78,102,63,118,175,63,0,211,47,192,27,108,180,154,143,201,241,103,198,228,6,255,121,99,146,217,160,102,36,36,88,72,163,100,205,227,226,120,3,140,225,25,89,108,246,127,175,215,193,19,145,109,1,102,9,49,232,138,65,116,19,17,36,246,103,148,127,198,245,191,193,127,221,49,34,194,244,72,113,90,212,33,10,33,2,237,51,222,230,184,140,8,157,30,243,58,0,124,244,132,160,234,63,219,35,16,137,209,216,60,235,44,55,191,220,224,159,126,172,153,177,207,10,131,172,56,88,137,121,232,205,117,175,14,101,164,24,47,12,1,74,2,244,104,81,140,165,254,247,7,186,12,48,169,86,236,227,165,122,172,19,143,232,27,200,201,184,193,127,29,9,160,34,173,229,169,86,192,40,105,75,218,163,84,115,20,22,20,16,244,236,90,20,234,82,39,156,196,168,232,2,81,97,17,182,68,154,118,90,238,154,245,251,34,113,202,69,8,143,224,6,255,245,36,128,166,196,162,176,206,243,2,208,249,102,85,158,34,98,116,212,108,22,177,242,200,216,208,
4,128,110,83,229,253,81,164,16,131,9,1,144,129,69,221,60,132,109,51,34,203,13,254,235,198,32,42,5,246,206,49,19,30,178,110,61,90,121,26,173,58,181,244,13,1,201,207,28,183,145,181,0,104,181,22,99,249,51,177,87,244,29,11,200,166,163,150,189,220,224,191,140,4,178,27,213,48,226,181,183,249,43,91,47,16,125,135,86,23,112,252,207,140,48,56,37,4,96,212,69,36,5,136,168,155,245,164,171,72,94,237,207,52,75,185,47,207,33,141,76,171,177,200,59,149,19,231,165,230,9,136,129,151,211,66,204,58,153,153,69,226,102,25,35,214,223,139,175,74,32,244,137,196,37,151,145,71,243,238,162,31,187,214,225,93,69,65,230,156,90,29,158,61,129,176,4,58,21,154,145,170,14,241,136,112,29,167,152,48,225,63,4,144,41,168,16,242,79,70,177,22,218,28,196,114,207,34,11,207,164,252,216,141,45,94,29,252,25,96,63,139,12,206,238,53,24,157,115,116,206,88,245,43,94,248,192,44,68,171,18,47,255,45,51,206,85,77,14,46,186,233,3,58,136,145,71,224,89,119,100,96,69,252,158,253,236,70,21,175,14,254,217,237,188,203,197,255,125,198,231,
81,163,37,70,204,45,132,161,66,188,4,36,3,128,134,167,211,198,175,78,60,1,76,92,61,90,136,177,8,95,203,47,130,55,87,56,99,161,207,187,0,232,221,142,129,93,48,132,172,89,65,194,37,214,226,51,186,24,130,155,41,231,163,78,56,49,104,115,80,180,47,128,119,63,234,234,82,0,15,196,83,129,127,238,183,201,147,254,19,192,255,142,199,98,53,10,41,130,47,94,211,54,124,65,59,250,120,101,239,209,202,68,166,255,100,90,159,170,131,131,27,9,22,94,222,213,43,129,180,220,171,133,212,18,144,90,106,134,212,50,19,244,93,122,245,191,226,239,205,26,99,244,60,179,75,217,189,212,97,33,230,36,82,252,131,116,161,162,137,32,91,8,132,22,7,9,232,94,69,155,110,50,43,167,208,176,35,211,252,244,21,47,229,75,127,123,68,12,68,194,215,76,24,139,150,158,87,137,55,145,69,74,237,135,51,83,117,242,96,103,129,24,165,69,16,98,64,170,188,188,248,144,89,249,247,42,214,191,124,1,1,101,199,186,144,231,216,34,132,10,24,46,102,153,57,219,126,46,187,18,21,34,135,58,241,68,140,246,102,67,4,18,196,189,183,170,169,228,44,33,229,139,
193,255,238,199,234,149,222,138,248,197,57,140,38,133,174,72,173,36,81,137,12,86,177,214,201,74,108,212,168,0,109,210,136,0,62,42,239,69,221,165,27,16,247,49,123,160,138,234,94,144,181,3,108,8,80,8,252,12,93,106,2,224,158,187,239,13,100,5,172,112,21,220,91,16,112,208,145,1,188,114,71,159,79,141,187,95,121,108,216,30,1,218,235,104,218,14,153,195,2,252,54,235,169,166,10,216,50,165,192,200,15,69,41,22,9,92,246,104,99,132,209,237,186,178,161,205,187,3,244,221,47,179,207,5,219,244,54,18,1,61,173,0,209,167,74,194,200,94,226,1,140,120,8,34,88,33,14,179,148,23,209,25,132,20,81,208,206,43,183,245,127,79,47,128,61,255,163,243,45,10,11,180,249,207,132,179,81,24,80,50,4,48,171,133,115,228,194,32,175,33,3,148,81,238,203,137,147,181,124,57,248,223,113,28,216,69,54,2,134,161,66,24,163,10,128,157,25,19,180,83,242,148,66,160,76,195,16,68,24,100,173,126,116,162,50,150,226,182,170,159,243,159,51,231,27,153,91,172,55,32,164,183,202,132,223,244,88,212,39,157,76,38,239,153,205,141,178,173,162,190,
17,164,223,162,5,48,162,25,211,250,45,27,30,160,171,81,153,244,94,74,39,168,147,7,24,101,56,100,49,14,178,250,48,187,88,162,220,160,190,201,130,240,2,152,57,22,149,156,163,22,223,243,98,167,205,203,153,34,32,187,91,46,59,64,50,40,130,140,138,124,239,212,40,227,219,195,128,209,115,204,118,27,66,230,170,0,164,49,58,7,203,89,4,208,36,47,158,49,94,1,155,163,69,68,147,83,214,81,223,158,194,91,147,11,58,31,152,148,28,59,167,35,15,88,0,204,157,214,19,112,116,160,71,107,149,217,166,163,168,231,81,110,208,222,23,192,27,69,189,87,38,228,100,59,76,71,36,145,193,87,25,13,1,50,235,1,68,184,182,205,25,119,255,83,45,247,183,239,14,252,142,255,15,13,11,34,111,224,146,203,140,205,65,179,225,128,23,98,176,177,16,179,120,226,190,220,151,236,156,71,66,0,102,222,71,161,199,233,154,84,125,194,32,50,158,3,235,174,61,131,245,111,162,249,12,235,61,99,46,101,140,86,150,136,228,21,8,160,60,17,32,217,13,75,239,203,125,153,25,234,142,120,171,79,159,155,245,100,240,143,50,231,59,172,206,187,47,55,81,188,237,
156,172,247,57,188,47,247,229,123,47,35,4,208,6,127,187,1,223,197,190,231,190,220,151,43,47,111,63,39,235,73,3,112,197,96,52,242,119,110,162,184,47,179,230,53,51,247,172,247,182,87,152,155,245,69,6,181,31,12,230,189,207,240,94,110,98,121,15,160,94,241,93,109,144,8,50,191,213,158,73,0,35,7,98,29,64,153,200,170,237,6,230,125,57,137,104,188,249,213,38,1,23,157,195,237,25,4,192,184,70,13,112,119,26,48,168,77,121,223,183,88,239,246,65,224,249,150,255,23,205,217,230,16,202,229,99,85,79,26,160,17,109,32,2,123,3,201,35,98,233,219,67,184,47,200,188,104,131,115,208,154,211,141,252,13,118,222,34,120,160,26,130,100,193,211,12,102,244,216,18,125,61,58,33,12,179,182,73,19,232,190,188,190,229,102,93,113,73,206,65,111,78,123,224,110,4,73,12,121,14,117,226,201,96,44,49,18,46,68,46,20,234,41,48,113,88,123,65,144,183,47,5,233,89,191,155,137,213,17,203,30,205,213,232,251,103,196,253,109,22,1,140,42,162,136,181,143,24,176,1,76,199,122,10,51,220,168,251,242,153,36,212,200,57,141,232,86,140,129,67,
132,237,233,243,178,62,9,8,13,184,10,241,30,52,222,111,128,171,119,135,1,223,225,89,52,32,246,70,189,201,145,185,140,146,66,68,2,169,236,87,157,4,98,196,221,103,226,252,38,34,59,73,8,18,196,91,239,224,238,127,18,185,188,211,24,54,128,36,24,208,139,51,151,17,15,249,50,99,85,79,18,86,26,192,102,209,107,253,253,29,24,108,196,35,56,51,19,208,110,18,120,187,113,64,60,69,68,200,235,1,47,32,192,143,239,23,80,7,67,244,174,130,140,85,157,60,136,153,184,231,8,240,125,146,55,128,12,58,42,0,189,18,8,219,151,131,127,150,165,71,206,255,232,124,243,230,242,14,26,56,70,139,72,157,135,154,24,76,164,84,23,177,232,253,128,104,207,91,131,188,7,39,66,64,208,139,204,87,86,111,45,224,117,200,37,123,110,163,116,156,103,164,36,48,96,2,24,53,196,83,158,114,97,69,64,246,207,245,12,23,133,7,123,192,178,81,44,213,20,79,2,97,79,38,60,184,189,128,247,179,254,145,97,64,52,170,29,12,67,145,57,44,192,111,179,224,103,214,208,64,4,48,82,236,227,13,122,4,238,93,25,244,29,8,11,16,183,233,83,128,208,190,16,252,87,
159,63,166,60,61,114,247,181,57,190,131,97,107,198,253,159,238,1,176,238,84,35,174,59,48,112,8,33,120,33,133,12,48,235,13,136,207,61,86,207,226,106,66,29,50,239,60,67,22,205,253,93,98,113,27,9,185,225,177,171,147,79,78,164,206,179,100,176,7,175,69,76,186,7,108,25,149,103,102,86,126,125,27,9,188,202,49,102,148,251,40,116,69,98,251,61,152,183,141,120,45,91,243,146,13,135,82,139,129,152,220,127,68,12,26,67,238,0,179,238,130,169,177,2,12,42,58,217,94,53,246,110,95,250,219,217,255,133,212,169,100,230,147,54,71,179,33,128,133,31,52,172,133,207,203,140,66,160,200,189,182,172,178,199,158,214,224,109,129,43,181,131,97,66,36,156,100,114,175,207,4,201,51,52,142,246,66,4,147,21,200,162,57,236,205,73,107,30,110,142,142,21,165,185,217,90,23,244,156,180,89,4,208,18,131,139,184,243,205,177,242,168,30,160,185,251,187,224,107,16,142,175,149,201,0,110,23,2,243,83,172,254,236,113,47,196,249,247,138,122,16,35,198,8,128,59,136,15,36,180,161,199,176,78,28,248,81,247,41,98,221,227,117,3,6,12,245,72,
50,181,3,153,177,250,4,18,120,197,99,64,207,17,90,117,138,106,86,150,119,106,93,81,161,27,197,205,148,243,145,205,2,68,113,52,146,215,223,1,247,125,15,216,214,27,236,93,236,58,4,17,108,217,177,36,196,151,87,1,208,204,186,241,246,70,4,134,46,164,241,226,238,222,234,239,192,124,243,244,170,104,142,70,6,140,9,187,232,197,64,45,1,126,9,98,127,13,96,76,236,142,88,252,13,136,201,16,15,1,33,131,51,38,168,188,48,25,92,13,250,43,198,118,116,49,154,55,111,163,249,137,26,42,47,243,16,133,0,169,177,91,129,1,45,3,19,78,35,11,196,226,123,68,176,57,94,129,197,202,245,192,236,69,249,143,197,57,86,244,117,118,140,158,177,123,204,167,85,17,162,165,188,222,235,94,204,143,90,247,166,204,79,36,28,216,29,224,163,198,213,59,174,112,188,70,27,130,160,165,140,145,42,143,128,63,123,149,164,155,149,233,54,116,95,158,71,24,232,146,94,166,42,85,78,156,151,90,152,43,98,151,179,207,38,73,90,3,96,149,199,209,184,31,245,4,162,239,216,36,46,27,30,170,166,74,158,156,155,52,206,29,187,72,211,137,210,127,154,27,
223,18,243,17,153,227,154,71,33,130,175,145,57,181,39,96,166,225,7,179,122,10,25,92,150,40,152,76,3,162,2,35,90,200,167,185,228,239,20,150,48,109,231,145,149,165,81,109,63,10,108,196,72,49,13,67,16,247,158,210,122,102,108,13,198,10,127,136,39,224,197,87,71,182,221,156,65,223,36,174,193,22,0,244,172,186,124,147,192,181,113,63,219,250,205,58,239,94,170,14,157,111,91,160,83,33,153,0,164,40,72,192,24,63,52,88,53,249,101,158,75,21,181,80,178,132,144,77,113,169,54,199,189,218,2,113,16,169,16,220,5,47,182,96,212,230,155,4,174,21,253,34,65,204,243,12,162,170,61,237,118,83,230,159,21,22,108,198,251,153,197,64,72,95,193,211,66,128,140,165,67,83,128,104,124,21,177,46,26,123,101,83,131,12,235,222,36,112,29,248,145,53,40,34,243,11,209,52,195,131,206,67,111,174,71,100,192,122,226,211,8,192,35,2,102,25,112,84,30,185,5,3,173,1,126,3,66,0,38,21,147,237,57,248,42,241,240,55,196,252,81,120,198,170,253,104,229,41,50,247,24,207,21,93,54,204,132,1,212,152,215,137,76,220,200,129,215,192,223,28,101,
53,114,169,80,54,102,188,128,145,12,64,187,73,224,212,49,201,20,176,161,75,208,35,18,200,204,205,221,8,119,81,224,139,224,141,119,96,47,189,14,156,156,76,141,117,254,29,161,77,0,0,19,205,73,68,65,84,52,208,17,176,173,193,142,88,55,170,192,202,172,209,206,134,7,25,113,245,19,128,127,22,248,153,126,19,209,226,52,212,229,71,230,30,66,6,232,202,85,182,53,216,52,13,128,109,154,200,20,250,120,213,85,209,0,163,128,71,6,60,171,186,158,114,66,62,208,27,56,243,248,209,77,97,216,246,115,104,126,31,153,155,155,225,5,160,105,65,214,16,13,137,128,179,246,37,67,42,236,208,156,169,55,168,143,65,79,128,13,9,178,29,134,191,149,4,206,56,110,198,40,141,184,252,168,229,127,36,230,223,6,122,0,34,120,61,10,51,94,141,209,0,178,173,150,68,184,62,0,81,60,165,13,248,14,186,98,153,5,25,140,8,51,115,63,194,79,33,129,51,193,143,108,56,131,134,0,59,8,212,109,210,220,100,178,83,187,156,188,211,245,58,225,36,23,82,16,60,14,104,5,79,66,246,90,255,94,183,191,255,179,252,125,188,31,30,239,135,91,145,255,46,22,234,
7,179,24,143,11,48,46,222,243,217,177,254,118,203,159,89,203,143,150,245,110,19,230,31,106,124,52,66,240,240,36,146,207,76,209,61,1,209,184,151,109,0,170,157,140,77,252,234,42,139,113,31,224,137,208,218,54,161,121,88,33,79,192,183,122,2,103,131,63,42,141,213,206,17,210,103,82,155,35,136,235,143,90,253,141,152,123,209,198,56,168,218,31,158,139,149,176,234,37,248,145,98,188,183,63,168,122,184,109,157,55,240,115,127,81,158,59,14,252,2,158,160,31,15,224,248,125,71,203,127,244,4,138,252,119,57,104,237,254,119,233,8,179,116,199,174,45,27,62,203,19,144,23,244,6,206,90,203,143,130,159,109,53,207,88,127,196,192,104,239,243,132,196,13,20,163,163,177,96,69,233,255,92,22,99,34,121,207,29,111,139,242,254,254,245,254,125,213,120,189,118,215,232,185,162,220,22,227,253,218,111,105,255,65,251,239,98,28,167,4,239,41,193,120,206,0,113,249,114,240,71,177,63,34,248,29,1,170,89,245,227,115,15,17,249,243,247,250,48,110,255,28,222,123,188,34,68,146,105,21,54,116,78,214,68,188,217,20,235,23,197,101,199,
63,179,119,214,214,58,33,213,113,165,126,188,0,205,27,120,116,36,240,80,200,97,119,188,128,163,30,112,244,4,188,221,86,139,49,62,136,39,48,2,228,87,208,5,206,10,105,208,6,24,200,86,93,153,166,51,15,5,252,15,32,20,64,132,105,47,37,29,197,254,94,232,77,143,247,66,88,39,207,202,123,86,177,56,94,65,111,173,139,97,221,17,175,160,4,94,66,255,95,170,114,76,5,240,12,4,180,244,140,39,240,142,222,192,217,237,187,4,176,248,66,134,0,86,81,206,102,128,253,209,89,244,222,210,91,175,89,214,255,209,17,5,155,22,68,90,131,83,23,134,0,36,112,119,25,224,139,1,204,98,16,130,231,214,35,225,64,113,174,2,128,221,3,116,123,33,18,184,130,8,206,238,131,192,128,127,63,220,34,233,61,175,216,204,34,0,198,237,183,220,127,164,94,69,11,1,68,241,10,178,241,126,99,9,128,213,2,34,43,89,3,11,91,130,24,31,241,22,138,99,249,17,34,136,72,78,6,72,224,221,137,224,25,192,207,130,223,35,2,75,177,215,98,125,20,240,163,177,191,215,97,56,138,251,153,12,212,84,2,16,7,60,222,235,37,0,102,36,236,69,34,159,39,24,10,224,21,72,
112,31,37,129,136,68,174,32,129,209,239,106,23,17,8,91,114,62,2,126,175,190,228,7,204,155,17,6,252,81,220,127,207,234,71,36,192,172,9,200,246,171,116,199,126,38,1,160,238,53,146,17,136,8,33,34,143,236,85,2,208,71,96,110,201,172,64,185,128,4,144,239,189,122,167,100,166,187,143,7,126,102,67,25,47,133,199,128,254,79,240,30,68,64,252,113,251,163,190,149,167,85,153,46,192,36,203,138,129,18,88,212,66,2,191,58,194,97,68,6,154,23,32,36,17,48,36,128,188,191,144,128,127,151,42,192,172,197,71,74,172,173,38,153,145,194,31,173,40,253,1,231,159,195,237,131,0,61,226,1,160,101,193,158,23,80,100,114,95,202,12,1,68,0,240,114,232,150,23,16,145,64,1,188,128,140,245,71,254,179,4,225,0,66,144,140,22,144,57,31,239,2,124,212,234,103,193,31,245,242,139,42,250,34,235,31,121,3,90,88,16,185,255,168,245,23,193,27,131,194,231,99,1,39,20,227,5,148,32,92,64,129,25,129,189,14,130,31,201,90,8,17,30,176,233,212,66,140,241,59,16,193,8,240,61,151,159,93,207,239,117,136,66,149,127,132,0,208,248,255,248,27,187,224,
139,130,70,98,254,169,30,64,86,12,140,188,3,212,51,152,29,231,107,218,131,144,0,103,73,128,25,199,12,208,203,139,130,158,117,247,61,235,207,130,223,83,251,181,24,125,115,212,125,244,170,89,127,164,155,53,179,250,116,138,248,199,18,192,168,23,16,197,255,66,0,123,6,1,32,218,68,148,229,40,73,16,151,193,207,191,2,17,140,244,162,67,186,40,49,224,247,186,74,71,189,36,60,203,255,72,128,31,81,255,163,206,192,8,232,167,149,2,47,131,147,171,4,175,49,107,4,88,11,142,146,137,16,154,68,20,247,163,174,190,182,80,200,58,49,103,103,7,202,69,96,159,161,246,123,49,191,8,214,196,211,171,240,219,18,214,255,120,255,127,129,234,255,7,16,255,216,70,32,162,144,225,165,89,128,140,101,43,196,235,209,227,154,32,130,154,32,22,113,254,3,98,165,219,96,108,207,18,193,59,104,0,153,52,31,179,207,36,90,228,227,89,125,164,220,215,243,12,188,242,95,109,141,0,187,61,184,204,6,125,150,0,80,47,128,93,53,24,17,193,76,119,31,241,68,144,99,155,229,186,179,225,192,43,165,9,51,155,116,48,214,159,105,224,105,169,253,143,
32,238,215,202,125,81,149,63,74,1,162,229,190,253,45,162,145,12,199,254,89,2,96,180,0,203,45,102,215,12,68,133,68,22,136,89,47,128,21,59,103,168,244,222,201,29,205,18,204,36,133,209,205,56,35,139,47,50,222,194,75,115,251,55,80,165,143,226,255,71,231,254,91,94,195,102,16,0,210,138,78,228,223,237,201,163,49,27,206,10,204,32,0,36,35,16,197,225,145,96,120,140,235,81,97,145,117,229,11,25,115,183,137,64,100,94,127,165,112,128,17,249,102,170,253,168,219,31,1,254,24,219,35,30,128,69,20,155,225,250,71,27,213,100,219,205,79,11,3,150,228,228,97,171,3,17,215,58,11,106,86,233,71,136,39,11,196,81,79,32,210,78,218,147,195,1,100,50,246,21,107,25,151,63,107,249,209,149,125,218,42,63,102,225,143,37,248,89,29,129,70,154,208,50,202,255,211,8,64,36,23,71,35,153,130,140,128,136,232,18,209,239,163,160,178,90,162,141,236,121,111,89,214,87,41,14,26,177,252,108,239,200,62,213,215,6,4,191,63,14,240,209,220,190,101,249,17,240,71,30,64,52,94,211,98,255,81,2,200,120,1,50,0,104,145,56,197,87,8,242,41,36,145,
53,34,36,208,158,111,19,64,250,44,113,112,84,236,99,9,96,7,213,126,68,244,219,132,47,239,205,230,251,45,215,31,221,143,50,43,248,61,197,3,64,181,0,47,190,206,122,2,81,78,31,245,6,68,174,89,133,151,221,90,156,233,56,124,86,169,40,74,106,179,193,207,108,214,137,186,254,76,109,255,67,248,110,63,232,66,31,171,239,63,210,133,122,170,245,31,37,0,212,130,34,233,62,145,56,39,207,46,208,25,109,202,161,189,142,212,187,51,13,46,71,222,199,144,241,51,221,254,89,169,62,198,237,207,46,238,177,4,64,77,63,216,28,18,96,92,254,136,208,27,121,30,46,37,128,108,40,32,68,184,96,145,67,37,60,1,68,171,96,129,158,253,92,27,32,139,54,72,20,103,121,50,35,224,223,65,183,31,221,162,11,105,233,133,228,251,189,10,191,227,181,79,61,90,173,191,217,254,255,167,9,127,207,34,0,212,50,35,93,132,80,143,128,249,175,179,99,227,6,62,70,98,64,198,165,22,199,202,50,199,134,238,72,211,130,207,48,49,190,38,240,161,150,31,113,253,45,160,255,79,176,6,31,154,197,71,44,191,23,255,139,112,155,125,76,213,5,150,73,238,34,67,2,
136,101,102,82,114,104,215,94,175,109,23,162,186,23,34,158,71,203,56,51,2,80,86,40,42,19,8,110,180,184,103,39,132,62,116,91,46,171,218,239,8,92,175,134,255,127,10,25,120,105,63,102,163,16,52,237,39,224,124,104,51,193,127,38,1,48,192,71,181,3,68,39,104,130,183,240,102,129,208,247,249,23,103,178,23,208,205,71,194,1,70,96,139,68,58,180,199,124,36,50,50,155,111,162,251,243,69,49,255,30,88,225,227,125,180,117,23,35,4,30,189,9,166,187,15,147,251,63,37,206,247,206,247,50,81,52,154,89,27,96,129,29,245,0,74,242,184,88,145,175,17,239,99,114,190,200,196,64,21,118,20,176,204,238,58,232,251,153,77,49,189,181,243,15,71,240,67,11,123,178,100,16,185,253,90,104,194,246,246,143,66,129,83,23,3,205,138,137,51,171,5,89,5,27,205,48,52,192,234,71,5,59,140,203,221,2,11,186,27,64,148,128,0,34,139,142,78,162,204,100,65,98,127,196,194,51,187,241,88,249,116,175,107,207,38,249,133,61,127,156,16,33,178,252,209,42,63,164,223,223,136,160,60,69,212,93,131,184,151,253,66,111,83,81,109,75,49,4,124,253,86,98,44,
105,48,86,63,98,105,237,228,174,192,68,255,217,94,12,105,111,126,188,237,55,37,101,170,29,81,50,101,51,27,168,247,34,162,231,185,45,29,0,205,245,163,181,254,35,157,125,163,170,63,166,183,63,66,154,158,110,116,134,245,255,191,207,163,187,3,207,34,1,143,28,52,177,77,219,29,197,10,19,54,50,246,71,149,250,40,134,251,57,233,203,223,241,212,38,193,18,16,192,113,255,193,93,1,255,46,220,90,135,145,48,40,210,30,144,176,195,106,226,153,241,10,172,21,126,104,79,191,7,1,250,76,103,31,70,249,23,34,230,63,29,252,22,1,156,65,2,154,219,109,109,175,189,31,44,222,17,12,50,243,192,129,180,23,186,40,101,117,148,237,159,173,206,143,219,158,215,195,173,229,5,252,132,102,30,248,51,123,25,140,142,25,147,114,236,199,78,228,223,54,88,104,137,239,46,254,142,189,153,253,252,144,202,63,116,135,159,93,176,54,223,251,64,22,104,58,248,61,2,24,37,129,200,218,71,36,208,239,38,92,187,112,96,31,156,212,168,24,179,19,150,107,81,60,129,69,121,189,30,110,173,112,96,55,192,127,44,126,170,128,8,58,226,5,176,165,189,
123,23,182,49,157,124,152,157,123,16,2,120,0,64,71,182,245,66,193,239,1,62,10,41,209,148,223,41,6,112,29,176,230,51,63,231,9,114,69,153,104,181,211,3,54,96,162,55,128,16,118,210,250,183,206,19,232,111,183,46,44,168,29,17,28,189,129,31,203,111,109,144,250,115,156,85,33,193,25,154,64,54,230,23,195,218,71,13,60,209,54,222,143,206,3,240,250,249,161,94,64,84,225,247,71,176,173,191,163,84,159,200,88,65,214,44,235,111,126,118,61,1,204,214,231,60,47,192,35,129,6,132,3,75,247,60,66,108,81,253,245,14,170,217,235,97,98,172,138,55,240,115,187,24,224,63,62,222,197,223,253,200,242,2,106,0,254,209,16,0,217,166,11,177,254,217,61,251,162,149,126,72,5,160,7,250,63,242,239,238,64,26,248,143,247,155,228,118,247,201,88,255,83,192,143,18,192,204,112,0,1,124,31,22,176,154,64,249,123,162,86,112,80,180,45,153,163,189,229,25,34,208,174,63,224,223,20,15,192,218,216,84,107,120,90,157,112,32,27,10,140,108,207,109,137,126,90,169,111,19,124,247,30,171,227,14,162,1,120,164,176,9,86,230,187,31,60,145,61,25,243,
163,34,224,85,27,178,82,4,144,37,1,52,53,216,255,225,162,0,190,26,154,128,119,224,11,161,92,75,96,253,61,47,96,59,0,191,39,2,143,0,150,131,91,95,187,251,30,1,100,214,71,204,32,0,36,165,133,172,234,203,172,242,139,54,246,200,144,193,67,177,252,72,188,31,165,253,154,226,29,121,158,231,25,170,63,244,185,117,2,160,103,165,6,53,143,160,116,128,151,110,80,51,25,2,182,164,21,89,155,190,42,143,23,199,11,168,221,253,40,51,192,110,129,230,121,3,214,227,6,140,83,54,99,130,186,253,25,241,143,105,252,25,9,124,200,70,158,155,196,235,252,53,97,52,211,230,251,116,189,96,77,126,249,76,18,208,178,0,226,132,1,40,9,48,245,236,34,120,126,90,179,250,187,225,254,111,135,172,64,134,0,102,144,192,108,15,96,6,248,153,109,188,144,245,254,12,17,88,122,194,6,8,126,40,248,45,247,159,81,252,47,17,11,215,129,31,57,187,241,36,82,53,232,145,192,210,101,7,34,203,207,238,55,191,26,158,192,166,0,127,35,67,129,168,90,208,35,2,17,108,23,99,17,189,16,43,2,63,50,126,179,92,127,207,3,64,5,193,77,176,38,30,86,110,63,3,
126,100,185,246,89,184,145,43,8,96,36,213,199,232,1,72,115,77,143,4,170,163,1,48,77,42,90,224,250,111,93,218,239,120,123,36,130,218,121,3,189,245,95,38,16,0,91,37,136,88,255,217,177,255,230,120,1,90,147,141,12,9,108,65,124,223,167,23,55,67,144,140,22,51,33,43,252,206,142,251,211,196,178,78,96,157,51,72,192,42,22,202,144,0,50,72,213,153,204,171,97,241,23,3,252,71,247,95,243,0,54,197,11,168,198,125,164,54,192,219,0,197,243,0,80,13,0,45,245,101,115,254,72,234,207,19,1,17,50,176,226,123,203,205,247,182,239,30,5,127,123,53,240,207,32,128,87,36,129,2,168,174,139,252,91,171,47,65,26,171,137,93,249,215,19,194,210,121,0,11,144,18,172,7,176,47,138,245,95,12,240,123,251,33,34,98,32,34,146,138,96,53,254,199,231,54,209,183,240,106,68,234,207,35,1,20,228,143,192,187,240,44,254,38,99,107,251,95,26,252,179,8,224,213,72,160,26,30,1,210,130,185,117,41,198,222,162,173,1,1,104,86,127,61,128,123,85,98,127,79,8,92,12,17,16,21,4,89,33,48,43,0,70,109,190,54,193,10,127,52,112,62,8,34,216,128,199,59,233,
242,127,44,248,103,18,192,171,146,64,83,178,7,222,196,222,59,239,64,139,99,23,135,8,142,36,80,21,47,96,35,51,1,26,1,44,19,195,128,104,114,101,220,255,45,73,0,81,17,208,78,2,61,106,213,181,25,154,132,85,242,253,113,224,159,77,0,175,72,2,34,255,22,98,84,103,114,71,224,143,136,160,7,250,6,184,254,72,42,80,243,0,208,173,209,17,29,0,141,255,5,204,150,160,125,253,153,76,0,26,30,68,138,254,30,16,82,212,195,255,99,192,127,6,1,204,34,1,49,178,1,22,9,28,93,247,35,240,189,248,215,178,110,139,225,13,120,68,128,94,107,16,255,107,160,95,28,215,191,6,224,63,195,3,208,72,192,107,246,185,129,153,128,109,18,25,68,109,186,54,227,191,52,225,242,251,163,187,248,62,29,252,103,17,192,12,18,240,82,130,214,82,98,173,108,184,25,225,64,79,20,75,224,9,180,46,83,160,77,32,22,244,168,0,56,146,14,244,82,129,40,1,68,26,0,155,255,143,132,64,134,12,34,21,63,2,63,2,252,126,161,83,22,252,237,213,192,127,38,1,188,2,9,20,209,23,19,245,174,111,53,38,120,237,4,193,227,218,254,170,0,127,55,82,124,22,216,89,247,191,6,
233,192,209,90,128,54,137,0,152,34,160,29,16,229,16,82,216,129,219,168,115,15,186,158,255,99,192,127,54,1,60,147,4,138,161,9,244,149,133,21,80,184,251,240,226,232,85,44,138,23,96,17,67,13,220,126,134,0,138,115,95,72,29,0,117,255,69,252,181,254,153,42,192,29,0,45,18,203,123,223,133,0,223,90,196,147,89,206,251,54,224,191,130,0,158,65,2,158,48,120,36,8,43,52,240,50,2,199,16,163,239,240,179,24,68,16,1,63,35,0,162,213,128,108,45,192,72,23,96,214,11,216,64,93,96,151,120,183,160,8,240,168,171,143,172,117,144,79,1,255,85,4,48,139,4,68,226,94,2,18,8,132,197,17,9,251,56,191,95,126,220,131,85,11,19,170,18,30,84,133,8,80,139,95,13,208,179,33,192,168,7,144,9,1,152,133,85,59,16,171,35,234,125,148,199,247,220,125,107,199,94,17,190,123,239,203,169,253,214,165,200,181,151,50,225,253,204,222,130,222,150,225,158,27,109,21,221,160,215,5,176,238,158,232,87,18,238,191,200,191,27,166,50,197,64,204,166,35,154,155,140,132,1,13,16,5,89,128,51,46,62,18,231,163,11,122,222,30,252,207,32,128,103,144,128,8,
182,124,182,24,68,48,74,6,94,90,15,237,6,228,165,255,180,14,65,103,102,1,68,176,14,64,200,6,160,253,26,129,150,0,57,2,122,166,138,143,217,183,239,173,193,255,44,2,56,131,4,68,226,22,217,5,244,8,10,0,184,136,12,138,216,121,124,180,200,39,250,15,154,245,23,241,219,134,139,65,144,34,113,155,42,75,13,71,188,0,212,27,208,222,195,236,186,179,3,255,1,221,160,3,221,182,235,109,193,127,165,6,48,91,19,64,190,195,219,108,196,218,40,164,215,7,52,253,160,223,4,180,111,249,221,131,121,39,200,194,179,248,53,8,95,74,64,118,89,15,64,4,223,242,27,93,82,221,18,160,182,138,140,90,96,233,145,102,29,40,232,25,224,190,60,248,159,233,1,92,225,9,48,250,64,37,116,130,18,168,242,76,248,128,0,158,85,253,71,4,192,172,16,200,20,7,33,93,131,26,120,63,114,241,163,248,62,35,242,181,79,1,255,43,16,192,44,18,64,117,1,9,196,65,134,4,188,80,1,1,116,4,242,40,223,111,129,190,130,224,207,244,3,144,192,122,162,245,1,25,114,64,110,25,240,123,98,159,36,227,253,183,2,255,171,16,192,51,73,0,241,4,4,176,188,30,88,17,144,
71,53,254,35,224,207,236,14,20,137,95,12,9,68,107,6,24,114,96,20,124,203,213,247,44,255,87,129,255,149,8,224,44,18,136,136,160,0,33,66,38,123,224,133,13,168,197,23,199,235,176,84,255,8,248,217,16,64,4,107,14,34,18,47,160,65,60,130,200,157,207,168,249,76,21,95,102,147,142,183,3,255,171,17,192,85,36,192,18,65,180,214,30,1,41,18,70,68,192,103,251,255,157,177,53,24,219,39,144,33,130,8,236,17,185,176,113,126,4,252,143,7,255,43,18,192,153,36,48,195,27,16,16,136,17,144,17,128,107,197,61,213,249,31,30,240,71,219,130,11,8,126,17,127,5,29,35,30,122,196,17,17,15,34,236,205,90,183,255,182,224,127,85,2,200,254,175,145,144,32,18,9,17,18,16,0,204,44,216,81,194,121,133,221,129,35,64,178,164,128,188,206,186,249,141,32,186,217,192,127,57,240,191,50,1,204,38,129,8,12,145,72,136,120,4,104,184,192,234,11,168,181,71,193,63,195,3,96,66,2,54,76,136,68,70,207,173,103,55,223,100,219,117,127,20,248,95,157,0,206,38,1,4,36,104,10,81,64,176,162,30,67,6,244,163,192,159,17,10,140,144,129,16,207,35,255,131,113,
243,153,85,123,31,3,254,119,32,128,145,255,152,37,130,140,86,224,133,8,108,248,160,121,10,140,197,191,146,0,88,66,216,1,146,64,54,113,101,98,122,6,232,237,4,16,183,79,4,215,39,146,0,227,17,32,4,48,74,14,242,68,240,159,65,2,50,25,228,172,139,63,178,104,231,35,193,255,78,4,48,250,95,179,153,2,4,244,77,240,28,124,70,87,64,65,207,128,191,16,19,54,67,2,150,59,206,18,133,0,223,81,100,60,143,223,78,0,112,251,116,80,125,10,9,160,97,1,3,54,54,92,144,36,129,32,158,202,140,16,128,181,172,40,128,81,171,222,18,191,31,29,79,59,17,192,237,27,0,245,13,36,128,122,4,104,152,128,0,185,8,30,114,68,214,190,144,227,128,90,66,198,19,64,137,193,242,26,70,221,251,204,98,157,175,0,255,187,18,192,140,255,61,131,8,80,183,123,22,49,176,238,126,73,30,59,66,2,140,5,190,2,232,40,200,219,201,224,109,223,6,164,119,255,239,179,61,130,12,56,203,68,160,151,201,99,53,131,12,102,3,60,163,228,183,11,128,219,190,21,68,159,78,2,103,121,4,51,0,62,234,242,207,32,0,52,68,56,235,254,8,240,191,26,252,159,64,0,51,143,161,12,
188,103,68,59,200,122,17,89,98,26,157,216,172,192,214,38,16,7,11,240,118,33,104,219,13,158,239,34,129,153,68,48,203,202,151,11,206,237,12,50,200,88,242,51,210,118,55,248,255,94,150,155,0,158,70,4,35,46,61,58,57,103,185,183,237,66,82,120,7,224,127,204,165,220,199,242,20,50,152,65,30,209,127,187,194,3,200,0,179,77,248,142,87,0,125,187,65,115,147,0,251,190,114,242,243,87,156,211,89,68,48,2,238,27,252,55,1,60,237,152,202,196,247,142,188,110,121,10,109,210,184,120,223,51,187,150,126,102,154,238,108,112,182,27,44,247,113,149,147,222,95,38,124,79,121,1,0,60,203,130,223,224,191,9,224,210,99,43,39,126,166,188,209,249,155,153,118,123,213,245,246,237,6,201,125,124,103,252,86,249,176,115,118,149,213,110,47,124,76,55,64,190,248,24,203,19,62,91,222,4,236,51,0,213,222,228,24,111,112,124,249,113,150,23,251,223,229,137,19,255,93,203,109,219,13,140,251,88,95,245,247,95,237,220,181,15,3,95,187,65,113,31,239,187,254,135,242,198,160,120,5,224,181,27,16,247,49,223,227,255,157,128,107,55,24,238,99,
191,255,215,247,1,236,43,215,9,252,63,67,39,199,163,137,90,181,31,0,0,0,0,73,69,78,68,174,66,96,130);


template_square2_256
:array[0..3097] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,1,0,0,0,1,0,8,6,0,0,0,92,114,168,102,0,0,11,225,73,68,65,84,120,1,236,216,91,139,101,87,21,5,96,99,238,55,204,67,32,241,33,16,240,69,65,255,255,15,81,208,23,65,240,65,133,8,9,185,95,219,57,219,90,229,73,117,119,170,91,135,149,26,225,219,176,250,236,115,78,213,172,217,223,60,107,236,93,245,179,159,61,254,120,110,94,182,24,248,12,252,180,62,3,143,236,246,231,31,121,229,251,255,225,159,11,2,65,232,51,80,255,25,216,109,190,97,254,200,113,25,0,39,237,119,211,239,235,47,204,58,231,251,220,98,224,51,208,247,25,56,123,248,50,0,174,207,175,79,102,131,239,249,126,241,110,252,151,174,30,247,249,229,215,204,83,7,1,2,69,2,15,166,215,239,102,125,51,235,171,171,199,125,190,199,131,179,185,47,55,255,43,243,198,155,179,94,157,181,65,32,4,6,193,65,160,80,224,108,254,221,248,159,207,250,120,214,23,179,54,12,30,134,192,94,237,119,243,159,0,216,13,191,155,255,221,89,111,207,122,99,214,139,179,132,192,32,56,8,20,9,156,205,255,245,244,252,201,172,15,
174,122,223,141,191,107,223,127,176,1,112,142,115,251,191,87,254,221,252,239,95,61,190,54,143,231,239,1,115,234,32,64,160,64,96,55,249,94,233,63,155,117,54,255,71,115,254,233,172,221,235,15,67,224,4,192,222,1,236,177,111,236,93,192,94,249,55,4,222,155,245,214,172,151,103,237,31,128,206,215,157,199,121,201,65,128,192,61,17,216,171,250,30,251,248,237,172,47,103,125,56,107,143,13,129,243,43,253,195,23,246,159,19,0,123,190,155,122,215,134,192,222,246,239,149,127,55,255,59,179,94,159,117,126,21,152,211,235,32,216,115,7,1,2,247,67,224,4,192,94,221,247,214,127,175,246,123,252,115,214,217,191,103,159,63,124,227,50,0,30,190,48,255,156,16,216,247,246,202,191,155,255,242,46,96,3,194,65,128,192,253,20,216,205,127,174,254,219,225,238,225,221,203,187,111,119,111,95,30,207,61,46,0,246,11,78,8,236,109,255,38,199,9,130,155,133,110,22,220,239,117,16,32,112,183,2,231,202,191,143,231,119,255,237,96,247,238,238,225,199,109,254,125,255,123,191,2,60,124,225,198,63,151,65,176,155,127,127,135,184,252,
91,192,141,47,247,148,0,129,31,81,224,252,238,191,45,252,224,198,63,61,62,233,14,224,188,127,30,55,65,118,61,85,209,243,77,30,9,16,184,83,129,115,39,112,246,235,173,63,252,182,0,216,59,128,115,155,127,206,207,227,173,197,125,1,1,2,119,46,112,185,63,47,207,31,219,200,38,197,255,114,156,31,224,241,223,65,201,129,195,143,241,25,248,175,247,240,179,4,192,254,199,46,143,155,207,47,223,115,78,128,192,221,9,220,220,139,55,159,63,177,147,103,9,128,39,22,241,6,1,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,
107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,
208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,
64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,
10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,
17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,
2,160,115,110,186,38,16,17,16,0,17,70,69,8,116,10,8,128,206,185,233,154,64,68,64,0,68,24,21,33,208,41,32,0,58,231,166,107,2,17,1,1,16,97,84,132,64,167,128,0,232,156,155,174,9,68,4,4,64,132,81,17,2,157,2,207,18,0,15,110,252,23,111,62,191,241,182,167,4,8,220,145,192,205,189,120,243,249,19,219,120,225,137,239,60,221,27,79,253,131,158,174,156,175,34,64,224,46,5,110,11,128,221,224,103,147,159,243,243,252,46,251,244,179,8,16,184,93,224,230,30,61,207,159,248,157,183,5,192,249,198,239,230,100,215,183,87,47,60,119,222,240,72,128,192,189,17,216,13,191,123,244,236,215,91,27,187,45,0,182,224,217,248,223,92,85,219,191,27,156,0,56,143,183,254,32,95,64,128,192,255,77,96,247,233,30,103,191,238,94,61,65,112,222,123,248,5,55,255,121,82,0,156,66,91,228,235,89,95,94,125,227,243,243,248,44,127,56,188,250,54,15,4,8,220,145,192,185,96,239,158,221,189,251,131,65,176,87,240,93,187,169,95,156,245,198,172,95,206,250,237,172,223,205,250,213,172,119,102,189,62,107,223,63,155,223,149,127,48,28,4,238,153,192,
185,218,111,8,236,230,255,116,214,63,102,253,121,214,239,103,253,97,214,223,102,125,50,107,223,255,238,50,0,246,110,96,3,224,221,89,191,153,245,235,89,239,205,122,107,214,203,179,246,234,127,54,254,121,156,151,28,4,8,220,19,129,19,0,251,184,87,254,189,11,248,112,214,95,103,253,105,214,31,103,253,125,214,6,192,254,154,112,29,0,187,161,247,10,255,218,172,183,103,237,149,255,253,171,243,125,109,195,225,92,253,231,212,65,128,192,61,23,216,187,128,221,228,159,205,250,96,214,95,102,237,157,192,158,239,107,143,4,192,94,225,95,153,245,139,89,123,23,176,65,176,119,4,231,214,223,85,127,48,28,4,74,4,206,223,241,246,86,127,175,248,187,241,247,234,255,209,172,47,102,237,29,194,131,179,169,247,113,175,240,123,165,223,16,120,115,214,171,179,94,154,181,175,159,175,155,83,7,1,2,37,2,39,4,190,154,126,63,159,245,241,172,221,252,15,175,254,243,248,189,141,125,25,2,187,241,207,109,191,205,191,82,14,2,157,2,39,4,118,211,111,16,92,111,254,57,191,190,3,216,255,218,217,232,123,197,63,235,242,245,61,119,
16,32,208,37,176,1,176,199,254,77,224,172,125,126,94,223,243,235,99,67,224,220,9,236,223,4,44,6,62,3,63,141,207,192,249,85,254,92,232,175,55,253,205,147,19,2,151,143,231,142,192,227,127,238,142,88,176,184,239,159,129,203,61,124,206,191,183,223,255,5,0,0,255,255,3,0,58,251,175,138,95,146,15,69,0,0,0,0,73,69,78,68,174,66,96,130);


template_square3_256
:array[0..4879] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,1,0,0,0,1,0,8,6,0,0,0,92,114,168,102,0,0,18,215,73,68,65,84,120,1,236,155,137,118,227,198,17,69,237,56,206,98,59,206,158,255,255,191,236,187,29,47,147,190,148,30,167,4,129,18,41,149,172,41,241,226,156,158,106,52,26,197,226,109,190,135,38,101,127,242,209,254,241,241,26,78,251,209,166,207,185,77,6,126,6,62,220,207,64,180,75,228,216,158,223,140,174,127,63,57,246,110,58,153,200,89,250,137,91,35,200,184,241,62,43,153,200,228,53,62,3,85,183,233,215,184,237,223,49,0,10,206,145,226,35,250,173,219,115,125,59,230,185,76,252,12,188,222,103,160,106,50,250,69,207,244,183,199,113,44,59,128,227,192,154,153,155,19,153,195,194,18,107,191,46,118,174,25,223,115,146,133,44,94,250,51,176,213,96,61,143,126,171,182,151,132,143,199,97,156,2,57,50,169,222,20,209,255,120,93,79,99,126,250,53,190,244,27,53,191,98,242,51,112,255,51,176,167,193,173,9,160,111,142,104,188,246,63,6,106,46,84,241,7,54,47,240,233,166,253,228,145,243,237,124,207,239,51,148,137,76,
186,62,3,209,104,204,32,218,197,8,162,237,213,189,119,28,174,197,0,170,248,235,147,159,34,17,252,79,31,104,92,127,108,206,67,247,123,237,97,190,242,145,207,222,103,160,234,46,125,244,138,17,160,235,173,1,188,91,99,247,142,106,0,185,129,177,184,10,137,127,118,219,126,190,98,26,99,244,247,98,230,27,223,179,147,133,44,94,234,51,16,115,168,38,176,103,0,75,174,31,97,2,119,140,0,161,231,233,207,132,237,211,159,228,17,58,111,128,243,184,12,115,99,26,15,109,53,214,52,15,9,72,224,5,8,68,208,223,175,220,180,111,87,251,102,181,175,87,251,106,53,140,128,131,121,153,147,123,14,227,24,64,142,24,65,76,32,219,127,132,255,249,109,219,51,129,220,183,53,129,237,121,94,199,40,1,9,92,78,224,206,147,123,221,158,243,8,251,148,248,185,254,93,105,156,163,77,238,255,56,6,16,17,231,169,158,175,1,249,10,128,1,124,177,26,145,29,1,59,1,238,165,101,23,176,186,39,127,116,208,12,160,227,33,129,203,8,68,228,219,187,50,78,68,208,136,159,198,147,255,191,171,69,215,8,159,29,1,231,245,107,65,244,254,142,11,17,103,
6,137,117,23,128,216,179,11,248,197,234,199,4,48,135,36,174,247,174,225,195,145,188,57,55,74,64,2,79,39,16,209,147,129,126,26,34,71,252,255,91,13,241,179,115,231,136,33,240,85,0,157,230,225,30,173,50,231,184,3,224,36,71,53,0,110,36,97,126,11,64,252,95,174,246,217,106,152,2,215,112,22,90,77,188,78,143,198,66,223,67,2,18,120,30,129,61,3,200,214,158,167,60,66,71,143,232,176,158,159,20,255,154,119,216,1,172,120,20,107,68,28,19,192,53,182,38,128,248,249,58,64,100,23,16,19,168,247,174,225,195,193,152,135,4,36,240,60,2,123,226,103,44,91,124,158,254,232,148,3,241,215,31,235,247,182,254,71,93,230,38,110,204,96,21,114,182,13,204,163,229,55,1,196,207,110,32,187,0,174,49,183,222,187,78,15,71,242,230,220,40,1,9,156,79,224,148,248,243,221,63,79,123,50,178,237,207,215,128,135,52,121,124,117,38,157,58,34,230,173,9,240,196,143,17,212,31,4,183,78,67,222,83,226,63,53,126,170,22,199,37,112,13,4,170,216,235,251,205,56,145,150,95,246,243,61,159,185,24,1,218,68,211,209,98,180,27,45,223,211,221,41,3,
200,196,122,35,201,72,76,227,133,104,249,129,48,47,188,183,11,72,174,53,253,112,108,207,51,110,148,128,4,110,4,94,57,108,197,31,3,64,252,136,158,131,62,26,140,62,171,240,185,94,53,87,251,135,109,59,19,114,220,185,120,59,200,88,109,121,17,204,131,22,35,136,25,240,181,32,45,255,17,17,49,173,94,203,152,241,61,31,89,92,39,139,61,93,48,198,231,33,215,18,209,90,190,231,231,225,27,93,86,173,166,191,166,239,31,56,197,169,163,222,76,159,35,99,196,236,8,170,17,80,12,95,15,104,20,184,141,41,60,215,50,55,177,94,183,127,195,80,14,111,143,67,62,239,53,110,215,153,107,140,37,166,143,198,34,122,180,87,159,246,85,159,235,210,157,35,26,190,51,248,144,1,220,153,184,78,106,242,244,243,226,113,159,106,6,217,29,164,224,189,88,1,208,223,155,227,152,92,222,218,103,224,210,207,125,116,149,24,189,69,127,209,99,226,86,187,39,207,47,49,128,154,36,47,84,99,138,73,113,53,82,56,231,121,3,137,153,147,115,227,125,70,50,121,187,76,78,125,254,163,149,92,175,49,58,67,123,244,171,6,215,233,241,96,252,209,227,169,
6,64,226,250,194,233,167,184,196,20,206,57,253,196,140,39,102,190,241,253,150,78,22,111,159,69,62,255,53,70,35,137,92,59,245,89,88,151,142,58,164,207,81,133,95,251,55,87,55,255,146,248,156,35,137,34,244,122,79,198,200,149,62,177,158,215,55,144,107,117,204,254,233,69,150,205,245,176,217,106,35,122,226,51,144,126,34,26,164,159,163,142,103,236,209,72,226,167,28,121,225,189,200,88,10,206,135,55,197,213,107,117,204,254,253,5,150,201,245,49,137,110,178,246,85,63,245,26,154,101,14,71,226,205,217,205,191,123,99,245,250,177,207,247,203,167,30,121,145,26,233,239,53,94,163,206,123,234,107,122,159,4,174,145,64,213,78,244,5,135,58,254,36,46,184,202,185,71,94,108,111,126,189,150,126,34,243,233,167,109,207,51,110,124,207,72,22,215,201,98,171,13,206,57,248,60,112,36,110,251,135,139,79,249,231,18,3,120,44,127,62,180,41,46,231,137,117,124,155,43,115,140,215,249,193,191,214,117,63,165,131,170,149,202,166,142,111,239,125,210,121,167,1,164,0,10,222,59,234,120,125,83,117,124,239,62,199,36,240,86,9,
156,210,193,41,77,156,26,127,50,159,14,3,216,43,42,99,196,244,83,228,246,60,227,70,9,92,59,129,173,54,170,126,182,215,96,85,175,63,137,221,115,13,96,175,168,20,82,175,165,159,152,57,219,200,117,155,12,222,250,103,96,251,185,175,231,209,72,34,215,106,191,206,125,118,255,185,6,144,2,158,83,32,247,166,37,159,81,2,111,153,64,62,239,79,209,77,238,73,124,22,167,46,3,72,17,151,22,117,233,252,188,142,81,2,111,133,192,171,106,160,219,0,46,89,148,87,125,227,151,20,234,92,9,188,48,129,115,181,112,238,188,179,203,125,9,3,56,85,228,169,241,179,139,117,162,4,174,132,192,99,90,121,236,250,217,152,94,194,0,206,126,113,39,74,64,2,175,75,160,211,0,46,113,165,75,230,190,46,33,95,93,2,63,12,129,87,209,68,167,1,252,48,152,124,21,9,72,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,
68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,
183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,
26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,
1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,
4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,
36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,128,6,208,134,210,68,18,152,71,64,3,152,183,102,86,44,129,54,2,26,64,27,74,19,73,96,30,1,13,96,222,154,89,177,4,218,8,104,0,109,40,77,36,129,121,4,52,128,121,107,102,197,18,104,35,160,1,180,161,52,145,4,230,17,208,0,230,173,153,21,75,160,141,64,167,1,188,187,160,170,75,230,94,144,214,169,18,24,75,224,85,52,209,105,0,99,201,91,184,4,174,149,192,75,24,192,41,39,59,53,126,173,236,125,223,18,56,69,224,49,173,60,118,253,84,222,123,227,47,97,0,247,94,228,196,64,219,155,56,145,223,97,9,76,33,112,174,22,206,157,119,246,251,238,54,128,75,11,188,116,254,217,111,204,137,18,24,66,224,85,53,240,227,38,72,207,121,19,245,222,143,155,234,49,141,4,62,100,2,245,51,127,105,157,185,55,241,210,251,239,204,127,174,1,60,84,4,215,34,232,244,19,239,20,81,78,30,202,87,166,217,149,192,155,37,16,13,36,242,70,107,191,245,141,63,215,0,78,21,71,193,136,63,133,199,8,50,191,158,51,230,33,1,9,188,215,75,
88,160,159,104,40,49,215,136,245,122,29,63,187,223,97,0,219,23,219,43,148,57,140,71,248,219,57,25,223,230,242,92,2,111,153,192,86,7,121,175,151,142,231,190,139,99,167,1,80,116,10,175,253,20,133,200,115,125,43,248,140,103,174,81,2,215,72,160,234,32,26,170,17,38,57,111,225,115,137,1,212,226,182,47,94,175,165,79,140,208,51,198,125,213,8,182,121,60,151,192,181,19,136,86,18,225,145,126,98,29,123,22,175,75,12,96,251,66,41,166,70,250,105,109,69,110,95,216,115,9,188,97,2,85,79,188,205,232,105,27,115,173,70,250,23,29,79,53,128,189,34,121,225,20,249,253,234,243,223,24,16,121,226,103,39,176,186,135,57,245,156,49,15,9,72,224,70,27,225,16,45,37,162,165,244,153,67,159,35,241,230,236,230,223,189,177,122,253,216,63,215,0,146,144,152,126,146,100,108,27,99,2,204,227,90,68,79,220,230,96,142,135,4,36,240,94,27,209,8,177,138,159,243,122,45,204,234,120,198,30,141,231,26,192,94,162,188,96,34,69,210,182,66,231,188,142,109,115,229,218,118,220,115,9,92,3,129,136,185,190,215,140,69,91,137,209,88,34,247,
228,90,238,207,189,185,150,241,221,248,84,3,200,139,214,184,45,42,194,143,192,19,83,200,246,60,227,70,9,92,35,129,42,92,222,127,206,247,52,134,214,24,79,204,28,238,203,145,251,115,190,27,47,49,128,188,72,141,17,253,119,43,123,254,191,2,34,45,2,223,198,189,66,50,103,239,154,99,18,120,171,4,30,18,105,174,213,88,245,134,230,114,94,53,153,249,103,49,67,120,159,172,134,96,137,159,174,246,147,213,62,91,237,139,213,126,181,218,239,110,219,31,74,255,215,171,255,229,106,159,175,246,243,213,126,186,26,102,66,14,114,198,12,34,236,196,117,233,120,236,141,29,47,218,145,192,149,17,216,19,110,198,18,243,196,71,252,223,174,246,245,106,95,173,246,175,213,254,177,218,95,87,251,211,109,251,227,138,180,63,175,246,183,213,254,185,218,127,87,251,223,106,223,172,118,48,16,68,88,13,0,17,35,230,106,0,191,93,231,191,191,109,152,193,111,86,195,0,126,177,26,6,240,179,213,48,14,238,205,211,127,117,239,237,0,24,227,80,248,55,28,252,87,2,123,4,34,246,92,203,121,98,158,250,24,0,66,198,0,254,189,26,2,199,0,254,
178,26,38,80,13,224,239,235,252,34,3,224,169,142,192,127,185,26,6,128,240,49,1,250,24,0,227,92,207,211,31,3,136,248,17,120,68,158,184,134,142,199,222,216,241,162,29,9,92,57,129,8,189,98,200,24,145,22,19,192,0,216,5,240,100,71,224,8,29,3,224,169,143,1,96,4,156,179,3,96,151,192,60,230,99,30,15,238,0,16,54,95,1,16,58,130,199,0,16,63,173,110,255,183,79,255,136,191,138,188,246,215,237,30,18,144,192,5,4,34,126,110,137,1,196,4,182,187,128,124,13,200,46,32,6,128,49,196,0,248,10,176,107,0,60,193,243,27,64,12,224,203,53,134,1,208,34,126,76,1,115,224,107,2,191,23,112,79,190,251,199,0,214,208,113,23,64,223,67,2,18,120,30,129,24,65,53,1,158,226,236,2,16,245,127,86,67,228,136,253,175,171,177,11,192,8,232,199,0,248,186,176,107,0,8,23,17,243,61,30,81,99,0,124,191,199,0,248,33,144,167,62,13,241,51,134,248,243,244,231,190,106,0,235,244,112,248,228,15,9,163,4,158,79,32,6,64,166,152,0,6,16,19,64,220,152,0,95,5,216,242,35,124,26,125,118,6,252,78,80,13,224,240,53,34,194,79,196,0,120,162,35,110,68,
158,223,1,16,126,196,159,31,254,48,10,230,87,241,71,244,137,235,178,135,4,36,208,68,32,38,16,3,32,98,0,108,233,121,178,231,7,65,4,207,83,63,141,157,1,6,192,247,127,118,12,249,10,240,14,161,230,199,59,98,12,128,191,4,100,23,128,9,240,212,103,219,143,248,25,231,122,182,254,220,71,158,61,209,239,141,173,169,30,18,144,192,5,4,34,252,122,75,76,128,39,121,118,1,249,65,16,177,35,122,140,128,72,203,15,128,24,0,243,143,59,128,8,152,200,211,60,191,3,176,11,136,9,32,252,60,249,35,126,204,130,123,114,255,234,30,14,69,31,18,70,9,244,19,168,102,64,63,127,17,200,15,130,152,64,190,14,96,4,52,190,26,212,237,127,12,224,184,3,200,19,28,3,200,46,128,45,126,76,128,72,59,37,254,173,232,183,231,235,86,15,9,72,224,153,4,170,248,73,85,119,1,24,65,53,129,236,6,120,242,71,252,121,250,99,0,7,243,136,240,137,121,154,19,171,9,32,250,8,159,221,1,215,242,189,159,185,28,10,254,134,131,255,74,224,135,36,16,67,64,252,244,17,54,38,64,227,55,1,76,128,72,171,223,253,51,255,176,3,168,38,16,35,168,59,129,152,1,145,
22,163,168,247,173,97,15,9,72,224,21,8,100,23,112,120,162,175,215,207,78,32,187,129,26,185,150,118,48,143,136,152,186,211,143,192,179,19,192,12,210,114,45,115,137,57,106,63,99,70,9,72,224,101,8,28,4,124,155,122,207,4,216,13,164,97,2,17,62,49,247,30,119,0,183,121,118,77,32,162,79,140,248,185,71,209,135,156,81,2,175,71,224,40,232,85,2,253,42,246,109,191,206,61,10,184,10,57,2,71,240,244,19,51,158,184,46,29,14,206,61,36,32,129,215,33,16,65,243,234,233,231,41,31,51,168,177,206,187,83,113,132,157,39,125,253,29,128,191,8,240,67,96,254,26,192,159,7,109,50,240,51,240,97,125,6,162,79,180,138,102,235,143,246,209,117,116,190,251,224,206,197,76,142,9,228,135,192,252,55,2,36,183,201,192,207,192,135,247,25,64,163,17,62,186,69,195,209,115,244,189,43,254,53,239,112,212,73,185,49,63,2,230,47,1,198,155,191,136,200,65,14,31,226,103,32,122,141,126,137,85,215,183,82,255,232,163,255,11,0,0,0,255,255,3,0,56,239,133,139,217,4,225,106,0,0,0,0,73,69,78,68,174,66,96,130);


template_diamond_16
:array[0..374] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,16,0,0,0,16,8,6,0,0,0,31,243,255,97,0,0,1,62,73,68,65,84,120,1,140,146,63,75,66,81,24,198,111,127,167,104,18,132,32,145,32,68,8,161,92,2,151,134,64,40,112,106,19,135,134,192,65,208,180,8,154,114,117,80,106,15,26,156,252,6,142,45,45,125,132,10,63,66,83,77,9,254,30,241,92,14,199,115,204,7,126,247,156,243,62,239,125,239,123,206,61,81,20,214,42,214,49,28,129,230,94,5,13,178,247,160,5,77,72,129,87,161,2,73,178,235,112,1,101,168,66,2,230,228,43,176,77,214,37,212,172,236,59,230,21,216,178,98,211,169,91,96,147,232,25,52,220,68,214,215,112,10,27,182,103,23,88,195,56,129,7,208,22,92,237,18,104,67,1,226,247,226,9,193,44,232,192,50,16,82,14,67,157,236,155,4,83,64,167,124,11,69,99,44,24,75,120,250,208,142,114,212,182,164,195,81,107,121,45,150,208,27,57,175,240,179,98,37,171,245,14,232,11,139,52,192,188,135,47,37,173,235,49,211,7,99,15,210,160,189,250,244,78,240,17,70,198,180,59,80,76,191,232,28,158,64,167,110,235,147,133,46,215,16,198,198,
112,11,40,174,243,184,130,174,22,51,253,49,234,229,23,248,133,88,190,2,50,117,109,111,64,55,80,106,131,90,255,214,98,89,165,73,236,195,51,184,219,33,244,191,116,71,14,225,0,66,157,70,19,0,0,0,255,255,3,0,138,45,34,73,219,198,20,198,0,0,0,0,73,69,78,68,174,66,96,130);


template_diamond_24
:array[0..556] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,24,0,0,0,24,8,6,0,0,0,224,119,61,248,0,0,1,244,73,68,65,84,120,1,164,149,203,43,5,97,24,198,221,35,10,17,145,66,110,41,117,202,66,145,75,217,177,112,73,98,65,44,68,146,123,114,43,33,108,44,148,149,133,133,63,193,138,5,59,43,27,11,11,11,27,127,0,86,148,164,240,123,104,78,99,250,102,230,115,206,83,191,230,204,59,239,251,61,103,190,247,157,153,132,4,123,37,147,218,0,17,72,178,45,179,77,76,100,193,106,152,131,105,40,7,197,66,101,107,80,200,74,99,208,7,3,48,2,121,16,42,27,131,108,86,25,132,5,72,131,44,88,133,110,200,132,64,133,25,100,80,173,133,54,60,171,164,112,190,9,29,32,83,95,5,25,164,82,213,12,19,144,107,88,161,132,216,36,168,241,26,0,163,252,12,212,192,90,80,83,155,140,149,191,193,118,14,51,80,1,198,166,251,25,148,82,48,11,157,16,166,126,18,166,160,200,148,104,50,200,39,113,20,134,77,5,62,177,113,226,67,144,227,189,238,53,208,132,244,128,246,86,61,176,85,58,137,170,209,29,103,184,139,220,6,154,140,86,208,56,22,184,147,44,127,
151,145,183,8,141,16,109,186,99,160,6,105,26,150,65,205,141,85,245,20,46,65,196,89,192,113,146,129,254,117,11,84,58,23,99,60,222,82,119,9,143,170,119,143,150,204,218,96,31,244,79,98,209,21,69,218,133,107,248,212,2,110,3,157,171,65,189,176,11,101,240,31,221,145,188,14,231,240,238,20,122,13,20,215,168,105,236,182,64,211,97,163,23,146,214,224,4,94,33,42,147,129,46,22,131,110,85,79,169,141,246,72,58,128,39,111,178,159,129,226,85,176,3,122,82,131,116,194,197,109,120,48,37,249,25,40,87,77,215,76,111,65,59,120,245,69,224,12,54,225,6,126,154,202,241,143,130,12,148,168,87,113,23,232,246,245,246,116,235,158,147,121,184,128,15,247,5,247,239,48,3,229,234,163,162,15,206,17,232,105,151,158,65,159,206,83,120,131,184,165,23,160,246,89,211,162,70,174,128,233,27,65,56,54,233,78,43,224,24,14,193,187,93,132,226,151,222,91,117,80,3,54,91,251,227,248,13,0,0,255,255,3,0,33,198,56,170,186,253,245,199,0,0,0,0,73,69,78,68,174,66,96,130);


template_diamond_32
:array[0..739] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,32,0,0,0,32,8,6,0,0,0,115,122,122,244,0,0,2,171,73,68,65,84,120,1,188,150,75,168,78,81,20,128,127,207,220,144,75,30,133,193,127,255,59,80,76,36,19,153,144,72,73,148,1,10,197,149,174,132,235,145,119,34,74,132,132,146,20,153,201,196,64,153,26,25,27,203,192,77,76,148,137,72,121,127,31,231,220,118,231,63,239,255,119,87,125,237,179,215,90,123,237,117,246,89,123,239,211,104,212,151,177,12,93,10,139,96,76,221,48,6,169,43,45,6,158,129,99,48,175,110,144,186,9,204,97,194,83,176,1,118,192,62,232,133,202,82,39,129,169,204,50,0,59,131,217,78,240,188,13,122,2,93,169,199,170,9,76,36,234,58,112,217,147,114,8,197,10,24,151,52,228,245,171,36,96,224,85,112,17,166,165,4,109,69,182,101,180,165,227,150,118,36,232,66,24,130,126,200,146,37,24,244,233,203,114,72,234,203,38,208,100,224,73,88,147,12,144,210,223,132,238,40,204,78,177,181,169,202,36,48,131,81,131,176,165,109,116,182,98,15,166,221,48,37,219,229,159,165,40,129,9,184,109,5,3,86,57,108,140,
235,214,116,155,230,206,145,103,116,242,245,112,9,166,67,85,153,203,128,235,176,18,50,119,70,86,2,190,237,98,56,12,238,251,186,98,29,88,15,11,178,2,164,37,224,228,45,184,12,203,179,6,86,208,175,197,247,44,164,30,215,105,9,204,196,249,32,184,116,221,146,205,4,218,11,109,159,50,153,192,100,156,182,195,126,232,182,120,92,111,132,73,97,224,48,1,139,78,135,43,161,67,23,159,45,68,63,235,106,24,41,202,145,7,148,38,211,4,29,92,137,255,33,239,9,250,4,134,225,55,180,237,109,151,199,125,127,15,194,228,232,118,44,31,136,96,29,60,133,239,113,52,43,62,41,22,202,17,56,157,52,116,216,247,6,189,3,159,195,56,105,9,104,119,203,92,3,171,183,27,114,155,32,231,224,99,50,88,86,2,250,121,251,153,132,251,184,19,121,204,224,227,48,156,22,100,124,154,50,210,189,162,189,10,94,177,165,110,182,104,92,216,188,161,99,140,183,161,50,124,206,91,1,253,220,25,22,165,91,211,179,189,138,188,198,217,191,164,103,240,183,226,211,6,23,37,224,24,175,212,3,112,1,194,115,131,110,166,252,192,226,143,201,125,248,154,233,133,
161,76,2,142,247,19,156,135,65,59,5,226,22,179,118,188,69,63,21,248,150,78,192,56,253,224,73,230,31,79,158,60,192,232,229,243,46,207,41,182,229,21,97,236,19,183,22,212,13,232,3,11,51,77,158,163,188,9,158,120,165,164,236,39,136,131,121,58,250,95,232,190,110,197,202,168,125,73,235,45,250,2,126,69,186,194,166,106,2,6,236,129,1,184,101,39,146,159,180,187,224,17,124,139,116,165,154,58,9,24,184,23,60,92,188,98,21,143,238,187,240,197,206,104,201,124,38,122,8,126,243,89,163,53,105,56,143,171,231,191,94,19,234,174,100,227,15,0,0,0,255,255,3,0,101,181,77,57,74,189,225,172,0,0,0,0,73,69,78,68,174,66,96,130);


template_diamond_48
:array[0..1090] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,48,0,0,0,48,8,6,0,0,0,87,2,249,135,0,0,4,10,73,68,65,84,120,1,212,152,73,136,85,71,20,134,53,138,105,227,132,35,226,188,144,216,42,68,37,36,8,46,2,206,160,139,24,21,20,109,197,57,198,196,49,49,142,17,21,65,113,194,93,116,225,66,201,194,172,226,70,16,92,73,2,234,70,2,66,136,224,46,226,66,212,77,52,40,14,249,62,104,161,187,223,125,247,214,189,183,174,175,253,225,163,251,213,171,58,117,206,187,85,167,206,173,46,93,170,211,7,152,158,4,99,161,107,85,211,56,73,21,210,225,102,56,8,59,97,36,84,162,170,2,24,140,183,223,192,124,88,10,43,160,47,68,87,21,1,244,193,203,141,176,9,186,65,111,56,12,11,161,9,162,42,118,0,58,184,8,246,37,120,121,130,182,25,96,80,209,20,51,0,29,155,6,155,161,123,130,135,3,104,219,14,83,32,218,166,142,21,128,14,77,128,253,48,25,234,105,58,95,24,224,168,122,29,242,182,199,10,64,135,204,54,95,4,56,208,66,31,55,248,192,128,190,153,93,98,4,96,198,249,26,204,54,161,250,150,142,43,193,13,94,74,101,3,232,197,236,95,194,
6,200,179,57,63,162,191,153,106,54,244,128,194,42,19,128,14,207,4,215,125,255,2,30,120,66,255,0,159,67,225,77,93,38,0,51,142,233,178,204,41,59,181,213,134,9,160,144,138,4,224,175,53,30,182,192,167,133,102,109,63,200,167,104,102,26,222,190,57,236,83,145,0,220,180,235,224,43,40,252,232,219,184,231,82,212,94,161,114,35,111,0,61,153,104,45,108,131,152,242,135,248,17,44,55,186,231,49,156,39,128,15,49,188,24,182,230,153,32,71,223,126,244,253,9,102,64,112,70,11,13,64,131,111,203,4,151,80,85,26,131,97,51,211,39,16,228,91,72,167,183,155,214,147,54,198,166,197,76,170,124,2,38,136,17,169,189,90,191,12,9,96,24,125,247,194,156,16,131,145,250,120,74,127,7,153,231,75,86,0,131,48,98,153,176,4,222,181,118,48,225,114,72,45,55,210,2,48,227,44,0,179,78,35,228,210,181,102,154,5,117,203,141,122,1,152,202,172,44,143,194,80,104,148,62,102,226,3,224,229,64,162,175,73,141,70,254,25,156,2,95,66,26,45,157,63,2,227,146,28,73,10,96,52,29,125,159,109,78,26,208,160,54,51,147,75,121,96,199,249,147,14,12,15,44,
159,128,248,52,58,131,94,225,196,85,248,3,94,180,117,168,158,131,22,107,103,192,13,212,25,116,30,39,220,11,255,116,116,198,205,154,164,191,105,52,247,15,1,215,96,35,117,133,201,143,193,253,36,39,234,61,1,251,154,186,230,129,153,200,108,208,8,221,100,82,139,188,223,193,101,84,163,180,0,236,236,33,178,10,92,78,89,125,233,18,85,79,177,182,26,126,131,118,235,190,237,44,33,78,121,156,239,129,239,219,14,124,7,255,123,135,116,22,158,165,205,21,18,128,227,189,54,57,4,43,253,80,177,158,99,255,52,156,128,71,89,115,133,6,224,121,225,102,62,14,230,228,42,245,43,198,77,32,247,224,77,214,68,161,1,104,199,51,99,38,252,12,99,160,10,253,137,81,215,253,109,200,116,94,7,242,4,96,127,211,110,11,248,136,251,65,76,249,139,91,66,123,96,189,14,53,156,55,0,237,246,5,75,13,235,147,34,227,25,86,163,135,180,152,40,126,129,255,106,190,77,105,40,234,192,112,108,250,254,186,6,146,202,145,148,41,107,190,114,211,186,97,79,194,147,154,111,51,26,138,6,160,217,137,224,164,101,223,212,46,98,99,55,36,158,180,180,
167,170,76,0,142,157,6,102,38,111,216,138,232,50,131,188,221,187,83,100,176,99,202,4,224,120,203,141,249,96,173,50,22,242,232,22,157,119,193,117,72,44,19,66,140,149,13,192,57,44,55,214,195,97,240,214,57,68,15,232,100,141,115,9,234,150,9,33,134,98,4,224,60,190,104,120,237,34,33,178,76,56,7,214,59,165,20,43,0,157,24,13,62,5,207,137,52,89,221,250,186,106,234,44,173,152,1,104,203,139,47,247,195,244,4,207,60,89,45,19,76,191,119,19,190,47,212,20,51,0,29,240,76,152,11,23,160,227,133,192,95,180,173,129,27,16,84,38,208,47,83,177,3,112,194,38,88,10,231,253,208,170,199,252,93,6,215,224,101,107,91,167,254,99,185,97,126,255,23,204,56,235,160,39,188,87,26,133,183,103,193,141,237,21,229,123,39,151,231,72,24,82,165,231,255,3,0,0,255,255,3,0,163,122,119,127,31,86,174,57,0,0,0,0,73,69,78,68,174,66,96,130);


template_diamond_64
:array[0..1328] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,64,0,0,0,64,8,6,0,0,0,170,105,113,222,0,0,4,248,73,68,65,84,120,1,228,154,75,168,22,101,28,198,237,226,5,137,64,51,148,104,117,144,174,171,162,141,130,183,176,66,92,68,87,169,78,137,90,120,33,104,163,182,232,80,223,194,210,40,77,173,232,78,81,88,180,8,106,85,16,20,181,104,153,155,22,25,173,66,200,160,16,66,34,203,46,191,223,161,19,167,143,249,102,222,121,231,125,103,230,228,3,143,158,153,121,223,255,251,252,159,115,190,119,158,153,115,102,205,234,22,87,178,252,165,93,74,56,183,195,197,47,99,237,87,225,30,184,176,43,29,93,25,112,17,13,63,1,151,195,141,112,55,156,7,91,71,23,6,216,232,46,120,219,180,110,119,242,245,61,176,117,61,109,47,120,30,77,110,129,54,60,29,158,223,7,215,194,115,166,95,200,253,117,155,6,216,216,141,208,70,109,120,24,139,56,241,60,188,106,248,66,206,227,54,13,176,177,195,240,130,146,134,150,114,237,25,184,184,100,76,210,75,109,25,96,67,54,102,131,85,184,129,1,19,112,126,213,192,20,215,219,48,224,66,132,14,160,
141,133,98,7,3,239,135,179,67,39,196,142,203,109,128,13,60,0,183,214,20,168,174,167,224,122,152,117,83,204,105,128,194,109,192,251,125,76,19,115,152,247,44,188,6,102,67,78,3,150,161,218,93,221,70,98,97,76,62,8,199,98,11,84,205,203,101,128,130,253,17,190,164,74,64,192,245,21,140,121,20,46,8,24,91,123,72,14,3,204,245,10,54,230,166,130,113,217,141,113,110,170,130,83,117,82,27,96,204,53,215,43,56,53,6,20,28,135,73,53,167,44,102,45,243,252,112,204,229,84,18,156,79,21,83,228,234,36,213,254,41,146,202,0,119,249,181,112,84,204,77,165,217,184,252,52,188,34,85,193,84,6,24,115,221,241,21,152,27,222,22,141,212,73,226,114,10,3,234,196,220,84,230,152,42,147,196,229,166,6,152,215,21,162,160,182,225,93,97,51,44,122,178,12,214,210,196,0,99,174,121,93,33,93,64,237,123,225,77,48,38,105,78,106,142,53,96,42,230,26,118,98,107,76,10,104,248,143,143,214,47,193,232,184,28,43,222,5,205,233,77,98,46,211,147,192,184,236,163,182,255,215,70,140,1,99,172,98,62,143,90,176,182,194,176,9,43,25,22,21,151,235,26,
96,30,119,33,243,121,223,224,99,183,251,81,173,184,92,199,0,11,187,64,142,152,75,217,36,24,80,229,86,24,220,87,232,64,199,141,195,1,236,51,140,203,7,224,170,80,145,161,6,172,166,160,49,215,5,250,142,37,8,220,15,47,15,17,26,98,128,185,219,252,221,70,204,13,209,28,50,198,187,212,227,33,154,171,12,48,230,154,187,163,239,179,204,237,10,254,230,233,49,56,191,76,64,153,1,78,156,128,93,196,220,50,205,117,174,185,105,111,134,35,227,114,153,1,119,48,209,2,51,25,246,183,23,94,55,170,137,145,206,48,225,98,232,143,81,31,210,222,40,253,33,231,191,99,208,107,240,167,162,193,101,15,17,154,179,29,30,130,101,63,41,69,117,251,114,238,20,66,238,132,31,193,191,138,68,149,25,224,120,247,129,39,225,131,30,204,48,252,129,222,135,224,139,208,175,11,81,101,128,147,188,253,89,196,143,195,76,130,223,184,1,252,181,76,116,136,1,206,55,84,188,3,103,202,237,240,61,180,110,133,133,159,123,206,255,139,80,3,156,176,6,190,13,151,120,208,99,124,129,182,77,240,155,16,141,117,12,112,35,220,0,223,132,125,141,196,223,
163,237,118,168,9,65,168,99,128,5,231,194,157,112,143,7,61,195,25,244,220,7,223,133,127,134,106,171,107,128,117,23,64,55,24,159,191,251,2,111,113,187,160,111,169,126,171,35,42,198,0,235,251,54,232,8,92,233,65,15,240,50,26,52,224,231,186,90,98,13,112,157,107,225,7,80,51,186,196,103,44,62,14,143,199,136,104,98,128,115,215,65,63,115,190,157,237,2,223,178,232,45,240,171,216,197,155,24,224,154,93,198,229,83,172,95,26,115,67,76,105,106,128,107,116,17,151,221,229,141,185,47,192,145,49,151,107,149,72,97,128,139,248,226,228,45,216,214,187,131,231,88,235,97,248,11,108,132,84,6,40,194,87,103,38,197,220,113,217,152,187,13,254,8,27,35,165,1,138,185,30,186,41,46,242,32,3,142,82,243,46,120,44,85,237,212,6,24,151,55,65,159,30,83,199,229,19,212,188,27,126,10,147,33,181,1,10,203,17,151,207,80,183,118,204,13,113,41,135,1,174,107,92,246,23,150,27,61,72,128,9,106,248,106,254,116,130,90,255,41,145,203,0,23,25,131,111,192,21,176,9,94,97,178,59,254,201,38,69,70,205,205,105,128,107,54,141,203,159,83,
195,191,60,139,138,185,10,168,66,110,3,172,127,51,244,206,48,167,74,204,208,117,155,118,238,151,67,231,147,30,230,54,64,177,179,225,118,232,158,224,93,34,4,198,220,13,240,67,88,248,54,55,164,72,200,152,54,12,80,71,157,184,156,44,230,246,201,0,181,44,134,33,113,57,89,204,237,155,1,234,185,26,190,15,151,122,80,128,143,57,119,47,252,161,224,90,150,83,109,125,4,166,196,187,158,15,76,71,224,112,92,62,202,57,147,222,215,176,53,180,109,128,141,77,197,101,255,188,205,247,9,194,7,27,55,189,79,60,56,27,48,143,38,247,65,119,248,223,225,22,24,122,135,96,232,255,3,11,105,227,117,248,8,244,249,225,172,132,38,116,245,62,113,210,240,191,1,0,0,255,255,3,0,30,51,150,206,212,183,143,245,0,0,0,0,73,69,78,68,174,66,96,130);


template_diamond_256
:array[0..4762] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,1,0,0,0,1,0,8,6,0,0,0,92,114,168,102,0,0,18,98,73,68,65,84,120,1,236,157,77,203,44,71,21,199,159,196,27,20,69,93,196,69,68,77,200,69,17,33,184,16,241,21,66,238,141,38,234,38,139,32,33,160,4,20,124,89,73,62,132,251,136,11,87,113,173,31,193,87,80,220,250,9,20,63,129,130,10,10,46,4,207,241,62,61,243,76,79,77,79,85,117,189,156,58,245,107,40,102,186,187,186,186,234,119,106,254,221,245,175,122,238,189,185,97,131,0,4,32,0,129,233,8,60,37,45,126,78,210,211,146,158,144,244,152,36,182,201,8,60,62,89,123,105,238,35,2,207,200,199,235,146,222,148,244,93,73,159,150,132,0,8,132,217,54,4,96,182,136,223,220,124,64,154,252,85,73,223,144,244,138,36,21,130,215,36,221,151,196,54,25,1,4,96,174,128,191,79,154,251,64,210,215,37,125,82,210,147,146,158,149,244,53,73,47,75,82,113,96,155,136,0,2,48,79,176,223,35,77,125,40,233,155,146,62,39,233,158,164,101,211,167,255,171,146,84,28,84,36,216,38,33,128,0,204,17,232,119,75,51,245,199,255,198,237,167,238,223,
221,222,33,59,159,149,164,226,160,249,84,44,216,38,32,128,0,248,15,114,236,143,251,154,72,248,39,53,97,11,17,0,255,65,191,47,77,140,125,189,191,59,76,208,55,2,21,15,54,199,4,16,0,199,193,149,166,169,169,247,210,109,138,53,248,22,163,80,69,67,197,131,205,49,1,4,192,111,112,247,252,144,115,132,195,47,73,199,45,67,0,124,6,87,199,243,47,72,210,185,254,220,87,121,125,250,199,14,29,36,43,219,136,4,16,128,17,163,182,93,231,197,244,211,31,255,11,146,214,142,255,246,213,199,179,165,202,57,150,200,55,115,4,16,0,115,33,217,93,161,146,79,238,18,111,18,187,27,68,1,245,8,32,0,245,216,246,40,185,198,216,125,143,151,208,131,1,247,76,32,128,0,36,192,50,158,181,230,15,181,134,176,24,199,57,71,245,16,0,31,113,110,49,127,95,114,104,225,131,186,131,86,32,0,227,7,177,213,10,190,197,20,100,185,240,248,125,230,208,2,4,224,128,98,200,47,173,127,148,173,196,102,200,96,140,88,105,4,96,196,168,29,235,220,227,181,188,197,112,227,216,66,190,85,37,128,0,84,197,91,181,240,158,198,92,77,195,177,42,52,10,63,37,
128,0,156,242,24,101,207,194,15,176,167,0,141,18,39,243,245,68,0,204,135,232,172,130,150,22,231,244,24,130,156,1,225,64,62,1,4,32,159,93,143,43,23,211,111,239,50,223,82,117,183,86,159,82,237,154,166,28,4,96,172,80,91,124,226,90,122,35,25,43,154,6,106,139,0,24,8,66,100,21,44,143,185,45,120,18,145,24,201,118,151,0,2,112,151,134,221,239,35,252,192,44,11,148,221,200,118,174,25,2,208,57,0,17,183,31,233,21,219,226,16,37,2,241,188,89,16,0,219,177,31,205,100,27,173,190,182,163,223,160,118,8,64,3,200,59,110,49,226,19,117,164,55,150,29,161,241,113,41,2,96,55,142,35,143,169,71,240,44,236,70,190,97,205,16,128,134,176,19,110,229,225,7,52,178,128,37,132,106,236,172,8,128,189,248,121,250,99,155,17,135,48,246,122,68,197,26,33,0,21,225,102,20,173,227,231,135,146,46,253,23,94,25,69,118,189,100,49,5,249,55,4,186,134,225,242,205,17,128,203,108,90,159,241,250,99,241,38,106,173,251,69,213,251,33,0,85,241,38,21,126,95,114,123,253,119,248,61,13,107,146,130,106,61,51,2,96,35,66,51,24,102,30,140,77,27,
189,165,96,45,16,128,130,48,51,139,154,233,135,49,131,208,101,118,131,62,151,33,0,125,184,47,119,157,113,209,140,231,161,206,18,215,97,62,17,128,126,161,90,76,63,43,127,219,223,138,196,172,237,110,197,55,233,62,8,64,18,174,162,153,103,126,18,206,248,230,83,180,243,148,42,12,1,40,69,50,173,28,198,194,55,55,51,121,31,105,189,163,97,110,4,160,33,236,219,91,209,241,143,204,17,194,35,139,46,223,16,128,182,216,153,15,63,231,61,243,80,232,156,70,227,35,8,64,59,224,172,136,11,179,94,76,65,150,11,135,249,84,61,138,0,84,197,123,40,156,78,126,64,17,252,130,56,6,177,212,63,136,0,212,103,172,119,224,53,247,58,103,134,71,215,25,21,207,129,0,20,71,122,86,32,70,215,25,146,139,7,48,72,47,162,169,115,2,1,168,195,117,41,149,14,189,144,136,255,68,48,227,89,237,206,137,0,236,70,120,177,0,22,187,92,68,115,245,4,67,166,171,136,202,100,64,0,202,112,92,151,178,152,126,179,45,243,93,115,200,221,135,95,46,185,196,235,16,128,68,96,145,217,121,130,69,130,218,200,198,27,212,6,156,82,167,16,128,82,36,143,229,
48,134,61,178,216,251,13,15,101,47,193,43,215,35,0,87,0,37,158,166,195,38,2,139,200,142,160,70,64,202,205,130,0,228,146,59,191,142,121,236,115,38,165,142,48,164,42,69,114,85,14,2,176,2,146,185,203,74,182,76,112,145,151,45,166,32,203,133,35,129,197,102,67,0,98,73,93,206,71,231,188,204,166,228,25,68,182,36,205,219,178,16,128,253,80,121,61,221,207,48,182,4,134,89,177,164,34,243,33,0,145,160,46,100,195,160,186,0,166,226,97,140,214,130,112,17,128,124,152,116,196,124,118,123,175,68,120,247,18,188,189,30,1,200,3,201,34,149,60,110,37,175,98,232,85,128,38,2,144,14,113,49,253,88,230,155,206,174,228,21,196,161,0,77,4,32,29,34,79,158,116,102,181,174,224,77,108,39,89,4,32,13,32,99,207,52,94,45,114,227,197,236,160,140,0,196,195,163,163,197,179,106,157,19,97,206,36,142,0,196,129,99,254,57,142,83,207,92,12,205,50,232,35,0,215,161,177,2,237,58,35,11,57,22,83,144,229,194,9,209,64,0,182,97,209,169,182,249,88,59,139,88,39,70,4,1,216,6,198,107,229,54,31,139,103,25,174,37,68,5,1,184,12,11,99,233,50,
27,235,103,48,108,35,35,132,0,132,65,209,129,194,92,70,58,138,128,71,68,11,1,56,135,196,226,146,115,38,163,30,97,8,119,37,114,8,192,41,160,197,244,99,153,239,41,151,81,247,136,231,149,200,33,0,167,128,120,98,156,242,240,176,199,27,221,70,20,17,128,35,28,198,140,71,22,222,190,225,233,92,136,40,2,240,8,12,29,228,66,7,113,116,24,129,15,4,19,1,184,185,225,21,49,208,49,156,30,98,136,183,10,236,236,2,128,73,180,234,16,206,119,137,247,42,192,179,11,0,79,132,85,135,152,96,151,55,190,59,65,158,89,0,24,19,222,233,8,147,125,197,243,185,13,248,172,2,64,7,152,236,23,31,104,46,15,0,129,50,163,0,240,199,34,129,95,195,164,135,166,31,2,206,38,0,58,254,123,40,233,141,219,79,221,103,155,151,192,98,10,78,251,111,8,204,36,0,211,7,123,222,223,249,102,203,167,126,40,204,36,0,247,165,27,188,42,233,129,36,245,0,216,32,176,16,152,118,88,56,139,0,96,248,44,93,157,207,75,4,166,52,134,103,16,128,41,3,123,169,151,115,124,147,192,116,15,10,239,2,192,162,143,205,254,206,201,0,129,169,134,138,158,5,96,49,253,
248,219,254,64,47,231,208,69,2,83,245,27,207,2,48,149,146,95,236,206,156,200,33,48,205,155,163,87,1,152,110,44,151,211,203,185,102,147,192,20,222,145,71,1,152,34,112,155,93,151,147,165,8,184,127,144,120,19,128,105,231,115,75,245,120,202,57,35,224,122,40,233,73,0,166,94,209,117,214,109,57,80,138,192,98,10,186,92,46,236,69,0,92,7,169,84,79,166,156,108,2,110,31,46,94,4,192,245,107,90,118,183,229,194,146,4,92,14,47,61,8,128,123,163,166,100,47,166,172,93,4,220,25,204,163,11,128,187,128,236,234,158,92,220,130,128,171,7,206,200,2,48,205,98,141,22,189,154,123,36,17,112,51,228,28,85,0,22,211,143,101,190,73,253,150,204,133,8,184,233,127,163,10,128,27,5,46,212,33,41,166,61,1,23,111,160,35,10,128,171,49,88,251,126,203,29,11,18,24,222,131,26,77,0,134,7,94,176,243,81,148,13,2,67,63,144,70,18,0,151,243,176,54,250,48,181,216,73,96,216,33,233,40,2,224,118,37,214,206,142,199,229,54,8,44,166,224,112,203,133,71,16,128,97,225,218,232,155,212,162,17,129,33,31,82,35,8,192,176,175,87,141,58,30,183,177,
67,96,184,97,170,117,1,24,218,96,177,211,47,169,73,67,2,67,25,213,150,5,96,40,144,13,59,24,183,178,79,96,152,7,151,85,1,112,177,200,194,126,63,165,134,21,9,12,49,116,181,40,0,139,233,199,50,223,138,189,147,162,171,19,24,162,31,91,20,128,33,148,179,122,247,225,6,30,8,152,127,147,181,38,0,195,140,157,60,244,78,218,208,132,128,105,47,203,146,0,152,6,213,164,171,112,19,175,4,204,62,216,172,8,192,112,243,167,94,123,42,237,170,70,192,228,208,214,130,0,12,185,130,170,90,55,161,96,175,4,22,83,208,212,114,225,222,2,96,18,138,215,30,72,187,186,19,48,247,176,235,45,0,38,95,139,186,119,19,42,224,153,128,169,225,110,79,1,48,107,140,120,238,125,180,205,4,1,51,134,119,47,1,48,3,192,68,119,160,18,51,18,48,241,0,236,33,0,230,23,71,204,216,27,105,115,23,2,221,135,192,173,5,96,49,253,88,230,219,165,191,113,83,99,4,186,255,30,90,11,64,119,197,51,214,1,168,14,4,186,190,17,183,20,0,19,99,30,250,27,4,12,18,184,235,137,61,219,178,126,173,4,224,189,210,168,7,146,94,149,164,111,1,108,16,128,192,41,129,
229,1,249,178,28,126,242,244,84,189,189,22,2,112,79,170,255,69,73,175,75,250,140,36,29,247,176,65,0,2,231,4,244,225,248,138,164,47,72,122,231,249,233,242,71,90,8,192,135,164,218,47,73,82,17,208,69,16,108,16,128,64,152,128,62,28,63,37,233,69,73,31,12,103,41,123,180,133,0,188,95,170,252,17,73,58,206,97,131,0,4,182,9,232,67,242,195,146,154,252,94,90,188,142,191,75,26,243,9,73,31,151,196,27,128,64,96,131,192,6,129,127,200,185,63,72,250,157,164,191,111,228,43,114,234,177,34,165,108,23,162,30,192,151,36,125,71,146,14,5,16,1,129,192,6,129,0,129,255,202,177,223,74,250,177,164,95,74,250,143,164,170,91,11,1,208,6,232,44,192,87,36,125,95,210,243,146,90,188,121,200,109,216,32,48,20,129,63,73,109,127,36,233,103,146,254,214,162,230,173,4,64,219,162,211,28,175,73,250,129,164,143,73,98,131,0,4,142,4,254,42,95,127,46,233,45,73,127,62,30,174,251,173,165,0,104,75,244,135,175,2,160,66,160,130,192,6,1,8,220,220,252,83,32,252,66,210,79,36,253,94,146,14,5,154,108,173,5,64,95,253,117,8,160,67,1,93,240,
208,196,233,148,251,176,65,192,42,129,127,75,197,126,45,233,237,219,79,221,111,182,181,22,0,109,152,174,125,86,83,240,219,183,159,186,207,6,129,25,9,232,147,94,159,248,250,228,215,55,0,125,19,104,186,245,16,0,109,160,62,249,245,13,0,83,80,105,176,205,74,96,49,253,116,236,175,30,64,243,173,151,0,104,67,49,5,155,135,155,27,26,34,176,152,126,234,250,171,16,116,217,122,10,128,54,24,83,176,75,216,185,105,103,2,221,76,191,117,187,123,11,0,166,224,58,34,236,123,39,240,47,105,224,175,36,253,84,210,111,36,53,53,253,228,126,39,91,111,1,208,202,168,9,248,162,164,111,73,250,178,36,86,10,10,4,54,151,4,244,199,174,63,122,253,241,171,8,168,24,116,221,44,8,128,2,208,31,189,254,248,85,4,84,12,152,25,16,8,108,174,8,116,119,252,67,52,173,8,128,214,141,153,129,80,132,56,230,133,64,119,199,63,4,210,146,0,104,253,152,25,8,69,137,99,163,19,48,225,248,135,32,90,19,0,173,35,51,3,161,72,113,108,84,2,102,28,255,16,64,139,2,192,204,64,40,82,28,27,145,64,215,101,190,49,192,44,10,128,214,155,229,194,49,209,
35,143,101,2,38,77,191,53,48,171,2,160,245,196,20,92,71,139,253,145,8,152,52,253,214,0,45,11,128,214,21,83,112,29,49,246,71,32,96,214,244,91,195,179,46,0,90,95,76,193,117,212,216,183,76,192,180,233,183,6,55,130,0,96,10,174,163,198,190,85,2,166,150,249,198,64,26,65,0,180,29,44,23,142,137,38,121,122,18,48,183,204,55,6,198,40,2,160,109,97,185,112,76,68,201,211,131,192,16,142,127,8,204,72,2,160,245,103,102,32,20,69,142,245,38,48,132,227,31,130,52,154,0,104,27,152,25,8,69,146,99,189,8,12,227,248,135,0,141,40,0,218,14,102,6,66,209,228,88,107,2,67,57,254,33,56,163,10,0,51,3,161,104,114,172,37,1,243,203,124,99,96,140,42,0,218,54,150,11,199,68,152,60,53,8,12,107,250,173,97,140,44,0,218,22,76,193,117,68,217,111,65,96,88,211,111,13,103,116,1,208,246,96,10,174,163,202,126,77,2,67,155,126,107,48,30,4,64,219,132,41,184,142,44,251,53,8,12,111,250,173,161,120,17,0,76,193,117,100,217,47,77,96,184,101,190,49,0,188,8,128,182,149,229,194,49,17,39,79,14,129,33,151,249,198,52,212,147,0,104,123,89,
46,28,19,117,242,164,16,112,227,248,135,26,237,77,0,180,141,204,12,132,34,205,177,92,2,110,28,255,16,0,143,2,160,237,100,102,32,20,109,142,165,18,112,229,248,135,26,239,85,0,180,173,204,12,132,34,206,177,88,2,238,28,255,80,195,61,11,0,51,3,161,136,115,44,134,128,139,101,190,49,13,245,44,0,218,126,150,11,199,244,2,242,220,37,224,218,244,187,219,80,253,238,93,0,180,141,152,130,74,129,45,150,128,107,211,111,13,97,6,1,208,54,99,10,174,35,207,126,136,128,123,211,111,221,232,89,4,64,219,141,41,184,142,62,251,119,9,76,97,250,221,109,176,126,159,73,0,48,5,215,209,103,127,33,224,114,153,239,210,184,173,207,153,4,64,57,176,92,120,171,55,204,121,206,237,50,223,152,112,206,38,0,202,132,229,194,49,61,99,142,60,83,57,254,161,144,206,40,0,202,129,153,129,80,111,152,239,216,84,142,127,40,188,179,10,128,178,96,102,32,212,35,230,57,54,157,227,31,10,237,204,2,160,60,152,25,8,245,10,255,199,166,116,252,67,97,157,93,0,152,25,8,245,10,223,199,166,89,230,27,19,198,217,5,64,25,177,92,56,166,167,248,
200,51,189,233,183,14,35,2,240,136,8,166,224,186,103,248,220,159,222,244,91,135,21,1,56,18,193,20,60,178,240,248,13,211,47,16,85,4,224,20,10,166,224,41,15,47,123,152,126,23,34,137,0,156,130,193,20,60,229,225,97,15,211,111,35,138,8,192,57,28,76,193,115,38,163,30,193,244,187,18,57,4,32,12,8,83,48,204,101,180,163,152,126,87,34,134,0,92,6,132,41,120,153,205,8,103,48,253,34,162,132,0,108,67,194,20,220,230,99,245,44,166,95,100,100,16,128,109,80,152,130,219,124,44,158,157,246,111,251,115,130,129,0,92,167,198,191,33,112,157,145,149,28,83,255,109,127,78,16,16,128,56,106,252,27,2,113,156,122,230,194,241,207,160,143,0,196,67,99,102,32,158,85,143,156,56,254,25,212,17,128,52,104,204,12,164,241,106,149,27,199,63,147,52,2,144,14,142,153,129,116,102,53,175,192,241,223,65,23,1,72,135,199,204,64,58,179,90,87,176,204,119,39,89,4,32,15,32,203,133,243,184,149,188,10,211,175,0,77,4,32,31,34,166,96,62,187,18,87,98,250,21,160,136,0,236,131,136,41,184,143,95,238,213,152,126,185,228,86,215,33,0,43,32,
25,187,152,130,25,208,118,92,130,233,183,3,222,250,82,4,96,77,36,125,31,83,48,157,89,238,21,44,243,205,37,119,225,58,4,224,2,152,196,195,44,23,78,4,150,145,157,101,190,25,208,174,93,130,0,92,35,20,127,158,229,194,241,172,82,115,226,248,167,18,139,204,143,0,68,130,138,204,198,204,64,36,168,196,108,56,254,137,192,98,179,35,0,177,164,226,243,49,51,16,207,42,38,39,142,127,12,165,204,60,8,64,38,184,43,151,49,51,112,5,80,228,105,28,255,72,80,185,217,16,128,92,114,219,215,49,51,176,205,39,230,44,203,124,99,40,237,204,131,0,236,4,184,113,57,203,133,55,224,92,57,133,233,119,5,80,169,211,8,64,41,146,225,114,48,5,195,92,174,29,197,244,187,70,168,208,121,4,160,16,200,141,98,48,5,55,224,4,78,97,250,5,160,212,58,132,0,212,34,123,90,46,166,224,41,143,75,123,152,126,151,200,84,58,142,0,84,2,187,42,22,83,112,5,36,176,203,50,223,0,148,218,135,16,128,218,132,143,229,179,92,248,200,98,253,141,101,190,107,34,141,246,17,128,70,160,111,111,195,114,225,115,222,56,254,231,76,154,29,65,0,154,161,62,220,
136,153,129,3,138,255,127,193,241,63,229,209,116,15,1,104,138,251,112,51,102,6,30,161,192,241,63,116,137,62,95,16,128,62,220,245,174,179,207,12,224,248,247,235,123,135,59,35,0,7,20,205,191,204,60,51,192,50,223,230,221,45,124,67,4,32,204,165,213,209,25,151,11,99,250,181,234,93,17,247,65,0,34,32,85,206,50,155,41,136,233,87,185,67,165,20,143,0,164,208,170,151,119,22,83,16,211,175,94,31,202,42,25,1,200,194,86,229,34,239,166,32,166,95,149,110,179,175,80,4,96,31,191,146,87,123,54,5,89,230,91,178,167,20,44,11,1,40,8,179,64,81,30,151,11,179,204,183,64,199,168,85,4,2,80,139,108,126,185,158,150,11,227,248,231,247,131,38,87,34,0,77,48,39,223,196,203,204,0,142,127,114,232,219,94,128,0,180,229,157,114,183,209,103,6,112,252,83,162,221,41,47,2,208,9,124,228,109,71,157,25,192,241,143,12,112,239,108,8,64,239,8,108,223,127,196,153,1,150,249,110,199,212,212,89,4,192,84,56,130,149,25,105,185,48,166,95,48,132,118,15,34,0,118,99,115,183,102,163,152,130,152,126,119,163,54,192,119,4,96,128,32,221,86,
209,186,41,136,233,55,78,95,58,212,20,1,56,160,24,226,139,85,83,16,211,111,136,238,115,94,73,4,224,156,137,229,35,22,77,65,76,63,203,61,230,74,221,16,128,43,128,12,158,182,100,10,98,250,25,236,32,41,85,66,0,82,104,217,201,107,197,20,196,244,179,211,39,178,106,130,0,100,97,51,113,81,111,83,16,211,207,68,55,216,87,9,4,96,31,191,222,87,247,50,5,49,253,122,71,190,208,253,17,128,66,32,59,21,211,195,20,228,111,251,59,5,187,198,109,17,128,26,84,219,150,217,242,223,16,224,111,251,219,198,182,250,221,16,128,234,136,155,220,160,197,191,33,128,227,223,36,148,109,111,130,0,180,229,93,243,110,181,103,6,112,252,107,70,175,83,217,8,64,39,240,149,110,91,107,102,0,199,191,82,192,122,23,139,0,244,142,64,249,251,151,158,25,192,241,47,31,35,51,37,34,0,102,66,81,172,34,37,103,6,88,230,91,44,44,54,11,66,0,108,198,101,111,173,74,44,23,198,244,219,27,133,1,174,71,0,6,8,82,102,21,247,154,130,152,126,153,224,71,186,12,1,24,41,90,233,117,205,53,5,49,253,210,89,15,121,5,2,48,100,216,146,42,157,106,10,98,
250,37,225,29,59,51,2,48,118,252,98,106,159,98,10,178,204,55,134,168,163,60,8,128,163,96,110,52,37,102,185,48,203,124,55,0,122,61,133,0,120,141,236,121,187,182,150,11,227,248,159,243,154,226,8,2,48,69,152,15,141,92,102,6,190,39,71,158,151,116,239,246,12,142,255,1,17,95,32,224,155,128,206,12,168,0,252,81,146,186,253,127,145,244,150,164,143,74,98,131,0,4,38,32,240,140,180,241,77,73,111,75,250,161,164,207,75,122,92,18,27,4,32,48,9,129,167,164,157,207,73,122,90,210,19,146,24,14,10,4,54,8,64,0,2,16,128,0,4,32,224,159,192,255,4,0,0,0,255,255,3,0,61,48,12,100,234,59,5,154,0,0,0,0,73,69,78,68,174,66,96,130);



template_diamond2_16
:array[0..370] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,16,0,0,0,16,8,6,0,0,0,31,243,255,97,0,0,1,58,73,68,65,84,120,1,148,146,63,75,66,81,24,198,213,108,144,8,130,64,130,136,130,136,160,65,28,196,104,112,104,16,218,154,10,138,150,106,105,232,15,161,139,96,8,225,212,224,100,141,46,226,215,104,176,175,224,42,225,87,112,208,69,204,223,35,190,114,187,157,123,195,7,126,156,115,223,231,189,239,57,231,61,39,18,9,86,12,43,3,105,208,220,169,64,131,236,29,120,134,7,216,2,167,130,10,36,201,190,131,75,184,129,91,88,135,63,114,21,88,37,235,10,180,186,169,200,228,2,86,44,96,163,191,192,50,70,30,30,33,110,73,140,137,89,236,216,23,255,213,156,37,204,28,188,192,54,248,181,71,160,12,71,48,95,216,38,81,130,251,160,149,213,245,32,29,98,220,195,174,37,88,129,77,2,79,112,106,70,200,120,134,167,155,217,80,142,182,45,169,57,218,90,22,180,155,48,141,49,191,102,12,188,201,58,99,21,206,33,76,77,204,10,124,43,201,219,233,46,223,117,80,3,117,86,151,218,4,223,161,103,166,119,7,138,169,224,9,212,64,59,242,170,
195,71,1,62,97,100,134,191,128,226,234,199,53,188,129,238,95,234,131,126,110,193,16,254,149,158,237,43,252,128,154,86,130,53,88,72,234,69,3,62,64,215,188,176,244,70,82,112,0,174,163,78,11,78,0,0,0,255,255,3,0,58,75,35,69,151,176,138,247,0,0,0,0,73,69,78,68,174,66,96,130);


template_diamond2_24
:array[0..564] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,24,0,0,0,24,8,6,0,0,0,224,119,61,248,0,0,1,252,73,68,65,84,120,1,164,149,203,43,69,81,20,198,189,35,133,34,20,137,110,36,145,18,145,145,68,30,25,72,34,74,174,87,17,50,161,188,202,163,100,100,96,98,224,47,80,230,140,148,41,49,49,53,194,196,196,76,73,158,191,239,102,215,185,199,57,247,108,215,87,191,123,238,217,123,173,253,221,125,214,58,251,38,36,216,43,153,208,58,168,134,36,219,52,219,192,68,22,12,193,12,76,65,9,104,44,80,182,6,249,172,52,2,253,48,8,67,144,11,129,178,49,200,98,149,94,152,131,28,40,128,89,232,130,76,136,169,32,131,116,178,59,97,17,180,184,81,17,95,150,160,21,210,204,160,215,53,150,65,10,9,77,48,9,122,254,110,169,216,170,135,10,175,6,240,148,159,129,10,88,1,211,208,14,94,5,213,88,15,200,164,204,39,198,183,221,138,127,18,85,208,88,146,201,56,132,65,181,249,37,175,29,168,59,134,33,252,43,218,127,64,187,24,128,108,119,136,219,64,93,161,238,152,0,103,81,221,121,238,123,181,177,106,213,6,25,206,73,167,65,42,19,205,
160,118,44,119,6,89,126,175,249,201,173,231,170,6,137,200,24,232,89,214,194,2,52,70,102,226,251,104,33,109,30,42,77,186,105,47,25,228,129,118,80,101,38,227,188,94,145,119,14,79,202,215,194,70,50,147,193,54,180,64,60,58,33,105,19,174,225,19,162,12,116,175,2,117,195,6,232,153,254,69,151,4,111,193,25,188,154,68,231,14,204,152,90,109,20,214,64,221,97,163,7,130,180,243,35,120,118,38,120,25,104,190,16,212,77,50,9,210,27,1,218,241,33,68,158,187,51,193,207,64,227,33,88,129,49,240,139,251,96,238,0,246,224,30,190,32,74,126,137,10,82,209,27,96,21,116,230,184,99,181,216,49,236,194,13,68,138,202,53,74,238,164,168,73,110,116,20,119,192,14,184,139,126,193,216,58,156,195,59,120,42,200,64,73,58,62,250,64,191,84,255,3,210,45,44,195,41,188,192,191,165,151,80,245,120,132,59,208,27,255,151,179,138,240,216,210,78,75,97,31,204,78,108,118,79,184,189,146,8,213,49,162,131,208,122,241,111,0,0,0,255,255,3,0,32,83,59,63,116,190,151,80,0,0,0,0,73,69,78,68,174,66,96,130);


template_diamond2_32
:array[0..749] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,32,0,0,0,32,8,6,0,0,0,115,122,122,244,0,0,2,181,73,68,65,84,120,1,188,151,75,136,78,97,24,199,63,102,92,115,143,5,163,102,138,97,65,73,22,12,133,38,37,41,164,80,38,229,126,139,73,185,55,148,97,72,97,106,22,22,178,181,177,177,178,80,86,54,86,22,202,66,44,229,146,133,164,164,38,185,252,126,147,57,157,206,119,110,239,241,205,252,235,215,119,206,251,189,207,243,254,191,115,158,247,57,231,171,213,170,171,137,208,101,176,24,198,86,77,83,53,112,12,11,182,194,73,56,10,115,161,146,170,26,152,195,106,7,97,15,236,133,221,48,3,130,85,197,192,84,86,217,9,71,96,60,184,112,55,108,131,201,16,164,80,3,19,200,222,9,94,246,89,177,149,230,115,172,161,14,104,142,141,23,30,134,24,48,177,11,156,129,37,41,153,87,49,118,26,150,67,233,188,101,39,90,116,11,193,95,185,6,178,180,145,47,14,129,5,106,76,161,202,26,240,18,31,135,237,144,151,216,124,187,96,63,204,134,66,149,49,48,147,44,93,112,0,44,186,34,77,99,194,9,216,1,22,108,174,138,12,88,116,155,193,95,
20,82,225,238,140,195,208,9,185,69,153,103,96,28,193,235,225,60,180,67,168,236,146,198,174,132,76,19,89,6,188,207,75,193,251,238,103,85,185,107,142,193,2,72,173,157,52,3,78,108,3,219,236,22,248,95,217,37,221,61,182,235,58,19,105,6,172,222,125,96,225,53,66,46,106,1,155,111,122,50,97,210,192,20,38,216,82,203,86,124,50,95,214,185,59,195,162,180,79,76,138,79,138,27,176,232,54,128,221,108,94,124,82,131,142,109,100,103,97,53,52,13,231,140,14,24,208,76,11,172,133,145,48,64,218,218,91,120,2,239,225,15,212,21,197,68,198,182,66,31,232,184,145,122,73,178,30,120,10,63,135,19,215,85,37,95,216,68,236,231,151,192,123,215,8,125,38,201,21,120,0,223,33,82,154,1,199,220,50,62,245,78,65,218,28,134,75,107,144,153,55,224,46,124,73,70,101,37,119,124,17,92,134,174,100,80,192,185,247,249,30,220,132,119,48,116,223,249,140,148,101,192,9,205,96,27,189,5,29,80,69,22,220,5,120,5,191,211,18,228,25,112,190,38,124,24,245,130,189,61,68,207,153,236,21,124,6,191,178,2,139,12,24,231,35,213,151,207,235,96,129,150,
209,39,38,157,131,71,240,35,47,160,140,1,227,125,11,238,254,71,209,206,176,226,111,195,125,248,6,185,42,107,192,121,109,112,17,108,211,241,14,202,105,36,47,245,0,220,129,143,209,104,206,65,89,3,166,112,209,21,208,11,155,32,77,15,25,188,10,175,161,174,226,211,2,66,12,24,111,81,174,131,62,240,45,56,46,59,156,69,247,2,50,139,46,30,224,113,168,1,99,124,53,243,143,201,53,240,101,85,189,129,30,120,12,131,48,226,114,55,248,100,251,10,31,192,214,237,163,124,84,213,194,106,253,96,77,184,75,70,93,22,101,59,180,66,149,91,57,100,248,47,0,0,0,255,255,3,0,180,45,81,145,187,144,59,79,0,0,0,0,73,69,78,68,174,66,96,130);


template_diamond2_48
:array[0..1231] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,48,0,0,0,48,8,6,0,0,0,87,2,249,135,0,0,4,151,73,68,65,84,120,1,204,152,217,171,85,85,28,199,181,44,42,203,129,82,202,41,189,89,104,74,40,102,97,81,14,169,56,225,152,165,57,157,235,213,75,80,52,152,86,255,65,20,21,61,20,21,37,213,67,130,111,133,8,250,18,215,23,233,165,64,68,4,7,168,151,20,45,141,68,108,52,63,159,232,200,221,231,236,105,237,179,247,185,126,225,227,61,103,13,191,181,126,123,175,223,111,253,142,253,250,85,167,1,152,190,31,58,224,186,170,150,169,202,176,118,221,248,102,88,11,35,160,63,148,174,42,28,112,163,195,97,37,172,130,53,176,8,134,64,233,170,194,129,65,236,114,9,108,130,187,193,99,84,131,153,112,11,148,170,178,29,112,131,179,160,11,38,128,111,195,53,102,64,55,60,4,55,66,105,42,211,129,27,216,213,20,216,8,211,98,118,248,56,109,27,64,199,174,143,233,47,212,84,150,3,110,232,94,112,243,79,128,206,52,106,32,13,198,194,106,24,5,165,4,117,25,14,184,17,179,140,193,106,198,25,12,73,186,147,142,78,88,14,183,39,13,10,
105,111,213,1,55,239,70,204,56,110,222,0,206,210,72,6,24,224,11,33,207,248,84,123,173,58,224,177,152,13,207,64,71,234,74,209,206,7,248,106,60,60,12,55,69,187,194,190,181,226,128,217,196,172,82,131,7,33,196,150,49,99,90,53,102,38,131,183,118,33,133,44,218,123,1,55,224,83,220,2,243,161,136,29,31,192,50,168,65,7,20,177,81,104,146,11,141,3,143,205,2,40,252,244,152,123,27,24,63,102,38,3,220,152,10,82,168,215,46,48,12,86,128,101,194,80,104,85,119,97,192,4,96,138,13,46,55,66,29,184,149,69,204,30,158,221,209,80,150,38,98,200,204,244,24,4,5,117,136,3,55,99,220,192,235,2,3,47,248,117,51,39,73,238,227,81,48,166,188,197,115,151,27,121,29,168,151,9,53,140,207,128,42,228,3,153,7,53,184,15,76,20,153,202,227,128,99,198,195,122,152,3,185,12,51,174,136,60,62,245,114,195,11,47,243,45,103,57,160,1,131,172,94,38,148,17,180,152,75,149,101,73,13,76,177,222,242,169,78,164,57,224,68,13,104,200,167,223,142,205,179,204,127,26,195,191,155,193,35,101,170,77,84,154,3,214,246,179,193,205,143,133,118,203,68,
97,182,75,45,55,146,28,48,11,88,30,212,96,58,36,141,163,171,50,121,65,206,2,157,152,0,177,23,102,220,198,28,168,247,91,193,128,138,157,72,123,59,100,80,63,9,157,48,14,154,246,219,216,208,159,65,94,233,94,237,11,224,90,144,78,120,243,47,133,166,155,58,46,37,58,193,155,113,42,164,253,56,161,187,109,58,197,74,61,112,24,254,128,171,242,137,55,202,183,114,15,60,15,221,160,67,125,169,51,44,254,62,236,4,29,249,23,174,42,206,1,59,235,113,240,10,159,61,131,125,229,196,175,172,253,5,124,0,39,225,50,68,148,228,128,131,220,180,197,213,54,152,11,237,14,230,223,89,243,43,120,15,190,131,191,161,73,105,14,56,216,223,172,139,225,85,152,2,237,84,15,139,189,9,7,224,18,196,42,203,1,251,189,141,173,215,183,131,55,100,213,242,140,31,129,55,96,15,92,128,68,101,57,224,68,199,140,134,46,216,2,214,42,85,234,56,198,61,243,187,224,103,136,4,45,223,35,202,227,128,19,76,183,166,214,23,193,210,162,170,160,62,135,237,79,225,35,248,17,154,130,150,182,136,242,58,224,36,203,139,233,240,26,44,129,144,185,12,207,
148,65,250,37,188,13,71,225,31,200,84,232,38,124,242,243,97,7,60,2,141,55,57,77,133,244,23,179,246,195,91,240,45,248,61,151,66,29,208,168,101,245,42,120,9,38,65,171,242,140,187,233,119,96,31,92,132,220,42,226,128,115,252,145,211,9,207,253,255,153,63,133,117,130,153,239,194,110,56,15,169,65,75,127,68,69,28,208,128,71,103,60,188,0,150,187,169,63,58,232,79,210,105,58,62,134,79,224,39,8,218,60,227,91,10,68,111,102,47,55,51,211,83,96,144,135,232,55,6,127,14,31,194,49,200,204,56,140,105,82,209,55,80,55,100,80,91,110,24,212,115,32,174,186,165,185,73,127,210,242,53,120,238,191,135,220,65,203,216,136,90,117,64,99,131,96,25,188,12,150,224,121,212,195,32,211,229,55,144,88,38,208,151,169,50,28,112,145,59,96,29,248,38,70,66,154,142,208,105,141,227,27,240,24,181,164,178,28,208,206,24,176,212,16,127,213,197,233,36,141,214,246,187,224,44,4,7,45,115,34,42,203,1,141,122,254,189,23,12,234,167,97,32,244,214,47,124,249,12,12,218,31,160,80,208,50,47,162,50,29,208,176,153,200,27,218,242,123,33,244,
150,101,130,249,254,16,228,42,19,122,79,110,231,103,255,63,105,57,28,4,55,106,134,217,11,51,33,52,213,50,165,111,52,148,101,187,225,48,232,200,106,104,60,82,52,93,187,242,104,142,130,215,225,89,48,75,149,125,92,49,89,173,44,55,204,76,102,164,202,54,127,5,0,0,255,255,3,0,92,116,139,203,74,238,66,93,0,0,0,0,73,69,78,68,174,66,96,130);


template_diamond2_64
:array[0..1726] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,64,0,0,0,64,8,6,0,0,0,170,105,113,222,0,0,6,134,73,68,65,84,120,1,228,154,235,143,93,83,24,135,235,174,67,219,49,138,162,152,153,106,93,7,45,218,209,186,205,164,81,70,166,40,170,84,59,134,160,238,197,223,225,126,13,74,20,95,144,16,31,52,164,73,19,151,47,141,134,32,225,131,8,73,147,186,132,140,75,220,111,207,211,216,50,103,102,206,217,107,159,189,246,222,71,251,75,158,228,204,217,123,93,222,119,175,245,174,223,62,153,73,147,170,211,238,12,61,7,14,131,93,171,154,70,85,3,239,70,192,93,176,10,46,132,3,96,23,40,93,85,36,192,64,13,248,34,184,12,86,195,185,48,21,74,79,66,217,9,48,64,3,93,2,203,161,27,122,224,10,88,4,123,67,169,42,59,1,147,137,238,44,88,9,199,131,91,97,47,232,5,147,112,34,236,9,165,169,204,4,24,152,1,94,9,167,129,129,39,154,194,135,115,192,107,174,10,19,83,138,202,74,128,1,25,152,1,246,193,62,48,90,110,141,233,112,62,184,53,102,64,41,115,43,99,16,199,48,32,3,27,128,253,97,162,98,231,119,30,137,203,192,68,76,131,137,
238,227,235,120,42,58,1,6,208,1,75,193,192,12,176,81,80,174,148,99,96,5,88,43,198,174,20,190,138,171,162,19,96,0,103,130,69,239,88,8,217,219,214,138,5,48,12,243,96,116,173,224,207,184,42,50,1,78,220,0,134,96,46,236,1,161,106,227,198,211,65,163,52,27,116,141,133,168,168,4,56,97,159,248,85,96,32,6,148,85,251,209,96,9,92,14,135,67,33,115,45,162,83,251,116,194,22,61,3,48,144,102,100,173,56,20,46,134,65,240,148,104,84,63,184,156,93,177,19,224,4,181,185,78,88,171,107,245,207,51,105,231,55,11,52,73,253,160,95,200,211,31,205,107,21,51,1,78,76,155,171,175,247,188,119,226,49,250,119,59,157,0,214,18,183,83,84,187,28,99,130,204,105,187,156,152,126,222,167,213,3,49,11,151,125,47,28,213,119,150,130,74,179,250,138,149,128,196,230,26,124,47,20,113,116,185,252,23,131,111,144,93,16,114,164,114,91,99,197,72,128,19,233,6,151,189,126,222,137,22,33,183,216,129,96,109,49,9,214,151,220,243,207,219,129,237,157,136,21,95,251,90,72,165,166,223,68,38,193,19,198,147,33,138,93,206,147,0,39,163,95,119,34,33,
54,151,219,162,200,21,151,216,229,51,248,236,43,118,211,202,147,0,109,174,126,125,5,56,161,40,123,146,126,66,100,205,57,21,220,118,39,65,211,53,167,217,4,56,160,54,119,24,244,237,78,168,108,249,0,250,193,57,52,109,151,155,73,128,199,155,3,234,211,61,151,155,177,185,52,203,45,183,96,7,232,54,45,138,135,64,230,120,178,54,240,126,139,144,254,220,129,155,181,185,52,141,34,147,160,93,246,100,24,132,204,69,56,75,2,28,204,1,28,200,42,236,192,126,87,181,140,225,40,112,69,246,131,199,112,240,188,66,19,96,135,118,236,0,154,157,89,16,218,150,91,11,151,219,210,223,27,87,195,124,176,70,5,41,52,8,173,168,251,93,63,174,47,143,105,115,233,46,138,156,163,63,182,186,18,156,99,144,93,14,73,128,29,245,128,79,126,33,56,80,171,74,95,146,20,197,78,62,167,30,205,105,9,176,131,46,176,202,234,195,221,6,173,44,183,170,118,249,2,176,48,250,106,222,48,198,70,23,189,166,205,53,120,59,179,227,224,226,194,189,85,201,57,118,130,6,109,16,92,21,117,231,93,47,1,54,176,161,54,215,138,239,209,87,183,19,174,181,154,
92,185,199,129,199,117,67,187,92,47,1,238,251,83,224,82,40,219,230,50,100,20,37,118,217,21,124,36,76,24,107,189,34,225,211,214,101,205,133,110,168,194,234,50,108,46,253,77,235,239,225,29,120,19,70,192,239,106,212,104,89,107,113,45,124,107,193,95,122,254,111,73,248,145,57,111,128,123,96,11,252,6,227,212,40,1,94,107,135,75,224,6,240,108,173,183,98,184,212,82,250,149,217,188,1,15,194,70,248,9,38,84,163,4,216,192,125,99,245,215,97,93,7,110,135,180,54,220,82,169,254,100,244,247,224,1,120,25,220,6,227,150,62,223,109,87,72,48,62,117,3,95,3,43,161,149,143,195,191,152,223,167,240,56,172,135,47,161,110,240,92,11,126,154,158,10,22,196,155,96,41,184,53,90,77,6,186,13,158,129,117,96,34,92,13,13,21,178,2,146,14,146,247,129,59,248,162,15,90,205,18,143,48,39,151,252,253,240,1,252,1,169,202,146,0,239,213,10,15,192,90,56,25,90,229,165,232,103,230,178,9,238,134,183,225,23,8,82,150,4,216,161,247,235,175,53,72,158,12,154,36,11,101,149,250,157,193,55,131,199,221,235,224,241,215,112,223,115,253,63,
101,77,128,13,13,120,38,92,11,67,255,126,110,166,31,154,230,150,69,239,35,120,24,158,135,111,32,56,120,238,13,46,130,222,59,90,46,253,163,225,54,240,69,169,3,202,78,130,129,126,14,22,189,39,96,43,152,144,76,202,51,105,127,117,177,14,88,15,206,131,125,161,44,25,188,79,219,167,238,121,255,9,4,21,61,238,171,81,158,4,216,81,27,84,97,151,131,108,110,77,164,117,254,200,155,0,219,183,131,69,241,70,72,254,249,145,143,133,73,79,111,165,191,23,54,66,93,155,203,181,84,229,77,128,3,88,20,15,134,171,97,24,58,33,70,191,116,51,78,26,155,247,225,17,120,17,70,32,83,209,227,254,26,197,154,168,118,121,22,92,15,69,217,101,3,213,221,61,6,235,225,43,200,92,244,104,83,163,88,9,176,211,196,46,223,202,231,65,152,234,151,145,100,240,6,252,28,60,10,38,34,213,230,114,79,170,98,38,192,193,38,67,31,220,2,103,67,44,187,236,82,127,5,30,130,119,65,243,19,69,177,19,96,127,83,96,0,110,135,121,144,215,46,107,107,55,129,54,247,45,8,182,185,220,155,170,216,9,112,64,251,212,46,251,131,164,118,121,54,88,40,155,145,
103,251,22,176,226,191,10,63,64,174,162,71,251,26,21,145,0,7,48,224,78,184,6,86,193,76,200,58,150,5,78,155,107,197,127,1,190,134,168,193,211,95,230,73,217,38,84,46,253,196,46,47,227,115,71,104,67,238,51,208,173,240,52,248,227,134,159,115,87,124,250,24,167,172,79,101,92,7,41,95,104,151,23,192,157,176,24,218,32,77,6,255,45,188,4,247,193,199,208,148,205,165,93,170,138,78,128,19,240,29,193,224,61,30,23,65,218,175,203,137,205,117,223,187,255,253,129,179,48,149,145,0,199,104,135,16,187,28,213,230,134,100,173,140,4,56,15,139,162,118,217,162,56,12,71,192,216,177,53,54,31,130,239,246,22,61,207,254,232,69,143,62,107,52,118,18,53,23,35,255,161,93,246,72,188,25,150,195,116,72,198,55,208,207,224,41,120,18,182,65,33,69,143,126,43,149,251,191,23,158,133,239,192,192,13,244,11,184,11,230,128,137,218,161,165,93,214,41,190,6,186,58,19,97,66,230,131,239,19,59,188,92,246,211,96,8,54,195,6,48,33,38,102,167,145,73,56,8,214,128,167,131,111,142,73,61,224,227,206,33,79,134,25,160,67,172,44,248,127,0,0,
0,255,255,3,0,212,142,214,102,5,219,218,114,0,0,0,0,73,69,78,68,174,66,96,130);


template_diamond2_256
:array[0..9316] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,1,0,0,0,1,0,8,6,0,0,0,92,114,168,102,0,0,36,44,73,68,65,84,120,1,236,157,59,172,237,218,89,133,129,64,66,110,30,55,143,155,7,9,100,175,115,238,205,141,64,208,32,1,18,18,13,5,69,58,20,16,116,32,58,26,26,30,21,208,34,74,164,128,68,74,68,71,3,136,138,2,165,66,2,74,10,4,9,231,236,125,194,205,139,4,200,139,60,120,142,111,239,61,206,153,199,219,94,246,242,182,189,236,233,241,75,255,182,151,151,237,101,143,57,255,49,231,28,243,183,247,235,190,45,182,23,4,190,93,55,250,29,242,239,148,127,183,252,205,242,183,220,174,179,157,239,99,59,67,128,130,143,213,143,0,193,141,191,78,254,122,249,155,228,239,144,191,91,254,78,57,68,240,6,57,223,135,12,4,194,94,44,4,80,127,73,59,248,41,235,239,146,191,81,254,118,249,247,200,63,32,255,94,249,187,228,244,8,32,7,19,64,122,4,2,163,118,11,1,212,93,194,205,224,167,235,255,86,249,75,114,2,255,32,191,144,67,6,111,147,67,14,144,4,61,1,31,171,213,88,173,8,132,0,106,45,217,103,1,76,25,123,220,79,240,211,218,191,
95,78,235,143,127,159,28,2,128,20,248,30,146,96,255,244,4,4,66,237,22,2,168,179,132,221,125,103,89,6,63,99,126,183,252,14,126,8,0,127,159,60,36,32,16,246,100,33,128,122,75,219,45,63,226,30,45,59,193,79,160,63,144,31,110,215,9,122,156,237,12,5,88,178,95,217,19,40,201,68,95,197,106,66,32,4,80,83,105,222,220,11,1,139,151,138,127,57,230,63,232,59,2,253,189,114,134,3,239,145,51,36,56,220,122,73,2,144,135,135,3,90,141,213,134,64,8,160,174,18,45,131,159,192,69,212,67,220,35,216,9,108,171,254,4,61,211,128,124,199,146,207,30,26,28,110,215,33,13,166,11,153,25,136,40,40,16,106,180,16,64,61,165,234,224,119,215,31,49,143,249,125,230,249,33,0,90,121,186,251,116,241,9,122,186,249,78,6,226,51,251,64,2,214,6,248,236,153,1,200,36,36,32,16,106,179,16,64,29,37,74,240,99,44,75,209,143,86,156,192,39,176,81,250,233,242,147,3,0,49,188,32,135,36,88,242,153,237,144,3,36,193,49,16,128,147,132,50,51,32,48,106,180,16,64,61,165,234,150,159,113,59,1,77,176,187,69,103,233,128,166,229,39,232,233,218,67,22,44,
75,18,224,56,200,130,99,32,130,230,204,64,73,54,250,58,182,101,4,66,0,91,46,189,155,107,119,215,255,152,232,71,32,19,216,47,202,25,215,151,105,191,62,14,18,128,28,60,100,40,201,131,99,33,149,136,130,2,161,38,11,1,108,187,52,203,224,111,19,253,152,218,35,248,233,218,51,158,103,204,79,119,158,160,167,236,125,60,235,4,55,228,0,73,16,240,28,119,184,117,200,32,162,160,64,168,205,66,0,219,45,209,50,120,61,238,167,149,118,11,78,0,151,227,126,7,63,251,186,220,57,7,198,103,72,1,114,96,63,200,2,210,224,28,206,15,136,40,40,48,106,51,87,132,218,238,171,246,251,105,11,126,186,239,109,162,31,10,63,65,237,60,127,7,125,115,73,93,48,145,176,63,162,160,245,0,136,192,26,2,36,19,81,80,32,212,96,33,128,237,149,98,25,184,14,88,130,159,22,155,185,254,178,197,182,138,111,209,143,242,54,121,104,245,169,149,231,244,19,131,144,0,228,97,18,232,18,5,187,206,249,244,228,89,89,47,2,33,128,245,150,205,177,43,163,220,8,126,198,237,101,240,31,244,25,2,96,42,143,192,109,138,126,109,193,175,221,174,205,223,113,
238,114,102,192,67,138,146,92,32,27,126,215,61,129,146,64,174,79,150,63,219,64,32,4,176,141,114,242,85,58,72,173,220,35,218,209,237,167,117,62,220,58,129,74,102,31,93,120,90,113,139,126,62,86,155,58,205,251,112,254,166,40,8,169,64,46,7,57,191,97,18,200,204,128,192,216,170,133,0,182,83,114,101,112,210,250,247,165,249,50,86,103,31,246,61,165,156,203,223,177,40,8,153,64,42,4,254,225,214,51,51,32,32,182,110,167,84,140,173,223,235,150,175,223,65,73,121,121,220,223,84,252,157,230,75,176,150,193,207,177,152,151,55,159,250,255,250,183,32,17,206,135,30,224,103,6,146,46,220,143,223,38,246,8,1,172,191,152,28,184,44,29,252,93,138,127,25,252,136,121,148,47,199,249,28,90,29,100,222,223,191,105,18,224,252,116,253,147,46,60,8,198,245,239,20,2,88,127,25,113,133,110,141,25,111,211,26,35,240,209,5,247,211,125,158,162,131,24,250,20,127,237,50,200,76,28,252,182,103,6,248,109,72,160,111,102,160,36,144,65,63,150,157,206,131,64,8,224,60,184,15,253,85,7,225,49,209,143,57,250,83,21,255,83,127,159,122,
226,153,1,72,198,51,3,37,9,113,13,16,68,68,65,129,176,21,11,1,172,183,164,202,224,111,19,253,80,228,9,126,186,228,205,52,95,31,59,197,221,249,92,109,51,3,252,254,225,214,35,10,78,129,246,194,231,8,1,44,12,248,192,159,115,208,81,62,30,247,211,186,186,229,37,240,250,210,124,7,254,212,160,221,124,61,144,128,103,6,146,46,60,8,186,117,239,20,2,88,95,249,16,108,24,75,7,127,151,232,215,151,230,123,125,162,9,255,148,132,148,116,225,9,129,61,215,169,66,0,231,66,254,248,239,58,208,250,68,63,122,5,83,137,126,199,175,232,217,76,2,196,100,81,112,104,186,112,73,106,125,191,147,239,23,68,32,4,176,32,216,3,126,138,64,193,207,37,250,245,93,162,175,143,122,99,81,176,28,154,68,20,236,67,112,101,223,135,0,214,83,32,14,46,130,255,156,162,95,31,34,229,117,210,67,201,59,4,250,16,91,241,247,33,128,117,20,142,131,138,242,240,184,191,108,89,151,22,253,250,80,241,245,70,20,236,67,106,229,223,135,0,206,95,64,14,166,50,248,215,34,250,245,161,83,94,115,68,193,62,180,86,248,125,8,224,188,133,66,240,99,44,221,
242,19,252,204,237,151,143,223,58,211,111,73,209,79,151,112,212,202,107,63,85,20,164,222,153,248,142,254,72,190,156,23,129,16,192,188,248,14,57,187,91,81,198,211,101,240,31,244,121,236,179,253,67,126,119,138,125,28,196,220,67,155,40,88,146,152,31,31,206,59,4,166,64,126,162,115,132,0,38,2,114,196,105,28,60,199,20,127,2,104,236,179,253,35,46,105,212,33,229,125,52,69,193,188,67,96,20,164,203,29,20,2,88,14,235,242,151,202,160,105,83,252,253,144,15,193,79,178,15,93,255,49,207,246,151,191,57,231,122,121,63,206,20,228,161,161,188,67,96,78,212,39,56,119,8,96,2,16,79,60,133,131,5,236,61,238,111,42,254,83,63,219,127,226,37,142,222,221,247,228,199,135,243,14,129,209,80,46,115,96,8,96,25,156,253,43,4,63,198,210,193,223,165,248,79,245,108,255,245,15,46,240,167,121,111,38,129,188,67,96,1,240,199,254,68,8,96,44,114,227,143,115,43,217,151,230,11,49,44,149,230,59,254,110,158,63,178,236,221,120,102,128,222,77,222,33,240,60,78,171,249,20,2,88,174,40,28,28,199,68,63,18,126,230,122,182,127,169,59,
245,125,82,183,60,51,0,153,249,73,198,164,11,47,85,18,3,126,39,4,48,0,164,9,118,113,80,172,61,205,119,130,91,189,62,69,121,191,205,153,129,188,67,96,42,148,39,56,79,8,96,2,16,123,78,225,96,0,107,143,251,155,162,223,146,207,246,247,92,238,100,95,251,190,147,46,60,25,164,211,159,40,4,48,61,166,229,25,29,4,101,240,119,137,126,75,63,219,95,94,231,156,235,229,189,39,93,120,78,164,71,156,59,4,48,2,180,129,135,16,252,24,75,183,252,4,255,22,210,124,185,238,41,172,196,192,162,224,208,119,8,80,55,77,160,83,92,75,206,209,130,64,8,160,5,148,9,55,185,245,219,98,154,239,84,48,56,136,193,194,162,96,57,4,74,186,240,84,72,143,56,79,8,96,4,104,3,14,113,165,63,166,248,111,33,205,119,192,173,14,218,165,196,163,41,10,38,93,120,16,132,243,236,20,2,152,30,215,178,178,211,245,39,33,134,23,104,242,68,31,65,191,181,52,95,93,242,36,86,226,146,116,225,73,32,189,255,73,66,0,247,199,176,60,131,43,57,184,122,220,95,118,119,153,2,219,106,154,111,121,159,247,89,55,54,206,20,76,186,240,125,208,188,231,177,33,
128,123,2,88,28,78,240,99,44,29,252,93,138,255,214,210,124,175,111,108,130,63,77,140,76,2,73,23,158,0,220,49,167,8,1,140,65,173,251,24,183,110,53,166,249,118,223,245,105,223,148,189,36,207,12,36,93,248,52,12,39,219,59,4,48,13,148,174,212,199,68,191,26,210,124,167,65,235,217,244,30,245,207,51,3,73,23,158,10,221,19,206,19,2,56,1,172,142,93,203,224,111,19,253,150,250,23,94,29,151,183,218,205,37,110,205,153,129,164,11,47,84,108,33,128,251,1,237,74,12,142,30,247,55,69,191,26,211,124,239,135,218,179,163,141,95,210,133,159,97,178,232,90,8,96,60,220,174,188,101,240,119,137,126,181,166,249,142,71,239,249,35,75,12,147,46,252,60,54,179,126,10,1,140,131,151,224,199,88,186,229,223,91,154,239,53,0,19,252,41,177,180,40,152,116,225,9,128,29,114,138,16,192,16,148,218,247,113,171,181,231,52,223,118,100,78,223,90,246,166,44,10,150,67,169,164,11,159,142,233,160,35,66,0,131,96,122,110,39,87,214,99,138,255,158,210,124,159,3,231,30,31,74,92,155,162,96,210,133,239,1,236,177,67,67,0,199,208,185,251,93,
89,73,219,20,255,189,166,249,222,69,106,220,150,18,223,164,11,143,195,240,164,163,66,0,195,225,114,229,116,215,159,10,90,118,83,147,230,59,28,203,190,61,141,177,51,5,147,46,220,135,216,200,239,67,0,195,128,35,248,49,150,165,232,247,146,62,19,248,188,231,174,156,238,131,24,168,188,136,90,96,108,242,208,106,172,7,129,38,214,38,129,164,11,247,0,55,230,235,16,192,112,212,220,42,37,205,119,56,102,99,247,52,97,130,185,103,6,32,213,188,93,120,44,162,29,199,133,0,58,128,41,54,187,50,30,19,253,146,230,91,0,54,209,170,113,167,142,122,102,32,233,194,19,129,235,211,132,0,140,68,251,210,149,144,224,111,19,253,146,230,219,142,219,84,91,75,252,155,51,3,73,23,158,0,229,16,64,55,136,174,124,96,228,113,127,83,244,43,199,253,36,175,32,12,178,111,112,21,8,19,153,203,33,233,194,19,1,90,158,38,21,181,68,227,217,186,43,93,25,252,73,243,125,134,207,57,214,202,178,72,186,240,68,37,16,2,184,11,36,193,143,177,116,203,159,52,223,107,72,206,246,167,44,19,139,130,73,23,158,160,56,66,0,237,32,186,181,73,154,
111,59,62,231,216,90,246,202,44,10,150,67,178,164,11,143,40,149,16,192,243,160,185,146,29,83,252,147,230,251,60,102,75,126,42,203,167,41,10,38,93,120,68,73,132,0,158,129,86,86,174,54,197,63,105,190,207,176,58,231,90,89,78,73,23,190,103,73,132,0,110,0,116,165,114,215,63,105,190,247,172,88,11,28,238,178,114,166,96,210,133,71,128,30,2,184,17,251,128,14,18,40,69,191,164,249,142,168,80,11,29,66,89,97,46,51,147,64,210,133,111,112,25,252,55,4,112,3,149,91,147,164,249,14,174,58,103,223,177,236,181,121,102,32,233,194,39,22,203,222,9,192,149,232,152,232,151,52,223,19,43,213,130,187,187,252,168,199,158,25,72,186,240,9,5,176,103,2,112,229,73,154,239,9,21,102,133,187,150,229,216,156,25,72,186,112,79,129,237,149,0,92,105,184,127,143,251,203,57,101,42,78,210,124,123,42,207,138,190,118,121,38,93,248,196,66,217,35,1,80,89,48,150,14,254,164,249,94,67,178,249,63,37,161,39,93,120,64,113,238,145,0,128,197,21,165,79,244,163,87,240,130,156,241,37,199,184,165,209,106,108,101,8,148,196,110,81,112,104,
186,112,121,236,202,110,107,222,203,217,27,1,56,128,35,250,205,91,175,206,117,118,151,47,245,218,162,96,57,180,227,205,77,78,232,122,151,214,249,142,70,128,158,224,222,98,65,183,188,175,155,118,229,136,232,119,93,244,213,254,41,203,57,162,96,79,49,239,133,245,92,41,184,95,143,251,203,150,33,162,95,79,69,217,216,215,46,239,136,130,61,5,183,7,2,112,101,40,131,63,162,95,79,197,168,228,235,178,204,35,10,182,20,106,237,4,64,240,99,44,221,242,231,217,254,107,72,170,255,83,150,253,169,162,32,113,225,134,163,106,160,106,39,0,10,207,173,0,227,193,50,248,15,250,204,59,253,120,140,20,65,232,69,249,155,228,236,71,215,113,23,21,64,247,89,179,185,12,169,3,109,162,224,238,223,33,80,51,1,184,240,143,41,254,121,182,191,230,240,191,185,183,178,30,52,69,193,221,191,67,160,86,2,40,11,157,174,63,79,139,189,77,254,94,57,65,239,169,160,247,104,157,199,72,17,4,217,103,183,211,65,186,247,154,173,172,15,121,135,64,81,210,53,18,128,11,155,123,243,184,191,169,248,195,252,239,150,243,248,104,25,252,28,139,
121,121,243,41,127,107,65,192,117,194,143,15,239,254,29,2,181,17,128,3,151,165,131,191,75,241,47,131,31,145,8,44,56,206,231,208,106,172,34,4,92,174,174,27,38,129,93,191,67,160,54,2,160,190,154,229,25,239,209,186,35,240,149,25,96,12,3,222,41,135,24,146,230,43,16,118,100,38,120,234,136,103,6,168,35,144,0,245,132,7,192,168,43,228,133,240,66,24,234,136,255,215,67,73,32,218,92,135,213,68,0,46,220,99,162,31,5,27,197,191,142,186,59,246,46,92,79,168,251,158,25,32,208,105,20,104,28,202,198,130,186,2,65,208,152,84,169,15,213,66,0,46,84,130,159,130,106,138,126,249,23,94,2,37,246,20,129,178,190,52,103,6,104,36,14,183,14,25,208,19,96,122,24,178,168,110,122,184,6,2,112,97,114,47,30,247,195,218,102,244,164,249,10,140,216,29,4,92,111,8,106,207,12,48,83,132,56,76,157,161,209,96,198,136,94,1,219,61,75,84,21,9,108,157,0,92,136,101,240,119,137,126,40,190,164,131,82,144,140,255,56,22,243,242,230,83,254,238,13,129,178,238,236,46,93,120,203,4,224,192,101,233,150,159,224,135,193,203,12,47,139,126,244,
10,34,250,9,132,216,83,4,202,58,100,81,112,232,59,4,136,29,142,247,57,158,158,116,75,43,91,38,0,112,54,123,51,142,43,131,255,160,207,73,243,21,8,177,94,4,28,196,212,37,139,130,229,16,178,108,76,104,92,168,103,213,204,12,108,149,0,92,104,140,199,40,52,68,26,196,26,68,155,195,173,83,112,100,250,49,197,3,171,83,104,85,141,223,116,63,177,105,16,40,235,83,83,20,172,58,93,120,139,4,80,22,86,155,226,159,52,223,105,130,98,111,103,41,235,149,69,65,26,15,26,17,26,147,195,173,87,53,51,176,53,2,112,33,113,221,30,247,151,221,53,212,219,164,249,10,132,216,104,4,92,183,156,41,88,117,186,240,150,8,128,224,199,88,58,248,187,20,127,152,27,98,176,226,207,125,154,60,180,26,11,2,173,8,52,235,152,73,128,250,196,248,159,198,133,70,166,20,150,173,7,108,178,142,109,137,0,132,251,115,162,31,1,158,52,95,80,137,77,137,128,27,10,98,195,51,3,212,53,72,160,186,116,225,173,16,128,11,229,152,232,7,51,39,205,87,32,196,238,141,128,235,27,241,225,153,1,122,155,78,46,171,38,93,120,11,4,224,194,32,248,219,68,191,
164,249,222,187,190,231,4,45,8,148,245,174,57,51,64,99,115,184,245,77,139,130,107,39,0,23,2,215,233,113,127,83,244,203,191,240,18,56,177,89,16,112,253,163,241,241,204,64,85,233,194,107,38,0,131,95,6,127,151,232,151,52,223,89,234,127,78,122,139,64,89,7,171,74,23,94,43,1,16,252,24,75,183,252,4,127,210,124,65,37,182,36,2,101,93,180,40,88,77,186,240,90,9,128,2,54,235,38,205,119,201,234,158,223,106,67,160,236,141,90,20,44,135,162,155,77,23,94,35,1,24,236,99,138,127,210,124,219,170,105,182,205,137,64,89,47,155,162,224,102,211,133,215,70,0,37,200,109,138,127,210,124,231,172,226,57,119,31,2,101,253,180,40,184,233,116,225,53,17,128,193,117,215,31,128,203,110,86,210,124,251,170,103,190,95,10,1,215,81,103,10,110,54,93,120,45,4,64,240,99,44,75,209,143,39,252,8,124,230,90,203,233,62,136,33,105,190,2,33,182,56,2,205,186,106,18,216,100,186,240,90,8,128,82,52,171,50,190,34,192,147,230,11,42,177,53,34,80,246,86,61,51,64,157,221,92,186,240,26,8,192,96,30,19,253,146,230,187,198,48,216,247,53,185,
222,18,67,158,25,216,92,186,240,185,9,192,32,38,205,119,223,193,180,213,187,47,235,111,115,102,96,19,233,194,231,36,0,131,199,53,120,220,223,20,253,202,113,191,223,234,195,190,231,188,238,173,86,214,92,247,60,8,184,30,111,50,93,248,92,129,100,208,202,224,79,154,239,60,21,52,103,93,6,129,178,46,111,38,93,248,28,4,64,240,99,44,221,242,39,205,247,26,146,252,217,40,2,101,157,182,40,184,137,116,225,115,16,0,101,108,182,76,154,239,70,107,124,46,251,14,2,101,175,214,162,96,57,164,93,101,186,240,210,4,96,144,142,41,254,73,243,189,83,183,178,97,35,8,148,245,187,41,10,174,50,93,120,73,2,40,193,161,235,79,2,5,207,86,243,126,53,130,62,105,190,2,33,182,121,4,202,122,190,250,116,225,165,8,192,160,184,235,159,52,223,205,215,243,220,64,15,2,174,235,206,20,92,101,186,240,18,4,64,240,99,44,75,209,47,105,190,215,176,228,79,133,8,52,235,188,73,96,117,233,194,75,16,0,229,107,54,76,154,111,133,181,61,183,212,138,64,217,235,245,204,192,234,210,133,231,38,0,131,112,76,244,75,154,111,107,253,201,198,
10,16,112,253,39,206,60,51,176,170,116,225,57,9,160,188,249,54,209,47,111,243,173,160,134,231,22,122,17,112,28,208,8,54,103,6,186,210,133,233,49,16,155,62,182,247,71,198,238,48,23,1,112,225,24,231,247,184,159,196,8,191,87,157,27,79,154,175,64,136,237,2,1,7,242,41,233,194,139,144,192,92,4,64,169,114,110,179,30,99,31,68,63,255,107,165,102,240,35,146,112,195,38,14,47,181,41,22,4,170,65,160,217,32,250,241,97,166,194,137,13,150,126,195,53,67,6,226,103,214,88,152,131,0,204,118,156,155,160,230,95,119,115,83,220,32,243,253,188,220,131,255,184,202,54,198,67,47,200,185,89,246,247,177,90,141,5,129,170,16,112,32,179,36,46,104,244,154,207,12,208,48,154,4,136,155,217,123,1,115,16,128,174,251,58,144,97,47,2,155,155,164,245,231,230,32,1,94,237,237,224,7,132,4,191,64,136,237,2,1,55,112,110,28,157,40,68,66,28,195,99,26,70,156,117,226,102,246,94,192,92,4,160,107,191,38,1,198,255,8,31,180,242,48,26,206,58,219,96,55,190,119,203,175,213,88,16,216,13,2,212,123,234,63,78,160,67,6,142,19,55,140,124,231,
158,131,86,167,55,90,233,169,173,100,57,107,0,4,62,58,0,14,179,241,153,27,110,146,192,172,55,171,223,139,5,129,181,32,240,63,186,144,111,201,191,33,255,138,252,223,229,159,151,127,70,254,57,249,191,201,191,42,255,47,249,255,202,255,79,62,185,205,69,0,190,208,38,25,16,240,4,62,61,0,88,207,4,192,117,56,248,189,212,166,88,16,168,10,1,130,24,39,160,9,254,255,148,127,89,254,5,249,103,229,79,228,87,242,79,203,33,0,190,55,1,104,117,122,155,43,216,56,175,187,56,4,60,99,28,198,54,15,228,175,202,63,40,231,225,31,182,161,132,210,43,128,20,60,28,152,235,186,244,19,177,32,112,22,4,220,130,59,248,191,166,171,248,146,156,86,255,95,228,143,228,255,116,235,175,105,73,143,224,235,242,255,150,115,140,143,215,234,116,54,87,160,249,188,180,236,140,99,24,219,64,2,204,255,19,252,31,146,63,188,253,140,40,248,162,156,97,1,189,2,72,0,243,57,110,62,229,111,16,216,54,2,110,249,9,104,90,118,130,159,150,159,214,254,74,254,201,91,191,212,242,95,229,16,4,189,4,7,255,166,8,64,215,125,29,192,4,49,1,77,96,211,
202,51,27,112,144,191,114,235,23,90,190,79,206,118,72,0,162,128,48,220,19,208,106,44,8,108,30,1,130,23,39,248,105,213,233,246,127,81,238,224,255,103,173,211,3,128,8,24,10,240,253,55,229,232,4,62,86,171,211,27,1,58,167,113,126,156,160,166,139,143,8,200,60,39,129,79,15,224,229,219,117,72,128,169,15,242,2,80,64,217,223,199,106,53,22,4,54,139,128,3,152,96,182,224,199,248,254,51,242,75,57,45,63,4,240,68,142,248,71,207,128,253,32,11,183,254,90,157,199,230,38,0,174,154,223,160,69,39,168,209,3,104,233,25,251,127,64,14,1,188,34,63,200,201,19,32,63,0,146,96,63,11,131,75,92,163,126,46,22,4,38,71,192,193,79,32,211,162,163,234,51,182,39,208,9,120,130,159,113,255,99,185,131,159,30,66,41,252,113,142,217,108,137,224,242,111,64,2,168,254,180,240,38,129,7,90,127,85,14,9,64,8,16,67,68,65,129,16,219,60,2,101,240,19,208,140,233,255,67,206,248,30,145,239,145,252,31,229,159,144,51,20,128,24,202,224,247,241,218,60,159,57,56,231,251,133,155,51,243,59,120,73,2,4,58,93,255,166,40,200,191,4,67,48,68,20,
132,48,56,198,199,107,53,22,4,86,143,128,91,109,90,126,130,191,77,244,163,219,79,15,224,82,142,24,232,57,255,217,199,253,250,173,167,70,55,251,28,102,128,8,108,134,6,4,122,233,108,227,218,112,19,128,86,175,137,128,101,44,8,172,29,1,130,159,113,60,173,58,137,62,136,126,8,124,159,146,95,221,250,107,90,18,252,244,14,32,138,69,131,95,191,183,120,64,185,37,39,192,219,68,193,7,218,126,33,71,15,96,102,0,81,48,51,3,2,33,182,25,4,220,117,119,240,55,21,127,186,254,143,229,79,228,30,247,47,38,250,53,81,36,32,151,54,126,147,86,29,18,104,138,130,16,192,67,57,36,144,153,1,129,16,219,20,2,14,126,90,242,166,226,127,165,109,116,249,233,250,55,131,159,214,159,30,3,198,57,22,179,115,17,0,55,8,9,208,237,111,146,192,203,218,246,138,28,18,200,204,128,64,136,109,2,1,7,63,129,108,197,31,209,143,110,63,1,79,240,183,41,254,244,20,56,198,199,107,117,57,59,7,1,112,119,252,46,14,9,208,19,56,54,51,240,94,125,143,40,72,34,17,195,6,142,241,241,90,141,5,129,179,35,224,86,155,64,254,150,156,49,61,243,249,164,
249,50,206,127,36,63,187,226,175,107,184,99,231,34,0,46,196,65,236,158,0,36,208,53,51,144,116,225,59,69,151,13,43,66,0,2,32,248,105,205,219,20,127,90,127,252,82,126,54,197,95,191,125,199,206,73,0,92,140,73,0,181,159,225,0,173,60,226,223,65,206,48,192,67,1,244,0,182,147,63,16,81,80,32,196,86,131,128,187,238,4,63,138,127,83,244,99,204,79,15,224,74,206,112,128,25,1,134,8,236,239,99,181,122,30,59,55,1,112,215,38,1,134,2,109,51,3,104,2,23,242,136,130,2,33,182,42,4,28,192,109,162,223,165,174,148,86,191,77,244,35,248,233,49,112,252,89,109,13,4,0,0,92,135,245,128,46,81,240,160,125,34,10,10,132,216,42,16,112,240,19,200,22,253,86,149,230,59,4,165,53,17,0,215,91,234,1,73,23,30,82,130,217,231,28,8,148,193,207,20,222,42,211,124,135,0,179,22,2,224,90,185,22,247,4,208,3,142,137,130,73,23,6,177,216,57,16,112,183,157,150,127,213,105,190,67,192,65,124,91,171,25,104,72,1,125,0,82,40,157,109,92,63,238,169,65,173,94,147,8,203,88,16,152,11,1,130,223,162,223,106,211,124,135,220,252,154,122,0,190,94,
247,4,186,68,193,7,218,241,66,142,30,144,116,97,163,150,229,18,8,184,235,239,224,111,42,254,143,116,17,143,229,79,228,103,79,243,29,2,200,26,9,128,235,230,186,186,68,65,8,224,161,28,18,200,204,128,64,136,45,130,128,131,191,77,241,191,210,21,116,41,254,103,75,243,29,130,202,154,9,128,235,135,4,232,246,119,205,12,64,2,153,25,16,8,177,89,17,112,240,151,138,255,234,211,124,135,32,178,86,2,224,218,185,54,220,61,129,164,11,131,74,108,105,4,8,126,140,224,223,84,154,239,245,85,247,252,89,51,1,112,233,37,9,244,205,12,36,93,184,167,176,243,245,40,4,32,0,139,126,155,74,243,29,114,183,107,39,0,238,193,36,128,218,15,9,36,93,24,84,98,75,32,224,174,127,151,232,183,234,52,223,33,0,109,129,0,184,15,147,64,215,204,192,203,218,231,66,30,81,16,180,98,83,32,224,224,111,19,253,46,245,3,93,162,31,100,65,143,129,227,87,111,91,33,0,128,228,90,173,7,116,137,130,7,237,19,81,80,32,196,238,133,128,131,191,20,253,54,151,230,59,4,129,173,17,0,247,228,153,129,99,162,96,222,46,60,164,244,179,79,27,2,101,240,
111,58,205,183,237,230,154,219,182,68,0,92,59,215,235,158,64,159,40,152,116,225,102,105,231,115,31,2,238,182,211,242,111,62,205,183,239,102,249,30,97,109,203,230,2,131,20,146,46,188,229,146,92,207,181,91,241,95,245,219,124,167,130,107,107,61,0,223,183,123,2,93,162,224,3,237,120,33,79,186,176,17,203,178,15,1,119,253,187,20,255,71,58,193,99,249,19,249,38,210,124,251,110,152,239,183,74,0,190,246,46,81,16,2,120,40,135,4,50,51,0,90,177,99,8,56,248,219,20,255,43,29,216,165,248,175,58,205,247,216,13,251,187,173,19,0,247,97,81,176,107,102,0,18,200,204,128,75,60,203,38,2,14,254,82,241,175,34,205,183,121,163,109,159,183,76,0,220,15,215,143,187,39,112,108,102,32,111,23,6,177,88,137,0,193,143,17,252,213,165,249,94,223,89,207,159,173,19,0,183,87,146,64,223,204,64,210,133,123,42,196,206,190,134,0,44,250,85,151,230,59,164,44,107,32,0,238,211,36,144,116,225,33,165,158,125,64,192,93,255,46,209,111,243,105,190,67,138,185,22,2,224,94,77,2,93,51,3,73,23,30,82,35,246,177,143,131,191,77,244,187,20,
4,93,162,31,100,65,143,193,67,7,173,110,219,106,34,0,74,130,251,177,30,208,37,10,30,180,79,68,65,129,176,83,115,240,151,162,95,149,105,190,67,202,183,70,2,224,190,61,51,112,76,20,76,186,240,144,26,82,215,62,101,240,87,159,230,59,164,232,106,35,0,238,153,123,114,79,160,79,20,76,186,240,144,90,82,199,62,238,182,211,242,239,34,205,119,72,177,109,61,21,120,200,61,186,224,33,133,164,11,15,65,172,222,125,172,248,239,34,205,119,72,49,214,216,3,240,125,187,39,208,37,10,62,208,142,23,242,164,11,27,177,122,151,238,250,119,41,254,143,116,235,143,229,79,228,213,164,249,14,41,206,154,9,128,251,231,254,186,68,65,8,224,161,28,18,72,186,176,64,168,212,28,252,109,138,255,149,238,185,75,241,223,124,154,239,144,242,220,3,1,128,131,69,193,174,153,1,72,32,51,3,67,106,204,182,246,113,240,151,138,255,110,210,124,135,20,85,237,4,0,6,220,35,238,158,192,177,153,129,164,11,131,88,29,70,240,99,4,255,46,211,124,175,239,190,231,207,30,8,0,8,74,18,232,155,25,72,186,112,79,165,217,200,215,16,128,69,191,93,166,
249,14,41,167,189,16,0,88,152,4,146,46,60,164,102,108,123,31,119,253,187,68,191,93,164,249,14,41,194,61,17,0,120,152,4,186,102,6,146,46,60,164,214,172,123,31,7,127,155,232,119,169,75,239,18,253,32,11,122,12,30,58,104,181,126,219,27,1,80,162,220,179,245,128,46,81,240,160,125,34,10,10,132,141,153,131,255,84,209,111,23,138,127,91,89,238,149,0,192,194,51,3,17,5,219,106,198,246,182,185,229,142,232,119,66,217,237,145,0,128,135,251,118,79,32,162,224,9,21,102,197,187,66,0,17,253,78,44,160,189,18,0,48,153,4,34,10,158,88,105,86,184,187,187,254,17,253,78,44,156,61,19,0,80,153,4,34,10,158,88,113,86,180,187,131,63,162,223,136,66,217,59,1,0,25,24,68,20,28,81,121,86,112,136,131,191,20,253,118,251,108,255,152,242,8,1,220,16,0,216,13,17,5,243,14,129,49,181,108,158,99,202,224,207,179,253,35,49,14,1,220,0,7,14,238,9,244,137,130,121,135,192,200,202,54,225,97,4,63,70,203,159,103,251,175,161,24,247,103,15,239,3,24,131,140,43,24,164,144,119,8,140,65,112,254,99,172,248,231,217,254,123,96,157,30,192,
243,224,185,39,208,37,10,62,208,238,23,242,188,67,224,121,220,150,252,228,174,127,151,226,255,72,23,243,88,254,68,190,171,103,251,199,20,66,8,224,46,106,96,210,37,10,66,0,15,229,144,64,222,33,32,16,22,54,7,127,155,226,127,165,107,233,74,243,221,109,166,95,95,249,132,0,238,34,100,76,44,10,118,165,11,67,2,73,23,190,139,223,92,91,28,252,165,226,159,103,251,239,137,182,43,251,61,79,83,221,225,224,130,187,39,144,116,225,243,22,49,193,143,17,252,121,182,255,26,138,105,254,132,0,186,113,44,73,160,111,102,32,239,16,232,198,113,138,111,32,0,139,126,121,182,127,10,68,111,207,17,2,56,14,166,73,32,233,194,199,113,154,243,91,119,253,187,68,191,60,219,127,15,244,67,0,253,224,153,4,186,102,6,242,14,129,126,12,199,238,225,224,111,19,253,46,117,210,46,209,15,178,160,199,224,161,131,86,99,109,8,132,0,218,80,185,187,13,156,172,7,116,137,130,7,237,19,81,240,46,118,99,183,56,248,75,209,47,105,190,99,209,236,56,46,4,208,1,76,99,179,113,242,204,192,49,81,48,233,194,13,240,70,124,44,131,63,105,190,35,
0,28,122,136,43,246,208,253,247,188,31,88,225,37,9,188,93,159,201,7,248,160,252,67,242,135,242,247,203,147,46,44,16,70,154,187,237,180,252,73,243,29,9,226,208,195,146,10,60,20,169,187,251,185,162,66,10,73,23,190,139,207,125,182,88,241,79,154,239,125,80,28,112,108,122,0,3,64,106,236,226,158,64,151,40,248,64,251,95,200,147,46,220,0,110,192,71,119,253,187,20,255,71,58,199,99,249,19,121,210,124,7,0,218,183,75,8,160,15,161,246,239,193,141,161,0,36,208,20,5,33,0,134,2,144,64,210,133,5,194,64,115,240,183,41,254,87,58,71,151,226,159,52,223,129,0,183,237,22,2,104,67,165,127,155,113,131,4,72,18,106,146,0,83,131,175,200,33,129,204,12,8,132,30,115,240,151,138,127,210,124,123,64,155,226,107,87,228,41,206,181,183,115,128,29,238,158,192,177,153,129,252,203,177,238,218,65,240,99,4,127,210,124,175,161,88,238,79,8,224,126,88,151,36,144,116,225,113,88,66,0,22,253,146,230,59,14,195,209,71,133,0,70,67,247,244,64,147,64,210,133,159,66,50,120,197,93,255,46,209,47,105,190,131,161,28,183,99,8,96,28,110,
205,163,76,2,93,51,3,73,23,110,34,118,147,166,11,1,180,137,126,151,218,222,37,250,65,22,244,24,60,116,208,106,108,44,2,33,128,177,200,221,61,14,44,173,7,116,137,130,7,237,19,81,240,89,240,151,162,95,210,124,239,214,169,217,183,132,0,166,131,216,88,122,102,224,152,40,184,231,116,97,119,251,9,254,164,249,78,87,255,70,157,201,149,118,212,193,57,232,14,2,224,137,151,36,144,116,225,103,48,185,219,238,224,111,19,253,24,247,211,253,191,148,127,65,254,85,57,68,193,80,193,228,161,213,216,20,8,36,21,120,10,20,187,207,225,10,15,41,160,15,48,83,80,58,219,40,3,28,210,48,33,123,169,77,213,25,193,111,209,239,43,90,255,162,252,179,242,79,201,175,110,253,53,45,9,254,175,201,19,252,2,97,46,171,185,162,205,133,217,144,243,130,43,222,37,10,62,208,119,23,242,61,165,11,187,245,118,240,127,89,247,79,240,127,90,126,37,127,36,127,44,127,34,79,154,175,64,88,194,168,164,177,121,16,0,91,90,117,72,160,41,10,66,0,15,229,144,192,30,210,133,29,252,109,138,63,193,79,151,159,174,127,51,248,147,230,43,80,230,180,
16,192,124,232,26,91,72,128,110,127,147,4,94,214,182,87,228,144,64,205,51,3,14,126,186,254,223,148,51,166,79,154,175,64,88,131,185,146,174,225,90,106,188,6,240,197,221,19,56,54,51,80,99,186,48,193,143,17,252,73,243,189,134,98,93,127,66,0,243,151,71,73,2,244,4,32,129,174,153,129,218,222,46,12,1,88,244,107,83,252,233,250,227,151,242,40,254,2,97,105,11,1,44,131,184,73,0,181,31,18,120,179,252,37,249,65,206,48,192,67,1,244,0,182,191,40,127,65,142,126,64,239,97,139,229,228,174,127,151,232,199,152,31,225,239,74,206,44,0,51,2,12,17,216,223,199,106,53,54,39,2,91,172,88,115,226,49,231,185,193,26,39,168,223,32,127,139,156,110,255,133,252,161,28,77,128,245,26,68,65,7,112,155,232,119,169,123,164,213,111,19,253,8,126,122,12,28,31,91,0,129,16,192,2,32,23,63,1,222,214,3,186,68,193,131,246,217,178,40,232,224,39,144,45,250,37,205,87,96,172,209,66,0,203,150,138,241,134,4,172,7,208,221,39,53,248,129,252,85,57,195,129,15,200,183,152,46,92,6,127,210,124,85,136,107,55,87,200,181,95,103,77,215,7,230,
120,73,2,93,162,224,150,222,46,236,110,59,45,63,193,223,38,250,209,237,167,251,127,41,143,232,39,16,206,109,136,82,177,243,34,224,192,129,20,208,7,232,25,148,206,54,202,9,135,52,76,218,94,106,211,106,140,224,103,28,159,183,249,174,166,72,142,95,200,26,43,209,241,43,174,231,91,176,199,187,68,193,7,250,238,66,142,30,192,204,192,91,229,107,157,25,112,215,223,193,159,52,95,21,214,22,44,4,112,222,82,2,255,46,81,16,2,120,40,135,4,214,60,51,224,224,111,83,252,175,116,237,116,249,219,20,255,164,249,10,152,115,91,8,224,188,37,96,252,173,7,116,205,12,184,39,240,14,93,46,211,135,236,199,144,128,227,125,14,173,46,110,14,254,82,241,79,154,239,226,197,48,254,7,207,89,121,198,95,117,93,71,58,136,221,19,216,74,186,48,193,143,17,252,73,243,189,134,98,123,127,66,0,235,40,179,146,4,60,61,216,53,51,176,150,116,97,8,192,162,95,155,226,79,215,31,191,148,71,241,23,8,107,180,16,192,122,74,197,36,64,215,30,18,88,115,186,176,187,254,93,162,31,99,254,71,242,43,121,210,124,5,194,90,45,4,176,174,146,49,9,
116,205,12,188,172,203,189,144,159,83,20,116,240,183,137,126,151,186,182,46,209,15,178,160,199,192,241,177,149,32,16,2,88,73,65,20,151,65,153,88,15,232,18,5,15,218,231,28,233,194,14,126,2,217,105,190,67,68,191,40,254,2,108,141,22,2,88,95,169,184,76,60,51,176,22,81,208,45,55,193,31,209,111,125,245,102,212,21,185,178,141,58,56,7,205,134,0,229,130,151,36,112,110,81,16,2,32,248,233,202,71,244,19,8,53,88,8,96,189,165,104,18,88,131,40,232,174,127,68,191,245,214,151,81,87,22,2,24,5,219,98,7,153,4,206,41,10,58,248,35,250,45,86,236,203,253,80,8,96,57,172,199,254,18,101,116,46,81,208,193,95,138,126,121,182,127,108,73,174,240,184,16,192,10,11,165,113,73,46,163,82,15,88,226,29,2,101,240,231,217,254,70,161,212,242,209,149,171,150,251,169,245,62,40,39,188,36,129,46,81,112,138,119,8,16,252,24,45,127,158,237,191,134,162,206,63,8,76,177,237,33,224,0,133,20,208,7,202,247,7,176,206,54,202,22,135,52,76,244,94,106,83,175,89,241,207,179,253,189,80,109,119,135,83,42,196,118,239,178,158,43,167,188,240,
46,81,240,129,190,187,144,223,231,29,2,238,250,119,41,254,143,116,254,199,242,39,242,207,201,191,36,255,134,60,153,126,2,97,107,22,2,216,90,137,61,27,10,64,2,205,76,65,8,224,161,28,18,24,147,46,236,224,111,83,252,175,116,206,79,202,201,243,111,6,127,50,253,4,202,22,45,4,176,189,82,115,153,209,181,167,187,223,36,129,151,181,237,21,57,36,112,74,186,176,131,191,84,252,135,164,249,150,45,63,231,136,109,8,1,87,166,13,93,114,46,85,8,80,110,56,36,64,79,224,190,233,194,14,92,130,63,105,190,2,97,47,22,2,216,110,73,151,36,64,79,0,18,232,154,25,56,246,14,129,50,248,105,205,147,230,187,221,58,113,242,149,135,0,78,134,108,85,7,152,4,80,251,33,129,83,223,33,224,155,161,229,103,220,143,226,223,124,161,39,99,126,132,191,43,121,158,237,23,8,53,89,8,96,251,165,105,18,232,154,25,64,19,184,144,55,69,65,72,195,229,223,38,250,93,234,251,46,209,175,28,247,107,183,88,16,8,2,231,68,128,64,38,160,249,159,131,100,9,126,64,254,35,242,143,200,127,67,254,49,249,95,202,255,94,254,154,156,86,158,231,249,81,
239,25,243,127,85,78,235,254,15,242,143,203,255,72,254,219,242,159,151,255,152,252,32,103,120,129,224,104,226,48,121,104,83,44,8,4,129,115,34,64,48,154,4,8,82,130,245,32,39,120,9,98,130,153,160,254,184,156,32,119,87,254,235,90,39,248,63,47,255,132,252,175,229,127,34,255,93,249,47,201,127,66,78,15,130,183,17,163,49,208,203,64,120,76,240,11,132,88,16,88,19,2,4,37,193,233,89,1,130,150,224,37,136,9,102,130,154,224,38,200,9,246,207,201,121,176,135,224,103,156,255,183,242,63,149,255,158,252,87,228,31,150,255,128,28,1,241,5,57,26,67,130,95,32,196,130,192,90,17,48,9,16,172,4,45,193,75,16,127,88,78,80,19,220,4,249,223,200,33,129,79,201,9,254,191,147,255,185,252,163,242,95,149,255,180,252,135,229,232,6,252,31,130,215,203,19,252,2,33,22,4,214,142,128,73,128,160,37,120,9,98,130,153,160,38,184,9,114,130,29,18,64,19,32,248,255,66,254,7,242,95,147,127,68,142,126,128,142,128,158,128,174,224,113,191,86,99,65,32,8,172,29,1,72,128,160,109,19,5,9,242,223,151,255,153,252,175,228,4,255,31,202,17,11,
127,70,254,163,114,102,13,222,38,143,232,39,16,98,65,96,107,8,64,0,38,1,130,152,96,38,168,9,110,90,248,95,151,127,84,254,199,242,143,201,127,83,254,115,114,68,195,131,252,237,114,142,139,232,39,16,98,65,96,139,8,64,0,22,5,9,102,130,250,32,39,200,127,86,78,139,255,59,242,223,146,255,130,28,177,16,209,240,29,242,55,202,19,252,2,33,22,4,182,140,64,73,2,4,53,193,253,80,254,227,114,166,7,127,89,254,139,242,159,146,127,191,252,93,242,40,254,2,33,22,4,106,65,160,36,1,130,251,37,249,171,114,90,124,102,7,126,82,254,67,114,158,28,36,149,56,211,125,2,33,22,4,106,66,192,36,64,112,191,73,254,110,249,43,242,31,148,67,6,4,191,167,251,162,248,11,140,88,16,168,13,1,72,128,224,102,122,16,18,120,167,252,61,114,122,4,4,127,57,221,199,190,177,32,16,4,42,66,128,160,110,146,0,129,15,25,16,252,17,253,4,194,222,236,255,5,0,0,0,255,255,3,0,93,40,180,11,49,49,15,191,0,0,0,0,73,69,78,68,174,66,96,130);


template_rings_16
:array[0..405] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,16,0,0,0,16,8,6,0,0,0,31,243,255,97,0,0,1,93,73,68,65,84,56,203,165,211,77,75,212,81,20,6,240,223,220,241,5,71,180,40,69,42,74,29,139,160,150,185,11,33,2,247,125,138,86,109,219,183,148,246,125,143,62,128,59,151,234,66,20,66,148,233,141,89,152,25,20,50,147,218,204,180,121,6,44,156,90,248,192,129,255,61,255,243,156,115,207,115,238,169,248,19,85,204,97,9,139,152,143,255,61,54,176,134,15,232,184,0,53,188,192,54,126,162,135,95,56,67,55,190,237,196,212,206,87,236,147,95,226,21,166,113,136,93,188,67,3,95,146,240,54,150,195,89,199,89,53,73,158,135,44,85,62,162,141,171,152,192,49,14,240,13,87,240,4,71,216,172,96,1,111,113,31,91,169,62,131,187,33,75,27,159,162,197,40,30,229,251,217,80,4,187,135,175,177,41,60,76,96,31,35,168,99,40,109,53,195,89,42,81,123,52,228,46,102,255,34,247,81,112,39,45,52,49,140,197,114,110,84,63,82,233,154,193,40,184,158,137,180,81,47,46,137,18,49,96,18,167,81,122,16,186,81,127,44,214,40,121,97,39,17,175,100,132,
39,23,144,123,249,247,29,55,51,153,141,146,231,185,151,4,211,17,115,39,154,244,98,167,216,143,141,227,86,56,107,213,4,86,240,52,9,90,73,242,57,237,28,36,248,48,228,7,153,192,10,86,171,169,176,147,107,62,198,141,4,118,147,188,149,243,108,102,63,140,215,120,147,155,253,115,153,58,89,168,129,203,84,249,207,58,215,227,111,12,90,231,223,37,175,104,186,7,6,97,7,0,0,0,0,73,69,78,68,174,66,96,130);


template_rings_24
:array[0..693] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,24,0,0,0,24,8,6,0,0,0,224,119,61,248,0,0,2,125,73,68,65,84,72,199,181,150,185,110,19,81,20,134,63,223,33,33,78,66,226,152,56,11,161,9,194,33,18,20,24,33,10,42,36,30,129,7,160,166,78,65,195,11,80,32,33,241,26,244,41,40,232,16,18,145,104,64,68,54,132,34,18,89,8,6,155,16,155,120,25,154,111,208,96,177,76,144,114,164,209,44,247,220,255,236,255,157,28,127,150,8,40,1,75,192,50,112,30,152,113,109,23,120,11,172,3,85,224,35,208,227,8,82,2,110,3,171,192,54,112,8,196,3,215,161,107,171,234,150,178,0,7,160,2,60,6,234,64,95,176,190,30,182,129,22,208,29,88,171,187,167,34,198,79,201,13,128,95,7,30,0,87,125,239,0,13,96,79,144,111,2,158,4,166,128,105,160,8,140,104,108,13,88,1,158,169,71,148,50,112,25,120,4,92,211,112,19,168,1,239,204,113,203,40,250,166,167,169,225,207,192,48,48,6,156,5,46,105,104,59,109,160,4,220,7,110,10,254,9,120,45,64,79,189,2,48,175,110,222,52,117,53,92,23,167,0,156,81,231,41,112,16,185,249,22,112,7,24,5,246,5,111,152,166,
162,93,180,4,204,2,167,129,57,175,8,56,0,190,27,81,30,152,208,145,13,224,85,228,166,123,134,214,51,37,59,70,50,15,92,212,72,240,91,114,13,249,125,84,103,146,6,152,6,78,105,236,73,208,179,138,155,246,205,93,172,39,101,1,254,214,117,115,192,162,207,77,235,149,19,115,41,24,126,209,13,13,195,77,188,31,207,208,218,57,139,91,176,1,182,188,23,129,229,224,132,14,233,117,211,197,36,117,89,229,132,250,73,247,181,197,44,135,212,248,199,22,12,251,58,207,209,36,111,154,250,214,2,96,38,112,204,18,36,174,36,151,73,65,219,41,47,178,202,129,222,135,84,244,187,65,86,236,104,96,66,133,158,173,154,85,186,234,199,192,164,41,238,0,181,32,229,38,147,56,153,226,149,45,219,246,95,18,3,155,169,193,156,243,94,7,214,131,124,254,82,197,113,21,146,110,168,166,10,255,59,233,59,55,239,125,158,144,38,98,49,171,145,185,14,192,13,9,43,153,204,150,224,13,219,48,63,192,190,45,167,126,195,154,13,3,23,236,255,47,178,242,243,72,107,31,164,132,101,169,120,204,244,36,197,222,113,66,191,202,158,155,50,237,158,249,31,1,
206,57,112,120,8,61,4,246,163,84,7,212,128,43,192,130,222,78,25,118,91,144,182,158,213,53,212,117,32,167,244,124,193,76,188,0,238,26,221,47,231,193,46,240,70,210,155,215,171,98,234,64,201,25,109,48,194,89,57,104,209,230,64,240,21,207,131,248,127,142,204,195,84,68,153,142,204,99,63,244,115,71,248,109,41,15,252,182,212,178,252,182,252,0,218,81,213,147,80,68,91,184,0,0,0,0,73,69,78,68,174,66,96,130);


template_rings_32
:array[0..977] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,32,0,0,0,32,8,6,0,0,0,115,122,122,244,0,0,3,153,73,68,65,84,88,195,197,151,201,79,83,81,20,198,127,239,117,96,42,148,81,16,81,166,56,196,133,6,66,194,202,152,248,87,144,184,55,46,100,235,198,184,116,195,198,133,38,46,89,153,224,222,255,192,104,162,33,70,209,196,9,80,8,150,42,50,23,40,133,182,110,190,107,142,207,71,104,105,34,39,105,94,250,222,189,103,248,238,57,223,57,215,163,116,169,1,58,128,110,160,23,232,2,26,245,109,13,88,0,190,2,115,64,26,216,41,69,169,87,162,225,43,192,8,48,4,116,2,9,32,102,246,23,129,61,32,3,164,128,73,96,2,120,86,170,35,97,18,7,134,129,113,96,21,40,200,80,41,191,130,246,140,75,71,188,92,227,53,192,40,48,13,228,15,48,144,87,116,219,138,62,204,193,188,116,140,74,103,73,71,208,12,220,214,166,90,243,190,8,108,41,178,101,96,29,200,234,125,76,107,91,180,63,169,119,78,182,129,7,192,24,176,98,141,69,66,34,191,3,220,2,234,204,251,44,240,5,248,12,124,151,113,27,245,190,140,172,0,63,245,140,74,135,39,103,6,244,
124,174,245,255,56,16,7,110,200,129,58,19,245,50,240,22,248,33,163,14,185,162,158,94,0,209,130,142,102,73,71,208,32,59,113,96,80,206,189,209,183,191,28,24,18,68,237,198,248,34,240,94,208,135,149,228,41,61,155,20,221,174,28,64,207,53,57,211,44,68,98,192,57,224,133,144,36,106,20,222,84,125,99,106,251,163,224,119,209,213,1,167,101,56,30,136,222,229,200,188,74,209,57,179,8,84,1,231,21,112,175,108,77,1,59,14,129,107,192,93,147,169,123,90,176,105,12,180,1,151,129,19,114,220,11,73,232,184,18,49,169,0,220,145,109,74,119,82,235,122,128,87,192,140,175,15,35,250,232,34,153,87,182,59,105,1,46,137,128,14,35,47,31,104,213,122,87,69,121,49,164,67,51,41,155,53,190,206,112,200,40,222,21,132,69,253,175,22,124,213,101,114,73,147,224,246,12,10,203,6,173,33,160,195,23,183,119,154,141,25,149,148,147,86,131,78,57,226,169,95,36,77,82,166,77,96,157,64,183,47,47,19,102,227,166,169,83,79,11,253,35,210,121,84,251,29,10,171,38,47,18,64,159,47,47,99,1,4,138,134,27,146,84,38,245,166,220,115,6,221,24,208,229,
171,165,218,174,150,53,155,171,77,169,86,210,212,34,1,86,117,232,54,250,252,127,241,130,37,179,102,32,247,2,217,158,181,188,125,68,201,57,218,149,84,25,180,215,124,77,50,123,102,129,173,245,156,26,79,37,178,97,28,136,27,110,216,3,22,124,141,81,153,64,210,196,140,151,41,195,239,229,202,126,128,83,154,141,238,12,48,235,139,161,82,1,4,236,28,240,75,199,84,174,56,70,221,48,199,221,110,208,77,1,115,190,200,97,210,120,89,21,168,221,44,240,233,8,179,221,10,240,205,232,173,23,165,59,231,38,129,180,47,197,19,230,172,61,224,140,89,236,148,185,230,84,60,196,112,65,179,192,148,113,58,162,6,228,18,124,93,54,255,116,195,20,208,175,6,226,9,174,132,184,219,37,232,142,142,163,160,182,28,9,105,199,25,205,128,211,129,122,239,49,125,161,0,60,1,30,1,251,86,193,48,240,88,142,56,133,105,224,67,8,252,53,74,168,122,17,85,78,121,178,26,168,40,31,56,9,92,52,147,241,12,112,29,120,25,156,136,150,148,181,87,205,204,159,16,21,111,170,75,218,236,222,16,66,75,122,102,2,213,18,85,48,103,141,241,109,224,30,240,
52,108,36,203,3,239,20,221,128,153,120,106,205,152,150,51,99,186,119,0,203,197,132,206,5,77,79,142,202,183,128,135,192,125,27,76,36,164,110,95,75,201,160,169,217,168,218,114,155,16,137,155,99,242,84,57,141,106,108,253,58,243,6,227,228,182,140,143,5,166,172,138,47,38,187,202,143,35,95,76,142,253,106,118,236,151,83,175,12,68,236,245,188,239,128,235,249,108,185,215,243,223,51,219,56,63,143,232,200,33,0,0,0,0,73,69,78,68,174,66,96,130);


template_rings_48
:array[0..1585] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,48,0,0,0,48,8,6,0,0,0,87,2,249,135,0,0,5,249,73,68,65,84,104,222,229,154,187,111,28,85,20,198,127,51,235,125,250,253,88,71,49,142,131,192,9,56,4,144,82,64,1,29,85,34,209,83,209,0,5,13,10,162,160,1,137,150,130,20,72,20,64,195,63,128,40,144,82,80,64,133,34,33,17,201,82,66,72,200,131,0,9,36,142,215,143,108,156,125,15,205,55,112,153,156,59,94,188,99,148,136,43,141,188,222,157,123,239,121,124,231,156,239,158,153,128,193,71,8,20,128,17,96,26,152,1,102,129,113,160,162,123,182,128,13,224,38,112,11,88,5,234,64,11,232,13,178,121,48,192,220,28,48,7,60,13,28,1,14,3,139,64,21,24,5,242,82,14,9,217,6,110,3,43,192,69,224,12,112,26,88,6,174,3,221,255,74,129,60,240,48,240,34,112,12,88,2,38,129,162,35,240,118,163,7,52,129,53,224,28,112,18,248,18,248,89,138,238,202,200,1,11,192,235,192,41,65,160,7,68,3,94,61,173,117,74,107,47,104,175,76,71,25,56,10,124,1,172,103,32,180,239,90,215,30,71,181,103,38,99,18,56,14,156,151,123,251,177,104,87,16,185,173,
171,174,185,221,62,188,214,214,94,199,181,247,142,99,32,0,246,2,111,0,175,1,83,41,247,118,128,6,176,41,43,110,232,255,150,132,10,21,35,101,9,53,174,64,79,139,155,26,240,41,240,33,240,187,214,49,113,237,27,115,192,219,18,126,194,115,79,87,105,241,50,112,9,248,77,27,55,100,201,158,227,149,22,112,71,41,244,134,230,53,148,20,138,134,49,203,192,83,74,207,203,242,100,223,10,76,2,111,73,248,49,227,247,72,214,254,17,184,34,171,183,251,244,106,160,249,77,205,187,165,207,35,192,80,226,254,162,178,92,14,248,94,10,111,171,64,25,120,5,120,211,99,249,142,242,246,89,89,187,59,96,140,181,29,216,149,129,82,194,8,69,224,144,126,95,214,254,94,5,114,192,11,192,187,192,188,103,179,75,186,154,41,66,197,184,207,9,34,129,19,164,62,15,221,149,65,242,138,143,32,97,212,71,28,143,71,62,5,246,1,239,0,207,26,193,21,103,135,171,41,86,207,41,64,231,129,253,202,233,243,138,167,184,66,227,4,183,207,27,150,18,113,224,127,43,111,220,163,64,30,120,9,120,213,225,48,110,176,94,145,240,61,79,117,174,2,143,137,78,204,
42,118,42,130,68,89,155,79,41,179,77,57,113,208,53,246,218,212,253,21,71,137,80,115,127,17,148,122,73,5,30,5,222,147,0,201,113,19,248,201,83,230,199,128,131,154,63,166,53,131,148,32,14,37,216,44,48,44,232,52,140,56,171,139,28,22,156,239,75,250,238,27,193,237,47,5,114,192,203,242,64,193,192,230,89,165,192,228,152,16,137,171,238,160,252,135,202,60,147,98,171,91,137,223,91,82,100,38,1,231,73,37,145,239,128,40,116,114,254,49,3,58,145,92,182,105,8,48,14,60,41,37,118,202,106,3,65,229,9,9,26,36,246,142,233,183,59,42,146,117,46,182,66,40,74,188,100,8,82,247,84,193,146,240,62,150,17,93,25,6,14,24,6,108,201,218,237,132,210,75,146,57,140,15,35,71,12,222,17,169,98,222,53,92,63,191,13,181,216,41,231,90,48,140,184,106,84,225,73,201,92,136,113,120,88,5,35,153,210,214,140,172,83,150,251,178,166,188,1,240,144,225,213,150,96,20,37,138,219,97,96,36,84,84,47,26,121,191,233,225,31,83,82,122,55,70,49,198,182,65,236,122,9,20,44,2,211,161,130,167,234,169,140,77,3,62,123,6,60,138,110,55,166,141,76,88,
55,100,169,2,213,80,249,120,212,88,104,203,40,50,133,12,3,55,205,11,195,6,156,147,177,56,10,204,134,74,135,121,35,128,27,158,197,11,187,172,192,144,178,220,118,242,228,129,137,184,42,90,135,138,150,177,72,113,151,225,19,7,179,101,36,11,206,149,144,251,115,68,253,158,30,67,97,221,34,104,5,99,129,166,239,104,151,177,240,237,62,228,233,1,91,161,168,105,219,16,182,100,44,210,48,160,149,245,232,24,1,107,201,211,6,214,67,241,13,43,223,87,140,98,213,246,240,162,44,71,195,32,118,121,131,102,220,6,110,134,170,114,43,30,5,74,134,219,110,236,50,140,86,13,47,143,24,16,90,1,86,66,77,184,104,196,65,193,83,31,86,125,29,130,12,70,83,228,45,57,146,148,186,39,153,87,67,85,185,51,70,154,202,139,52,133,134,139,175,101,112,152,183,130,247,87,195,56,5,85,231,32,161,232,25,160,30,202,93,167,69,220,146,129,51,107,96,175,39,43,173,102,172,64,77,10,68,9,25,102,12,238,181,38,153,91,161,4,90,86,151,56,50,176,183,215,200,193,13,29,240,215,50,18,190,14,92,48,178,79,94,228,46,159,240,212,185,248,92,28,195,
227,186,90,220,91,134,23,22,60,253,161,77,167,55,20,13,0,155,77,193,161,102,88,127,143,60,144,228,104,39,227,88,201,57,11,221,2,158,51,250,65,67,162,16,181,100,83,73,88,220,112,14,234,255,230,140,208,1,254,72,241,228,184,26,90,201,115,202,105,224,253,248,168,153,75,228,213,28,240,188,145,62,203,14,246,34,131,51,213,28,69,74,250,27,120,44,222,81,252,92,80,155,102,203,211,29,60,100,120,126,3,56,1,124,109,181,85,122,42,106,143,27,7,156,248,240,221,149,162,145,17,216,119,52,127,69,159,91,206,117,71,13,171,235,74,127,87,181,142,69,97,226,243,118,242,220,209,1,190,82,183,122,205,133,135,59,174,1,159,72,251,131,70,64,29,208,156,171,30,74,209,149,149,214,157,134,65,156,40,226,43,72,137,135,17,25,111,206,72,223,151,37,219,181,180,222,104,164,27,34,224,25,238,125,74,18,183,14,43,178,96,59,133,18,199,235,245,28,143,165,53,188,102,212,94,153,53,132,175,1,31,0,159,39,13,151,243,4,215,121,254,238,207,23,13,6,59,170,13,59,12,246,168,52,212,62,251,5,221,17,67,201,77,224,99,224,35,139,1,228,82,
8,213,15,90,112,201,80,34,208,119,85,5,90,40,101,186,142,50,65,10,207,31,210,209,116,94,80,157,51,224,28,11,255,153,2,119,197,215,77,78,43,46,203,186,231,16,246,67,183,56,125,78,43,232,166,244,255,144,3,131,80,241,51,172,223,247,169,85,190,95,112,41,121,148,173,201,242,39,212,92,27,168,225,180,147,135,124,113,246,169,43,85,238,202,67,190,126,199,3,253,152,213,133,219,125,247,160,251,129,127,213,224,127,249,178,135,149,137,220,215,109,170,202,46,19,252,243,117,155,117,135,106,100,246,186,205,159,114,151,46,155,24,236,93,27,0,0,0,0,73,69,78,68,174,66,96,130);


template_rings_64
:array[0..2113] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,64,0,0,0,64,8,6,0,0,0,170,105,113,222,0,0,8,9,73,68,65,84,120,218,237,155,75,108,92,213,25,199,127,247,206,195,30,63,198,118,236,184,9,73,107,20,32,16,160,89,244,177,168,212,146,44,202,14,169,187,74,136,13,221,34,16,143,13,66,108,16,66,66,72,72,44,216,32,36,36,216,192,130,170,82,119,93,116,3,44,186,104,213,71,10,4,210,208,16,2,36,197,196,196,30,79,102,60,51,158,203,226,254,143,114,51,248,124,231,142,51,143,160,244,72,87,35,123,230,222,251,61,255,223,227,124,39,98,184,43,210,85,2,166,128,89,96,65,159,211,192,132,126,183,5,212,129,26,240,141,62,47,3,109,32,209,53,52,2,135,241,204,34,48,7,252,16,56,2,28,5,14,3,251,128,61,64,69,66,41,232,158,109,49,219,0,214,128,11,192,41,224,4,112,18,56,7,172,3,157,65,11,99,144,2,136,165,213,195,192,61,192,175,196,252,178,254,95,202,88,132,181,156,198,219,178,138,175,36,132,247,128,119,37,152,58,208,189,94,4,16,75,219,63,7,126,3,28,3,86,164,229,194,128,132,187,45,235,56,11,188,3,252,17,248,171,
172,162,203,152,86,4,204,0,199,129,87,129,51,242,229,110,70,139,131,190,186,122,199,25,189,243,184,104,136,70,205,124,17,184,13,120,22,248,72,68,37,35,190,182,244,238,103,69,75,113,84,204,79,1,247,1,127,18,90,119,199,192,124,214,34,106,162,229,62,209,54,84,147,95,2,30,3,62,206,32,242,110,136,222,86,152,91,207,92,117,253,127,55,2,237,136,166,199,68,99,52,104,16,140,128,3,192,35,192,131,192,222,62,238,77,128,166,52,117,9,216,16,160,181,116,185,85,214,85,1,170,202,23,102,128,201,156,239,74,128,85,224,117,224,101,224,139,60,33,51,202,201,252,10,240,36,112,191,16,63,207,106,139,160,243,98,188,213,39,98,199,74,148,230,129,253,210,108,41,199,125,235,192,91,192,11,138,26,166,16,10,57,53,255,20,240,128,52,19,90,29,224,75,197,238,179,210,252,110,18,24,103,218,155,192,255,148,32,21,100,33,177,113,223,36,112,187,104,253,167,222,191,107,1,44,1,143,203,236,171,57,8,190,8,188,47,198,27,3,204,218,18,61,239,43,89,83,69,151,207,130,39,20,25,10,192,63,132,55,125,11,96,10,248,157,252,126,49,64,96,
11,248,68,64,180,57,196,220,61,17,51,171,114,167,170,193,195,164,132,176,161,148,186,221,143,0,138,192,189,192,211,202,231,45,172,168,3,31,42,95,223,30,81,40,222,150,75,52,36,132,178,161,196,67,192,127,128,255,238,132,65,5,143,223,223,2,60,3,252,44,224,111,27,192,191,100,250,253,166,207,69,153,234,84,134,129,168,79,160,172,9,244,230,51,149,101,47,47,243,114,229,191,168,210,12,10,96,6,120,8,248,173,204,200,98,254,132,8,200,179,74,114,165,31,73,43,135,128,155,101,97,7,245,185,95,213,98,57,83,33,134,86,83,180,248,132,16,171,10,189,172,250,161,101,9,32,6,126,161,144,183,223,48,253,45,49,127,41,7,129,21,133,209,59,196,240,98,70,235,69,209,80,144,128,38,101,210,203,34,122,78,145,160,25,192,149,166,92,113,175,39,37,46,233,121,127,7,62,203,62,171,87,0,243,192,19,42,50,138,134,255,125,40,68,14,69,152,131,192,93,192,77,98,46,238,179,167,48,43,194,43,153,228,201,183,26,18,214,210,14,239,137,36,216,174,202,234,230,78,2,136,85,195,63,26,64,253,47,124,128,210,163,245,35,194,146,188,153,92,
168,220,94,148,0,234,198,111,55,213,123,168,122,20,178,40,43,56,227,172,160,208,227,251,15,171,158,47,24,136,255,190,92,192,10,159,71,129,31,244,161,241,60,171,156,17,66,205,8,147,117,89,65,217,67,219,101,53,86,90,100,8,140,212,201,57,102,164,155,9,240,105,64,3,142,249,37,134,83,163,151,101,89,7,141,231,215,122,253,188,7,11,142,137,215,40,43,128,162,218,88,43,129,7,159,15,244,8,238,200,145,52,93,235,42,233,61,75,198,111,190,148,59,248,234,154,123,28,198,57,1,204,201,255,43,134,246,207,5,76,127,69,102,63,138,85,86,190,95,49,162,194,231,30,43,168,136,215,57,39,128,40,211,189,45,24,8,123,193,32,104,86,2,136,25,221,170,6,44,246,124,22,237,123,192,240,136,203,112,157,0,92,247,214,183,214,12,237,71,153,38,232,168,123,146,7,4,222,62,43,88,243,124,183,44,158,163,88,62,117,84,225,195,170,242,18,35,228,45,143,169,49,59,169,60,193,71,247,154,135,238,105,241,92,138,133,220,135,13,244,239,4,210,221,189,129,148,121,216,107,159,81,12,93,18,253,59,1,233,97,96,58,206,100,91,86,218,219,52,204,
176,159,246,216,48,214,180,97,189,77,143,235,70,226,121,54,86,239,109,143,193,196,101,143,20,29,26,207,48,222,21,43,133,247,181,229,26,30,1,236,1,22,156,5,84,2,189,189,196,240,193,137,49,11,32,50,250,148,137,81,81,86,156,5,76,7,154,141,155,129,228,39,102,252,171,20,72,224,124,247,204,184,206,171,213,26,11,21,61,209,117,32,0,139,135,174,81,173,78,92,15,218,27,84,175,112,215,0,178,21,232,229,197,129,26,60,185,14,4,208,50,120,40,24,125,141,173,88,213,157,213,122,178,80,190,195,24,183,167,123,4,144,244,73,127,27,216,140,5,18,141,93,2,76,35,80,32,141,202,252,215,141,8,81,50,104,175,197,164,157,210,53,67,130,83,70,123,172,77,96,231,101,4,171,139,191,55,233,102,147,124,105,242,55,206,2,46,24,2,152,8,148,201,171,99,198,129,77,163,73,83,241,228,41,137,120,174,197,202,244,78,25,56,80,196,222,16,93,13,184,208,176,215,5,131,246,121,15,8,182,197,115,61,214,31,39,12,41,70,129,22,87,147,116,243,114,28,171,105,244,41,34,117,167,118,162,187,46,158,219,177,204,225,36,118,155,123,193,168,248,18,
210,30,92,125,12,224,247,89,192,252,23,60,223,185,201,179,36,206,180,187,78,26,177,116,146,116,163,196,242,195,79,71,28,18,215,241,55,63,17,189,19,158,248,239,102,15,147,56,243,176,247,12,95,142,72,59,177,86,221,255,57,118,211,116,144,203,13,72,109,25,218,247,117,142,27,226,117,61,155,229,117,72,123,229,103,3,9,197,77,129,164,232,227,17,224,65,139,116,103,106,205,248,205,1,79,143,32,17,143,239,186,18,63,206,124,113,138,116,8,177,109,88,193,138,202,103,43,53,254,64,66,72,134,164,249,15,100,105,190,231,87,73,55,96,35,15,250,191,35,94,191,179,51,212,209,15,142,27,13,134,146,174,175,13,127,239,112,101,156,101,118,128,229,242,134,52,111,9,183,72,218,236,244,129,223,57,224,69,89,234,119,4,224,178,163,67,192,143,141,34,98,90,154,216,8,184,195,69,33,244,148,192,104,183,101,115,91,96,247,17,246,110,180,179,208,155,61,239,106,1,127,0,222,200,98,93,97,135,31,109,0,191,52,98,168,27,58,216,192,152,189,145,64,107,10,57,13,89,78,57,167,69,36,153,24,127,146,116,67,182,21,184,103,25,184,211,147,
182,39,164,35,60,207,103,205,127,39,1,36,50,239,121,224,167,248,187,173,5,101,135,161,66,202,89,195,37,49,115,81,66,219,214,187,182,179,165,169,194,233,170,66,234,105,49,158,167,228,94,4,238,54,82,246,58,240,26,240,118,111,228,240,105,248,86,210,97,195,95,7,186,69,155,192,191,3,136,236,235,49,100,7,35,186,153,146,182,211,231,179,22,229,178,211,70,221,255,103,210,97,175,211,189,194,44,24,128,179,70,58,2,111,117,140,221,150,117,27,187,119,184,147,73,118,197,108,75,247,119,251,76,164,92,110,114,23,254,25,225,68,76,63,7,252,141,156,67,82,174,196,116,155,139,63,49,164,235,34,195,162,62,107,140,102,82,204,205,1,222,134,221,149,94,5,94,2,126,239,75,154,10,1,244,61,45,230,239,14,100,129,5,174,236,47,52,9,207,244,92,75,11,111,175,76,126,95,128,254,117,249,253,43,70,195,36,56,41,218,16,10,47,144,110,71,79,4,76,178,66,186,69,94,229,202,48,116,50,32,198,23,73,231,2,110,145,201,91,97,181,6,188,169,152,111,102,166,121,142,180,212,72,199,98,170,50,185,201,28,196,186,237,182,57,17,186,157,65,
254,126,152,118,27,175,183,139,241,106,142,48,186,46,230,95,112,5,79,8,72,242,2,206,181,140,203,187,99,113,217,113,249,173,158,180,187,119,92,126,94,245,71,153,33,142,203,211,39,234,14,242,192,68,67,214,181,145,201,39,70,126,96,98,55,235,134,61,50,211,91,116,220,176,135,166,178,46,241,189,63,54,119,195,31,156,252,255,209,217,33,185,198,13,121,120,218,247,124,183,63,55,205,213,199,231,103,184,250,248,252,38,87,31,159,119,155,182,67,61,62,255,45,20,23,53,103,108,198,210,19,0,0,0,0,73,69,78,68,174,66,96,130);


template_rings_256
:array[0..19748] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,1,0,0,0,1,0,8,6,0,0,0,92,114,168,102,0,0,76,236,73,68,65,84,120,1,236,221,75,140,101,89,118,30,102,137,148,154,77,145,221,93,93,143,174,126,86,69,214,163,159,164,217,164,216,144,37,13,44,192,128,225,137,1,195,158,88,19,25,176,167,214,80,128,7,30,16,240,64,19,193,128,39,158,24,182,135,30,122,224,129,97,192,128,5,3,178,77,208,166,36,147,18,217,85,221,85,89,239,103,179,94,253,40,118,179,73,255,223,205,248,131,59,111,222,200,140,204,184,231,220,115,35,206,2,86,236,125,158,123,239,181,215,255,175,181,247,185,89,245,139,127,101,149,37,91,224,175,166,115,219,250,11,167,231,148,244,23,135,242,175,165,94,253,235,169,211,79,12,229,39,83,255,165,11,104,159,85,246,125,218,81,111,123,109,95,255,218,39,117,178,221,231,91,103,215,191,139,179,128,201,92,101,57,22,24,129,83,80,21,104,230,170,10,136,35,184,1,187,250,203,169,255,141,232,175,156,234,175,166,164,159,57,213,79,15,165,250,168,159,202,49,245,108,223,163,164,37,14,132,82,82,209,159,93,
164,208,190,143,132,144,91,207,136,65,125,149,5,88,96,37,128,195,78,194,54,224,11,156,17,232,5,28,0,22,148,0,13,168,64,253,217,232,35,209,199,162,159,139,62,126,170,95,72,249,197,83,253,82,202,175,68,159,140,62,113,90,119,188,173,95,206,57,207,120,71,223,165,124,52,170,13,170,61,237,150,40,144,77,201,167,125,45,41,24,71,199,164,36,29,243,118,125,115,113,253,51,175,5,86,2,152,215,222,117,126,101,129,49,130,29,112,128,8,160,0,11,200,68,104,160,3,66,192,252,124,20,72,129,21,160,159,138,62,19,125,246,180,124,250,244,156,243,244,198,169,182,238,153,18,1,50,216,165,37,134,241,218,248,156,235,250,160,47,136,71,223,30,142,150,28,16,84,137,1,113,201,86,58,206,95,72,157,214,22,169,110,234,45,157,95,101,38,11,172,4,48,189,161,235,232,117,122,101,193,208,52,94,100,151,118,3,251,67,81,81,87,4,23,185,1,15,136,1,252,171,81,96,167,128,78,159,58,85,247,20,176,200,129,122,190,89,128,247,209,102,8,187,202,49,234,151,108,182,51,9,239,27,223,171,174,173,146,134,58,98,104,214,96,60,198,101,124,93,
70,148,16,216,98,180,75,14,55,82,18,104,217,243,107,185,103,11,172,4,176,103,131,158,190,142,227,210,58,184,146,173,11,248,49,194,139,154,5,60,16,61,21,5,244,175,157,150,128,95,176,223,72,29,33,20,224,5,55,192,121,7,45,240,164,235,141,202,218,168,2,100,247,3,206,43,1,214,53,247,246,57,165,247,245,189,74,109,201,0,74,22,250,131,48,244,135,182,127,206,233,155,231,187,124,144,33,52,59,144,249,176,15,45,33,212,134,74,210,242,214,209,250,119,47,22,96,240,85,246,99,129,58,236,54,232,165,244,28,93,4,148,210,3,18,208,0,133,136,189,13,248,70,121,231,79,162,5,187,251,1,13,232,40,48,81,32,109,148,245,254,110,250,1,152,54,171,142,101,26,93,175,159,87,186,167,123,13,158,169,246,61,202,182,161,189,146,136,113,233,71,251,53,146,67,179,141,18,131,177,176,129,103,60,63,46,25,144,36,66,168,29,83,221,128,191,246,237,177,114,149,75,90,96,37,128,75,26,48,143,215,49,149,141,98,64,15,96,192,194,193,129,65,52,44,224,69,247,49,194,139,242,0,223,232,46,173,6,22,32,233,198,219,8,242,130,113,4,117,163,169,
182,129,168,64,106,217,190,93,180,4,194,106,223,215,178,164,166,205,18,134,178,253,42,65,140,228,128,24,140,69,38,80,66,80,47,41,168,35,132,113,185,48,102,6,236,75,90,110,215,55,23,215,63,247,103,129,149,0,238,207,94,189,187,160,111,148,98,71,224,0,8,32,224,196,5,61,80,63,19,253,70,116,4,253,211,57,118,109,123,67,13,80,26,25,69,216,130,10,192,188,127,4,248,8,230,246,165,125,219,85,186,103,215,249,237,115,185,237,220,251,218,78,75,125,24,137,162,228,208,12,99,204,32,154,49,32,51,99,68,8,93,66,32,133,146,131,115,99,102,224,157,29,235,216,215,156,62,35,4,231,87,185,79,11,48,234,42,23,183,192,232,124,117,124,206,9,156,64,207,161,165,183,128,253,108,180,160,7,124,199,55,162,178,0,17,158,195,143,17,190,14,47,122,22,236,141,184,117,254,93,0,222,117,110,236,231,88,207,171,47,36,227,51,247,170,123,225,120,79,137,65,89,98,40,41,24,87,51,35,196,54,18,66,51,4,54,217,86,182,113,191,103,217,132,61,198,113,231,240,76,244,101,149,11,90,96,37,128,139,25,170,14,206,233,216,140,19,54,218,139,102,
192,12,216,141,244,5,62,208,63,117,122,205,18,64,132,147,25,108,71,248,17,240,64,179,237,224,163,179,183,47,45,115,251,65,165,253,216,85,234,152,243,181,155,113,25,95,237,7,208,198,46,75,40,33,32,210,102,8,108,85,45,89,34,13,207,52,43,216,182,77,46,109,68,187,171,220,195,2,43,1,220,221,64,117,222,58,48,199,229,180,156,84,196,2,234,27,81,17,30,232,191,126,90,127,42,229,24,233,187,142,247,28,71,191,23,224,181,59,106,14,143,82,198,49,168,19,101,237,89,66,104,134,80,66,96,35,202,94,162,127,151,11,200,128,221,169,243,136,3,17,123,207,46,95,110,155,185,188,202,46,11,236,50,218,174,251,174,219,185,58,41,71,21,177,56,40,103,227,144,34,145,117,251,211,209,111,158,42,224,139,246,55,162,227,119,112,142,43,98,73,235,57,183,247,236,138,240,218,27,53,135,87,82,198,49,170,19,229,72,8,72,150,157,216,139,34,2,246,27,201,160,203,5,196,42,91,48,55,238,101,91,239,234,187,83,221,200,246,113,207,95,251,114,37,128,219,93,160,206,88,224,139,46,156,75,180,145,190,139,234,95,141,138,246,141,248,136,192,
249,166,248,141,78,187,64,239,253,187,52,167,175,165,108,219,130,17,58,7,124,115,36,3,89,147,185,216,69,6,136,22,17,184,102,206,70,34,240,190,202,88,239,185,107,93,174,4,112,107,250,235,136,141,68,141,248,28,203,103,42,155,122,128,255,173,40,224,75,249,111,68,101,2,174,119,93,223,245,105,157,144,125,251,238,177,204,233,85,118,88,96,219,70,142,59,39,187,200,128,189,101,6,192,143,120,149,84,214,96,14,60,227,249,202,95,180,146,210,187,175,189,92,119,2,168,195,213,201,10,124,78,100,99,239,36,10,236,82,125,192,71,2,79,69,165,249,174,75,65,119,237,80,247,189,99,153,91,87,185,15,11,108,219,206,49,127,21,221,1,27,192,155,21,116,191,160,4,160,52,47,50,2,115,106,126,61,191,75,206,59,191,235,222,43,119,238,58,19,64,29,140,13,56,9,103,226,52,128,45,226,23,248,192,15,248,55,162,62,223,89,10,52,205,151,146,114,196,237,148,179,239,206,165,85,246,96,129,218,83,73,74,216,219,89,1,34,144,21,152,199,146,129,12,193,121,115,108,174,251,142,84,255,202,152,17,56,190,118,114,29,9,128,3,212,129,0,23,
240,57,9,96,239,2,190,136,95,224,91,18,184,23,240,57,159,231,251,62,229,232,92,57,92,101,2,11,212,206,45,249,112,73,28,25,219,12,52,63,162,63,34,168,142,243,54,206,211,181,38,1,64,184,46,82,135,49,102,192,229,40,141,248,64,254,235,209,239,68,255,86,244,183,79,143,69,126,27,124,214,249,210,125,209,101,123,183,121,116,166,92,94,101,70,11,236,154,83,115,100,174,204,89,55,109,205,173,57,53,183,230,216,177,57,151,237,241,129,107,59,167,215,133,0,234,40,141,20,162,131,207,121,39,209,111,69,183,129,255,108,206,113,30,14,34,221,31,119,151,251,46,229,42,203,176,192,56,39,200,93,38,96,206,204,157,57,52,151,230,116,155,8,204,253,73,148,47,184,127,92,38,92,139,249,189,234,4,80,199,48,78,41,187,116,95,26,47,165,183,198,255,173,104,163,194,111,164,46,226,91,6,248,57,111,35,126,215,248,125,215,181,112,140,140,255,24,101,156,163,18,65,51,130,254,68,219,28,155,235,146,62,31,224,11,124,130,111,240,17,190,194,103,250,190,84,175,166,92,101,2,232,228,213,17,48,188,117,254,141,104,35,129,180,240,219,
209,175,159,158,247,45,191,192,111,90,216,247,40,87,57,14,11,140,115,214,229,94,137,160,191,222,52,231,230,158,15,116,201,199,55,248,200,174,140,47,167,175,158,92,69,2,232,228,111,71,125,159,238,76,250,223,140,98,255,223,140,218,225,127,42,138,253,31,141,218,40,90,129,31,35,92,17,169,47,40,75,4,230,216,92,155,115,115,207,7,248,2,159,224,27,124,132,175,92,139,108,224,170,17,64,39,124,92,235,99,244,167,163,77,251,76,178,12,192,154,208,15,121,92,247,201,168,59,251,108,210,247,164,186,202,21,176,64,231,211,220,74,239,205,181,57,55,247,124,128,47,240,137,6,7,190,194,103,154,13,92,217,189,129,171,68,0,38,217,120,48,253,174,181,190,52,79,202,247,141,232,141,168,53,97,55,248,174,205,154,47,99,190,206,178,77,4,221,40,228,11,124,130,111,116,89,176,107,111,128,111,53,64,164,122,252,114,85,8,160,224,7,100,147,106,87,247,36,250,107,81,172,46,197,83,127,38,186,157,238,203,22,174,212,164,102,60,171,220,221,2,245,23,115,111,201,55,46,11,248,8,95,225,51,124,71,253,36,202,167,126,53,58,6,139,28,
30,183,28,59,1,140,19,105,183,222,68,250,254,43,165,51,129,141,250,214,117,118,247,93,179,182,107,186,239,121,186,202,245,180,64,231,31,168,249,4,223,224,35,124,133,207,52,27,224,75,124,202,53,62,198,215,174,68,224,56,102,2,232,228,141,41,191,245,220,55,163,210,55,106,93,135,209,109,234,216,248,177,19,220,201,235,243,57,181,202,53,182,64,253,0,160,249,6,31,225,43,124,134,239,240,161,250,19,223,226,99,136,194,50,147,239,245,249,84,143,79,142,149,0,24,93,223,203,220,143,164,126,18,245,195,14,108,109,19,7,131,159,68,173,239,76,216,26,245,99,132,85,206,181,64,129,92,159,226,51,124,231,36,202,151,248,20,223,234,143,135,248,92,125,138,47,122,254,232,4,131,29,155,48,52,182,238,68,61,156,122,127,242,233,71,30,79,71,173,243,173,217,164,107,87,130,169,51,142,7,149,125,255,214,253,40,29,253,130,198,235,216,154,222,215,207,100,6,159,140,2,60,253,149,211,227,151,83,254,73,244,199,209,159,69,127,30,221,183,189,243,202,233,228,152,8,192,228,80,108,219,84,13,200,173,215,190,22,5,254,27,209,241,
199,60,238,43,59,119,114,115,234,202,201,121,78,215,243,231,149,247,50,68,109,54,150,222,213,227,237,231,207,59,191,125,223,210,143,59,14,248,0,118,165,128,179,77,4,130,203,75,209,119,162,31,69,255,52,250,231,81,54,170,205,83,93,174,28,11,1,152,16,138,145,77,130,200,14,232,79,69,1,159,158,68,187,201,119,229,118,107,51,182,202,182,99,245,184,78,183,235,152,131,126,28,253,73,148,131,210,123,9,123,19,229,39,78,213,186,216,113,53,213,179,186,115,218,86,142,178,125,60,94,91,114,189,99,84,138,254,124,15,94,216,194,49,240,83,25,1,159,124,61,250,97,20,9,200,4,72,231,226,214,209,2,255,30,3,1,116,34,76,0,195,127,38,42,197,7,250,175,71,159,141,90,2,248,71,31,126,220,97,66,140,171,207,165,122,212,178,237,68,142,171,141,54,117,188,159,230,90,207,245,30,14,73,17,0,199,44,248,183,223,155,75,59,69,228,163,156,253,123,167,245,218,182,165,235,128,97,221,236,220,221,178,46,215,143,73,58,30,227,19,120,248,86,199,91,34,64,0,252,243,181,232,7,209,218,58,213,101,147,192,210,9,160,14,166,159,28,144,
131,21,252,223,76,253,217,168,93,89,191,216,66,12,38,196,68,244,185,84,143,82,70,112,22,200,5,182,84,19,208,155,110,170,143,199,35,192,251,236,159,229,30,231,101,0,247,43,156,153,131,43,205,67,193,157,234,70,128,129,186,71,223,216,223,61,206,1,141,121,41,136,148,163,108,31,143,215,150,84,111,63,141,223,146,192,24,213,59,70,227,116,76,95,139,190,23,101,107,118,39,227,124,222,58,179,144,191,58,188,84,97,116,170,143,162,186,205,190,39,163,95,139,54,242,75,73,187,217,87,22,238,100,229,210,81,73,157,164,160,85,2,109,215,150,5,121,35,186,107,212,125,141,236,63,76,125,10,209,230,221,196,252,0,69,201,183,192,48,39,34,162,57,236,57,132,80,18,233,28,231,212,102,174,149,75,149,246,85,41,24,25,195,72,4,198,103,188,200,192,181,110,14,46,154,4,150,74,0,140,204,136,250,199,216,143,68,79,162,223,138,126,35,250,116,84,38,208,111,251,53,186,231,142,73,182,65,63,2,190,64,111,233,26,160,79,13,246,7,177,159,93,240,109,17,41,59,135,5,255,72,8,230,140,110,19,130,247,44,121,30,245,13,240,101,155,219,
36,48,18,64,199,208,76,160,100,157,199,150,35,75,36,0,134,171,227,112,162,17,252,8,160,224,151,17,28,235,102,223,8,124,142,209,53,188,8,46,213,6,250,130,125,137,128,79,247,238,41,63,218,186,99,155,16,128,5,136,140,93,157,218,195,49,247,149,130,168,199,75,41,235,163,8,204,190,64,253,21,158,168,227,234,15,82,103,139,46,195,58,247,57,117,120,89,26,1,212,176,34,6,135,145,222,159,68,173,247,129,255,153,232,23,163,5,191,254,123,134,46,93,58,241,74,186,13,122,192,231,36,117,20,169,255,85,146,93,132,32,146,22,252,50,61,54,65,10,37,131,113,110,151,54,199,250,3,228,35,9,56,54,166,130,95,157,190,19,53,126,191,21,88,84,38,176,36,2,168,65,245,9,248,109,236,61,21,5,126,250,116,84,218,15,252,214,156,199,2,254,17,248,141,246,192,45,218,55,61,188,170,160,207,16,207,149,145,16,204,247,8,126,100,96,89,129,12,108,252,2,84,101,73,68,208,190,240,69,217,104,129,95,95,46,1,56,126,59,106,206,59,215,245,139,156,58,156,44,133,0,24,136,22,252,34,63,240,255,90,180,224,111,228,7,126,134,237,51,169,46,82,58,
193,74,105,60,7,31,129,47,26,112,134,171,22,233,51,164,251,150,146,1,27,33,3,25,0,18,160,72,178,68,96,222,43,230,127,9,210,126,212,119,235,151,37,131,146,23,63,160,205,4,244,189,62,162,126,16,89,2,1,212,96,250,98,194,31,137,158,68,1,159,62,19,253,66,116,59,242,231,212,34,165,147,170,4,124,187,224,152,31,208,165,249,118,243,1,223,185,85,238,180,0,128,80,68,47,11,224,19,234,108,183,84,34,168,15,43,245,181,226,152,200,252,186,167,211,37,0,31,32,245,151,91,71,51,255,45,59,205,220,236,89,115,53,28,240,51,220,54,248,165,253,199,6,254,2,223,103,160,215,162,111,68,223,142,138,110,28,250,253,232,10,254,24,225,30,194,86,190,167,179,151,141,52,202,166,236,249,110,20,160,216,250,160,0,74,251,163,240,231,250,178,128,197,119,249,240,55,79,245,36,37,31,231,235,238,171,255,167,122,24,57,36,1,116,240,210,58,44,207,96,39,209,111,157,42,195,141,105,127,13,150,211,139,19,78,88,150,231,180,175,70,71,224,75,99,87,224,199,8,15,32,35,17,32,0,68,192,198,175,159,214,17,65,163,106,170,7,151,109,18,224,
195,124,185,126,125,146,58,95,231,243,124,191,56,72,117,126,209,248,161,4,249,48,128,180,14,43,222,136,254,250,169,126,53,229,151,163,219,108,153,83,139,146,70,31,14,40,213,255,232,84,1,126,77,245,99,132,9,68,244,180,71,160,236,242,128,15,1,85,3,218,33,253,58,221,216,8,223,144,230,35,48,164,37,40,60,23,253,131,83,125,49,165,243,150,54,37,177,84,231,149,26,108,222,86,111,177,158,182,77,164,31,130,216,221,255,90,244,27,209,99,137,252,38,152,138,236,82,125,17,233,237,40,34,88,83,253,24,97,34,105,70,32,11,216,149,17,116,94,38,106,254,194,175,69,66,178,86,68,133,156,154,9,240,113,190,206,231,249,62,12,192,194,65,72,235,16,4,96,160,34,191,129,127,58,202,16,34,254,215,163,192,239,152,193,24,206,125,7,49,76,218,61,79,56,88,211,253,183,82,127,39,10,248,31,70,87,224,199,8,51,9,91,35,0,68,32,146,170,155,3,115,209,136,106,174,14,41,245,245,146,0,223,230,227,124,157,207,59,134,1,88,56,136,175,207,77,0,12,162,77,63,244,249,84,20,43,50,196,55,163,207,70,11,126,223,84,151,184,230,47,248,69,125,
41,157,205,40,142,39,229,231,136,235,230,94,140,48,179,148,8,128,223,92,152,27,217,152,250,18,246,6,248,60,95,230,211,2,27,31,231,235,124,158,239,195,0,44,192,196,236,153,192,156,4,192,16,53,6,70,124,44,250,84,20,27,50,136,53,255,163,209,17,252,238,95,130,20,248,34,203,219,81,81,31,248,57,157,53,156,114,149,195,90,192,28,80,192,167,234,230,233,208,217,192,232,247,124,155,143,243,117,62,207,247,97,0,22,96,162,65,111,54,191,159,155,0,12,208,198,205,195,209,39,163,24,144,33,190,18,101,132,50,97,141,150,83,7,23,224,167,141,250,156,74,180,111,186,239,155,245,42,203,176,64,51,49,155,177,219,217,64,231,241,16,61,173,63,139,242,124,156,175,243,121,190,15,3,176,0,19,176,81,18,72,117,122,153,139,0,24,64,91,214,58,15,69,159,136,126,45,106,240,234,159,139,126,58,250,137,168,251,102,99,192,180,117,55,225,52,34,72,215,250,192,207,185,68,125,229,42,203,180,128,232,79,199,108,64,230,102,46,205,233,33,164,24,224,227,124,157,207,243,125,24,128,5,117,216,128,145,217,48,48,7,1,108,15,220,26,200,
160,233,73,244,241,232,193,119,67,211,135,81,56,201,159,71,69,253,215,162,210,125,81,95,132,113,110,141,250,49,194,194,101,87,54,240,70,250,140,20,204,237,33,136,160,88,0,114,62,207,247,79,162,197,67,55,5,63,145,115,179,144,192,212,4,208,1,75,125,172,127,62,31,181,11,106,192,55,78,143,177,222,39,163,7,217,5,77,187,219,194,49,104,215,249,74,209,100,141,250,49,194,17,202,174,108,0,161,119,158,231,30,18,76,240,117,62,207,247,97,2,22,96,2,54,28,195,10,204,76,78,2,83,18,128,129,118,176,54,56,108,126,24,168,116,199,64,237,126,250,151,94,174,45,9,252,162,131,148,95,164,23,45,214,168,31,35,28,185,140,217,128,76,206,215,26,196,126,200,76,128,207,243,125,24,232,111,4,96,3,70,96,101,196,5,28,77,34,83,18,128,14,123,191,116,7,211,117,211,3,248,165,58,143,68,49,221,172,155,30,105,239,60,17,17,186,222,247,99,30,142,226,63,204,33,130,172,114,53,44,96,94,45,223,16,187,61,156,183,163,135,218,23,0,106,190,15,3,176,0,19,176,97,99,16,86,96,6,118,38,197,232,84,47,55,56,239,150,198,216,245,148,214,
60,115,170,6,103,23,116,41,59,254,128,191,107,189,15,252,235,70,95,140,112,197,4,161,251,130,131,224,101,121,175,71,15,177,47,0,35,180,24,233,151,129,226,4,102,138,17,88,114,239,222,101,10,2,232,192,176,155,52,70,58,115,18,197,110,79,68,187,227,95,118,155,100,96,105,231,34,210,117,224,184,222,7,122,224,151,38,174,114,53,45,96,142,41,18,160,72,225,16,251,2,124,31,6,97,225,211,209,126,25,128,149,147,104,151,2,176,228,222,189,99,101,10,2,72,63,55,107,122,131,178,190,17,241,177,218,73,212,174,167,212,198,247,206,201,88,45,239,190,136,20,252,210,64,145,96,93,239,95,196,106,87,231,158,243,246,5,234,23,115,141,20,168,97,1,38,96,3,70,78,162,48,3,59,48,4,75,191,24,221,187,236,155,0,58,152,166,53,54,55,172,105,48,90,215,253,191,146,122,25,45,213,131,72,39,25,248,215,245,254,65,166,96,49,141,118,95,64,38,96,127,64,54,88,255,152,171,147,112,3,19,176,241,72,116,220,15,152,244,167,194,251,36,0,131,232,64,176,89,83,255,167,82,199,100,142,251,121,163,247,230,212,236,210,201,29,193,255,211,244,
66,74,120,157,196,103,40,243,33,234,136,50,219,42,37,229,144,215,65,198,125,129,67,144,64,241,32,112,154,19,88,129,25,216,57,137,58,134,169,6,78,247,239,69,246,73,0,58,228,125,126,196,192,169,252,222,217,0,186,238,255,76,234,135,254,222,127,157,192,207,214,54,145,0,91,84,177,201,100,141,41,197,20,97,148,254,139,53,206,109,171,251,31,142,154,71,247,184,151,186,143,51,186,110,62,175,18,65,140,36,240,195,140,109,238,76,0,168,165,249,230,141,109,217,26,118,96,8,150,204,5,108,237,21,179,251,122,153,206,123,87,83,127,59,152,210,254,27,81,41,12,39,180,33,136,193,14,37,87,29,252,34,132,168,13,160,5,173,210,92,40,169,185,160,192,140,16,204,139,235,5,120,203,222,163,236,115,238,171,106,163,4,225,28,103,245,46,209,235,152,165,36,240,126,6,113,8,18,96,59,24,129,21,246,100,127,24,130,37,118,222,251,87,129,125,18,0,246,226,132,162,195,147,81,29,239,186,255,208,169,255,85,4,255,8,120,142,194,65,216,187,160,223,5,240,70,122,215,10,98,206,182,75,57,224,118,230,176,77,16,109,203,187,220,235,25,
231,142,153,16,70,18,248,81,198,50,103,38,32,144,210,46,5,216,212,156,194,18,76,57,54,239,176,230,190,75,203,62,8,64,71,188,71,122,34,117,209,225,167,162,77,253,69,165,67,166,254,87,9,252,5,61,176,3,35,91,23,252,64,45,77,116,77,189,128,100,123,115,35,178,80,206,67,205,217,69,180,247,247,121,239,242,78,109,105,3,216,245,67,57,18,194,152,33,28,91,118,80,18,120,47,99,58,4,9,176,57,27,195,14,187,118,41,192,206,48,214,165,192,165,73,128,3,92,70,116,128,234,176,40,194,241,78,78,149,51,152,120,231,57,207,161,4,1,96,113,147,106,66,127,26,253,40,122,76,210,204,170,96,3,126,81,23,8,213,217,189,128,43,80,11,242,206,145,185,110,253,65,203,241,29,234,218,104,123,28,83,31,218,71,37,50,66,18,84,95,245,89,26,123,12,178,77,2,239,166,211,124,105,46,97,87,216,105,86,117,146,58,53,215,206,179,125,231,49,213,7,147,203,18,128,86,189,195,119,74,14,32,26,73,85,48,149,73,151,250,99,171,75,119,52,239,120,16,49,97,64,127,140,224,111,180,71,164,85,0,98,103,224,42,168,164,139,35,216,71,144,214,238,202,125,
201,248,206,214,219,166,82,95,244,169,25,2,159,224,180,219,203,4,100,177,244,61,131,109,18,120,63,125,158,131,4,106,87,216,97,35,115,13,83,176,197,158,124,0,230,216,251,82,114,153,23,232,164,231,77,182,221,96,78,121,18,109,234,175,147,156,216,61,238,157,91,76,212,207,163,31,157,234,177,68,254,243,162,61,123,2,145,136,80,208,215,81,198,50,151,15,34,99,31,90,31,201,160,89,75,179,2,4,112,12,89,65,73,128,31,253,56,202,167,230,34,1,216,225,15,37,125,216,58,137,194,26,204,241,131,75,225,203,195,151,17,207,247,23,127,62,85,232,160,9,30,83,127,206,48,183,152,160,63,143,190,29,253,81,244,39,81,19,185,100,49,209,0,14,40,108,56,70,123,96,177,30,28,211,190,130,44,167,23,41,237,95,75,125,55,6,99,25,179,2,199,75,39,2,190,3,252,63,140,90,78,242,173,185,72,96,92,10,240,11,24,131,53,24,187,116,22,240,160,4,96,82,61,139,129,164,40,58,118,18,237,15,126,172,243,218,57,247,206,41,38,134,118,221,111,242,68,255,165,74,35,62,27,142,192,111,180,231,0,108,77,11,166,84,143,74,218,239,142,195,152,128,190,
89,129,177,142,68,176,196,165,193,199,233,163,44,64,64,121,55,90,63,75,117,50,97,55,54,131,37,152,98,39,24,59,137,242,21,118,186,84,22,224,229,15,34,99,199,48,81,163,191,9,53,177,156,26,227,31,66,10,254,15,210,248,251,81,224,199,222,75,148,70,68,118,3,0,199,214,123,82,190,237,104,159,83,87,66,74,6,74,99,108,122,203,185,141,157,29,56,182,243,75,146,102,146,124,106,36,129,57,250,200,78,48,85,210,220,149,5,176,231,125,203,131,16,64,39,176,209,159,243,98,37,105,93,39,111,111,159,41,238,115,68,192,111,130,62,60,45,129,255,135,209,165,137,201,124,108,80,192,7,128,2,223,188,212,206,169,94,73,233,248,140,181,68,192,151,216,0,17,112,118,107,221,37,125,53,144,1,252,36,250,94,20,9,240,53,62,55,165,176,19,27,117,67,16,198,96,13,230,216,171,89,64,237,153,83,23,151,7,37,0,19,230,59,101,163,191,12,128,67,115,100,231,93,159,91,76,196,207,163,38,9,232,129,95,125,73,194,54,156,187,233,190,186,9,100,71,54,43,240,83,189,86,82,39,103,3,68,200,30,108,163,68,4,206,177,211,18,68,112,145,81,242,45,37,
159,155,154,4,210,196,198,63,250,219,0,88,131,185,238,5,20,115,236,120,95,114,191,4,80,150,17,253,49,51,71,198,68,62,83,97,166,238,76,246,190,156,154,69,76,0,181,238,199,204,38,198,68,45,73,216,139,141,176,182,178,199,72,115,110,123,165,201,69,74,237,192,38,162,63,18,40,17,44,105,89,192,183,248,24,95,123,55,90,255,75,117,18,169,93,224,14,198,248,15,204,193,30,12,242,37,215,122,95,170,23,147,7,33,0,44,61,238,252,99,33,147,101,210,14,181,246,55,1,210,50,172,108,114,126,22,93,146,72,107,27,201,76,86,211,253,70,124,19,183,202,45,11,212,137,217,134,221,16,38,219,113,122,206,175,190,4,249,56,157,104,22,240,126,234,124,112,106,129,61,24,43,65,142,89,0,76,186,126,95,190,116,63,4,208,137,177,131,107,34,164,33,126,156,128,129,76,74,127,241,215,251,114,106,22,97,120,159,101,76,70,83,127,204,188,4,145,154,1,123,117,77,247,47,62,43,252,136,127,114,106,89,64,51,38,164,192,247,14,189,36,224,99,246,3,74,2,83,127,26,44,174,250,89,16,230,96,15,6,217,3,38,93,235,125,169,222,91,238,135,0,188,205,
253,152,70,227,54,34,40,231,54,57,93,135,164,58,155,20,252,239,164,69,41,89,39,100,182,14,220,165,161,58,172,236,200,90,214,4,113,94,54,52,73,171,92,204,2,37,2,25,0,191,107,137,0,68,194,67,138,108,147,207,33,3,75,129,169,73,32,77,156,237,5,52,147,44,14,217,6,54,239,11,211,23,189,185,147,80,246,193,56,210,143,37,68,255,247,211,15,44,108,50,108,252,45,65,56,38,176,55,114,41,157,91,193,31,35,60,128,212,255,154,250,114,246,145,84,31,224,149,123,123,164,75,1,36,240,65,116,202,165,0,59,208,226,144,29,96,16,22,97,178,89,248,133,253,204,139,46,42,94,234,83,4,199,198,58,54,33,150,16,253,129,255,135,81,224,151,5,28,90,216,135,163,138,84,38,100,141,250,49,194,158,132,243,119,73,80,82,40,40,4,130,67,8,224,235,147,77,56,17,216,220,183,79,169,78,34,218,147,113,55,11,128,69,152,124,51,10,11,127,22,149,141,220,83,46,146,1,116,48,26,229,208,64,175,177,49,250,63,208,14,100,222,241,160,130,101,233,210,82,127,96,167,34,190,148,31,67,95,152,141,115,239,42,247,182,64,129,207,198,221,83,225,151,108,
125,40,217,94,10,212,63,167,232,79,241,8,115,29,55,44,194,36,108,58,7,171,189,47,213,243,229,34,4,224,105,247,105,144,193,173,105,53,40,194,57,198,68,23,125,79,110,221,155,96,124,209,127,41,169,255,8,126,147,224,248,66,147,144,251,86,185,63,11,212,174,245,65,101,193,112,127,111,218,223,221,31,231,85,252,81,22,58,71,54,2,115,176,7,131,198,15,147,176,233,24,86,47,132,201,139,220,196,216,77,57,52,212,157,255,174,193,218,152,251,230,16,236,218,93,127,233,215,18,82,255,17,252,62,211,172,224,159,222,19,118,145,64,179,174,233,91,191,179,5,190,104,67,80,10,174,156,114,67,208,216,97,23,246,140,25,22,17,0,108,194,40,98,104,22,144,234,249,114,47,2,168,145,237,21,104,200,70,131,134,164,95,135,220,249,127,47,237,99,218,37,236,250,175,224,207,68,28,72,234,159,0,32,242,53,40,29,106,57,240,97,250,208,175,2,178,0,193,106,74,105,96,134,69,152,132,77,24,133,85,152,173,125,82,221,45,247,34,0,79,185,167,155,127,77,51,24,88,202,133,129,238,217,72,238,217,151,52,250,151,101,127,182,175,23,63,224,123,
118,129,159,189,216,100,149,121,44,192,214,108,62,146,192,33,151,3,31,167,47,72,96,142,44,192,216,97,176,227,237,242,156,95,246,223,227,164,122,190,220,141,0,10,108,44,35,173,45,195,216,104,176,211,233,92,89,38,213,201,165,27,43,99,244,71,4,135,18,54,232,110,255,152,246,31,170,63,215,189,93,254,218,12,64,9,20,128,48,183,52,56,89,18,52,11,152,42,19,48,102,24,228,127,124,17,54,155,161,59,215,101,128,251,118,202,221,8,192,3,174,99,24,233,21,118,161,53,242,133,24,38,247,239,83,172,171,186,214,58,100,244,151,114,21,252,117,180,18,230,62,199,187,190,235,226,22,168,253,173,129,249,107,179,84,243,52,183,108,103,1,83,182,15,163,176,216,189,128,226,244,66,155,129,119,35,0,6,117,189,191,252,107,250,143,85,199,232,127,46,187,228,190,125,201,118,244,103,96,68,112,8,41,219,142,81,166,206,119,136,254,172,109,254,165,5,58,15,219,36,128,164,231,148,6,169,31,167,209,41,179,128,142,183,89,0,108,34,0,88,69,128,253,101,224,185,24,61,143,0,182,95,204,160,143,157,190,20,211,120,177,244,98,78,241,207,
46,155,94,29,50,250,99,86,186,70,254,57,103,255,226,109,213,119,75,2,230,10,105,207,45,127,154,6,187,23,192,119,167,20,88,132,73,216,4,124,88,53,254,123,6,234,243,8,32,207,110,54,178,164,255,210,93,172,98,15,64,58,229,165,221,252,75,117,114,105,244,199,164,12,122,200,232,143,97,25,153,77,24,154,253,206,101,215,92,91,229,48,22,48,39,230,166,36,80,96,204,217,155,49,11,248,32,13,215,143,167,232,131,241,194,100,179,83,88,133,89,126,122,87,172,158,71,0,53,96,119,255,75,0,94,56,126,99,156,203,249,151,16,253,145,31,149,250,51,116,55,88,82,93,101,129,22,224,155,230,72,166,102,222,154,177,165,58,155,204,145,5,24,103,199,10,155,48,90,2,16,176,186,87,183,19,171,187,8,160,47,236,186,130,195,99,82,47,99,68,140,178,235,185,156,222,187,148,53,15,29,253,1,158,97,11,126,105,229,78,131,238,221,2,235,11,47,99,1,115,212,172,77,198,102,30,249,240,92,50,103,22,0,147,176,89,162,131,217,250,107,191,214,221,225,179,231,1,217,141,30,226,232,62,45,96,148,70,255,187,166,20,185,111,223,178,132,157,127,118,
232,90,82,52,185,195,144,251,30,244,250,190,189,89,192,92,1,130,101,64,231,112,111,47,191,192,139,198,44,128,47,79,37,198,9,155,99,22,0,187,198,92,2,72,245,118,217,69,0,94,228,188,77,5,236,41,253,239,90,106,238,244,95,6,240,65,244,144,107,127,142,131,85,25,114,93,247,199,8,71,38,245,103,62,60,206,229,92,195,144,5,216,183,226,195,124,153,79,239,91,140,145,90,242,192,40,95,53,94,216,133,225,115,191,6,108,19,128,151,144,238,42,122,24,123,138,122,210,167,67,164,255,135,222,249,231,52,148,97,217,171,54,74,117,149,35,177,128,57,51,119,136,156,154,203,57,101,204,2,186,172,157,162,125,99,132,81,88,237,126,85,9,0,166,201,109,254,187,77,0,189,193,205,94,34,226,121,65,1,112,110,42,145,123,166,144,70,127,236,137,73,231,150,142,221,248,45,129,110,51,222,220,157,89,219,187,148,5,204,157,249,44,9,240,237,185,164,65,172,89,192,84,237,26,35,140,34,56,62,107,188,221,251,128,233,59,252,119,23,1,56,231,37,12,37,141,240,2,47,179,155,216,151,220,241,162,92,219,167,148,37,155,58,249,15,28,204,45,198,
15,244,140,184,70,255,185,173,191,255,246,248,44,223,110,116,84,242,235,185,164,89,128,223,176,212,191,247,217,182,241,81,24,237,47,3,97,23,134,249,50,76,223,129,247,237,19,125,137,52,194,58,130,243,143,155,127,219,247,231,242,100,98,195,4,1,0,63,6,157,91,56,7,27,0,191,114,149,171,97,129,102,1,157,219,185,70,197,135,249,50,159,158,114,51,16,70,199,205,64,227,53,86,231,138,239,84,111,201,8,104,23,9,6,177,105,96,13,65,177,135,227,57,211,127,12,41,253,103,44,58,183,0,191,113,43,25,240,14,195,229,220,42,199,103,129,206,163,125,45,243,75,231,36,247,250,51,223,230,227,83,136,49,194,42,204,26,95,113,236,24,182,73,177,126,71,74,128,16,220,212,245,127,9,96,76,255,189,96,74,105,122,84,99,77,253,51,202,93,99,169,115,48,26,155,156,25,108,215,205,235,185,163,178,128,185,52,167,230,152,159,155,227,185,196,127,188,134,95,79,181,12,48,14,227,235,50,160,4,48,238,3,140,65,255,14,2,240,112,211,255,174,255,189,100,36,128,57,192,32,69,178,102,2,254,185,55,255,26,253,141,123,221,248,139,17,174,160,
240,97,193,13,1,208,185,178,0,190,60,229,50,192,184,232,72,0,221,7,24,151,1,185,229,150,140,108,224,65,199,192,238,102,15,2,0,3,57,55,222,155,195,201,68,6,240,97,180,25,192,100,13,157,243,98,192,167,107,244,63,199,64,87,224,116,125,189,4,48,103,22,32,176,81,62,62,213,50,160,56,54,62,24,134,101,152,46,142,141,127,35,5,181,19,53,10,99,120,136,22,8,24,229,236,161,212,167,146,166,255,12,132,0,230,78,255,141,151,209,148,198,63,199,152,211,204,42,7,176,128,185,237,134,160,57,151,249,205,33,93,6,200,4,234,239,251,110,215,216,96,22,150,235,203,252,121,12,106,27,223,46,1,228,218,70,250,16,195,52,69,178,36,152,123,3,144,113,44,3,230,78,255,25,136,51,148,41,83,93,229,10,91,128,255,251,202,99,206,249,248,28,210,101,64,247,1,166,104,19,184,141,7,118,141,13,150,97,154,127,195,248,153,140,4,160,238,33,76,104,151,116,220,0,116,205,75,55,172,145,114,74,1,124,44,57,119,244,55,38,6,98,180,70,255,57,198,171,221,85,230,183,64,253,25,48,204,57,34,152,75,248,54,31,159,226,115,96,199,5,179,2,153,12,
0,150,97,26,182,97,252,12,247,101,189,62,196,16,110,98,20,107,6,70,113,238,236,129,212,167,146,166,67,214,70,93,39,77,213,214,174,247,26,183,241,50,216,28,227,221,213,135,245,220,252,22,48,215,230,29,249,243,249,57,126,115,34,250,35,0,190,254,112,148,236,59,216,24,87,137,205,184,96,154,143,59,87,188,111,28,189,13,123,0,99,184,201,3,128,224,24,73,244,158,84,39,21,36,80,240,79,193,142,119,235,188,241,74,151,110,51,208,221,30,88,175,29,189,5,10,4,4,96,238,145,192,28,130,0,236,113,117,31,96,138,54,141,13,118,155,5,192,52,108,59,62,11,112,173,184,217,218,192,197,222,216,116,216,61,115,17,0,208,75,143,232,156,235,255,130,95,105,252,115,141,55,77,173,114,96,11,152,107,75,190,146,0,144,76,45,124,155,143,119,175,107,138,246,140,11,118,5,52,88,110,96,135,113,88,223,248,248,72,0,234,77,131,0,129,65,48,72,55,13,230,0,133,12,96,170,181,81,94,125,174,48,74,163,127,109,114,238,205,235,133,43,103,1,115,206,223,235,243,115,12,176,251,0,124,126,223,82,172,194,46,12,27,87,131,27,140,27,239,230,
30,23,137,3,55,187,209,134,129,40,56,103,6,112,232,245,191,177,178,197,186,249,23,35,92,51,41,88,248,189,53,57,95,152,67,166,222,7,48,46,64,111,6,0,211,198,8,227,205,0,254,106,163,157,155,1,64,20,116,35,182,40,40,106,160,156,154,84,14,181,254,239,88,141,189,246,152,116,160,235,203,23,105,1,115,15,28,93,6,79,221,201,57,247,1,96,185,25,0,63,135,245,13,174,91,113,128,21,220,200,8,5,127,153,34,167,38,23,4,32,45,178,15,48,231,250,127,77,255,39,159,218,163,104,0,1,240,133,70,200,169,59,205,199,101,156,83,111,4,194,48,156,143,216,46,174,239,200,0,220,84,240,151,28,114,106,22,1,252,110,2,206,210,224,105,35,53,80,55,255,230,202,120,230,28,227,218,214,221,45,96,206,169,20,89,202,204,39,230,144,250,188,114,42,49,46,88,30,73,64,125,147,237,250,227,6,165,147,141,254,140,224,92,175,167,58,169,116,15,64,90,164,62,167,96,253,51,131,204,217,240,218,214,226,44,192,223,129,159,79,204,33,128,95,159,159,194,239,139,109,227,234,94,0,140,243,119,215,206,50,128,222,96,125,224,6,55,207,5,138,14,220,6,
140,47,0,116,46,233,119,81,89,15,131,172,114,189,45,192,7,128,159,255,203,8,167,150,110,4,126,116,218,80,177,176,207,118,97,27,150,141,9,182,139,111,231,207,34,188,129,187,193,70,129,27,24,161,235,132,84,39,7,135,129,3,190,31,1,77,153,14,229,245,183,73,141,50,142,245,182,27,214,131,107,101,129,18,0,12,204,177,12,176,254,231,243,83,236,3,52,160,41,155,213,24,23,140,243,123,4,112,150,1,244,6,23,101,1,99,90,220,23,229,244,100,130,0,14,177,1,104,220,180,108,63,199,88,39,51,226,250,226,75,89,160,115,111,99,174,126,113,169,23,94,224,225,254,32,136,239,79,17,253,141,169,25,0,76,195,118,179,222,51,2,232,77,189,161,41,2,35,212,40,169,78,42,6,79,231,140,254,6,132,9,207,214,67,78,172,114,173,45,192,223,41,223,231,27,115,8,159,167,83,16,128,254,143,227,129,109,122,150,225,111,88,32,39,148,6,220,200,63,215,250,63,77,158,73,73,224,236,196,196,21,217,142,241,210,185,136,110,226,33,173,175,223,131,5,248,2,44,208,57,126,22,60,135,223,55,11,128,107,251,93,198,118,71,6,208,65,23,252,12,49,23,48,
106,132,169,88,48,67,185,67,140,247,140,9,239,184,186,158,184,174,22,224,243,13,12,50,129,57,164,254,63,69,91,197,241,72,2,183,17,128,70,93,236,186,103,195,12,57,190,202,224,31,199,44,19,152,107,172,218,93,101,217,22,224,11,34,191,64,56,7,1,20,252,45,167,176,206,72,2,198,116,22,228,11,118,39,177,66,7,237,252,28,210,136,175,236,247,208,57,218,213,70,73,111,174,177,206,53,174,181,157,203,91,160,190,49,71,96,216,246,253,98,226,242,163,184,253,13,29,19,140,195,58,204,111,190,2,24,164,139,37,0,245,50,70,170,147,139,1,251,14,138,0,232,92,210,113,27,47,153,99,178,111,181,180,254,93,170,5,234,3,115,98,192,39,64,126,15,3,83,129,191,120,110,160,47,1,252,66,7,170,116,145,246,92,31,202,169,201,165,63,0,154,243,43,128,241,141,99,157,124,144,107,3,71,97,129,250,125,125,99,234,78,3,63,255,247,41,112,10,233,120,90,22,235,142,55,41,191,210,193,46,2,112,109,106,193,122,253,20,50,231,63,2,170,65,54,134,152,122,144,235,251,143,202,2,115,250,196,143,99,25,255,6,97,170,223,2,48,188,241,0,126,193,127,
22,232,203,114,214,5,118,62,207,82,131,212,231,52,66,73,32,205,206,38,140,176,202,106,129,243,44,192,255,225,98,14,153,242,119,0,250,95,2,224,243,48,222,175,95,155,37,64,89,161,4,208,141,192,18,64,75,47,154,66,128,191,58,197,251,119,189,211,206,127,55,67,166,30,223,174,246,215,115,203,182,0,159,40,14,230,248,45,0,107,76,129,129,250,182,18,206,235,243,176,174,190,33,128,148,103,75,128,102,4,125,208,181,171,40,6,207,8,198,187,202,106,129,93,22,104,180,156,195,71,128,127,106,41,9,24,143,177,109,48,222,193,57,24,117,234,206,28,250,253,198,109,188,126,22,185,202,106,129,93,22,144,37,242,147,98,100,215,61,199,120,238,54,156,95,181,193,221,207,132,48,196,42,171,5,238,102,129,6,138,187,221,115,108,215,70,191,63,251,215,128,199,54,136,203,246,183,44,120,217,247,172,207,175,22,56,106,11,92,231,12,224,168,39,110,237,252,106,129,125,88,96,37,128,125,88,113,125,199,106,129,35,181,192,117,38,128,169,126,121,117,164,174,176,118,123,135,5,174,162,143,140,95,28,254,162,4,208,111,144,45,119,216,
226,74,157,242,251,107,234,87,88,171,172,22,216,101,1,190,81,63,217,117,253,88,207,21,227,27,34,24,9,0,219,245,23,73,155,139,199,58,194,11,244,219,88,253,6,123,206,127,123,112,129,110,173,183,44,200,2,253,71,58,115,248,200,184,51,63,149,9,96,218,88,40,255,223,96,188,63,118,240,107,167,199,163,95,137,126,46,234,183,201,254,251,97,174,147,41,59,168,35,254,151,204,116,174,136,12,252,198,92,69,132,83,142,49,175,95,229,136,44,0,36,254,117,30,159,124,127,134,126,243,67,255,45,66,186,79,95,108,32,7,120,216,250,147,232,235,209,23,163,175,70,127,84,2,0,118,192,71,0,136,192,255,75,188,63,151,157,250,147,153,78,50,182,255,93,242,28,255,111,246,52,179,17,227,243,31,3,165,251,52,250,230,229,235,159,163,182,0,159,244,159,169,159,43,40,193,219,148,190,216,229,46,2,120,45,250,66,20,17,156,17,0,48,0,254,19,209,207,71,31,138,206,69,0,105,106,3,126,4,128,121,231,250,255,2,24,31,230,93,9,32,70,88,229,54,11,240,195,185,8,160,209,95,214,205,39,167,8,184,8,192,191,180,125,47,10,248,55,163,111,68,127,
44,3,240,187,248,102,0,8,224,11,209,207,70,231,34,0,108,219,255,39,192,79,82,247,223,73,159,67,74,0,251,78,187,230,232,251,218,198,116,22,224,143,8,224,131,40,208,240,201,41,5,1,200,0,148,126,154,190,111,2,48,158,102,0,37,128,23,115,238,173,232,79,70,2,120,52,39,16,192,23,163,37,0,255,116,112,223,29,202,43,239,16,253,176,12,96,108,153,192,28,130,244,154,1,104,159,24,235,42,215,215,2,192,66,0,70,6,48,7,1,8,68,178,208,71,162,130,241,190,241,102,76,246,188,236,1,252,32,250,74,244,133,232,25,1,112,126,255,169,96,29,120,50,90,2,0,142,169,9,192,96,117,16,227,90,111,205,97,240,52,179,17,4,96,220,50,128,41,12,191,105,100,253,115,148,22,0,24,209,114,142,128,132,0,164,255,252,16,22,251,101,46,213,189,8,124,33,52,248,26,9,224,237,28,127,172,65,206,63,18,192,151,114,252,112,116,14,2,72,51,27,65,0,50,128,57,9,0,185,25,183,18,25,236,155,121,243,202,85,142,208,2,0,35,253,111,6,48,245,158,20,156,1,127,9,96,223,89,168,241,32,52,216,26,9,224,157,28,255,41,2,160,254,109,188,180,191,75,0,217,64,
9,96,142,29,114,157,44,1,204,245,41,208,184,129,223,56,177,240,28,227,76,51,171,44,220,2,130,81,9,192,114,20,120,166,148,145,0,166,240,65,227,49,6,25,0,208,191,18,253,126,20,25,108,8,64,163,8,192,70,132,207,128,205,0,172,75,156,159,162,83,121,237,109,162,147,58,72,231,34,0,70,1,124,186,126,9,136,17,86,217,88,128,47,246,11,192,156,191,1,152,202,7,5,87,27,235,198,132,0,110,70,95,136,250,36,248,83,81,16,192,69,66,41,136,245,63,149,1,232,144,20,121,14,2,208,73,224,199,184,202,185,4,248,141,209,26,108,142,113,206,53,174,181,157,7,179,0,63,68,0,192,49,215,114,212,39,119,88,155,138,0,140,7,174,144,217,27,209,23,163,8,192,30,199,207,74,0,74,169,200,231,163,8,224,209,40,66,152,139,0,210,212,65,126,11,32,195,161,253,20,170,31,251,94,131,121,231,42,203,183,0,240,19,64,105,6,48,199,250,95,240,161,130,209,190,247,161,140,169,191,2,4,248,215,162,210,255,151,162,198,184,33,0,141,2,128,14,60,22,181,4,80,90,18,216,28,67,14,100,106,96,72,201,25,124,206,223,2,24,155,236,199,216,167,152,128,188,
118,149,35,178,0,192,88,255,211,185,214,255,112,38,248,238,123,35,186,132,86,2,176,230,71,0,223,139,190,26,181,231,246,103,99,6,224,71,8,34,255,151,163,143,71,75,0,200,97,223,204,148,87,158,137,119,235,172,118,164,255,8,128,206,33,72,135,241,129,127,170,20,108,142,113,172,109,236,199,2,210,101,224,231,135,115,174,255,45,185,139,197,84,247,42,124,220,120,16,192,43,81,25,0,34,176,196,249,185,70,1,208,250,23,1,60,28,253,74,212,82,224,179,81,172,52,53,1,164,137,141,48,190,78,209,185,8,64,195,198,104,25,32,13,171,61,82,93,229,26,90,64,180,156,115,253,47,248,240,59,203,237,41,124,79,96,69,0,48,245,110,180,4,240,102,234,48,118,27,1,0,1,208,35,0,251,0,54,39,116,80,138,60,101,6,144,215,159,9,166,146,122,41,231,18,227,179,215,97,2,144,1,49,222,85,174,143,5,0,133,90,39,55,3,152,122,253,207,186,178,108,153,39,2,152,98,19,186,4,32,221,71,0,47,69,45,1,222,142,34,128,63,231,244,68,227,8,64,135,44,1,252,123,0,217,0,2,112,126,138,206,229,181,119,8,240,251,100,129,137,231,152,0,29,96,3,89,78,247,
1,230,26,171,182,87,89,142,5,154,254,35,0,62,40,114,78,41,141,254,48,55,213,254,147,49,245,19,224,91,169,223,140,126,63,138,12,156,223,16,64,151,0,64,128,141,164,255,20,1,56,158,243,75,0,163,207,189,17,168,77,19,32,19,152,42,21,203,171,87,89,184,5,4,29,235,100,191,67,153,99,253,15,91,205,178,167,248,71,64,121,253,230,147,166,72,47,179,121,61,10,252,47,68,45,115,224,236,47,68,191,166,247,234,128,240,104,20,1,40,117,82,231,166,142,138,77,185,187,17,104,18,230,220,7,232,50,192,56,215,101,64,140,112,141,100,76,255,125,26,179,252,20,29,167,22,216,18,112,186,1,88,12,236,171,93,227,66,106,214,255,0,255,74,244,249,232,75,81,89,142,192,119,150,1,104,28,1,0,187,14,125,49,250,88,84,122,226,28,96,146,125,119,242,214,91,255,242,175,78,235,176,9,152,115,31,192,216,141,209,114,199,196,76,77,120,105,98,149,5,89,64,170,44,250,91,43,91,134,2,199,212,2,91,8,96,10,127,131,35,98,28,227,6,32,2,120,53,10,91,127,22,61,203,0,82,223,56,189,116,95,90,130,0,30,143,118,125,2,28,192,63,53,1,164,137,205,4,
32,0,236,37,77,153,67,24,10,248,101,2,192,223,148,44,213,85,174,184,5,128,69,202,47,42,34,0,58,181,204,177,254,55,46,126,109,60,239,68,111,70,17,192,155,81,164,0,95,155,168,175,44,184,1,192,103,137,47,68,17,192,103,163,150,5,115,110,4,234,52,224,91,2,204,145,138,165,153,141,52,11,176,4,152,106,83,230,180,169,181,88,136,5,128,164,4,128,4,68,255,57,130,142,168,63,199,250,223,120,16,27,208,191,24,237,23,0,231,101,61,103,4,160,46,242,1,1,118,250,92,20,1,244,75,128,204,192,181,41,51,128,190,91,182,33,69,153,123,31,192,196,143,155,129,235,50,32,6,185,6,34,18,118,243,207,102,217,28,50,245,250,223,24,140,11,134,140,233,181,40,240,143,27,128,8,96,179,4,72,121,6,108,32,7,118,192,255,124,244,145,168,117,138,168,232,26,41,80,111,29,77,243,183,27,49,115,238,3,24,73,247,1,128,127,221,12,156,102,110,151,242,214,70,127,0,105,250,63,87,198,105,105,13,87,116,223,129,166,227,178,198,135,159,119,163,47,71,191,27,125,41,106,163,83,150,237,190,219,64,13,216,58,131,0,116,16,1,200,4,212,187,17,232,158,
57,8,192,68,208,57,247,1,210,220,198,30,136,110,221,12,100,141,171,47,135,216,252,155,107,253,47,163,69,0,111,71,165,255,207,69,223,136,58,7,87,183,17,64,142,55,192,70,0,246,1,48,211,23,162,150,1,93,171,116,131,108,74,2,232,187,49,20,149,194,32,130,185,68,155,192,47,19,64,4,235,102,96,140,112,69,5,0,198,232,63,199,230,31,83,74,255,237,173,33,2,254,5,115,251,22,196,6,55,93,255,75,253,159,143,34,3,123,107,59,9,32,231,55,36,192,241,173,133,125,6,68,0,237,236,28,251,0,105,110,35,200,6,83,1,164,29,203,57,197,132,116,41,96,146,230,202,122,230,28,227,117,111,11,248,129,68,122,12,248,64,193,215,230,16,1,85,128,181,188,134,181,6,189,84,247,38,93,255,251,254,111,253,15,252,223,143,254,32,138,24,140,125,35,58,80,169,163,119,25,0,248,150,0,221,7,192,86,189,127,138,78,183,31,45,117,84,26,99,48,202,185,132,35,52,11,96,139,53,11,152,203,242,243,181,115,168,232,47,160,88,82,35,1,65,182,152,75,117,47,98,92,148,15,119,253,127,51,245,239,70,149,50,130,205,247,255,148,27,41,160,29,20,212,156,94,
4,238,62,128,76,64,221,166,152,200,184,239,78,231,149,183,73,251,161,163,6,130,157,125,182,152,83,216,128,109,216,65,202,54,245,152,211,196,42,51,89,96,140,254,54,196,230,140,254,34,63,240,243,169,169,210,127,227,19,48,101,54,93,255,35,0,153,128,108,26,174,206,100,36,0,39,235,232,128,174,147,54,2,45,3,202,88,115,254,30,64,91,58,108,48,115,47,3,198,44,64,186,132,185,73,201,233,214,209,250,247,216,44,208,8,9,24,0,82,157,107,28,99,250,47,200,76,225,79,252,85,192,236,250,95,234,255,92,212,152,145,157,235,236,176,145,109,2,112,178,209,79,138,98,9,128,0,230,252,61,64,154,219,8,227,116,25,160,211,115,46,3,116,128,29,72,179,158,117,41,112,203,30,199,254,247,253,12,160,202,191,144,253,28,34,160,78,153,254,119,12,93,255,191,151,19,175,70,191,23,69,2,253,7,64,176,116,38,219,4,80,70,114,158,195,31,106,31,160,253,232,50,0,248,125,17,152,83,56,6,59,32,2,75,129,117,67,48,70,56,98,217,149,250,207,153,89,138,254,8,160,233,127,125,124,95,38,109,118,195,111,173,255,223,137,222,140,74,255,95,142,
222,246,253,63,199,27,57,143,0,234,244,126,22,44,3,120,44,170,110,31,0,24,116,126,223,3,200,43,239,16,203,128,178,244,33,178,0,109,235,67,137,96,205,2,238,152,162,163,57,1,32,162,162,212,88,234,175,156,75,198,205,63,68,48,21,126,140,145,207,26,219,91,209,23,163,210,255,215,163,200,238,182,245,127,142,207,118,245,213,43,237,156,212,87,199,129,159,234,184,99,128,64,16,83,19,64,223,47,165,193,106,178,0,107,152,185,197,88,17,192,186,33,56,183,229,247,215,30,96,8,32,239,70,69,66,107,228,57,151,148,219,209,159,79,77,33,176,2,35,136,206,166,159,244,255,249,168,108,192,121,54,96,139,51,217,206,0,122,1,248,116,210,183,127,105,11,2,176,28,64,0,162,96,159,43,72,115,106,50,25,179,128,146,193,100,141,237,120,49,71,1,126,99,214,190,189,17,227,158,99,236,105,102,149,75,90,160,224,7,2,224,159,123,227,143,191,192,16,18,128,161,41,130,167,49,82,17,222,248,140,245,102,244,143,163,47,70,17,2,63,190,109,253,159,227,51,32,171,87,234,220,58,218,175,1,8,224,209,168,101,0,2,152,115,25,160,63,221,11,144,
9,28,42,11,96,96,246,208,151,146,64,170,171,44,220,2,230,77,228,151,22,191,31,5,4,126,52,151,0,63,181,246,183,132,46,190,82,221,171,24,167,244,31,201,189,25,253,126,20,1,216,8,180,39,192,111,221,115,155,52,146,223,118,50,7,141,110,174,115,246,18,128,129,200,2,230,94,6,32,28,131,51,136,67,100,1,28,6,33,98,80,36,64,214,253,128,91,118,88,242,95,14,15,244,84,20,228,67,63,138,206,37,141,254,112,35,250,195,83,177,181,239,62,192,133,224,104,183,191,233,255,115,169,191,125,122,254,142,244,63,231,119,102,0,206,19,29,213,97,96,55,0,25,128,65,116,23,179,228,49,213,128,210,212,153,104,163,192,63,84,22,32,114,52,125,67,2,136,80,191,230,24,127,154,89,229,62,45,0,252,124,166,209,31,56,164,199,115,10,220,80,152,105,214,184,111,127,49,78,42,56,26,31,192,223,140,54,253,111,214,115,71,250,159,123,206,37,128,58,182,18,208,57,187,44,224,145,232,220,95,3,106,48,89,64,211,183,146,65,78,205,42,34,136,126,176,137,62,76,53,169,121,245,42,151,176,0,64,112,120,107,225,174,251,45,1,230,20,190,81,2,152,58,
250,27,47,223,52,198,55,162,223,143,254,81,244,174,233,127,174,159,75,0,174,21,120,156,93,186,11,252,178,0,131,50,56,153,129,107,189,47,213,73,69,59,88,78,6,112,168,44,192,0,101,1,12,46,11,208,31,182,32,115,217,225,86,107,235,223,243,44,96,110,104,193,47,2,2,7,159,153,83,10,254,41,163,127,199,195,15,253,78,70,250,15,244,82,127,202,6,50,159,157,233,127,206,223,149,0,92,231,212,84,212,243,59,230,135,163,227,50,0,8,200,212,206,223,247,31,250,139,128,177,114,164,238,7,32,192,149,4,88,101,25,178,13,254,247,210,45,89,227,156,235,126,150,24,163,63,204,116,233,232,218,62,165,227,53,70,153,142,111,255,141,254,47,166,142,252,248,235,206,244,63,231,239,74,0,5,157,146,163,219,193,52,24,58,46,3,166,26,92,154,185,67,244,5,224,232,33,179,0,6,55,110,203,128,53,19,136,17,22,32,5,131,168,39,21,46,248,237,128,207,45,15,165,65,25,128,160,57,229,206,191,113,1,183,40,111,188,54,255,158,143,90,255,191,30,69,124,176,114,174,20,228,231,221,224,58,7,151,198,60,17,253,78,244,111,71,127,45,250,149,168,108,
64,84,6,134,57,196,36,3,157,207,28,210,29,131,62,196,4,167,217,141,32,194,95,137,178,131,210,18,105,46,91,164,169,85,6,11,0,194,8,126,105,255,220,155,126,186,83,63,224,11,116,202,101,178,49,11,70,112,240,74,244,15,163,255,87,244,247,162,47,71,127,24,69,0,112,179,83,46,66,0,28,218,30,128,77,64,192,255,187,209,223,138,62,29,245,143,133,164,59,238,185,215,187,114,203,94,196,160,165,54,254,227,6,72,224,221,232,33,101,23,9,176,197,92,246,56,228,216,151,208,246,174,200,127,40,240,179,7,76,216,47,19,20,100,1,83,5,4,227,134,5,107,255,183,163,82,255,223,143,254,179,40,34,64,134,31,71,221,115,46,1,96,167,123,73,157,217,64,126,41,42,189,233,50,0,248,231,222,12,76,147,155,126,152,100,236,166,127,6,122,40,209,15,182,145,153,176,167,62,177,11,89,73,224,150,29,166,250,187,52,240,3,188,128,0,252,116,234,192,200,215,164,249,130,224,203,209,239,70,159,139,34,4,203,2,62,121,46,248,115,237,66,14,202,137,57,182,181,204,231,163,191,17,253,59,209,111,71,111,68,101,6,50,132,169,7,155,38,206,196,160,
100,1,31,68,101,1,31,70,25,226,144,178,102,2,243,90,127,105,224,135,143,126,41,251,213,212,249,195,84,1,192,216,69,118,129,79,164,127,49,250,47,162,255,103,244,95,70,45,145,47,68,0,23,205,0,242,190,205,96,220,15,236,99,22,96,224,221,7,152,106,192,105,226,14,145,141,96,64,134,56,228,134,96,59,214,76,64,159,216,73,159,214,76,160,214,217,111,185,52,240,27,157,136,47,3,176,241,167,132,133,41,241,32,186,11,122,2,160,79,127,162,63,5,126,231,249,225,61,229,34,4,208,151,116,48,221,20,68,2,212,166,7,48,58,79,122,223,173,163,105,254,182,13,237,2,158,193,58,167,126,72,209,254,184,28,64,2,83,239,2,31,114,188,135,104,187,209,79,228,147,1,190,31,101,247,67,108,248,165,217,141,136,246,180,129,113,202,108,184,228,103,243,79,230,251,86,212,250,255,143,78,75,132,224,218,93,215,254,185,190,145,139,18,64,1,231,33,131,235,94,128,1,99,60,89,129,223,10,76,57,240,188,254,54,105,159,48,33,25,179,129,91,103,14,243,183,36,48,102,2,43,9,236,103,46,56,191,249,30,193,207,217,15,9,126,115,91,224,11,134,176,
0,7,83,10,27,244,135,63,175,164,254,92,20,1,248,12,120,207,157,255,220,115,38,5,209,217,137,187,84,220,219,232,255,229,212,125,9,248,55,163,255,70,244,137,168,245,15,98,112,223,253,188,55,183,63,176,52,26,248,34,240,222,169,170,47,65,16,163,37,128,245,32,199,80,151,38,206,105,159,52,119,37,164,81,79,196,23,245,148,210,92,224,231,240,135,148,199,210,248,195,81,36,96,126,167,12,130,181,131,32,195,207,95,142,254,127,209,255,59,250,251,81,75,129,251,34,128,139,102,0,121,239,109,160,54,72,96,183,214,49,112,78,126,168,44,0,160,180,205,25,68,93,125,59,228,87,129,52,191,17,253,145,134,233,19,37,202,53,27,216,152,226,194,127,74,242,118,186,145,188,20,87,244,99,95,36,112,72,249,116,26,167,205,0,224,105,234,224,55,70,127,128,255,110,84,244,87,151,9,241,49,54,187,144,220,111,103,129,171,89,128,168,47,11,248,91,209,95,143,58,198,132,115,103,1,105,114,3,180,247,83,126,24,229,32,202,67,59,71,186,112,38,136,178,169,162,108,224,209,40,91,174,217,64,140,112,142,52,218,33,81,41,191,57,53,199,128,
175,126,104,49,159,15,71,205,165,108,143,154,211,169,164,246,16,253,249,248,203,209,63,136,254,110,244,247,79,143,27,253,217,236,66,114,191,4,224,126,131,20,113,13,252,107,81,4,240,55,163,95,141,62,30,101,8,36,113,191,239,206,35,15,44,53,206,15,242,134,70,9,245,37,9,187,116,73,160,236,146,160,78,51,167,189,150,100,151,237,190,52,122,113,226,166,252,37,116,224,231,228,75,144,166,254,210,126,106,254,166,156,67,118,17,221,69,249,183,162,207,69,255,223,40,2,144,5,200,144,100,190,236,86,27,166,122,119,121,144,14,115,216,102,1,95,78,253,183,162,99,22,240,72,142,17,196,212,6,73,19,183,137,65,75,143,24,167,89,128,136,177,36,249,229,116,134,109,74,0,74,231,230,112,160,52,179,120,49,135,20,240,57,58,224,255,36,42,234,113,254,165,100,117,50,58,115,38,8,242,247,169,83,255,218,5,192,5,182,237,232,47,253,191,239,232,159,103,30,136,177,0,27,9,72,245,13,190,89,192,111,167,254,108,244,11,81,209,110,238,44,32,77,110,156,103,92,10,112,24,206,180,52,1,252,18,193,167,83,119,204,150,236,58,55,113,
166,201,131,75,29,92,244,18,201,0,159,138,248,62,165,46,37,234,167,43,155,53,63,2,0,126,123,95,124,253,65,2,105,30,187,176,176,79,163,255,27,169,63,31,253,127,162,141,254,72,1,73,222,87,244,207,253,15,220,113,142,138,245,24,64,22,240,155,209,102,1,79,166,206,153,57,120,29,58,213,217,132,17,100,0,31,69,45,7,144,0,103,90,162,112,36,25,64,191,18,52,27,24,237,54,181,115,29,202,46,156,154,40,205,89,163,190,121,51,103,128,191,180,121,3,118,115,198,191,205,153,186,185,154,82,106,159,70,255,151,210,216,31,68,129,255,159,71,27,253,101,191,236,120,95,242,160,206,229,57,3,151,5,60,28,181,254,255,78,84,22,160,254,197,168,200,230,183,1,15,218,70,30,125,32,97,48,138,21,75,2,28,201,206,241,18,5,232,155,13,168,87,165,152,87,145,8,204,13,169,99,3,190,8,111,174,164,251,141,250,72,96,73,98,94,204,9,240,11,124,15,69,249,246,212,254,205,78,37,195,215,83,183,246,23,253,127,239,180,46,216,61,80,244,207,115,151,234,188,129,75,243,49,33,192,255,122,84,22,240,27,209,27,81,41,146,212,118,116,226,28,206,
34,117,46,36,240,222,169,170,47,89,186,44,40,1,40,17,195,72,4,117,182,150,75,30,207,216,183,17,244,157,155,2,31,248,11,124,105,174,227,37,10,127,22,236,0,95,57,135,95,215,86,130,215,187,209,23,163,255,50,250,187,81,89,0,66,64,148,236,86,27,167,122,113,185,140,35,121,150,17,62,17,101,148,167,162,178,0,250,245,232,151,162,206,247,23,130,169,206,42,12,34,45,122,51,138,4,100,1,239,71,151,46,136,64,102,85,34,96,63,68,224,28,123,110,59,222,101,230,48,175,155,76,70,135,84,151,158,154,3,169,44,144,43,169,232,182,100,224,167,123,155,84,31,17,35,1,25,192,212,155,126,105,98,35,108,198,62,252,246,181,232,31,71,69,126,250,66,212,121,25,147,251,70,123,231,240,98,114,89,231,241,60,99,112,218,199,163,223,138,202,2,190,29,69,8,159,139,74,151,230,50,88,154,186,77,24,133,145,56,30,18,224,120,34,207,49,8,155,178,91,193,223,140,192,241,67,81,68,176,77,6,57,117,169,172,206,243,15,42,219,14,88,208,23,248,108,95,224,3,124,117,105,169,254,246,248,45,101,217,187,169,255,167,82,191,44,110,182,219,216,117,
204,126,2,24,155,189,29,5,248,127,17,21,253,255,85,244,173,168,204,192,61,219,182,207,169,139,201,101,7,226,121,42,74,125,38,122,18,253,173,232,111,71,191,25,253,74,244,225,40,167,237,189,169,206,42,28,16,248,63,58,45,57,220,177,144,64,186,186,17,203,44,25,0,59,34,2,75,47,245,102,95,37,2,54,38,45,111,29,221,250,187,235,220,120,253,162,245,93,206,214,115,74,90,208,91,155,178,247,24,237,57,172,185,56,6,1,126,126,13,252,8,89,157,173,167,150,218,145,221,172,241,95,137,254,235,168,181,255,239,71,111,70,249,176,236,160,247,166,122,255,178,15,167,240,142,70,170,199,82,255,90,20,1,252,102,244,217,168,207,130,12,137,36,246,209,94,94,115,95,82,3,49,100,73,0,115,30,27,9,24,116,179,2,100,80,66,64,6,148,125,169,104,197,206,163,230,112,35,151,181,63,91,86,106,215,150,108,43,29,5,250,81,27,233,1,31,25,28,139,240,89,10,252,8,24,248,107,211,84,39,21,54,5,110,153,235,27,209,231,163,255,60,138,0,190,27,125,39,138,28,46,21,253,243,252,222,0,137,21,57,161,116,255,75,81,27,130,223,57,45,111,164,124,
52,90,231,189,172,19,230,85,247,45,117,82,27,129,82,170,247,162,199,74,2,29,124,237,89,240,203,6,144,130,99,132,220,243,156,216,252,92,36,75,200,109,119,8,219,145,218,80,116,167,236,200,73,129,126,4,190,107,28,147,246,190,84,143,74,70,240,179,243,72,170,83,15,132,157,217,142,127,190,27,125,49,250,7,209,223,59,45,95,75,201,246,136,149,125,47,37,156,100,31,210,78,219,205,5,178,151,162,64,47,253,103,76,233,170,232,212,244,105,110,18,104,123,216,124,91,142,49,19,48,6,14,50,138,40,85,34,46,248,145,130,241,33,132,109,2,40,73,32,237,93,226,253,141,222,230,151,179,181,44,240,149,5,122,75,206,121,204,114,104,240,179,49,187,178,35,44,1,252,139,81,152,114,12,99,108,237,190,75,75,129,113,233,23,229,5,222,197,169,172,81,63,23,253,122,84,22,240,237,232,51,209,207,71,63,21,69,4,251,108,55,175,187,176,48,26,101,72,6,190,10,153,64,134,177,83,68,46,160,31,193,239,198,206,83,73,98,155,24,220,83,224,115,196,2,191,14,87,27,214,9,143,29,240,198,91,57,36,248,245,129,109,217,220,114,234,205,232,247,
162,54,254,68,255,63,142,190,29,221,43,1,236,43,3,72,191,54,194,89,164,131,239,71,95,141,138,184,205,2,16,67,179,0,78,121,8,18,104,155,87,41,19,136,41,119,202,118,134,176,125,83,9,162,4,224,58,251,20,232,5,254,85,2,248,182,13,198,227,37,128,31,169,90,219,203,218,128,253,229,232,11,81,88,130,41,216,50,47,123,147,125,18,64,29,71,244,192,82,214,47,55,163,8,192,6,138,20,245,208,75,129,116,225,140,120,70,18,40,49,28,235,114,192,184,238,87,238,69,16,247,251,190,99,190,31,248,249,40,95,69,140,15,69,249,68,253,34,213,73,165,89,85,83,127,216,121,37,10,252,55,163,142,97,10,182,122,111,170,151,23,145,120,42,193,84,148,17,1,31,1,200,2,108,84,53,19,152,203,192,105,242,54,105,187,250,163,143,236,128,125,149,24,120,149,235,99,1,192,167,2,2,31,157,27,252,105,114,3,106,224,150,109,137,252,47,69,255,40,250,135,209,155,209,247,162,190,172,116,217,149,234,126,100,159,25,192,216,35,29,213,97,29,199,100,12,204,176,246,0,186,20,96,108,64,44,24,83,157,85,218,46,214,39,142,217,131,34,129,235,146,250,
102,168,215,82,4,37,27,160,124,83,6,32,242,43,231,246,73,17,93,16,18,225,165,249,111,69,111,70,173,255,97,103,4,127,14,247,43,34,222,84,210,129,41,137,200,207,200,8,128,241,237,80,107,127,110,131,167,201,51,41,9,232,147,181,48,240,235,147,62,43,145,216,42,87,207,2,5,190,168,191,4,240,243,51,224,127,35,250,253,232,191,142,218,244,123,61,250,81,212,210,128,79,22,75,169,238,71,166,36,0,61,212,97,236,166,4,54,36,80,2,80,47,9,164,186,185,174,156,91,74,64,37,40,253,69,4,93,26,172,36,48,247,140,76,219,30,192,83,224,71,4,50,192,6,128,6,132,156,154,92,10,104,224,254,48,250,86,244,197,168,212,255,95,69,109,0,54,250,23,67,57,181,95,225,232,83,138,142,151,221,94,73,221,18,128,209,101,2,0,167,125,147,161,156,211,248,105,238,14,209,62,66,124,52,218,157,241,146,3,118,94,229,248,45,208,116,191,155,125,142,59,215,115,143,14,1,116,221,239,179,180,239,253,162,255,243,81,88,225,115,176,3,67,147,201,212,25,64,59,110,16,246,5,148,12,62,102,2,178,0,4,112,168,137,72,211,103,82,192,139,8,250,90,130,212,
71,253,243,25,102,149,227,179,128,37,231,67,81,192,255,108,84,0,114,124,40,159,3,126,120,240,37,6,248,1,254,187,81,155,126,207,69,223,140,218,131,218,251,174,127,222,121,155,204,69,0,6,92,18,80,7,44,147,2,104,227,82,160,0,204,233,131,137,62,144,166,133,250,202,78,250,173,92,151,4,49,194,17,137,172,19,216,15,189,222,175,201,10,126,27,205,82,124,235,124,81,95,218,111,221,255,106,212,146,160,223,252,221,63,153,204,69,0,6,96,32,72,160,172,230,83,32,18,160,34,172,99,253,89,10,9,232,71,247,5,244,29,17,136,24,253,132,185,102,3,49,198,130,133,95,73,241,27,245,45,61,69,255,18,123,137,62,167,102,147,98,160,203,226,55,210,114,55,253,16,192,75,209,49,245,159,20,252,70,61,39,1,104,207,128,164,62,72,128,148,4,154,5,20,92,75,32,1,253,107,63,164,140,5,127,109,166,92,179,1,86,90,158,52,234,219,207,233,46,255,33,83,126,22,42,248,5,14,63,56,123,43,122,51,106,199,31,248,95,136,254,73,84,102,0,35,147,131,63,109,28,132,0,186,20,80,22,84,37,128,49,19,208,191,67,176,180,118,71,105,31,244,17,17,152,152,
53,27,24,45,180,156,250,121,81,223,249,146,249,33,122,203,103,168,29,127,159,245,222,142,190,20,149,242,35,128,239,69,157,179,39,208,12,57,213,233,165,209,108,250,150,254,178,5,134,40,9,96,58,19,35,242,151,4,212,155,9,164,186,24,18,168,3,53,133,212,199,218,111,205,6,204,212,97,69,164,151,242,143,81,223,177,185,57,212,102,95,154,222,0,159,207,3,54,240,191,19,125,57,106,211,79,228,183,254,127,51,106,211,15,65,148,44,82,157,94,234,192,211,183,116,123,11,6,9,252,6,188,107,57,32,194,54,202,2,222,82,164,36,176,43,27,144,189,176,231,186,55,48,239,108,33,100,233,189,181,62,245,11,83,107,125,81,255,144,192,79,243,27,41,248,1,124,123,199,95,6,240,90,116,182,77,191,77,143,134,63,135,36,128,102,1,72,0,25,232,11,16,85,69,216,37,147,0,50,176,36,208,239,246,181,99,224,120,43,17,196,8,19,10,224,139,240,118,247,1,191,107,125,231,216,127,41,224,231,219,253,220,247,106,234,34,190,200,239,7,63,175,68,237,7,216,75,114,31,178,152,85,56,236,33,165,36,32,11,96,0,147,6,76,221,11,80,215,199,37,76,102,
186,113,155,52,51,105,54,128,172,86,34,184,205,68,147,28,20,248,141,248,5,126,163,126,179,180,73,26,191,143,151,54,242,3,191,205,189,215,162,223,139,2,191,117,255,203,209,247,162,192,15,7,179,131,63,109,110,192,165,60,148,24,116,73,64,196,148,13,152,64,64,170,2,214,146,73,160,14,183,77,4,250,172,239,200,12,129,173,25,65,140,112,9,41,240,1,189,17,191,255,122,207,181,6,137,18,243,37,154,186,244,163,231,129,255,15,243,102,122,51,138,20,252,3,160,131,68,254,180,187,145,67,103,0,58,81,18,144,5,0,137,178,36,0,60,64,180,100,18,72,247,54,253,29,137,128,99,178,173,254,175,68,16,35,92,66,118,1,223,210,11,17,20,248,5,255,37,154,217,219,163,219,224,127,61,111,22,249,11,254,23,83,223,6,191,103,14,34,75,32,0,3,103,0,76,8,252,221,19,48,169,178,128,99,33,129,116,245,236,139,133,190,219,132,226,168,205,2,70,34,80,95,51,130,24,225,46,82,224,111,167,250,54,252,216,181,160,95,66,196,239,48,182,193,255,70,46,124,63,42,237,167,192,255,110,116,252,220,119,48,240,167,31,7,95,2,232,67,133,33,44,7,70,
18,48,185,192,130,8,198,76,160,147,222,50,151,23,35,250,212,126,141,68,48,46,105,140,197,146,97,37,130,59,167,13,184,199,205,61,63,234,113,174,192,103,179,218,184,118,206,169,131,10,223,165,130,88,215,252,34,63,240,91,239,47,18,252,233,215,162,8,64,127,106,68,36,208,61,1,231,76,122,9,64,233,24,184,200,82,156,224,86,111,254,242,111,157,212,25,125,5,120,75,131,109,34,112,174,89,206,117,205,10,68,123,118,176,163,47,181,87,22,248,77,245,151,8,252,116,115,227,179,124,148,207,22,252,175,165,254,189,104,35,255,11,169,191,19,253,81,212,125,238,167,7,23,70,93,154,48,12,38,181,20,176,67,10,20,206,149,4,148,173,47,157,4,210,213,179,104,165,190,77,4,34,27,240,151,0,174,19,25,108,131,254,209,216,193,142,62,224,187,6,248,227,183,252,145,80,115,105,17,82,32,3,245,15,163,190,243,23,252,214,252,141,252,35,248,15,182,227,159,254,220,33,75,36,0,157,100,88,70,69,2,126,27,61,146,192,8,126,117,160,90,162,115,164,91,183,73,251,216,82,70,192,209,253,35,21,89,193,54,25,56,239,122,201,225,216,179,3,99,
49,70,0,7,110,41,189,72,63,130,222,122,223,61,128,207,78,75,158,91,62,10,204,124,244,163,40,240,191,26,21,249,199,13,63,107,254,70,254,69,129,63,253,218,68,82,229,18,133,129,101,2,28,127,204,4,234,24,192,63,146,65,129,149,211,139,151,177,175,205,10,74,6,0,15,4,142,1,193,49,130,144,29,148,36,44,131,150,78,8,35,224,129,29,232,1,220,250,30,232,17,156,241,56,95,208,143,128,103,163,165,74,193,111,14,128,95,132,127,37,250,124,84,212,71,0,47,70,129,191,27,126,139,3,127,250,182,104,2,208,63,70,67,2,178,1,36,64,213,77,64,163,127,137,96,116,158,92,62,10,41,17,180,28,201,0,224,129,4,1,20,252,219,132,208,243,178,137,67,146,66,193,174,191,180,17,126,27,240,238,115,206,61,5,189,249,51,254,99,153,191,6,38,190,248,65,244,237,232,203,209,239,70,129,223,166,223,205,168,79,125,5,191,103,232,226,132,241,151,46,53,120,151,3,126,60,129,4,8,167,161,219,36,224,218,146,35,136,254,109,75,73,160,101,199,213,165,2,192,72,159,75,8,192,79,93,119,110,251,124,201,193,115,174,177,17,27,62,136,0,46,5,220,182,
219,186,232,222,8,47,178,139,240,250,233,122,1,223,190,56,214,15,99,59,38,208,167,187,27,0,215,23,45,75,223,143,190,21,125,41,10,252,162,190,159,247,190,28,5,254,250,233,98,193,159,62,110,38,67,185,116,169,225,75,2,99,38,80,71,42,96,234,96,198,228,218,49,138,126,87,245,191,99,52,182,145,16,74,10,221,67,112,92,128,170,23,252,174,123,22,0,71,149,81,140,199,99,221,179,142,129,26,160,1,27,168,11,110,101,235,218,116,175,53,189,123,104,159,239,124,116,60,99,153,219,142,66,10,98,129,71,84,127,47,250,70,244,102,212,63,232,17,249,149,175,68,93,27,127,225,231,217,197,138,201,57,22,97,72,75,130,113,57,96,13,182,157,13,148,8,26,101,56,220,49,203,8,152,142,69,57,142,19,248,0,14,16,11,210,2,20,112,217,14,113,32,2,37,5,254,150,234,187,212,123,123,94,22,241,197,40,66,40,41,20,236,141,240,252,233,110,128,111,255,115,219,209,72,253,78,240,233,102,223,235,169,247,27,191,148,255,249,232,107,81,75,2,193,201,178,213,115,116,209,114,76,19,162,175,117,124,142,203,193,31,139,62,25,253,90,244,171,209,
27,81,78,42,18,185,238,190,171,66,4,25,202,185,114,158,163,245,252,121,229,185,47,60,189,80,255,56,175,220,126,190,247,109,159,63,198,99,54,163,130,14,80,143,224,127,49,199,207,69,165,254,47,69,223,137,186,238,190,110,246,213,230,57,181,92,57,198,9,211,103,81,166,105,175,77,165,39,162,8,128,62,29,253,82,20,57,136,84,162,152,13,50,207,29,227,120,211,237,75,201,190,29,241,58,216,144,205,168,236,82,58,255,97,20,200,69,121,145,31,248,233,203,209,63,137,90,22,200,16,26,249,83,61,14,57,214,201,212,111,145,29,176,1,220,38,20,208,3,191,108,64,249,149,232,231,162,174,73,81,17,6,226,32,199,58,238,91,189,95,255,78,101,129,146,37,32,3,244,143,162,54,251,222,142,190,18,5,126,81,95,137,12,92,235,102,95,35,127,78,29,143,28,51,16,244,157,34,1,169,190,104,255,249,232,141,232,179,209,103,162,50,131,199,163,150,4,214,171,214,179,215,57,27,200,240,87,57,199,2,99,212,183,203,255,195,232,15,162,111,69,69,250,239,69,159,143,190,24,125,51,42,43,144,242,203,18,250,108,170,199,37,199,76,0,44,93,18,144,
13,124,34,10,228,143,70,69,127,4,32,19,56,137,202,14,156,183,33,102,179,108,205,6,98,132,85,54,22,216,142,250,210,121,155,121,239,70,69,249,155,81,17,31,1,200,2,156,71,14,63,141,54,234,247,29,57,117,92,114,236,4,80,107,27,7,18,0,108,0,151,246,203,6,78,162,37,2,164,96,73,224,71,42,107,54,16,35,172,114,22,185,69,241,70,125,159,241,198,148,31,240,111,70,69,125,41,127,215,251,5,127,78,29,175,92,21,2,48,3,37,1,235,124,75,2,95,1,154,13,88,18,60,21,181,36,248,98,212,146,192,146,1,89,200,28,144,135,231,175,146,61,50,156,85,206,177,64,83,118,32,22,201,129,90,74,47,229,127,61,250,114,244,133,168,148,191,81,191,187,252,63,207,185,43,1,254,140,227,202,57,124,65,60,102,3,34,62,208,159,68,145,192,141,168,37,193,152,13,244,75,129,231,200,74,4,183,236,112,213,254,54,85,7,96,81,223,6,158,116,190,81,95,202,255,98,20,248,111,70,145,129,107,219,81,191,239,201,165,227,150,171,232,232,29,19,48,219,240,27,179,129,47,231,216,190,0,18,120,34,250,133,168,108,160,123,3,238,149,65,172,68,16,35,92,33,41,
96,1,95,4,183,121,7,212,214,250,162,254,27,209,151,163,192,111,189,255,106,212,90,191,81,31,89,120,150,244,93,183,142,142,252,111,193,114,228,195,216,217,125,99,163,0,109,111,160,159,11,237,13,60,25,125,42,122,18,29,179,1,203,6,247,89,22,120,174,246,105,153,83,171,28,145,5,10,86,37,224,75,247,69,125,192,30,163,254,205,28,139,250,47,69,187,214,119,223,207,162,158,243,124,223,149,234,213,145,171,238,216,29,95,179,1,192,6,114,81,31,240,79,162,79,70,101,3,136,193,158,129,13,196,110,18,34,142,149,8,98,132,35,147,130,85,9,192,128,220,77,62,27,121,162,59,160,139,250,64,127,51,42,253,151,13,32,7,68,113,101,163,126,198,118,38,5,200,217,137,43,90,49,78,138,8,154,13,72,251,253,90,176,251,3,72,224,43,81,191,27,240,235,66,155,132,126,64,212,253,129,149,8,98,140,133,203,54,240,187,206,247,131,30,155,124,126,181,247,86,244,149,40,240,223,140,90,231,251,149,159,229,64,163,190,116,223,187,250,190,84,175,166,92,23,2,48,123,29,43,18,0,102,217,128,175,0,136,192,134,160,253,129,147,40,34,64,10,200,
161,68,224,190,79,70,237,41,172,68,16,35,44,76,10,84,165,136,15,248,34,190,117,126,129,15,228,192,94,224,91,231,251,220,7,248,238,19,245,61,11,252,164,239,188,117,116,69,255,22,20,87,116,120,59,135,101,204,180,68,96,227,79,164,247,181,192,50,0,17,200,4,148,54,9,145,131,101,129,165,67,137,64,22,225,121,74,174,163,29,111,141,252,176,127,11,82,160,165,77,245,1,90,42,47,221,7,114,155,124,0,47,242,43,165,255,246,0,100,6,54,4,11,124,239,235,59,83,189,250,114,157,29,119,36,2,128,70,4,214,254,136,192,50,96,36,130,113,127,96,155,8,154,17,212,150,45,243,138,85,38,176,64,1,90,176,2,239,46,224,119,157,63,2,95,250,15,248,62,253,1,190,231,16,71,223,149,234,245,146,235,238,172,29,127,163,249,54,17,52,35,248,82,220,194,178,96,36,2,100,33,115,176,52,240,220,95,139,122,79,223,153,234,109,117,199,171,60,152,5,10,122,79,171,3,173,52,191,192,23,201,129,122,220,224,147,238,191,22,29,35,254,54,240,189,135,140,239,191,117,230,154,252,29,157,245,154,12,121,231,48,107,135,145,8,0,91,180,151,17,216,15,
64,0,93,22,32,2,251,3,174,53,35,232,231,67,68,176,157,21,228,212,74,6,140,112,31,50,130,82,157,138,246,128,111,189,110,195,174,169,190,168,110,131,79,106,223,116,191,155,123,174,89,14,124,28,109,196,191,246,192,143,45,54,82,199,239,241,117,47,217,163,10,196,205,8,68,122,251,0,37,130,102,3,136,192,39,69,215,198,175,6,150,19,158,245,142,102,5,163,173,199,122,110,89,229,212,2,187,64,15,172,77,243,165,237,128,47,226,219,220,19,241,127,16,5,124,10,244,5,190,107,238,107,170,239,29,37,146,177,157,156,190,190,178,58,226,238,185,47,9,40,129,88,84,7,106,155,128,159,137,250,189,128,205,65,75,3,36,160,238,156,140,192,117,132,33,35,144,69,32,130,187,145,65,46,95,219,236,96,27,136,5,232,8,250,166,249,5,254,7,177,151,168,110,141,111,131,15,240,95,59,173,59,231,186,204,0,240,101,11,43,240,99,132,243,100,37,128,243,44,115,235,252,72,4,34,57,34,248,68,20,17,216,3,176,12,144,21,32,129,18,1,50,104,70,208,229,1,34,40,25,116,137,48,102,6,219,243,176,125,156,199,175,132,156,7,120,231,11,250,113,109,
255,113,206,3,179,20,190,17,31,232,11,124,224,127,39,42,253,183,190,119,175,229,129,119,120,95,9,101,187,221,92,90,133,5,174,170,163,237,123,118,107,167,238,17,116,121,0,212,162,189,168,111,41,0,252,136,0,41,56,166,174,33,2,132,209,172,0,137,200,10,74,6,219,75,133,182,151,91,54,178,125,220,243,75,47,183,129,55,2,178,128,239,186,94,164,7,94,160,23,237,1,26,240,69,116,105,62,5,118,160,71,0,142,93,147,230,123,198,243,222,229,189,148,108,183,127,235,236,250,247,204,2,199,234,88,103,3,152,185,82,123,41,145,65,151,7,0,13,220,64,46,250,203,12,144,1,85,71,4,202,238,19,32,13,228,97,89,225,217,106,223,87,162,209,206,216,102,14,239,144,94,191,227,194,76,39,206,3,89,207,23,244,5,102,211,114,96,175,74,215,129,24,152,169,104,47,170,3,185,178,81,95,221,218,30,57,32,137,70,251,2,127,108,51,151,87,185,151,5,14,237,60,247,234,223,82,175,215,110,74,90,50,16,213,129,26,25,124,42,42,250,127,54,106,127,0,25,168,59,135,36,92,255,27,131,122,166,155,135,99,134,208,119,43,219,94,170,103,196,176,93,119,
124,158,180,223,231,93,239,249,2,169,199,231,149,227,125,173,43,105,35,188,178,105,61,192,138,212,221,204,251,113,234,85,209,30,184,69,245,247,162,64,111,77,175,238,156,235,64,63,110,234,121,119,219,75,117,141,248,140,112,63,114,81,135,184,159,119,94,183,123,107,67,101,35,183,212,30,25,140,153,1,224,23,252,178,1,117,25,1,29,9,1,17,32,6,25,194,72,4,227,146,97,108,171,245,177,31,121,244,76,122,254,236,196,125,86,10,236,62,214,227,130,188,101,193,56,166,244,35,240,69,120,96,7,98,101,1,47,218,83,32,111,132,87,167,99,164,71,28,93,219,183,173,156,90,65,207,8,15,42,151,117,142,7,109,247,42,62,87,91,42,171,8,1,25,80,209,189,217,1,128,91,46,20,252,8,161,36,80,82,112,221,125,158,233,114,65,189,239,235,187,187,108,216,222,71,200,173,103,253,104,127,218,71,215,238,38,64,189,173,238,239,57,0,44,208,91,58,7,160,84,148,110,90,175,4,120,96,46,216,11,254,2,222,121,215,75,16,125,190,239,43,224,219,126,110,93,129,207,8,151,149,139,58,196,101,219,185,110,207,215,174,35,240,0,22,72,11,216,113,185,
0,236,116,92,54,200,16,156,179,95,80,194,40,33,52,195,104,150,49,102,10,218,209,110,203,214,29,247,92,170,231,10,144,1,92,181,160,43,8,149,128,217,77,187,166,245,141,208,35,224,1,218,154,30,184,69,244,247,78,75,4,224,28,29,211,122,239,69,40,180,237,181,253,156,90,65,207,8,171,28,151,5,74,2,5,32,2,40,112,187,113,248,217,156,123,60,250,68,244,217,232,183,163,127,55,250,239,68,255,131,232,63,136,254,103,209,255,60,250,59,209,127,28,253,175,162,255,77,244,191,143,254,143,209,255,41,250,63,71,255,151,232,255,26,253,223,162,255,123,244,159,70,255,143,232,63,139,254,110,244,247,238,161,238,113,175,103,254,105,212,59,188,203,59,189,91,27,218,210,166,182,245,65,95,244,233,119,162,250,168,175,250,172,239,198,96,44,198,100,108,79,68,141,213,152,17,28,27,124,34,250,215,163,205,98,74,84,108,183,202,106,129,43,99,129,146,193,24,149,27,205,127,41,163,44,33,88,14,60,22,253,82,244,70,244,235,81,0,250,219,209,191,23,253,119,163,255,126,244,63,138,254,39,209,127,24,253,71,209,255,34,250,59,209,
255,50,10,144,255,36,10,156,255,117,20,80,255,219,232,127,23,5,220,255,97,75,157,115,205,61,238,245,140,103,189,195,187,188,243,119,162,218,208,150,54,181,173,15,250,162,79,127,47,170,143,250,170,207,250,110,12,198,242,80,180,128,55,86,128,55,246,95,56,213,209,54,57,181,202,106,129,171,111,129,209,233,1,65,4,164,192,33,42,126,50,106,9,96,105,0,64,143,70,69,79,160,122,50,250,76,244,27,209,223,136,126,39,250,119,162,255,86,244,223,142,2,228,191,23,5,206,255,48,250,247,163,255,113,20,104,255,211,115,212,53,247,184,215,51,158,245,14,239,242,78,239,214,134,182,180,169,109,125,120,50,170,79,250,166,143,250,170,207,253,220,57,70,120,227,51,214,113,236,57,92,101,181,192,106,129,17,20,64,66,1,70,164,44,41,52,83,232,190,192,167,115,13,224,30,137,138,180,64,248,133,232,151,163,128,121,18,125,42,250,108,20,96,191,25,253,214,57,234,154,123,220,235,153,147,168,119,120,151,119,122,183,54,180,165,77,109,139,234,250,242,203,81,125,43,216,245,185,96,55,142,113,108,57,92,101,181,192,106,129,187,
89,96,4,140,58,16,81,160,42,41,108,19,131,140,1,16,1,178,153,131,72,92,146,120,56,245,42,16,143,218,243,202,130,219,179,141,228,5,185,54,182,129,94,176,159,7,120,253,95,101,129,22,248,255,5,0,0,0,255,255,3,0,76,147,184,24,41,208,82,213,0,0,0,0,73,69,78,68,174,66,96,130);


implementation

end.
